/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.placements;

import java.util.ArrayList;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelClass;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.IPlacementConstraints;
import org.gvsig.labeling.placements.CannotPlaceLabel;
import org.gvsig.labeling.placements.ILabelPlacement;
import org.gvsig.labeling.placements.MultiShapePlacementConstraints;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.styling.LabelLocationMetrics;
import org.gvsig.tools.task.Cancellable;

public class MultiShapePlacement
implements ILabelPlacement {
    private final ILabelPlacement pointPlacement;
    private final ILabelPlacement linePlacement;
    private final ILabelPlacement polygonPlacement;

    public MultiShapePlacement(ILabelPlacement pointPlacement, ILabelPlacement linePlacement, ILabelPlacement polygonPlacement) {
        this.pointPlacement = pointPlacement;
        this.linePlacement = linePlacement;
        this.polygonPlacement = polygonPlacement;
    }

    @Override
    public ArrayList<LabelLocationMetrics> guess(ILabelClass lc, Geometry geom, IPlacementConstraints placementConstraints, double cartographicSymbolSize, Cancellable cancel, ViewPort vp) {
        MultiShapePlacementConstraints pc = (MultiShapePlacementConstraints)placementConstraints;
        GeometryType gt = geom.getGeometryType();
        if (gt.isTypeOf(1) || gt.isTypeOf(7)) {
            if (this.pointPlacement != null) {
                return this.pointPlacement.guess(lc, geom, pc.getPointConstraints(), cartographicSymbolSize, cancel, vp);
            }
        } else if (gt.isTypeOf(2) || gt.isTypeOf(8)) {
            if (this.linePlacement != null) {
                return this.linePlacement.guess(lc, geom, pc.getLineConstraints(), cartographicSymbolSize, cancel, vp);
            }
        } else if ((gt.isTypeOf(3) || gt.isTypeOf(9)) && this.polygonPlacement != null) {
            return this.polygonPlacement.guess(lc, geom, pc.getPolygonConstraints(), cartographicSymbolSize, cancel, vp);
        }
        return CannotPlaceLabel.NO_PLACES;
    }

    @Override
    public boolean isSuitableFor(IPlacementConstraints placementConstraints, int shapeType) {
        return shapeType == 0 || shapeType == 6;
    }
}

