/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.symbol;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.rendering.symbols.CartographicSupport;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.labeling.lang.LabelClassUtils;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMarkerSymbol_v2;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.impl.AbstractMarkerSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.IMask;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.task.Cancellable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharacterMarkerSymbol
extends AbstractMarkerSymbol
implements IMarkerSymbol_v2 {
    private static Logger logger = LoggerFactory.getLogger(CharacterMarkerSymbol.class);
    public static final String CHARACTER_MARKER_SYMBOL_PERSISTENCE_NAME = "CHARACTER_MARKER_SYMBOL_PERSISTENCE_NAME";
    private Font font = new Font("Arial", 0, 20);
    private int unicode;
    private ISymbol selectionSymbol;
    private VisualCorrection visualCorrection;
    private int alpha = 255;
    private static GeometryManager geoman = GeometryLocator.getGeometryManager();

    public CharacterMarkerSymbol() {
    }

    public CharacterMarkerSymbol(Font font, int charCode, Color color) {
        this.font = font;
        this.unicode = charCode;
        this.setColor(color);
    }

    public Font getFont() {
        if (this.font == null) {
            this.font = new Font("Arial", 0, (int)Math.round(this.getSize()));
        }
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        this.setSize(this.font.getSize());
    }

    public ISymbol getSymbolForSelection(Color selectionColor) {
        if (this.selectionSymbol == null) {
            this.selectionSymbol = (ISymbol)LabelClassUtils.clone((Persistent)this);
            this.selectionSymbol.setColor(selectionColor);
        } else {
            this.selectionSymbol.setColor(selectionColor);
        }
        if (this.selectionSymbol instanceof CartographicSupport) {
            ((CartographicSupport)this.selectionSymbol).setUnit(this.getUnit());
        }
        return this.selectionSymbol;
    }

    public void draw(Graphics2D g, AffineTransform affineTransform, Geometry geom, Feature feat, Cancellable cancel, Rectangle r) {
        double size_d = this.getCartographicSize();
        size_d = this.getAdjustedSize(r, size_d);
        double theta = this.getEfectiveRotationInRadians(feat);
        int xOffset = (int)this.getEfectiveOffset(feat).getX();
        int yOffset = (int)this.getEfectiveOffset(feat).getY();
        if (size_d < 1.0E-4) {
            return;
        }
        Point cen = null;
        try {
            cen = geom.centroid();
        }
        catch (Exception e) {
            logger.warn("While getting centroid", (Throwable)e);
            return;
        }
        g.setColor(this.getColor());
        Point2D.Double p = new Point2D.Double(cen.getX(), cen.getY());
        if (this.isVisuallyCorrected()) {
            ((Point2D)p).setLocation(((Point2D)p).getX() - (double)xOffset * (size_d *= this.visualCorrection.sizeScale) * this.visualCorrection.xOffsetScale, ((Point2D)p).getY() - (double)yOffset * size_d * this.visualCorrection.yOffsetScale);
        }
        g.setFont(this.getFont().deriveFont((float)size_d));
        g.translate((int)(((Point2D)p).getX() + (double)xOffset), (int)(((Point2D)p).getY() + (double)yOffset));
        if (theta != 0.0) {
            g.rotate(theta);
        }
        char[] text = new char[]{(char)this.unicode};
        IMask mask = this.getMask();
        if (mask != null) {
            FontRenderContext frc = g.getFontRenderContext();
            GlyphVector gv = this.font.createGlyphVector(frc, text);
            Shape markerShape = gv.getOutline(0.0f, 0.0f);
            mask.getFillSymbol().draw(g, null, mask.getHaloShape(markerShape), feat, cancel);
        }
        g.drawChars(text, 0, text.length, -((int)(size_d * 0.4)), (int)(size_d * 0.4));
        if (theta != 0.0) {
            g.rotate(-theta);
        }
        g.translate(-((int)(((Point2D)p).getX() + (double)xOffset)), -((int)(((Point2D)p).getY() + (double)yOffset)));
    }

    public void setUnicode(int symbol) {
        this.unicode = symbol;
    }

    public int getUnicode() {
        return this.unicode;
    }

    public void setSize(double size) {
        super.setSize(size);
        this.font = new Font(this.font.getName(), this.font.getStyle(), (int)Math.round(size));
    }

    public boolean isVisuallyCorrected() {
        return this.visualCorrection != null;
    }

    public void setVisuallyCorrected(boolean visuallyCorrected) {
        if (visuallyCorrected && this.visualCorrection == null) {
            int j;
            int i;
            int i2;
            int j2;
            CharacterMarkerSymbol clone = (CharacterMarkerSymbol)((Object)LabelClassUtils.clone((Persistent)this));
            int frameSize = 200;
            double symbolSize = 100.0;
            BufferedImage bi = new BufferedImage(frameSize, frameSize, 2);
            Graphics2D aGraphics = bi.createGraphics();
            clone.setOffset(new Point2D.Double(0.0, 0.0));
            clone.setSize(symbolSize);
            clone.setColor(Color.PINK);
            Point pCenter = null;
            try {
                pCenter = geoman.createPoint((double)(frameSize / 2), (double)(frameSize / 2), 0);
            }
            catch (Exception e) {
                logger.error("While creating point", (Throwable)e);
            }
            clone.draw(aGraphics, new AffineTransform(), (Geometry)pCenter, null, null, null);
            int realTop = -1;
            int realBottom = -1;
            int realLeft = -1;
            int realRight = -1;
            boolean done = false;
            for (j2 = 0; !done && j2 < bi.getHeight(); ++j2) {
                for (i2 = 0; !done && i2 < bi.getWidth(); ++i2) {
                    if (bi.getRGB(i2, j2) == 0) continue;
                    realTop = j2;
                    done = true;
                }
            }
            done = false;
            for (j2 = bi.getHeight() - 1; !done && j2 >= 0; --j2) {
                for (i2 = 0; !done && i2 < bi.getWidth(); ++i2) {
                    if (bi.getRGB(i2, j2) == 0) continue;
                    realBottom = i2;
                    done = true;
                }
            }
            done = false;
            for (i = 0; !done && i < bi.getWidth(); ++i) {
                for (j = 0; !done && j < bi.getHeight(); ++j) {
                    if (bi.getRGB(i, j) == 0) continue;
                    realLeft = i;
                    done = true;
                }
            }
            done = false;
            for (i = bi.getWidth() - 1; !done && i >= 0; --i) {
                for (j = 0; !done && j < bi.getHeight(); ++j) {
                    if (bi.getRGB(i, j) == 0) continue;
                    realRight = i;
                    done = true;
                }
            }
            int realWidth = bi.getWidth() - realRight - realLeft;
            int realHeight = bi.getHeight() - realBottom - realTop;
            this.visualCorrection = new VisualCorrection();
            if (realBottom != -1 && realTop != -1 && realLeft != -1 && realRight != -1) {
                double correctingSize = Math.max(realHeight, realWidth);
                this.visualCorrection.sizeScale = clone.getSize() / correctingSize;
            }
            if (realLeft != -1 && realRight != -1) {
                double correctingCenterX = (double)realWidth * 0.5 + (double)realLeft;
                double correctingCenterY = (double)realHeight * 0.5 + (double)realBottom;
                this.visualCorrection.xOffsetScale = (pCenter.getX() - correctingCenterX) / (double)frameSize;
                this.visualCorrection.yOffsetScale = (pCenter.getY() - correctingCenterY) / (double)frameSize;
            }
        } else {
            this.visualCorrection = null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return LabelClassUtils.clone((Persistent)this);
    }

    public void getPixExtentPlus(Geometry geom, float[] distances, ViewPort viewPort, int dpi) {
        float cs;
        distances[0] = cs = (float)this.getEfectiveSize(null);
        distances[1] = cs;
    }

    public boolean isOneDotOrPixel(Geometry geom, double[] positionOfDotOrPixel, ViewPort viewPort, int dpi) {
        boolean onePoint;
        int type = geom.getType();
        switch (type) {
            case 1: 
            case 7: 
            case 16: {
                return false;
            }
        }
        Envelope geomBounds = geom.getEnvelope();
        double dist1Pixel = viewPort.getDist1pixel();
        float[] distances = new float[2];
        this.getPixExtentPlus(geom, distances, viewPort, dpi);
        boolean bl = onePoint = geomBounds.getLength(0) + (double)distances[0] <= dist1Pixel && geomBounds.getLength(1) + (double)distances[1] <= dist1Pixel;
        if (onePoint) {
            Envelope bounds = geom.getEnvelope();
            positionOfDotOrPixel[0] = bounds.getMinimum(0);
            positionOfDotOrPixel[1] = bounds.getMinimum(1);
        }
        return onePoint;
    }

    public int getOnePointRgb() {
        return this.getColor().getRGB();
    }

    public boolean isSuitableFor(Geometry geom) {
        return geom.getType() == 1 || geom.getType() == 7;
    }

    public void print(Graphics2D g, AffineTransform at, Geometry geom, PrintAttributes properties) {
        this.draw(g, at, geom, null, null);
    }

    public void setAlpha(int a) {
        this.alpha = a;
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        if (state.isNull("offset")) {
            double x = state.getDouble("xOffset");
            double y = state.getDouble("yOffset");
            this.setOffset(new Point2D.Double(x, y));
        }
        if (state.hasValue("vc_xOffsetScale")) {
            this.visualCorrection = new VisualCorrection();
            this.visualCorrection.xOffsetScale = state.getDouble("vc_xOffsetScale");
            this.visualCorrection.yOffsetScale = state.getDouble("vc_yOffsetScale");
            this.visualCorrection.sizeScale = state.getDouble("vc_sizeScale");
        } else {
            this.visualCorrection = null;
        }
        this.font = (Font)state.get("font");
        this.unicode = state.getInt("unicode");
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set("xOffset", this.getOffset().getX());
        state.set("yOffset", this.getOffset().getY());
        if (this.visualCorrection != null) {
            state.set("vc_xOffsetScale", this.visualCorrection.xOffsetScale);
            state.set("vc_yOffsetScale", this.visualCorrection.yOffsetScale);
            state.set("vc_sizeScale", this.visualCorrection.sizeScale);
        }
        state.set("font", (Object)this.font);
        state.set("unicode", this.unicode);
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(CHARACTER_MARKER_SYMBOL_PERSISTENCE_NAME) == null) {
            DynStruct definition = manager.addDefinition(CharacterMarkerSymbol.class, CHARACTER_MARKER_SYMBOL_PERSISTENCE_NAME, "CHARACTER_MARKER_SYMBOL_PERSISTENCE_NAME Persistence definition", null, null);
            definition.extend(manager.getDefinition("MarkerSymbol"));
            definition.addDynFieldDouble("xOffset").setMandatory(true);
            definition.addDynFieldDouble("yOffset").setMandatory(true);
            definition.addDynFieldObject("font").setClassOfValue(Font.class).setMandatory(true);
            definition.addDynFieldInt("unicode").setMandatory(true);
            definition.addDynFieldDouble("vc_xOffsetScale").setMandatory(false);
            definition.addDynFieldDouble("vc_yOffsetScale").setMandatory(false);
            definition.addDynFieldDouble("vc_sizeScale").setMandatory(false);
        }
    }

    private class VisualCorrection {
        double xOffsetScale = 1.0;
        double yOffsetScale = 1.0;
        double sizeScale = 1.0;

        private VisualCorrection() {
        }
    }
}

