/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureStoreProviderFactory;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureStore;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureType;
import org.gvsig.json.Json;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.future.FutureUtils;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DALFile
implements Persistent {
    private static final Logger LOGGER = LoggerFactory.getLogger(DALFile.class);
    private static final String DALFILE_PERSISTENCE_DEFINITION_NAME = "DALResources";
    private final List<FeatureType> featureTypes = new ArrayList<FeatureType>();
    private String defaultFeatureTypeId;

    public static DALFile getDALFile() {
        DALFile f = new DALFile();
        return f;
    }

    public static DALFile getDALFile(ResourcesStorage.Resource resource) {
        DALFile df = new DALFile();
        df.read(resource);
        return df;
    }

    public static void registerPersistenceDefinition() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(DALFILE_PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(DALFile.class, DALFILE_PERSISTENCE_DEFINITION_NAME, "DALResources Persistent definition", null, null);
            definition.addDynFieldString("defaultFeatureType");
            definition.addDynFieldList("featureTypes").setClassOfItems(FeatureType.class).setPersistent(true);
        }
    }

    public boolean isEmpty() {
        return CollectionUtils.isEmpty(this.featureTypes);
    }

    public void write(ResourcesStorage.Resource resource) {
        try {
            OutputStream out = resource.asOutputStream();
            this.write(out);
        }
        catch (Throwable ex) {
            throw new RuntimeException("Can't write DAL resource.", ex);
        }
    }

    public void write(File outfile) {
        this.write(outfile);
    }

    public void write(File outfile, String format) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(outfile);
            this.write(out);
        }
        catch (Throwable ex) {
            try {
                throw new RuntimeException("Can't write DAL file.", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    public void write(OutputStream out) {
        if (FutureUtils.use((String)"JsonDalFormat")) {
            this.write(out, "JSON");
        } else {
            this.write(out, "BIN");
        }
    }

    public void write(OutputStream out, String format) {
        try {
            switch (StringUtils.upperCase((String)format)) {
                case "JSON": {
                    org.gvsig.json.JsonObjectBuilder builder = Json.createObjectBuilder();
                    builder.add("version", "2.7.0a");
                    builder.add("updated", ZonedDateTime.now().withZoneSameInstant(ZoneOffset.UTC).toString());
                    org.gvsig.json.JsonArrayBuilder typesBuilder = Json.createArrayBuilder();
                    for (FeatureType featureType : this.featureTypes) {
                        typesBuilder.add((JsonObjectBuilder)featureType.toJsonBuilder());
                    }
                    builder.add("featureTypes", (JsonArrayBuilder)typesBuilder);
                    IOUtils.write((String)builder.build().toString(), (OutputStream)out, (Charset)StandardCharsets.UTF_8);
                    break;
                }
                case "HEX": {
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    PersistenceManager manager = ToolsLocator.getPersistenceManager();
                    PersistentState state = manager.getState((Object)this);
                    manager.saveState(state, (OutputStream)buffer);
                    IOUtils.write((String)Hex.encodeHexString((byte[])buffer.toByteArray()), (OutputStream)out, (Charset)StandardCharsets.UTF_8);
                    break;
                }
                default: {
                    PersistenceManager manager = ToolsLocator.getPersistenceManager();
                    PersistentState state = manager.getState((Object)this);
                    manager.saveState(state, out);
                    break;
                }
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException("Can't write DAL resource.", ex);
        }
    }

    public void read(ResourcesStorage.Resource resource) {
        BufferedInputStream bin;
        if (resource == null) {
            throw new IllegalArgumentException("Resource null is not a valid resource");
        }
        try {
            InputStream in = resource.asInputStream();
            bin = new BufferedInputStream(in);
            bin.mark(5000);
        }
        catch (Throwable ex) {
            throw new RuntimeException("Can't read DAL resource (resname=" + resource.getName() + ", resurl=" + Objects.toString(resource.getURL()) + ", restype=" + resource.getClass().getName() + ").", ex);
        }
        try {
            this.readFromDalFormat(bin);
            return;
        }
        catch (Throwable ex) {
            LOGGER.debug("Can't read DAL resource from DAL format", ex);
            try {
                bin.reset();
                this.readFromJson(bin);
            }
            catch (Throwable ex2) {
                throw new RuntimeException("Can't read DAL resource (resname=" + resource.getName() + ", resurl=" + Objects.toString(resource.getURL()) + ", restype=" + resource.getClass().getName() + ").", ex2);
            }
            return;
        }
    }

    public void readFromDalFormat(BufferedInputStream in) {
        if (in == null) {
            throw new IllegalArgumentException("Resource null is not a valid resource");
        }
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DALFile x = (DALFile)manager.getObject((InputStream)in);
        this.featureTypes.clear();
        this.featureTypes.addAll(x.featureTypes);
    }

    public void readFromJson(BufferedInputStream in) {
        if (in == null) {
            throw new IllegalArgumentException("Resource null is not a valid resource");
        }
        DataManager dataManager = DALLocator.getDataManager();
        JsonObject json = Json.createObject((InputStream)in);
        this.featureTypes.clear();
        if (json.containsKey((Object)"featureTypes") && !json.isNull("featureTypes")) {
            JsonArray theFeatureTypes = json.getJsonArray("featureTypes");
            for (JsonValue theFeatureType0 : theFeatureTypes) {
                JsonObject theFeatureType = (JsonObject)theFeatureType0;
                EditableFeatureType fetureType = dataManager.createFeatureType(theFeatureType);
                this.featureTypes.add((FeatureType)fetureType);
            }
        } else {
            EditableFeatureType fetureType = dataManager.createFeatureType(json);
            this.featureTypes.add((FeatureType)fetureType);
        }
    }

    public void setFeatureType(FeatureType featureType) throws DataException {
        this.featureTypes.clear();
        this.featureTypes.add(featureType.getCopy());
        this.defaultFeatureTypeId = featureType.getId();
    }

    public void setStore(DefaultFeatureStore store) throws DataException {
        this.featureTypes.clear();
        List theTypes = store.getFeatureTypes();
        for (FeatureType theType : theTypes) {
            FeatureType ft = theType.getCopy();
            ft = this.fixOID(store, ft);
            this.featureTypes.add(ft);
        }
        this.defaultFeatureTypeId = store.getDefaultFeatureType().getId();
    }

    private FeatureType fixOID(DefaultFeatureStore store, FeatureType featureType) {
        if (((FeatureStoreProviderFactory)store.getProviderFactory()).supportNumericOID() && !featureType.hasOID() && ArrayUtils.isEmpty((Object[])featureType.getPrimaryKey())) {
            EditableFeatureType eft = featureType.getEditable();
            eft.setHasOID(true);
            FeatureType necft = eft.getNotEditableCopy();
            return necft;
        }
        return featureType;
    }

    public void updateStore(DefaultFeatureStore store) throws DataException {
        ArrayList<FeatureType> theTypes = new ArrayList<FeatureType>();
        FeatureType defaultFeatureType = null;
        for (FeatureType type : this.featureTypes) {
            ((DefaultFeatureType)type).setStore(store);
            theTypes.add(type);
            if (!StringUtils.equals((CharSequence)this.defaultFeatureTypeId, (CharSequence)type.getId())) continue;
            defaultFeatureType = type;
        }
        if (theTypes.isEmpty()) {
            return;
        }
        if (defaultFeatureType == null) {
            defaultFeatureType = (FeatureType)theTypes.get(0);
        }
        FeatureType ft = this.fixOID(store, defaultFeatureType);
        if (theTypes.get(0) == defaultFeatureType) {
            theTypes.set(0, ft);
        }
        store.setFeatureTypes(theTypes, ft);
    }

    public List<FeatureType> getFeatureTypes() throws DataException {
        ArrayList<FeatureType> theTypes = new ArrayList<FeatureType>();
        for (FeatureType type : this.featureTypes) {
            theTypes.add(type);
        }
        if (theTypes.isEmpty()) {
            return null;
        }
        return theTypes;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("defaultFeatureType", this.defaultFeatureTypeId);
        state.set("featureTypes", this.featureTypes);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        try {
            this.defaultFeatureTypeId = state.getString("defaultFeatureType");
            List theTypes = state.getList("featureTypes");
            this.featureTypes.clear();
            for (FeatureType theType : theTypes) {
                this.featureTypes.add(theType);
            }
        }
        catch (Throwable th) {
            LOGGER.warn("Can't load DAL resource.", th);
            throw new PersistenceException(th);
        }
    }
}

