/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.feature.DataTypeDetector;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryCoercionContext;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.CoercionContext;
import org.gvsig.tools.dataTypes.CoercionContextLocale;
import org.gvsig.tools.dataTypes.DataTypesManager;

public class DataTypeDetectorImpl
implements DataTypeDetector {
    private Locale locale;
    private PossibleDataType possibleDataType;
    private DataTypeDetectedImpl detectedDataType;
    private Coercion toGeom;
    private CoercionContext coercionContext;
    private GeometryCoercionContext geometryCoercionContext;

    public DataTypeDetectorImpl(Locale locale) {
        this.init(locale);
    }

    private void init(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        DataTypesManager typeManager = ToolsLocator.getDataTypesManager();
        this.coercionContext = CoercionContextLocale.create((Locale)locale);
        this.toGeom = typeManager.getCoercion(66);
        this.geometryCoercionContext = GeometryLocator.getGeometryManager().createGeometryCoercionContext();
        this.geometryCoercionContext.setMode(4);
        this.detectedDataType = new DataTypeDetectedImpl();
        this.possibleDataType = new PossibleDataType();
        this.possibleDataType.possibleGeometryType = -1;
        this.possibleDataType.possibleGeometrySubtype = 4;
        this.locale = locale;
    }

    public void addValue(String rawvalue) {
        int displaySize;
        if (rawvalue == null) {
            return;
        }
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        if (this.detectedDataType.blank) {
            this.detectedDataType.blank = StringUtils.isBlank((CharSequence)rawvalue);
        }
        if ((displaySize = rawvalue.length()) > this.detectedDataType.displaySize) {
            this.detectedDataType.displaySize = displaySize;
        }
        if (StringUtils.isNotBlank((CharSequence)rawvalue)) {
            Number num;
            if (this.possibleDataType.possibleDecimal) {
                try {
                    BigDecimal decimal = this.toDecimal(rawvalue);
                    if (decimal == null) {
                        this.possibleDataType.possibleDecimal = false;
                    } else {
                        int integerDigits;
                        if (decimal.scale() > this.detectedDataType.decimalDigits) {
                            this.detectedDataType.decimalDigits = decimal.scale();
                        }
                        if ((integerDigits = decimal.precision() - decimal.scale()) > this.detectedDataType.integerDigits) {
                            this.detectedDataType.integerDigits = integerDigits;
                        }
                    }
                }
                catch (Exception ex) {
                    this.possibleDataType.possibleDecimal = false;
                }
            }
            if (this.possibleDataType.possibleDouble) {
                try {
                    num = this.toDouble(rawvalue);
                    this.possibleDataType.possibleDouble = num != null;
                }
                catch (Exception ex) {
                    this.possibleDataType.possibleDouble = false;
                }
            }
            if (this.possibleDataType.possibleFloat) {
                try {
                    num = this.toFloat(rawvalue);
                    this.possibleDataType.possibleFloat = num != null;
                }
                catch (Exception ex) {
                    this.possibleDataType.possibleFloat = false;
                }
            }
            if (this.possibleDataType.possibleLong) {
                this.possibleDataType.possibleLong = this.isValidLong(rawvalue);
            }
            if (this.possibleDataType.possibleInt) {
                this.possibleDataType.possibleInt = this.isValidInteger(rawvalue);
            }
            if (this.possibleDataType.possibleDate) {
                try {
                    this.possibleDataType.possibleDate = this.toDate(rawvalue) != null;
                }
                catch (Exception ex) {
                    this.possibleDataType.possibleDate = false;
                }
            }
            if (this.possibleDataType.possibleTime) {
                try {
                    this.possibleDataType.possibleTime = this.toTime(rawvalue) != null;
                }
                catch (Exception ex) {
                    this.possibleDataType.possibleTime = false;
                }
            }
            if (this.possibleDataType.possibleTimestamp) {
                try {
                    this.possibleDataType.possibleTimestamp = this.toTimestamp(rawvalue) != null;
                }
                catch (Exception ex) {
                    this.possibleDataType.possibleTimestamp = false;
                }
            }
            if (this.possibleDataType.possibleURL) {
                try {
                    new URL(rawvalue);
                    this.possibleDataType.possibleURL = true;
                }
                catch (Exception ex) {
                    this.possibleDataType.possibleURL = false;
                }
            }
            if (this.possibleDataType.possibleGeometry) {
                try {
                    Geometry geom = (Geometry)this.toGeom.coerce((Object)rawvalue, (CoercionContext)this.geometryCoercionContext);
                    if (geom == null) {
                        this.possibleDataType.possibleGeometry = true;
                    } else {
                        this.possibleDataType.possibleGeometry = true;
                        if (this.possibleDataType.possibleGeometryType == -1) {
                            this.possibleDataType.possibleGeometryType = geom.getGeometryType().getType();
                        } else if (this.possibleDataType.possibleGeometryType != geom.getGeometryType().getType()) {
                            this.possibleDataType.possibleGeometryType = 0;
                        }
                        if (this.possibleDataType.possibleGeometrySubtype == 4) {
                            this.possibleDataType.possibleGeometrySubtype = geom.getGeometryType().getSubType();
                        } else if (this.possibleDataType.possibleGeometrySubtype != geom.getGeometryType().getSubType()) {
                            this.possibleDataType.possibleGeometrySubtype = 1;
                        }
                    }
                }
                catch (Exception ex) {
                    this.possibleDataType.possibleGeometry = false;
                }
            }
        }
        if (this.possibleDataType.possibleInt) {
            this.detectedDataType.type = 4;
        } else if (this.possibleDataType.possibleLong) {
            this.detectedDataType.type = 5;
        } else if (this.possibleDataType.possibleDecimal) {
            this.detectedDataType.type = 19;
        } else if (this.possibleDataType.possibleFloat) {
            this.detectedDataType.type = 7;
        } else if (this.possibleDataType.possibleDouble) {
            this.detectedDataType.type = 7;
        } else if (this.possibleDataType.possibleURL) {
            this.detectedDataType.type = 16;
        } else if (this.possibleDataType.possibleDate) {
            this.detectedDataType.type = 9;
        } else if (this.possibleDataType.possibleTime) {
            this.detectedDataType.type = 10;
        } else if (this.possibleDataType.possibleTimestamp) {
            this.detectedDataType.type = 11;
        } else if (this.possibleDataType.possibleGeometry) {
            this.detectedDataType.type = 66;
            this.detectedDataType.geomtype = GeometryUtils.getGeometryType((int)this.possibleDataType.possibleGeometryType, (int)this.possibleDataType.possibleGeometrySubtype);
        } else {
            this.detectedDataType.type = 8;
            this.detectedDataType.displaySize = Math.max(10, this.detectedDataType.displaySize);
        }
    }

    public DataTypeDetector.DataTypeDetected getDataType() {
        return this.detectedDataType;
    }

    private boolean isValidLong(String s) {
        if (s == null) {
            return true;
        }
        if ((s = s.trim().toLowerCase()).isEmpty()) {
            return true;
        }
        try {
            if (s.startsWith("0x")) {
                Long.valueOf(s.substring(2), 16);
            } else {
                Long.valueOf(s);
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean isValidInteger(String s) {
        if (s == null) {
            return true;
        }
        if ((s = s.trim().toLowerCase()).isEmpty()) {
            return true;
        }
        try {
            if (s.startsWith("0x")) {
                Integer.valueOf(s.substring(2), 16);
            } else {
                Integer.valueOf(s);
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private BigDecimal toDecimal(String s) {
        try {
            if (s.startsWith("+")) {
                s = s.substring(1);
            }
            ParsePosition p = new ParsePosition(0);
            DecimalFormat nf = (DecimalFormat)NumberFormat.getInstance(this.locale);
            nf.setParseBigDecimal(true);
            BigDecimal num = (BigDecimal)nf.parse(s, p);
            if (p.getErrorIndex() > 0 || p.getIndex() < s.length()) {
                return null;
            }
            return num;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private Double toDouble(String s) {
        try {
            if (s.startsWith("+")) {
                s = s.substring(1);
            }
            ParsePosition p = new ParsePosition(0);
            DecimalFormat nf = (DecimalFormat)NumberFormat.getInstance(this.locale);
            Number n = nf.parse(s, p);
            if (p.getErrorIndex() > 0 || p.getIndex() < s.length()) {
                return null;
            }
            double num = n.doubleValue();
            return num;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private Float toFloat(String s) {
        try {
            if (s.startsWith("+")) {
                s = s.substring(1);
            }
            ParsePosition p = new ParsePosition(0);
            DecimalFormat nf = (DecimalFormat)NumberFormat.getInstance(this.locale);
            Number n = nf.parse(s, p);
            if (p.getErrorIndex() > 0 || p.getIndex() < s.length()) {
                return null;
            }
            double num = n.doubleValue();
            if (num > 3.4028234663852886E38 || num < (double)1.4E-45f) {
                return null;
            }
            return Float.valueOf((float)num);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private Date toDate(String s) {
        DateFormat[] formatters;
        for (DateFormat formatter : formatters = new DateFormat[]{DateFormat.getDateInstance(3, this.locale), DateFormat.getDateInstance(2, this.locale), DateFormat.getDateInstance(1, this.locale), new SimpleDateFormat("yyyy-MM-dd")}) {
            formatter.setLenient(false);
            try {
                java.util.Date d = formatter.parse(s);
                if (d == null) continue;
                return new Date(d.getTime());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    private Time toTime(String s) {
        DateFormat[] formatters;
        for (DateFormat formatter : formatters = new DateFormat[]{DateFormat.getTimeInstance(2, this.locale), DateFormat.getTimeInstance(3, this.locale), DateFormat.getTimeInstance(1, this.locale), new SimpleDateFormat("HH:mm:ss"), new SimpleDateFormat("HH:mm")}) {
            formatter.setLenient(false);
            try {
                java.util.Date d = formatter.parse(s);
                if (d == null) continue;
                return new Time(d.getTime());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    private Timestamp toTimestamp(String s) {
        DateFormat[] formatters;
        for (DateFormat formatter : formatters = new DateFormat[]{DateFormat.getDateTimeInstance(2, 2, this.locale), DateFormat.getDateTimeInstance(2, 3, this.locale), DateFormat.getDateTimeInstance(2, 1, this.locale), DateFormat.getDateTimeInstance(3, 2, this.locale), DateFormat.getDateTimeInstance(3, 3, this.locale), DateFormat.getDateTimeInstance(3, 1, this.locale), DateFormat.getDateTimeInstance(1, 2, this.locale), DateFormat.getDateTimeInstance(1, 3, this.locale), DateFormat.getDateTimeInstance(1, 1, this.locale), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd HH:mm")}) {
            formatter.setLenient(false);
            try {
                java.util.Date d = formatter.parse(s);
                if (d == null) continue;
                return new Timestamp(d.getTime());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        try {
            return Timestamp.valueOf(s);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static class PossibleDataType {
        public boolean possibleInt = true;
        public boolean possibleFloat = true;
        public boolean possibleDouble = true;
        public boolean possibleDecimal = true;
        public boolean possibleLong = true;
        public boolean possibleURL = true;
        public boolean possibleDate = true;
        public boolean possibleTime = true;
        public boolean possibleTimestamp = true;
        public boolean possibleGeometry = true;
        private int possibleGeometrySubtype;
        private int possibleGeometryType;

        private PossibleDataType() {
        }
    }

    private static class DataTypeDetectedImpl
    implements DataTypeDetector.DataTypeDetected {
        private int type;
        private int displaySize;
        private int integerDigits;
        private int decimalDigits;
        private boolean blank;
        private GeometryType geomtype;

        private DataTypeDetectedImpl() {
        }

        public int getType() {
            return this.type;
        }

        public int getDisplaySize() {
            return this.displaySize;
        }

        public int getPrecision() {
            return this.decimalDigits + this.integerDigits;
        }

        public int getScale() {
            return this.decimalDigits;
        }

        public boolean isBlank() {
            return this.blank;
        }

        public GeometryType getGeometryType() {
            return this.geomtype;
        }

        public void setDisplaySize(int size) {
            this.displaySize = size;
        }
    }
}

