/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl;

import java.text.DateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import javax.json.JsonObject;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataTypeUtils;
import org.gvsig.fmap.dal.expressionevaluator.FeatureAttributeEmulatorExpression;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableForeingKey;
import org.gvsig.fmap.dal.feature.FeatureAttributeEmulator;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.exception.AttributeFeatureTypeIntegrityException;
import org.gvsig.fmap.dal.feature.exception.AttributeFeatureTypeSizeException;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.impl.DefaultForeingKey;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.json.Json;
import org.gvsig.json.JsonManager;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.json.SupportToJson;
import org.gvsig.timesupport.Interval;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.evaluator.Evaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEditableFeatureAttributeDescriptor
extends DefaultFeatureAttributeDescriptor
implements EditableFeatureAttributeDescriptor {
    private static Logger logger = LoggerFactory.getLogger(DefaultEditableFeatureAttributeDescriptor.class);
    private final DefaultFeatureAttributeDescriptor source;
    private boolean hasStrongChanges;
    private String originalName = null;

    protected DefaultEditableFeatureAttributeDescriptor(DefaultFeatureAttributeDescriptor other) {
        super(other);
        if (other instanceof DefaultEditableFeatureAttributeDescriptor) {
            DefaultEditableFeatureAttributeDescriptor other_edi = (DefaultEditableFeatureAttributeDescriptor)other;
            this.originalName = other_edi.getOriginalName();
            this.source = other_edi.getSource();
        } else {
            this.source = other;
        }
        this.hasStrongChanges = false;
    }

    public DefaultEditableFeatureAttributeDescriptor(FeatureType type, boolean strongChanges) {
        super(type);
        this.source = null;
        this.hasStrongChanges = strongChanges;
    }

    public DefaultFeatureAttributeDescriptor getSource() {
        return this.source;
    }

    @Override
    public void fixAll() {
        super.fixAll();
    }

    public void checkIntegrity() throws AttributeFeatureTypeIntegrityException {
        AttributeFeatureTypeIntegrityException ex = new AttributeFeatureTypeIntegrityException(this.getName());
        if (this.size < 0) {
            ex.add((Object)new AttributeFeatureTypeSizeException(this.size));
        }
        if (this.dataType.isObject() && this.objectClass == null) {
            logger.warn("Incorrect data type object, objectClass is null.");
            ex.add((Object)new AttributeFeatureTypeIntegrityException(this.name));
        }
        if (ex.size() > 0) {
            throw ex;
        }
    }

    public EditableFeatureAttributeDescriptor setAllowNull(boolean allowNull) {
        this.updateStrongChanges(this.allowNull, allowNull);
        this.allowNull = allowNull;
        this.setFixed(false);
        return this;
    }

    public EditableForeingKey getForeingKey() {
        if (this.foreingKey == null) {
            this.foreingKey = new DefaultForeingKey();
            this.foreingKey.setDescriptor(this);
        }
        return this.foreingKey;
    }

    public EditableFeatureAttributeDescriptor setDataType(DataType dataType) {
        this.updateStrongChanges((Object)this.dataType, dataType);
        this.dataType = dataType;
        this.setFixed(false);
        return this;
    }

    public EditableFeatureAttributeDescriptor setDataType(int type) {
        this.updateStrongChanges(this.dataType, type);
        this.dataType = ToolsLocator.getDataTypesManager().get(type);
        this.setFixed(false);
        return this;
    }

    public EditableFeatureAttributeDescriptor setDefaultValue(Object defaultValue) {
        this.updateStrongChanges(this.defaultValue, defaultValue);
        this.defaultValue = defaultValue;
        this.setFixed(false);
        return this;
    }

    public EditableFeatureAttributeDescriptor setDefaultFieldValue(Object defaultValue) {
        return this.setDefaultValue(defaultValue);
    }

    public EditableFeatureAttributeDescriptor setAvoidCachingAvailableValues(boolean avoidCachingAvailableValues) {
        this.avoidCachingAvailableValues = avoidCachingAvailableValues;
        this.setFixed(false);
        return this;
    }

    public EditableFeatureAttributeDescriptor setEvaluator(Evaluator evaluator) {
        this.updateStrongChanges(this.evaluator, evaluator);
        this.evaluator = evaluator;
        this.setFixed(false);
        return this;
    }

    public EditableFeatureAttributeDescriptor setFeatureAttributeEmulator(FeatureAttributeEmulator featureAttributeEmulator) {
        this.featureAttributeEmulator = featureAttributeEmulator;
        this.setFixed(false);
        return this;
    }

    public EditableFeatureAttributeDescriptor setFeatureAttributeEmulator(Expression expression) {
        if (ExpressionUtils.isPhraseEmpty((Expression)expression)) {
            this.setFeatureAttributeEmulator((FeatureAttributeEmulator)null);
            return this;
        }
        FeatureAttributeEmulatorExpression emulator = DALLocator.getDataManager().createFeatureAttributeEmulatorExpression(this.getFeatureType(), expression);
        return this.setFeatureAttributeEmulator((FeatureAttributeEmulator)emulator);
    }

    public EditableFeatureAttributeDescriptor setFeatureAttributeEmulator(String expression) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            this.setFeatureAttributeEmulator((FeatureAttributeEmulator)null);
            return this;
        }
        return this.setFeatureAttributeEmulator(ExpressionUtils.createExpression((String)expression));
    }

    public EditableFeatureAttributeDescriptor setGeometryType(int type) {
        this.geometryType = type;
        if (this.geometrySubType == 4) {
            this.geometrySubType = 0;
        }
        this.geomType = null;
        this.setFixed(false);
        return this;
    }

    public EditableFeatureAttributeDescriptor setGeometrySubType(int subType) {
        this.geometrySubType = subType;
        this.geomType = null;
        this.setFixed(false);
        return this;
    }

    public EditableFeatureAttributeDescriptor setGeometryType(GeometryType geometryType) {
        this.updateStrongChanges(this.geomType, geometryType);
        this.geomType = geometryType;
        this.geometryType = this.geomType.getType();
        this.geometrySubType = this.geomType.getSubType();
        this.setFixed(false);
        return this;
    }

    public EditableFeatureAttributeDescriptor setGeometryType(String geometryType) {
        if (StringUtils.isBlank((CharSequence)geometryType)) {
            throw new IllegalArgumentException("Invalid geometry type (null)");
        }
        String separators = ":/-!;#@";
        Character sep = null;
        for (char ch : separators.toCharArray()) {
            if (geometryType.indexOf(ch) < 0) continue;
            sep = Character.valueOf(ch);
            break;
        }
        if (sep == null) {
            throw new IllegalArgumentException("Invalid geometry type (" + geometryType + ") can't find separator, format can be GEOMETRYTYPE[" + separators + "]GEOMETRYSUBTYPE");
        }
        String[] xx = geometryType.split("[" + sep + "]");
        int theGeomType = GeometryUtils.getGeometryType((String)xx[0]);
        int theGeomSubtype = GeometryUtils.getGeometrySubtype((String)xx[1]);
        this.setGeometryType(theGeomType, theGeomSubtype);
        this.setFixed(false);
        return this;
    }

    public EditableFeatureAttributeDescriptor setGeometryType(int type, int subType) {
        this.geometryType = type;
        this.geometrySubType = subType;
        this.geomType = null;
        this.setFixed(false);
        return this;
    }

    public EditableFeatureAttributeDescriptor setIsPrimaryKey(boolean isPrimaryKey) {
        this.updateStrongChanges(this.primaryKey, isPrimaryKey);
        this.primaryKey = isPrimaryKey;
        this.setFixed(false);
        return this;
    }

    public EditableFeatureAttributeDescriptor setIsReadOnly(boolean isReadOnly) {
        this.updateStrongChanges(this.readOnly, isReadOnly);
        this.readOnly = isReadOnly;
        this.setFixed(false);
        return this;
    }

    public EditableFeatureAttributeDescriptor setMaximumOccurrences(int maximumOccurrences) {
        this.updateStrongChanges(this.maximumOccurrences, maximumOccurrences);
        this.maximumOccurrences = maximumOccurrences;
        this.setFixed(false);
        return this;
    }

    public EditableFeatureAttributeDescriptor setMinimumOccurrences(int minimumOccurrences) {
        this.updateStrongChanges(this.minimumOccurrences, minimumOccurrences);
        this.minimumOccurrences = minimumOccurrences;
        this.setFixed(false);
        return this;
    }

    public EditableFeatureAttributeDescriptor setName(String name) {
        if (StringUtils.equals((CharSequence)this.name, (CharSequence)name)) {
            return this;
        }
        if (this.originalName == null) {
            this.originalName = this.name;
            if (!this.isComputed()) {
                this.hasStrongChanges = true;
            }
        }
        super.setName(name);
        if (!this.isComputed()) {
            this.hasStrongChanges = true;
        }
        this.setFixed(false);
        return this;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public EditableFeatureAttributeDescriptor setObjectClass(Class theClass) {
        this.updateStrongChanges(this.objectClass, theClass);
        this.objectClass = theClass;
        this.setFixed(false);
        return this;
    }

    public EditableFeatureAttributeDescriptor setPrecision(int precision) {
        this.updateStrongChanges(this.precision, precision);
        this.precision = precision;
        this.setFixed(false);
        return this;
    }

    public EditableFeatureAttributeDescriptor setScale(int scale) {
        this.updateStrongChanges(this.scale, scale);
        this.scale = scale;
        this.coerceContext = null;
        this.mathContext = null;
        this.setFixed(false);
        return this;
    }

    public EditableFeatureAttributeDescriptor setSRS(IProjection SRS) {
        this.updateStrongChanges(this.SRS, SRS);
        this.SRS = SRS;
        this.setFixed(false);
        return this;
    }

    public EditableFeatureAttributeDescriptor setSRS(String SRS) {
        if (StringUtils.isBlank((CharSequence)SRS)) {
            this.setSRS((IProjection)null);
            return this;
        }
        SRS = SRS.replace('@', ':');
        IProjection proj = CRSFactory.getCRS((String)SRS);
        this.setSRS(proj);
        this.setFixed(false);
        return this;
    }

    public EditableFeatureAttributeDescriptor setInterval(Interval interval) {
        this.updateStrongChanges(this.getInterval(), interval);
        super.setInterval(interval);
        this.setFixed(false);
        return this;
    }

    public EditableFeatureAttributeDescriptor setSize(int size) {
        this.updateStrongChanges(this.size, size);
        this.size = size;
        this.setFixed(false);
        return this;
    }

    public boolean hasStrongChanges() {
        return this.hasStrongChanges;
    }

    public EditableFeatureAttributeDescriptor setAdditionalInfo(String infoName, Object value) {
        return this.setAdditionalInfo(infoName, Objects.toString(value, ""));
    }

    public EditableFeatureAttributeDescriptor setAdditionalInfo(String infoName, String value) {
        if (this.additionalInfo == null) {
            this.additionalInfo = new HashMap();
        }
        this.additionalInfo.put(infoName, value);
        this.setFixed(false);
        return this;
    }

    public EditableFeatureAttributeDescriptor setIsAutomatic(boolean isAutomatic) {
        this.isAutomatic = isAutomatic;
        this.setFixed(false);
        return this;
    }

    public EditableFeatureAttributeDescriptor setIsTime(boolean isTime) {
        this.updateStrongChanges(this.isTime, isTime);
        this.isTime = isTime;
        this.setFixed(false);
        return this;
    }

    public EditableFeatureAttributeDescriptor setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        this.setFixed(false);
        return this;
    }

    public EditableFeatureAttributeDescriptor setIsIndexed(boolean isIndexed) {
        this.updateStrongChanges(this.indexed, isIndexed);
        this.indexed = isIndexed;
        this.setFixed(false);
        return this;
    }

    public EditableFeatureAttributeDescriptor setAllowIndexDuplicateds(boolean allowDuplicateds) {
        this.updateStrongChanges(this.allowIndexDuplicateds, allowDuplicateds);
        this.allowIndexDuplicateds = allowDuplicateds;
        this.setFixed(false);
        return this;
    }

    public EditableFeatureAttributeDescriptor setIsIndexAscending(boolean ascending) {
        this.updateStrongChanges(this.isIndexAscending, ascending);
        this.isIndexAscending = ascending;
        this.setFixed(false);
        return this;
    }

    public EditableFeatureAttributeDescriptor setDataProfileName(String dataProfile) {
        super.setDataProfileName(dataProfile);
        this.setFixed(false);
        return this;
    }

    private void updateStrongChanges(int previous, int newvalue) {
        if (this.isComputed()) {
            return;
        }
        if (previous == newvalue) {
            return;
        }
        this.hasStrongChanges = true;
    }

    private void updateStrongChanges(DataType previous, int newvalue) {
        if (this.isComputed()) {
            return;
        }
        if (previous != null && previous.getType() == newvalue) {
            return;
        }
        this.hasStrongChanges = true;
    }

    private void updateStrongChanges(boolean previous, boolean newvalue) {
        if (this.isComputed()) {
            return;
        }
        if (previous == newvalue) {
            return;
        }
        this.hasStrongChanges = true;
    }

    private void updateStrongChanges(Object previous, Object newvalue) {
        if (this.isComputed()) {
            return;
        }
        if (Objects.equals(newvalue, previous)) {
            return;
        }
        this.hasStrongChanges = true;
    }

    public EditableFeatureAttributeDescriptor setLocale(Locale locale) {
        this.locale = locale == null ? Locale.ENGLISH : locale;
        this.coerceContext = null;
        this.mathContext = null;
        this.setFixed(false);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EditableFeatureAttributeDescriptor setLocale(String locale) {
        try {
            String s = DataTypeUtils.toString((Object)locale, null);
            if (StringUtils.isBlank((CharSequence)s)) {
                EditableFeatureAttributeDescriptor editableFeatureAttributeDescriptor = this.setLocale((Locale)null);
                return editableFeatureAttributeDescriptor;
            }
            Locale l = new Locale(s);
            EditableFeatureAttributeDescriptor editableFeatureAttributeDescriptor = this.setLocale(l);
            return editableFeatureAttributeDescriptor;
        }
        catch (Exception ex) {
            EditableFeatureAttributeDescriptor editableFeatureAttributeDescriptor = this.setLocale((Locale)null);
            return editableFeatureAttributeDescriptor;
        }
        finally {
            this.setFixed(false);
        }
    }

    public EditableFeatureAttributeDescriptor setRoundMode(int roundMode) {
        switch (roundMode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.roundMode = roundMode;
                this.coerceContext = null;
                this.mathContext = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("round mode '" + roundMode + "' not valid.");
            }
        }
        this.setFixed(false);
        return this;
    }

    public EditableFeatureAttributeDescriptor set(String name, Object value) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Name can't be empty");
        }
        switch (name.trim().toLowerCase()) {
            case "isavoidcachingavailablevalues": 
            case "avoidcachingavailablevalues": 
            case "nocachingavailablevalues": {
                this.setAvoidCachingAvailableValues(DataTypeUtils.toBoolean((Object)value, (boolean)false));
                break;
            }
            case "availablevalues": {
                this.setAvailableValuesExpression(DataTypeUtils.toString((Object)value, null));
                break;
            }
            case "isreadonly": 
            case "readonly": {
                this.setIsReadOnly(DataTypeUtils.toBoolean((Object)value, (boolean)false));
                break;
            }
            case "mandatory": {
                this.setMandatory(DataTypeUtils.toBoolean((Object)value, (boolean)false));
                break;
            }
            case "hidden": {
                this.setHidden(DataTypeUtils.toBoolean((Object)value, (boolean)false));
                break;
            }
            case "allownull": {
                this.setAllowNull(DataTypeUtils.toBoolean((Object)value, (boolean)false));
                break;
            }
            case "indexed": 
            case "isindexed": {
                this.setIsIndexed(DataTypeUtils.toBoolean((Object)value, (boolean)false));
                break;
            }
            case "indexasc": 
            case "indexascending": 
            case "isindexascending": {
                this.setIsIndexAscending(DataTypeUtils.toBoolean((Object)value, (boolean)false));
                break;
            }
            case "pk": 
            case "ispk": 
            case "primarykey": 
            case "isprimarykey": {
                this.setIsPrimaryKey(DataTypeUtils.toBoolean((Object)value, (boolean)false));
                break;
            }
            case "allowindexduplicateds": {
                this.setAllowIndexDuplicateds(DataTypeUtils.toBoolean((Object)value, (boolean)false));
                break;
            }
            case "isautomatic": 
            case "automatic": {
                this.setIsAutomatic(DataTypeUtils.toBoolean((Object)value, (boolean)false));
                break;
            }
            case "time": 
            case "istime": {
                this.setIsTime(DataTypeUtils.toBoolean((Object)value, (boolean)false));
                break;
            }
            case "profile": {
                this.setDataProfileName(DataTypeUtils.toString((Object)value, null));
                break;
            }
            case "group": {
                this.setGroup(DataTypeUtils.toString((Object)value, null));
                break;
            }
            case "description": {
                this.setDescription(DataTypeUtils.toString((Object)value, null));
                break;
            }
            case "label": {
                this.setLabel(DataTypeUtils.toString((Object)value, null));
                break;
            }
            case "shortlabel": {
                this.setShortLabel(DataTypeUtils.toString((Object)value, null));
                break;
            }
            case "expression": {
                this.setFeatureAttributeEmulator(DataTypeUtils.toString((Object)value, null));
                break;
            }
            case "size": {
                this.setSize(DataTypeUtils.toInteger((Object)value, (int)50));
                break;
            }
            case "displaysize": {
                this.setDisplaySize(DataTypeUtils.toInteger((Object)value, (int)50));
                break;
            }
            case "precision": {
                this.setPrecision(DataTypeUtils.toInteger((Object)value, (int)10));
                break;
            }
            case "scale": {
                this.setScale(DataTypeUtils.toInteger((Object)value, (int)10));
                break;
            }
            case "roundmode": {
                this.setRoundMode(DataTypeUtils.toInteger((Object)value, (int)7));
                break;
            }
            case "locale": {
                this.setLocale(DataTypeUtils.toString((Object)value, null));
                break;
            }
            case "order": {
                this.setOrder(DataTypeUtils.toInteger((Object)value, (int)0));
                break;
            }
            case "fk": 
            case "foreingkey": {
                this.getForeingKey().setForeingKey(DataTypeUtils.toBoolean((Object)value, (boolean)false));
                break;
            }
            case "fk_code": 
            case "foreingkey_code": 
            case "foreingkey.code": {
                this.getForeingKey().setCodeName(DataTypeUtils.toString((Object)value, (String)""));
                break;
            }
            case "fk_label": 
            case "foreingkey_label": 
            case "foreingkey.label": {
                this.getForeingKey().setLabelFormula(DataTypeUtils.toString((Object)value, (String)""));
                break;
            }
            case "fk_closed": 
            case "fk_closedlist": 
            case "fk.closedlist": 
            case "foreingkey_closedlist": 
            case "foreingkey.closedlist": {
                this.getForeingKey().setClosedList(DataTypeUtils.toBoolean((Object)value, (boolean)false));
                break;
            }
            case "fk_table": 
            case "foreingkey_table": 
            case "foreingkey.table": {
                this.getForeingKey().setTableName(DataTypeUtils.toString((Object)value, null));
                break;
            }
            case "interval": {
                this.setInterval(DataTypeUtils.toInterval((Object)value, null));
                break;
            }
            case "geomtype": 
            case "geometrytype": {
                this.setGeometryType(DataTypeUtils.toString((Object)value, null));
                break;
            }
            case "srs": {
                this.setSRS(DataTypeUtils.toString((Object)value, null));
                break;
            }
            case "relation": {
                this.setRelationType(this.toRelation(value));
                break;
            }
            case "name": {
                this.setName(DataTypeUtils.toString((Object)value, null));
                break;
            }
            case "type": 
            case "datatype": {
                String ss = DataTypeUtils.toString((Object)value, null);
                if (StringUtils.isBlank((CharSequence)ss)) break;
                this.setDataType(ToolsLocator.getDataTypesManager().getType(ss));
                break;
            }
            case "defaultvalue": {
                this.setDefaultValue(value);
                break;
            }
            case "availablevaluesfilter": {
                this.setAvailableValuesFilter(DataTypeUtils.toString((Object)value, null));
                break;
            }
            case "format": 
            case "defaultformat": {
                this.setDefaultFormat(DataTypeUtils.toString((Object)value, null));
                break;
            }
            default: {
                throw new IllegalArgumentException("Name attribute '" + name + "' not valid.");
            }
        }
        this.setFixed(false);
        return this;
    }

    private int toRelation(Object value) {
        if (value == null) {
            return 0;
        }
        Integer x = (Integer)DataTypeUtils.coerce((int)4, (Object)value, null);
        if (x != null) {
            return x;
        }
        try {
            String s;
            switch (s = value.toString().toUpperCase()) {
                default: {
                    return 0;
                }
                case "IDENTITY": {
                    return 2;
                }
                case "COLLABORATION": {
                    return 1;
                }
                case "COMPOSITION": {
                    return 3;
                }
                case "AGGREGATE": 
            }
            return 4;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public EditableFeatureAttributeDescriptor setDisplaySize(int size) {
        this.displaySize = size;
        this.setFixed(false);
        return this;
    }

    public EditableFeatureAttributeDescriptor setAvailableValuesFilter(Expression filter) {
        super.setAvailableValuesFilter(filter);
        return this;
    }

    public EditableFeatureAttributeDescriptor setAvailableValuesFilter(String filter) {
        super.setAvailableValuesFilter(filter);
        return this;
    }

    public EditableFeatureAttributeDescriptor setForeingkey(boolean isForeingkey, boolean isClosedList, String tableName, String codeName, String labelFormula) {
        if (isForeingkey) {
            EditableForeingKey fk = this.getForeingKey();
            fk.setForeingKey(isForeingkey);
            fk.setClosedList(isClosedList);
            fk.setTableName(tableName);
            fk.setCodeName(codeName);
            fk.setLabelFormula(labelFormula);
        } else {
            this.foreingKey = null;
        }
        this.setFixed(false);
        return this;
    }

    public EditableFeatureAttributeDescriptor setTag(String name, Object value) {
        this.getTags().set(name, value);
        this.setFixed(false);
        return this;
    }

    public static void selfRegister() {
        Json.registerSerializer((JsonManager.JsonSerializer)new TheJsonSerializer());
    }

    public EditableFeatureAttributeDescriptor setDefaultFormat(String format) {
        this.defaultFormat = format;
        this.setFixed(false);
        return this;
    }

    private static class TheJsonSerializer
    implements JsonManager.JsonSerializer {
        public Class getObjectClass() {
            return DefaultEditableFeatureAttributeDescriptor.class;
        }

        public Object toObject(JsonObject json) {
            DefaultFeatureAttributeDescriptor o = new DefaultFeatureAttributeDescriptor();
            o.fromJson(json);
            return o;
        }

        public JsonObjectBuilder toJsonBuilder(Object value) {
            return ((SupportToJson)value).toJsonBuilder();
        }
    }
}

