/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl;

import java.text.MessageFormat;
import java.util.Iterator;
import javax.json.JsonObject;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.dal.DataTypeUtils;
import org.gvsig.fmap.dal.exception.DataListException;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureAttributeEmulator;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.exception.FeatureTypeIntegrityException;
import org.gvsig.fmap.dal.feature.impl.DefaultEditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureType;
import org.gvsig.fmap.dal.impl.DefaultDataManager;
import org.gvsig.json.Json;
import org.gvsig.json.JsonManager;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.json.SupportToJson;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.observer.Notification;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;

public class DefaultEditableFeatureType
extends DefaultFeatureType
implements EditableFeatureType,
Observer {
    private static final long serialVersionUID = -713976880396024389L;
    private boolean hasStrongChanges;
    private DefaultFeatureType source;

    public DefaultEditableFeatureType(FeatureStore store) {
        super(store);
        this.hasStrongChanges = false;
        this.source = null;
    }

    public DefaultEditableFeatureType(FeatureStore store, String id) {
        super(store, id);
        this.hasStrongChanges = false;
        this.source = null;
    }

    protected DefaultEditableFeatureType(DefaultEditableFeatureType other) {
        super(other);
        this.hasStrongChanges = other.hasStrongChanges;
        this.source = (DefaultFeatureType)other.getSource();
    }

    protected DefaultEditableFeatureType(DefaultFeatureType other) {
        super(other);
        this.source = other;
        this.fixAll();
    }

    @Override
    protected DefaultFeatureAttributeDescriptor getCopyAttributeDescriptor(DefaultFeatureAttributeDescriptor src) {
        DefaultEditableFeatureAttributeDescriptor copy = new DefaultEditableFeatureAttributeDescriptor(src);
        copy.setFeatureType(this);
        return copy;
    }

    public void forceStrongChanges() {
        this.hasStrongChanges = true;
    }

    public boolean hasStrongChanges() {
        if (this.hasStrongChanges) {
            return true;
        }
        for (DefaultEditableFeatureAttributeDescriptor attr : this) {
            if (attr.isComputed() || !attr.hasStrongChanges()) continue;
            return true;
        }
        return false;
    }

    @Override
    public FeatureType getCopy() {
        DefaultEditableFeatureType copy = new DefaultEditableFeatureType(this);
        copy.fixAll();
        return copy;
    }

    @Override
    public EditableFeatureType getEditable() {
        return (EditableFeatureType)this.getCopy();
    }

    public boolean addAll(DefaultFeatureType other) {
        for (DefaultFeatureAttributeDescriptor attr : other) {
            DefaultEditableFeatureAttributeDescriptor editableAttr = attr instanceof DefaultEditableFeatureAttributeDescriptor ? new DefaultEditableFeatureAttributeDescriptor(attr) : new DefaultEditableFeatureAttributeDescriptor(attr);
            editableAttr.addObserver(this);
            super.add(editableAttr);
        }
        this.pk = null;
        this.fixAll();
        return true;
    }

    public EditableFeatureAttributeDescriptor addLike(FeatureAttributeDescriptor other) {
        DefaultEditableFeatureAttributeDescriptor editableAttr = new DefaultEditableFeatureAttributeDescriptor((DefaultFeatureAttributeDescriptor)other);
        super.add(editableAttr);
        if (!editableAttr.isComputed()) {
            this.hasStrongChanges = true;
        }
        editableAttr.addObserver(this);
        this.fixAll();
        return editableAttr;
    }

    public FeatureType getSource() {
        return this.source;
    }

    public FeatureType getNotEditableCopy() {
        this.fixAll();
        DefaultFeatureType copy = new DefaultFeatureType(this, false);
        for (DefaultFeatureAttributeDescriptor attr : this) {
            DefaultFeatureAttributeDescriptor newattr = new DefaultFeatureAttributeDescriptor(attr);
            newattr.setFeatureType(copy);
            copy.add(newattr);
        }
        copy.fixAll();
        return copy;
    }

    public EditableFeatureAttributeDescriptor add(String name, int type) {
        return this.add(name, type, true);
    }

    public void removeAll() {
        while (!super.isEmpty()) {
            FeatureAttributeDescriptor attr = (FeatureAttributeDescriptor)this.get(0);
            if (attr instanceof Observable) {
                ((Observable)attr).deleteObserver((Observer)this);
            }
            super.remove(0);
        }
        this.fixAll();
    }

    @Override
    public void addAll(FeatureType attributes) {
        super.addAll(attributes);
        this.fixAll();
    }

    private EditableFeatureAttributeDescriptor add(String name, int type, boolean strongChanges) {
        for (EditableFeatureAttributeDescriptor descriptor : this) {
            if (!descriptor.getName().equalsIgnoreCase(name)) continue;
            throw new IllegalArgumentException(MessageFormat.format("Duplicated name descriptor {0}.", name));
        }
        DefaultEditableFeatureAttributeDescriptor attr = DefaultDataManager.createEditableFeatureAttributeDescriptor(this, name, type, strongChanges);
        attr.setIndex(this.size());
        this.hasStrongChanges = this.hasStrongChanges || strongChanges;
        super.add(attr);
        this.pk = null;
        attr.addObserver(this);
        this.fixed = false;
        return attr;
    }

    public EditableFeatureAttributeDescriptor add(String name, int type, int size) {
        return this.add(name, type, true).setSize(size);
    }

    public EditableFeatureAttributeDescriptor add(String name, int type, Evaluator evaluator) {
        if (evaluator == null) {
            throw new IllegalArgumentException();
        }
        return this.add(name, type, false).setEvaluator(evaluator);
    }

    public EditableFeatureAttributeDescriptor add(String name, int type, FeatureAttributeEmulator emulator) {
        if (emulator == null) {
            throw new IllegalArgumentException();
        }
        return this.add(name, type, false).setFeatureAttributeEmulator(emulator);
    }

    public EditableFeatureAttributeDescriptor add(String name, String type) {
        return this.add(name, ToolsLocator.getDataTypesManager().getType(type));
    }

    public EditableFeatureAttributeDescriptor add(String name, String type, int size) {
        return this.add(name, ToolsLocator.getDataTypesManager().getType(type), size);
    }

    public Object removeAttributeDescriptor(String name) {
        return this.remove(name);
    }

    public boolean removeAttributeDescriptor(EditableFeatureAttributeDescriptor attribute) {
        return this.remove(attribute);
    }

    @Override
    public FeatureAttributeDescriptor remove(int index) {
        FeatureAttributeDescriptor attr = (FeatureAttributeDescriptor)this.get(index);
        if (!attr.isComputed()) {
            this.hasStrongChanges = true;
        }
        if (index == this.getDefaultGeometryAttributeIndex()) {
            this.defaultGeometryAttributeIndex = -1;
            this.defaultGeometryAttributeName = null;
        } else if (index == this.getDefaultTimeAttributeIndex()) {
            this.defaultTimeAttributeIndex = -1;
            this.defaultTimeAttributeName = null;
        }
        super.remove(attr);
        this.fixed = false;
        this.pk = null;
        if (attr instanceof Observable) {
            ((Observable)attr).deleteObserver((Observer)this);
        }
        this.fixAll();
        return attr;
    }

    public Object remove(String name) {
        FeatureAttributeDescriptor attr = (FeatureAttributeDescriptor)this.get(name);
        if (attr == null) {
            return null;
        }
        this.remove(attr.getIndex());
        return attr;
    }

    public boolean remove(EditableFeatureAttributeDescriptor attribute) {
        this.remove(attribute.getIndex());
        return true;
    }

    @Override
    protected void fixAll() {
        if (this.fixed) {
            return;
        }
        super.fixAll();
        for (FeatureAttributeDescriptor attr : this) {
            DefaultEditableFeatureAttributeDescriptor attr2;
            if (!(attr instanceof DefaultEditableFeatureAttributeDescriptor) || !(attr2 = (DefaultEditableFeatureAttributeDescriptor)attr).hasStrongChanges()) continue;
            this.hasStrongChanges = true;
            break;
        }
        this.fixed = true;
    }

    public void checkIntegrity() throws DataListException {
        Iterator<FeatureAttributeDescriptor> iter = super.iterator();
        FeatureTypeIntegrityException ex = null;
        while (iter.hasNext()) {
            DefaultEditableFeatureAttributeDescriptor attr = (DefaultEditableFeatureAttributeDescriptor)iter.next();
            try {
                attr.checkIntegrity();
            }
            catch (Exception e) {
                if (ex == null) {
                    ex = new FeatureTypeIntegrityException(this.getId());
                }
                ex.add((Object)e);
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    public void setDefaultGeometryType(int type, int subType) {
        EditableFeatureAttributeDescriptor descr = (EditableFeatureAttributeDescriptor)this.getDefaultGeometryAttribute();
        if (descr == null) {
            throw new IllegalStateException("Default geometry attribute not set.");
        }
        descr.setGeometryType(type, subType);
        this.fixed = false;
    }

    public void setDefaultGeometryAttributeName(String name) {
        if (name == null || name.length() == 0) {
            this.defaultGeometryAttributeName = null;
            this.defaultGeometryAttributeIndex = -1;
            this.fixed = false;
            return;
        }
        FeatureAttributeDescriptor attr = this.getAttributeDescriptor(name);
        if (attr == null) {
            throw new IllegalArgumentException("Attribute '" + name + "' not found.");
        }
        this.defaultGeometryAttributeName = name;
        this.defaultGeometryAttributeIndex = attr.getIndex();
        this.fixed = false;
    }

    @Override
    public int getDefaultGeometryAttributeIndex() {
        this.fixAll();
        return this.defaultGeometryAttributeIndex;
    }

    @Override
    public String getDefaultGeometryAttributeName() {
        this.fixAll();
        return this.defaultGeometryAttributeName;
    }

    @Override
    public FeatureAttributeDescriptor getDefaultGeometryAttribute() {
        this.fixAll();
        return super.getDefaultGeometryAttribute();
    }

    @Override
    public int getDefaultTimeAttributeIndex() {
        this.fixAll();
        return this.defaultTimeAttributeIndex;
    }

    @Override
    public String getDefaultTimeAttributeName() {
        this.fixAll();
        return this.defaultTimeAttributeName;
    }

    public void setHasOID(boolean hasOID) {
        this.hasOID = hasOID;
        this.fixed = false;
    }

    @Override
    protected Iterator getIterator(Iterator iter) {
        return new EditableDelegatedIterator(iter, this);
    }

    public EditableFeatureAttributeDescriptor getEditableAttributeDescriptor(String name) {
        return (EditableFeatureAttributeDescriptor)this.getAttributeDescriptor(name);
    }

    public EditableFeatureAttributeDescriptor getEditableAttributeDescriptor(int index) {
        return (EditableFeatureAttributeDescriptor)this.getAttributeDescriptor(index);
    }

    public void setCheckFeaturesAtFinishEditing(boolean check) {
        this.checkFeaturesAtFinishEditing = check;
        this.fixed = false;
    }

    public void setCheckFeaturesAtInsert(boolean check) {
        this.checkFeaturesAtInsert = check;
        this.fixed = false;
    }

    protected void setAllowAutomaticValues(boolean value) {
        this.allowAtomaticValues = value;
        this.fixed = false;
    }

    @Override
    public void copyFrom(FeatureType other) {
        super.copyFrom(other);
        if (other instanceof EditableFeatureType) {
            DefaultEditableFeatureType other2 = (DefaultEditableFeatureType)other;
            this.hasStrongChanges = other2.hasStrongChanges();
            this.source = (DefaultFeatureType)other2.getSource();
        } else {
            this.hasStrongChanges = false;
            this.source = (DefaultFeatureType)other;
        }
        this.fixed = false;
    }

    public void copyFrom(JsonObject json) {
        this.fixed = false;
    }

    public void set(String name, String value) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Name can't be empty");
        }
        switch (name.trim().toLowerCase()) {
            case "checkfeaturesatfinishediting": {
                this.setCheckFeaturesAtFinishEditing(DataTypeUtils.toBoolean((Object)value, (boolean)false));
                break;
            }
            case "checkfeaturesatinsert": {
                this.setCheckFeaturesAtInsert(DataTypeUtils.toBoolean((Object)value, (boolean)false));
                break;
            }
            case "defaultgeometryattributename": 
            case "defaultgeometryname": 
            case "defaultgeometry": {
                this.setDefaultGeometryAttributeName(DataTypeUtils.toString((Object)value, null));
                break;
            }
            case "addcheckrule": {
                String jsons = DataTypeUtils.toString((Object)value, null);
                JsonObject json = Json.createObject((String)jsons);
                this.getRules().add(json.getString("name", null), json.getString("description", null), json.getBoolean("checkAtUpdate", false), json.getBoolean("checkAtFinishEdition", false), ExpressionUtils.createExpression((String)json.getString("expression", null)));
                break;
            }
            default: {
                throw new IllegalArgumentException("Name attribute '" + name + "' not valid.");
            }
        }
        this.fixed = false;
    }

    public static void selfRegister() {
        Json.registerSerializer((JsonManager.JsonSerializer)new TheJsonSerializer());
    }

    public void update(Observable observable, Object notification) {
        if (notification instanceof Notification && observable instanceof DefaultFeatureAttributeDescriptor) {
            DefaultFeatureAttributeDescriptor attr = (DefaultFeatureAttributeDescriptor)observable;
            Notification n = (Notification)notification;
            if (n.isOfType("fixed_changed") && !attr.isFixed()) {
                this.fixed = false;
            }
        }
    }

    private static class TheJsonSerializer
    implements JsonManager.JsonSerializer {
        public Class getObjectClass() {
            return DefaultEditableFeatureType.class;
        }

        public Object toObject(JsonObject json) {
            EditableFeatureType o = new DefaultFeatureType().getEditable();
            o.fromJson(json);
            return o;
        }

        public JsonObjectBuilder toJsonBuilder(Object value) {
            return ((SupportToJson)value).toJsonBuilder();
        }
    }

    protected class EditableDelegatedIterator
    extends DefaultFeatureType.DelegatedIterator {
        private final DefaultEditableFeatureType fType;

        public EditableDelegatedIterator(Iterator iter, DefaultEditableFeatureType fType) {
            super(DefaultEditableFeatureType.this, iter);
            this.fType = fType;
        }

        @Override
        public void remove() {
            this.iterator.remove();
            this.fType.fixAll();
        }
    }
}

