/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl;

import java.lang.ref.WeakReference;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.json.JsonObject;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.expressionevaluator.FeatureAttributeEmulatorExpression;
import org.gvsig.fmap.dal.feature.DataProfile;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureAttributeEmulator;
import org.gvsig.fmap.dal.feature.FeatureAttributeGetter;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.ForeingKey;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureType;
import org.gvsig.fmap.dal.feature.impl.DefaultForeingKey;
import org.gvsig.fmap.geom.GeometryCoercionContext;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.json.Json;
import org.gvsig.json.JsonManager;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.json.SupportToJson;
import org.gvsig.timesupport.Interval;
import org.gvsig.timesupport.RelativeInterval;
import org.gvsig.timesupport.TimeSupportLocator;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.CoercionContext;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.tools.dynobject.AbstractDynMethod;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynField_LabelAttribute;
import org.gvsig.tools.dynobject.DynField_v2;
import org.gvsig.tools.dynobject.DynMethod;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObjectUtils;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.dynobject.exception.DynFieldIsNotAContainerException;
import org.gvsig.tools.dynobject.exception.DynFieldValidateException;
import org.gvsig.tools.dynobject.exception.DynMethodException;
import org.gvsig.tools.dynobject.impl.DefaultTags;
import org.gvsig.tools.evaluator.AbstractEvaluator;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.evaluator.EvaluatorData;
import org.gvsig.tools.evaluator.EvaluatorException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.observer.BaseNotification;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.ObservableHelper;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFeatureAttributeDescriptor
implements FeatureAttributeDescriptor,
Persistent,
DynField_v2,
DynField_LabelAttribute,
Observable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DefaultFeatureAttributeDescriptor.class);
    public static final String NOTIFICATION_FIXED_CHANGED = "fixed_changed";
    protected boolean allowNull;
    protected DataType dataType;
    protected String dataProfile;
    protected DateFormat dateFormat;
    protected Object defaultValue;
    protected int index;
    protected int maximumOccurrences;
    protected int minimumOccurrences;
    protected int size;
    protected String name;
    protected Class objectClass;
    protected int precision = -1;
    protected int scale = -1;
    protected int roundMode = 4;
    protected Evaluator evaluator;
    protected boolean primaryKey;
    protected boolean readOnly;
    protected IProjection SRS;
    protected GeometryType geomType;
    protected int geometryType;
    protected int geometrySubType;
    protected Map<String, String> additionalInfo;
    protected boolean isAutomatic;
    protected boolean isTime = false;
    protected Interval interval;
    protected FeatureAttributeGetter featureAttributeGetter = null;
    protected FeatureAttributeEmulator featureAttributeEmulator = null;
    protected boolean indexed = false;
    protected boolean isIndexAscending = true;
    protected boolean allowIndexDuplicateds = true;
    protected DynObjectValueItem[] availableValues;
    protected DynObjectValueItem[] availableValuesCache;
    protected Expression availableValuesExpression;
    protected boolean avoidCachingAvailableValues;
    private Map<Object, String> labelOfValueMap;
    protected String description;
    protected Object minValue;
    protected Object maxValue;
    protected String label;
    protected String shortLabel;
    protected int order;
    protected boolean hidden;
    protected String groupName;
    protected Tags tags = new DefaultTags();
    private DynMethod availableValuesMethod;
    private DynMethod calculateMethod;
    private WeakReference typeRef;
    protected DefaultForeingKey foreingKey = null;
    protected CoercionContext coerceContext = null;
    protected MathContext mathContext = null;
    private int relationType = 0;
    protected Locale locale;
    protected int displaySize;
    protected String defaultFormat;
    protected boolean fixed = false;
    protected ObservableHelper observableHelper = new ObservableHelper();
    private static final String FEATATTRDESC_PERSISTENCE_DEFINITION_NAME = "FeatureAttributeDescriptor";
    private Expression availableValuesFilter;

    public DefaultFeatureAttributeDescriptor() {
    }

    protected DefaultFeatureAttributeDescriptor(FeatureType type) {
        this();
        this.setFeatureType(type);
        this.allowNull = true;
        this.dataType = null;
        this.dateFormat = null;
        this.defaultValue = null;
        this.defaultFormat = null;
        this.index = -1;
        this.maximumOccurrences = 0;
        this.minimumOccurrences = 0;
        this.size = 0;
        this.name = null;
        this.objectClass = null;
        this.precision = -1;
        this.scale = -1;
        this.roundMode = 4;
        this.evaluator = null;
        this.primaryKey = false;
        this.readOnly = false;
        this.SRS = null;
        this.geometryType = 16;
        this.geometrySubType = 4;
        this.additionalInfo = null;
        this.isAutomatic = false;
        this.hidden = false;
        this.relationType = 0;
        this.locale = null;
        this.displaySize = 0;
        this.avoidCachingAvailableValues = false;
    }

    protected DefaultFeatureAttributeDescriptor(DefaultFeatureAttributeDescriptor other) {
        this();
        this.copyFrom((DynField)other);
    }

    public void copyFrom(DynField other1) {
        if (!(other1 instanceof DefaultFeatureAttributeDescriptor)) {
            throw new IllegalArgumentException("Can't copy from a non DefaultFeatureAttributeDescriptor");
        }
        DefaultFeatureAttributeDescriptor other = (DefaultFeatureAttributeDescriptor)other1;
        this.typeRef = other.typeRef;
        this.allowNull = other.allowNull;
        this.dataType = other.dataType;
        this.dateFormat = other.dateFormat;
        this.defaultValue = other.defaultValue;
        this.defaultFormat = other.defaultFormat;
        this.index = other.index;
        this.maximumOccurrences = other.maximumOccurrences;
        this.minimumOccurrences = other.minimumOccurrences;
        this.size = other.size;
        this.name = other.name;
        this.objectClass = other.objectClass;
        this.precision = other.precision;
        this.scale = other.scale;
        this.roundMode = other.roundMode;
        this.evaluator = other.evaluator;
        this.primaryKey = other.primaryKey;
        this.readOnly = other.readOnly;
        this.SRS = other.SRS;
        this.geometryType = other.geometryType;
        this.geometrySubType = other.geometrySubType;
        this.geomType = other.geomType;
        if (other.additionalInfo != null) {
            this.additionalInfo = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : other.additionalInfo.entrySet()) {
                this.additionalInfo.put(entry.getKey(), entry.getValue());
            }
        } else {
            this.additionalInfo = null;
        }
        this.isAutomatic = other.isAutomatic;
        this.isTime = other.isTime;
        this.featureAttributeEmulator = other.featureAttributeEmulator;
        this.indexed = other.indexed;
        this.isIndexAscending = other.isIndexAscending;
        this.allowIndexDuplicateds = other.allowIndexDuplicateds;
        this.hidden = other.hidden;
        this.dataProfile = other.dataProfile;
        this.availableValues = other.availableValues;
        this.availableValuesExpression = other.availableValuesExpression;
        this.availableValuesFilter = other.availableValuesFilter;
        this.description = other.description;
        this.minValue = other.minValue;
        this.maxValue = other.maxValue;
        this.label = other.label;
        this.order = other.order;
        this.groupName = other.groupName;
        if (other.tags == null) {
            this.tags = null;
        } else {
            try {
                this.tags = other.tags.clone();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.foreingKey = null;
        if (other.foreingKey != null) {
            try {
                this.foreingKey = (DefaultForeingKey)other.foreingKey.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        if (this.foreingKey != null) {
            this.foreingKey.setDescriptor(this);
        }
        this.availableValuesMethod = other.availableValuesMethod;
        this.calculateMethod = other.calculateMethod;
        this.relationType = other.relationType;
        this.locale = other.locale;
        this.displaySize = other.displaySize;
        this.avoidCachingAvailableValues = other.avoidCachingAvailableValues;
    }

    public void setFeatureType(FeatureType type) {
        this.typeRef = type == null ? null : new WeakReference<FeatureType>(type);
        this.setFixed(false);
    }

    public String getDataTypeName() {
        if (this.getDataType() == null) {
            return "(unknow)";
        }
        return this.getDataType().getName();
    }

    public String getFullDataTypeName() {
        if (this.getDataType() == null) {
            return "(unknow)";
        }
        DataType dt = this.getDataType();
        if (dt.supportSize()) {
            return dt.getName() + "(" + this.getSize() + ")";
        }
        if (dt.supportPrecision()) {
            if (dt.supportScale()) {
                return dt.getName() + "(" + this.getPrecision() + "," + this.getScale() + ")";
            }
            return dt.getName() + "(" + this.getPrecision() + ")";
        }
        if (dt.supportScale()) {
            return dt.getName() + "(???," + this.getScale() + ")";
        }
        return this.getDataType().getName();
    }

    public DefaultFeatureAttributeDescriptor getCopy() {
        return new DefaultFeatureAttributeDescriptor(this);
    }

    public Object clone() throws CloneNotSupportedException {
        return new DefaultFeatureAttributeDescriptor(this);
    }

    public boolean allowNull() {
        return this.allowNull;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = this.dataType.isNumeric() ? Locale.ENGLISH : Locale.getDefault();
        }
        return this.locale;
    }

    public DataType getDataType() {
        if (this.featureAttributeGetter != null) {
            return this.featureAttributeGetter.getDataType();
        }
        return this.dataType;
    }

    public FeatureAttributeDescriptor setDataType(int type) {
        this.dataType = ToolsLocator.getDataTypesManager().get(type);
        this.setFixed(false);
        return this;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Deprecated
    public Object getDefaultValueCoerced() {
        return this.getCoercedDefaultValue();
    }

    public Object getCoercedDefaultValue() {
        try {
            Object value = this.defaultValue;
            if (value == null) {
                return null;
            }
            if (ExpressionUtils.isDynamicText((String)value.toString())) {
                value = ExpressionUtils.evaluateDynamicText((String)value.toString());
            }
            return this.getDataType().coerce(value);
        }
        catch (CoercionException ex) {
            return null;
        }
    }

    public Supplier getDefaultValueSupplier() {
        return this::getDefaultValueCoerced;
    }

    public DynField setDefaultValueSupplier(Supplier supplier) {
        return this;
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    public int getGeometryType() {
        if (this.dataType.getType() != 66) {
            return -1;
        }
        return this.geometryType;
    }

    public int getGeometrySubType() {
        if (this.dataType.getType() != 66) {
            return 4;
        }
        return this.geometrySubType;
    }

    public GeometryType getGeomType() {
        if (this.dataType.getType() != 66) {
            return null;
        }
        if (this.geomType == null) {
            if ((this.geometryType == -1 || this.geometryType == 16) && this.geometrySubType == 4) {
                return null;
            }
            try {
                this.geomType = GeometryLocator.getGeometryManager().getGeometryType(this.geometryType, this.geometrySubType);
            }
            catch (GeometryException e) {
                throw new RuntimeException("Error getting geometry type with type = " + this.geometryType + ", subtype = " + this.geometrySubType, e);
            }
        }
        return this.geomType;
    }

    public int getIndex() {
        return this.index;
    }

    protected FeatureAttributeDescriptor setIndex(int index) {
        this.index = index;
        this.setFixed(false);
        return this;
    }

    public int getMaximumOccurrences() {
        return this.maximumOccurrences;
    }

    public int getMinimumOccurrences() {
        return this.minimumOccurrences;
    }

    public String getName() {
        return this.name;
    }

    public FeatureAttributeDescriptor setName(String name) {
        this.name = name;
        return this;
    }

    public Class getObjectClass() {
        if (this.getDataType().getType() == 64) {
            return this.objectClass;
        }
        return this.getDataType().getDefaultClass();
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public Coercion getCoercion() {
        return this.getDataType().getCoercion();
    }

    public MathContext getMathContext() {
        if (this.mathContext == null) {
            this.mathContext = this.getDataType().isNumeric() ? new MathContext(this.getPrecision(), RoundingMode.valueOf(this.getRoundMode())) : MathContext.UNLIMITED;
        }
        return this.mathContext;
    }

    public CoercionContext getCoercionContext() {
        if (this.coerceContext == null) {
            if (this.getDataType().isNumeric()) {
                this.coerceContext = DataTypeUtils.coerceContextDecimal((Locale)this.getLocale(), (int)this.getPrecision(), (int)this.getScale(), (int)this.getRoundMode());
            } else if (this.getType() == 66) {
                GeometryCoercionContext context = GeometryLocator.getGeometryManager().createGeometryCoercionContext();
                context.setGeometryType(this.getGeomType());
                context.setMode(2);
                this.coerceContext = context;
            } else {
                this.coerceContext = this.getType() == 11 ? DataTypeUtils.coerceContextLocale((Locale)this.locale) : DataTypeUtils.coerceContextLocale((Locale)this.getLocale());
            }
        }
        return this.coerceContext;
    }

    public int getRoundMode() {
        return this.roundMode;
    }

    public IProjection getSRS() {
        return this.SRS;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public IProjection getSRS(WeakReference storeRef) {
        if (this.SRS == null) {
            FeatureStore store = (FeatureStore)storeRef.get();
            this.SRS = (IProjection)store.getDynValue("CRS");
        }
        return this.SRS;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public boolean isReadOnly() {
        if (this.readOnly) {
            return true;
        }
        return this.isAutomatic() || this.isComputed();
    }

    public String getAdditionalInfo(String infoName) {
        if (this.additionalInfo == null) {
            return null;
        }
        return this.additionalInfo.get(infoName);
    }

    public boolean isAutomatic() {
        return this.isAutomatic;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultFeatureAttributeDescriptor)) {
            return false;
        }
        DefaultFeatureAttributeDescriptor other = (DefaultFeatureAttributeDescriptor)obj;
        if (this.allowNull != other.allowNull) {
            return false;
        }
        if (this.index != other.index) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (this.getDataType() != other.getDataType()) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        if (!Objects.equals(this.defaultValue, other.defaultValue)) {
            return false;
        }
        if (!Objects.equals(this.defaultFormat, other.defaultFormat)) {
            return false;
        }
        if (this.primaryKey != other.primaryKey) {
            return false;
        }
        if (this.isAutomatic != other.isAutomatic) {
            return false;
        }
        if (this.readOnly != other.readOnly) {
            return false;
        }
        if (this.precision != other.precision) {
            return false;
        }
        if (this.maximumOccurrences != other.maximumOccurrences) {
            return false;
        }
        if (this.minimumOccurrences != other.minimumOccurrences) {
            return false;
        }
        if (this.geometryType != other.geometryType) {
            return false;
        }
        if (this.geometrySubType != other.geometrySubType) {
            return false;
        }
        if (!Objects.equals(this.evaluator, other.evaluator)) {
            return false;
        }
        if (!Objects.equals(this.featureAttributeEmulator, other.featureAttributeEmulator)) {
            return false;
        }
        if (!Objects.equals(this.SRS, other.SRS)) {
            return false;
        }
        if (!Objects.equals(this.dateFormat, other.dateFormat)) {
            return false;
        }
        if (!Objects.equals(this.objectClass, other.objectClass)) {
            return false;
        }
        return Objects.equals(this.dataProfile, other.dataProfile);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.allowNull = state.getBoolean("allowNull");
        this.dataType = ToolsLocator.getDataTypesManager().get(state.getInt("dataType"));
        this.dataProfile = state.getString("dataProfile");
        try {
            this.defaultValue = state.getString("defaultValue");
            if (!ExpressionUtils.isDynamicText((String)((String)this.defaultValue))) {
                this.defaultValue = this.dataType.coerce(this.defaultValue);
            }
        }
        catch (CoercionException coercionException) {
            // empty catch block
        }
        this.index = state.getInt("index");
        this.maximumOccurrences = state.getInt("maximumOccurrences");
        this.minimumOccurrences = state.getInt("minimumOccurrences");
        this.size = state.getInt("size");
        this.name = state.getString("name");
        try {
            String objectClassName = state.getString("objectClass");
            if (!StringUtils.isBlank((CharSequence)objectClassName)) {
                this.objectClass = Class.forName(objectClassName);
            }
        }
        catch (Throwable e) {
            LOGGER.warn("Can't restore the objectClass of the FeatureAttributreDescriptor", e);
        }
        this.precision = state.getInt("precision");
        this.scale = state.getInt("scale");
        this.roundMode = state.getInt("roundMode");
        String locale_s = state.getString("locale");
        this.locale = StringUtils.isBlank((CharSequence)locale_s) || "null".equalsIgnoreCase(locale_s) ? null : Locale.forLanguageTag(locale_s);
        this.evaluator = (Evaluator)state.get("evaluator");
        this.primaryKey = state.getBoolean("primaryKey");
        this.readOnly = state.getBoolean("readOnly");
        this.SRS = (IProjection)state.get("SRS");
        this.geometryType = state.getInt("geometryType");
        this.geometrySubType = state.getInt("geometrySubType");
        if (this.geometryType != -1 && this.geometrySubType != 4) {
            this.geomType = GeometryUtils.getGeometryType((int)this.geometryType, (int)this.geometrySubType);
        }
        this.isAutomatic = state.getBoolean("isAutomatic");
        this.isTime = state.getBoolean("isTime");
        if (state.hasValue("intervalStart")) {
            long intervalStart = state.getLong("interval_start");
            long intervalEnd = state.getLong("interval_end");
            this.interval = TimeSupportLocator.getManager().createRelativeInterval(intervalStart, intervalEnd);
        } else {
            this.interval = null;
        }
        this.featureAttributeEmulator = (FeatureAttributeEmulator)state.get("featureAttributeEmulator");
        this.indexed = state.getBoolean("indexed");
        this.isIndexAscending = state.getBoolean("isIndexAscending");
        this.allowIndexDuplicateds = state.getBoolean("allowIndexDuplicateds");
        Map values = state.getMap("availableValues");
        if (values == null || values.isEmpty()) {
            this.availableValues = null;
        } else {
            this.availableValues = new DynObjectValueItem[values.size()];
            int n = 0;
            Coercion coercion = this.getCoercion();
            for (Map.Entry entry : values.entrySet()) {
                Object value;
                try {
                    value = coercion.coerce(entry.getValue());
                }
                catch (CoercionException ex) {
                    value = entry.getValue();
                }
                this.availableValues[n++] = new DynObjectValueItem(value, (String)entry.getKey());
            }
        }
        this.description = state.getString("description");
        this.minValue = state.get("minValue");
        this.maxValue = state.get("maxValue");
        this.label = state.getString("label");
        this.order = state.getInt("order");
        this.hidden = state.getBoolean("hidden");
        this.groupName = state.getString("groupName");
        this.relationType = state.getInt("relationType", 0);
        this.foreingKey = (DefaultForeingKey)state.get("foreingKey");
        if (this.foreingKey != null) {
            this.foreingKey.setDescriptor(this);
        }
        this.tags = (Tags)state.get("tags");
        if (this.tags == null) {
            this.tags = new DefaultTags();
        }
        this.displaySize = state.getInt("displaySize", 0);
        this.availableValuesExpression = (Expression)state.get("availableValuesExpression");
        this.availableValuesFilter = (Expression)state.get("availableValuesFilter");
        this.avoidCachingAvailableValues = state.getBoolean("avoidCachingAvailableValues", false);
        this.availableValuesCache = null;
        this.defaultFormat = state.getString("defaultFormat");
        this.setFixed(false);
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        Coercion toString = ToolsLocator.getDataTypesManager().getCoercion(8);
        state.set("allowNull", this.allowNull);
        state.set("dataType", this.dataType.getType());
        state.set("dataProfile", this.dataProfile);
        state.set("defaultValue", Objects.toString(this.defaultValue, null));
        state.set("index", this.index);
        state.set("maximumOccurrences", this.maximumOccurrences);
        state.set("minimumOccurrences", this.minimumOccurrences);
        state.set("size", this.size);
        state.set("name", this.name);
        state.set("objectClass", this.objectClass == null ? null : this.objectClass.getName());
        state.set("precision", this.precision);
        state.set("scale", this.scale);
        state.set("roundMode", this.roundMode);
        if (this.locale == null) {
            state.setNull("locale");
        } else {
            state.set("locale", this.locale.toLanguageTag());
        }
        state.set("evaluator", (Object)this.evaluator);
        state.set("primaryKey", this.primaryKey);
        state.set("readOnly", this.readOnly);
        state.set("SRS", (Object)this.SRS);
        GeometryType theGeomType = this.getGeomType();
        if (theGeomType == null) {
            state.set("geometryType", -1);
            state.set("geometrySubType", 4);
        } else {
            state.set("geometryType", theGeomType.getType());
            state.set("geometrySubType", theGeomType.getSubType());
        }
        state.set("isAutomatic", this.isAutomatic);
        state.set("isTime", this.isTime);
        if (this.interval == null) {
            state.setNull("interval_start");
            state.setNull("interval_end");
        } else {
            state.set("interval_start", ((RelativeInterval)this.interval).getStart().toMillis());
            state.set("interval_end", ((RelativeInterval)this.interval).getEnd().toMillis());
        }
        state.set("SRS", (Object)this.SRS);
        if (this.featureAttributeEmulator instanceof Persistent) {
            state.set("featureAttributeEmulator", (Object)this.featureAttributeEmulator);
        } else {
            state.setNull("featureAttributeEmulator");
        }
        state.set("indexed", this.indexed);
        state.set("isIndexAscending", this.isIndexAscending);
        state.set("allowIndexDuplicateds", this.allowIndexDuplicateds);
        if (this.availableValues == null) {
            state.setNull("availableValues");
        } else {
            LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
            for (DynObjectValueItem value : this.availableValues) {
                if (value == null) continue;
                values.put(value.getLabel(), value.getValue());
            }
            state.set("availableValues", values);
        }
        state.set("description", this.description);
        state.set("minValue", this.minValue);
        state.set("maxValue", this.maxValue);
        state.set("label", this.label);
        state.set("order", this.order);
        state.set("hidden", this.hidden);
        state.set("groupName", this.groupName);
        state.set("relationType", this.relationType);
        state.set("foreingKey", (Persistent)this.foreingKey);
        state.set("tags", (Persistent)this.tags);
        state.set("displaySize", this.displaySize);
        state.set("availableValuesExpression", (Persistent)this.availableValuesExpression);
        state.set("availableValuesFilter", (Persistent)this.availableValuesFilter);
        state.set("avoidCachingAvailableValues", this.avoidCachingAvailableValues);
        state.set("defaultFormat", this.defaultFormat);
    }

    public static void registerPersistenceDefinition() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(FEATATTRDESC_PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(DefaultFeatureAttributeDescriptor.class, FEATATTRDESC_PERSISTENCE_DEFINITION_NAME, "FeatureAttributeDescriptor persistent definition", null, null);
            definition.addDynFieldBoolean("allowNull");
            definition.addDynFieldInt("dataType");
            definition.addDynFieldString("dataProfile");
            definition.addDynFieldString("defaultValue");
            definition.addDynFieldInt("index");
            definition.addDynFieldInt("maximumOccurrences");
            definition.addDynFieldInt("minimumOccurrences");
            definition.addDynFieldInt("size");
            definition.addDynFieldString("name");
            definition.addDynFieldString("objectClass");
            definition.addDynFieldInt("precision");
            definition.addDynFieldInt("scale").setMandatory(false).setDefaultDynValue((Object)-1);
            definition.addDynFieldInt("roundMode").setMandatory(false).setDefaultDynValue((Object)4);
            definition.addDynFieldString("locale").setMandatory(false).setDefaultDynValue((Object)"null");
            definition.addDynFieldObject("evaluator").setClassOfValue(Evaluator.class);
            definition.addDynFieldBoolean("primaryKey");
            definition.addDynFieldBoolean("readOnly");
            definition.addDynFieldObject("SRS").setClassOfValue(IProjection.class);
            definition.addDynFieldInt("geometryType");
            definition.addDynFieldInt("geometrySubType");
            definition.addDynFieldBoolean("isAutomatic");
            definition.addDynFieldBoolean("isTime");
            definition.addDynFieldLong("interval_start");
            definition.addDynFieldLong("interval_end");
            definition.addDynFieldObject("featureAttributeEmulator").setClassOfValue(FeatureAttributeEmulator.class);
            definition.addDynFieldBoolean("indexed");
            definition.addDynFieldBoolean("isIndexAscending");
            definition.addDynFieldBoolean("allowIndexDuplicateds");
            definition.addDynFieldMap("availableValues").setClassOfItems(Object.class);
            definition.addDynFieldString("description");
            definition.addDynFieldObject("minValue");
            definition.addDynFieldObject("maxValue");
            definition.addDynFieldString("label");
            definition.addDynFieldInt("order");
            definition.addDynFieldBoolean("hidden");
            definition.addDynFieldBoolean("avoidCachingAvailableValues");
            definition.addDynFieldString("groupName");
            definition.addDynFieldInt("relationType");
            definition.addDynFieldObject("foreingKey").setClassOfValue(DefaultForeingKey.class);
            definition.addDynFieldObject("tags").setClassOfValue(Tags.class);
            definition.addDynFieldInt("displaySize").setMandatory(false);
            definition.addDynFieldObject("availableValuesExpression").setClassOfValue(Expression.class).setMandatory(false);
            definition.addDynFieldObject("availableValuesFilter").setClassOfValue(Expression.class).setMandatory(false);
            definition.addDynFieldString("defaultFormat").setMandatory(false);
        }
    }

    public Tags getTags() {
        return this.tags;
    }

    public Expression getAvailableValuesFilter() {
        return this.availableValuesFilter;
    }

    public FeatureAttributeDescriptor setAvailableValuesFilter(Expression filter) {
        this.availableValuesFilter = filter;
        this.setFixed(false);
        return this;
    }

    public FeatureAttributeDescriptor setAvailableValuesFilter(String filter) {
        this.availableValuesFilter = ExpressionUtils.createExpression((String)filter);
        this.setFixed(false);
        return this;
    }

    public boolean hasConstantAvailableValues() {
        return this.availableValues != null;
    }

    public boolean isAvoidCachingAvailableValues() {
        return this.avoidCachingAvailableValues;
    }

    public boolean hasAvailableValues() {
        return this.getAvailableValues() != null;
    }

    public DynObjectValueItem[] getAvailableValues(DynObject context) {
        if (this.availableValuesMethod != null) {
            DynObjectValueItem[] values;
            try {
                values = (DynObjectValueItem[])this.availableValuesMethod.invoke(context, new Object[]{this});
            }
            catch (DynMethodException ex) {
                return this.getAvailableValues();
            }
            if (values != null) {
                return values;
            }
        }
        if (context != null) {
            if (!ExpressionUtils.isEmpty((Expression)this.availableValuesFilter)) {
                return this.getAvailableValuesFromFilter(context);
            }
            if (!ExpressionUtils.isEmpty((Expression)this.availableValuesExpression)) {
                return this.getAvailableValuesFromExpression(context);
            }
        }
        return this.getAvailableValues();
    }

    private DynObjectValueItem[] getAvailableValuesFromFilter(DynObject context) {
        Expression filter = this.availableValuesFilter;
        if (ExpressionUtils.isEmpty((Expression)filter)) {
            return null;
        }
        if (context == null) {
            return new DynObjectValueItem[0];
        }
        MutableSymbolTable symbolTable = ExpressionUtils.createSymbolTable();
        if (context != null) {
            MutableSymbolTable contextSymbolTable = ExpressionUtils.createSymbolTable((String)"feature", (DynObject)context);
            symbolTable.addSymbolTable((SymbolTable)contextSymbolTable);
        }
        DynObjectValueItem[] allValues = this.getAvailableValues();
        ArrayList<DynObjectValueItem> filteredValues = new ArrayList<DynObjectValueItem>();
        int index = 0;
        for (DynObjectValueItem value : allValues) {
            symbolTable.setVar("$value", value.getValue());
            symbolTable.setVar("$label", (Object)value.getLabel());
            symbolTable.setVar("$index", (Object)index++);
            Object include = null;
            try {
                include = filter.execute((SymbolTable)symbolTable);
            }
            catch (Exception ex) {
                if (context != null) {
                    LOGGER.warn("Can't filter available values of field '" + this.getName() + "'.\n" + ex.getMessage() + "\nFilter expression:\n" + filter.getPhrase() + "\nAvailable variables:" + Objects.toString(symbolTable.variables()));
                }
                return allValues;
            }
            if (DataTypeUtils.isFalse((Object)include, (boolean)false)) continue;
            filteredValues.add(value);
        }
        DynObjectValueItem[] values = filteredValues.toArray(new DynObjectValueItem[filteredValues.size()]);
        return values;
    }

    public boolean isAvailableValuesCalculated() {
        if (this.availableValuesMethod != null) {
            return true;
        }
        if (!ExpressionUtils.isEmpty((Expression)this.availableValuesFilter)) {
            return true;
        }
        if (!ExpressionUtils.isEmpty((Expression)this.availableValuesExpression)) {
            return true;
        }
        return this.isForeingKey() && this.foreingKey.isClosedList();
    }

    public DynObjectValueItem[] getAvailableValues() {
        DynObjectValueItem[] values = this.availableValues;
        if (values != null) {
            return values;
        }
        values = this.availableValuesCache;
        if (values != null) {
            return values;
        }
        if (this.isForeingKey() && this.foreingKey.isClosedList()) {
            values = this.foreingKey.getAvailableValues(null);
        }
        if (!this.avoidCachingAvailableValues) {
            this.availableValuesCache = values;
        }
        return values;
    }

    private DynObjectValueItem[] getAvailableValuesFromExpression(DynObject context) {
        if (this.availableValuesExpression == null || this.availableValuesExpression.isEmpty()) {
            return null;
        }
        if (context == null) {
            return new DynObjectValueItem[0];
        }
        try {
            MutableSymbolTable symbolTable = ExpressionUtils.createSymbolTable();
            MutableSymbolTable contextSymbolTable = ExpressionUtils.createSymbolTable((String)"feature", (DynObject)context);
            symbolTable.addSymbolTable((SymbolTable)contextSymbolTable);
            DynObjectValueItem[] value = null;
            try {
                value = this.availableValuesExpression.execute((SymbolTable)symbolTable);
            }
            catch (Exception ex) {
                LOGGER.warn("Can't calculate available values of field '" + this.getName() + "'.\n" + ex.getMessage() + "\nExpression:\n" + this.availableValuesExpression.getPhrase() + "\nAvailable variables:" + Objects.toString(symbolTable.variables()));
                value = new DynObjectValueItem[]{};
            }
            return DynObjectUtils.getAvailableValuesFrom((Object)value);
        }
        catch (Throwable th) {
            LOGGER.warn("Can't get available values from expression", th);
            return null;
        }
    }

    public Expression getAvailableValuesExpression() {
        return this.availableValuesExpression;
    }

    public FeatureAttributeDescriptor setAvailableValuesExpression(String expression) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            this.availableValuesExpression = null;
            return this;
        }
        this.availableValuesExpression = ExpressionUtils.createExpression((String)expression);
        this.setFixed(false);
        return this;
    }

    public FeatureAttributeDescriptor setAvailableValuesExpression(Expression expression) {
        this.availableValuesExpression = expression;
        this.setFixed(false);
        return this;
    }

    public String getLabelOfValue(Object value) {
        String theLabel = null;
        if (this.isForeingKey() && !this.getForeingKey().isClosedList() && StringUtils.isNotBlank((CharSequence)(theLabel = this.getForeingKey().getLabel(null, value)))) {
            return theLabel;
        }
        if (this.labelOfValueMap != null) {
            theLabel = this.labelOfValueMap.get(value);
            if (theLabel == null) {
                theLabel = Objects.toString(value, "");
            }
            return theLabel;
        }
        DynObjectValueItem[] values = this.getAvailableValues();
        if (values == null) {
            return this.format(value);
        }
        LinkedHashMap<Object, String> map = new LinkedHashMap<Object, String>();
        for (DynObjectValueItem theValue : values) {
            map.put(theValue.getValue(), theValue.getLabel());
        }
        this.labelOfValueMap = map;
        theLabel = this.labelOfValueMap.get(value);
        if (theLabel == null) {
            return this.format(value);
        }
        return theLabel;
    }

    public String getDescription() {
        if (this.description == null) {
            return this.getName();
        }
        return this.description;
    }

    public Object getMaxValue() {
        return this.maxValue;
    }

    public Object getMinValue() {
        return this.minValue;
    }

    public int getTheTypeOfAvailableValues() {
        return 1;
    }

    public int getType() {
        if (this.featureAttributeGetter != null) {
            return this.featureAttributeGetter.getDataType().getType();
        }
        return this.getDataType().getType();
    }

    public boolean isMandatory() {
        if (this.isAutomatic()) {
            return false;
        }
        return !this.allowNull() || this.isPrimaryKey();
    }

    public boolean isPersistent() {
        return false;
    }

    public DynField setAvailableValues(DynObjectValueItem[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            this.availableValues = null;
        } else {
            Coercion coercion = this.getCoercion();
            this.availableValues = new DynObjectValueItem[values.length];
            for (int i = 0; i < values.length; ++i) {
                Object value;
                DynObjectValueItem element = values[i];
                try {
                    value = coercion.coerce(element.getValue());
                }
                catch (CoercionException ex) {
                    value = element.getValue();
                }
                this.availableValues[i] = new DynObjectValueItem(value, element.getLabel());
            }
        }
        this.setFixed(false);
        return this;
    }

    public DynField setDescription(String description) {
        this.description = description;
        this.setFixed(false);
        return this;
    }

    public DynField setMandatory(boolean mandatory) {
        throw new UnsupportedOperationException();
    }

    public DynField setMaxValue(Object maxValue) {
        try {
            this.maxValue = this.coerce(maxValue);
        }
        catch (CoercionException e) {
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    public DynField setMinValue(Object minValue) {
        try {
            this.maxValue = this.coerce(minValue);
        }
        catch (CoercionException e) {
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    public DynField setPersistent(boolean persistent) {
        throw new UnsupportedOperationException();
    }

    public DynField setTheTypeOfAvailableValues(int type) {
        throw new UnsupportedOperationException();
    }

    public DynField setType(int type) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public DynField setDefaultDynValue(Object defaultValue) {
        return this.setDefaultFieldValue(defaultValue);
    }

    public DynField setDefaultFieldValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.setFixed(false);
        return this;
    }

    public Class getClassOfValue() {
        return null;
    }

    public DynField getElementsType() {
        return null;
    }

    public DynField setClassOfValue(Class theClass) throws DynFieldIsNotAContainerException {
        throw new UnsupportedOperationException();
    }

    public DynField setElementsType(DynStruct type) throws DynFieldIsNotAContainerException {
        throw new UnsupportedOperationException();
    }

    public DynField setElementsType(int type) throws DynFieldIsNotAContainerException {
        throw new UnsupportedOperationException();
    }

    public FeatureAttributeDescriptor setDataProfileName(String dataProfile) {
        this.dataProfile = dataProfile;
        this.setFixed(false);
        return this;
    }

    public String getDataProfileName() {
        return this.dataProfile;
    }

    public boolean hasDataProfile() {
        return StringUtils.isNotBlank((CharSequence)this.dataProfile);
    }

    public DataProfile getDataProfile() {
        if (StringUtils.isBlank((CharSequence)this.dataProfile)) {
            return null;
        }
        DataProfile profile = DALLocator.getDataManager().getDataProfile(this.dataProfile);
        return profile;
    }

    public void validate(Object value) throws DynFieldValidateException {
        if (value == null && !this.allowNull()) {
            throw new DynFieldValidateException(value, (DynField)this, null);
        }
        try {
            this.dataType.coerce(value);
        }
        catch (CoercionException e) {
            throw new DynFieldValidateException(value, (DynField)this, (Throwable)e);
        }
    }

    public String getSubtype() {
        if (this.featureAttributeGetter != null) {
            return this.featureAttributeGetter.getDataType().getSubtype();
        }
        return this.dataType.getSubtype();
    }

    public Object coerce(Object value) throws CoercionException {
        if (value == null) {
            return value;
        }
        try {
            return this.getDataType().coerce(value, this.getCoercionContext());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public DynField setAvailableValues(List values) {
        this.availableValues = values == null || values.isEmpty() ? null : values.toArray(new DynObjectValueItem[values.size()]);
        this.setFixed(false);
        return this;
    }

    public String getGroup() {
        return this.groupName;
    }

    public int getOder() {
        return this.order;
    }

    public String getLabel() {
        if (this.label == null) {
            return this.getName();
        }
        return this.label;
    }

    public String getLocalizedLabel() {
        if (StringUtils.isBlank((CharSequence)this.label)) {
            return this.getName();
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        return i18n.getTranslation(this.label);
    }

    public DynField setLabel(String label) {
        this.label = label;
        this.setFixed(false);
        return this;
    }

    public DynField setShortLabel(String shortLabel) {
        this.shortLabel = shortLabel;
        this.setFixed(false);
        return this;
    }

    public String getShortLabel() {
        return StringUtils.isBlank((CharSequence)this.shortLabel) ? this.getLabel() : this.shortLabel;
    }

    public String getLocalizedShortLabel() {
        if (StringUtils.isBlank((CharSequence)this.shortLabel)) {
            return this.getLocalizedLabel();
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        return i18n.getTranslation(this.shortLabel);
    }

    public DynField setGroup(String groupName) {
        this.groupName = groupName;
        this.setFixed(false);
        return this;
    }

    public DynField setOrder(int order) {
        this.order = order;
        this.setFixed(false);
        return this;
    }

    public DynField setHidden(boolean hidden) {
        this.hidden = hidden;
        this.setFixed(false);
        return this;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public DynField setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.setFixed(false);
        return this;
    }

    public boolean isContainer() {
        return false;
    }

    public Class getClassOfItems() {
        return null;
    }

    public DynField setClassOfItems(Class theClass) {
        throw new UnsupportedOperationException();
    }

    public DynField setType(DataType type) {
        throw new UnsupportedOperationException();
    }

    public DynField setSubtype(String subtype) {
        throw new UnsupportedOperationException();
    }

    public boolean isTime() {
        return this.isTime;
    }

    public FeatureAttributeGetter getFeatureAttributeGetter() {
        return this.featureAttributeGetter;
    }

    public void setFeatureAttributeGetter(FeatureAttributeGetter featureAttributeTransform) {
        this.featureAttributeGetter = featureAttributeTransform;
        this.setFixed(false);
    }

    public FeatureAttributeEmulator getFeatureAttributeEmulator() {
        return this.featureAttributeEmulator;
    }

    public FeatureAttributeDescriptor setFeatureAttributeEmulator(FeatureAttributeEmulator featureAttributeEmulator) {
        this.featureAttributeEmulator = featureAttributeEmulator;
        this.setFixed(false);
        return this;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public boolean isForeingKey() {
        return this.foreingKey != null && this.foreingKey.isForeingKey();
    }

    public ForeingKey getForeingKey() {
        return this.foreingKey;
    }

    public boolean allowIndexDuplicateds() {
        return this.allowIndexDuplicateds;
    }

    public boolean isIndexAscending() {
        return this.isIndexAscending;
    }

    public DynField setClassOfValue(DynStruct dynStrct) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DynField setClassOfValue(String theClassNameOfValue) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getClassNameOfValue() {
        return null;
    }

    public DynStruct getDynClassOfValue() {
        return null;
    }

    public DynField setTypeOfItems(int type) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getTypeOfItems() {
        return 0;
    }

    public DynField setClassOfItems(DynStruct dynStrct) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DynField setClassOfItems(String theClassNameOfValue) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getClassNameOfItems() {
        return null;
    }

    public DynStruct getDynClassOfItems() {
        return null;
    }

    public DynField setRelationType(int relationType) {
        this.relationType = relationType;
        this.setFixed(false);
        return this;
    }

    public int getRelationType() {
        return this.relationType;
    }

    public DynField setAvailableValues(DynMethod availableValuesMethod) {
        this.availableValuesMethod = availableValuesMethod;
        this.setFixed(false);
        return this;
    }

    public DynMethod getAvailableValuesMethod() {
        if (this.availableValuesMethod != null) {
            return this.availableValuesMethod;
        }
        if (this.isAvailableValuesCalculated()) {
            AbstractDynMethod method = new AbstractDynMethod("getAvailableValuesOf" + this.getName()){

                public Object invoke(DynObject context, Object[] args) throws DynMethodException {
                    return DefaultFeatureAttributeDescriptor.this.getAvailableValues(context);
                }
            };
            return method;
        }
        return null;
    }

    public DynMethod getCalculateMethod() {
        return this.calculateMethod;
    }

    public DynField setCalculateMethod(DynMethod method) {
        this.calculateMethod = method;
        this.setFixed(false);
        return this;
    }

    public boolean isCalculated() {
        return this.calculateMethod != null;
    }

    public Object getCalculatedValue(DynObject self) {
        try {
            return this.calculateMethod.invoke(self, new Object[]{this});
        }
        catch (DynMethodException ex) {
            throw new RuntimeException(ex);
        }
    }

    public DynField setValidateElements(boolean validate) {
        return this;
    }

    public boolean getValidateElements() {
        return false;
    }

    public boolean hasLabel() {
        return StringUtils.isNotBlank((CharSequence)this.label);
    }

    public boolean hasShortLabel() {
        return StringUtils.isNotBlank((CharSequence)this.shortLabel);
    }

    public boolean hasDescription() {
        return StringUtils.isNotBlank((CharSequence)this.description);
    }

    public FeatureAttributeDescriptor getValue() {
        return this;
    }

    public int getDisplaySize() {
        return this.displaySize;
    }

    public boolean isInAvailableValues(Object valueToCheck) {
        if (this.getAvailableValues() != null) {
            for (DynObjectValueItem availableValue : this.getAvailableValues()) {
                if (!Objects.equals(valueToCheck, availableValue.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public void setConstantValue(boolean isConstantValue) {
        this.evaluator = isConstantValue ? new ConstantValueEvaluator() : null;
        this.setFixed(false);
    }

    public boolean isComputed() {
        return this.featureAttributeEmulator != null || this.evaluator != null || this.isCalculated();
    }

    public FeatureStore getStore() {
        FeatureType ftype = this.getFeatureType();
        if (ftype == null) {
            return null;
        }
        return ftype.getStore();
    }

    public FeatureType getFeatureType() {
        if (this.typeRef == null) {
            return null;
        }
        FeatureType ftype = (FeatureType)this.typeRef.get();
        return ftype;
    }

    public FeatureAttributeDescriptor setInterval(Interval interval) {
        this.interval = interval;
        this.setFixed(false);
        return this;
    }

    public void fixAll() {
        if (this.fixed) {
            return;
        }
        if (!this.getDataType().supportSize()) {
            this.size = 0;
        }
        DataType.NumberPrecisionAndScale ps = this.getDataType().fixPrecisionAndScale(this.precision, this.scale);
        this.precision = ps.getPrecision();
        this.scale = ps.getScale();
        switch (this.getType()) {
            case 9: 
            case 10: 
            case 11: 
            case 68: 
            case 69: {
                if (this.getInterval() == null) break;
                this.isTime = true;
            }
        }
        this.fixed = true;
    }

    public String[] getRequiredFieldNames() {
        FeatureAttributeEmulator emulator = this.getFeatureAttributeEmulator();
        if (emulator == null) {
            return null;
        }
        return emulator.getRequiredFieldNames();
    }

    public void recentUsed() {
        DefaultFeatureType.RECENTS_USEDS.add(this);
    }

    public boolean hasOnlyMetadataChanges(FeatureAttributeDescriptor other) {
        if (other == null) {
            throw new NullPointerException();
        }
        DefaultFeatureAttributeDescriptor old = (DefaultFeatureAttributeDescriptor)other;
        if (!StringUtils.equalsIgnoreCase((CharSequence)old.name, (CharSequence)this.name)) {
            return false;
        }
        if (old.isComputed() && old.isComputed() == this.isComputed()) {
            return true;
        }
        if (this.dataType != old.dataType) {
            return false;
        }
        if (this.size != old.size) {
            return false;
        }
        if (this.precision != old.precision) {
            return false;
        }
        if (this.geomType != old.geomType) {
            return false;
        }
        if (this.SRS != old.SRS) {
            return false;
        }
        return this.isAutomatic == old.isAutomatic;
    }

    private String getAll() {
        Expression exp;
        PropertiesBuilder builder = new PropertiesBuilder();
        builder.separator("/");
        builder.name(this.name);
        builder.type(this.dataType);
        builder.set("size", this.size, 0);
        switch (this.getType()) {
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                if (this.locale == null) break;
                builder.set("locale", this.getLocale());
                break;
            }
            case 19: {
                builder.set("precision", this.precision);
                builder.set("scale", this.scale);
                builder.set("roundMode", this.getRoundMode());
                if (this.locale == null) break;
                builder.set("locale", this.getLocale());
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                if (this.locale == null) break;
                builder.set("locale", this.getLocale());
                break;
            }
            case 66: {
                GeometryType theGeomType;
                IProjection proj = this.getSRS();
                if (proj != null) {
                    builder.set("srs", proj.getAbrev().replace(":", "@"));
                }
                if ((theGeomType = this.getGeomType()) == null) break;
                String geomTypeName = GeometryUtils.getGeometryTypeName((int)this.getGeomType().getType());
                String geomSubtypeName = GeometryUtils.getGeometrySubtypeName((int)this.getGeomType().getSubType());
                builder.set("geomtype", geomTypeName + "@" + geomSubtypeName);
            }
        }
        builder.set("hidden", this.isHidden(), false);
        builder.set("readOnly", this.isReadOnly(), false);
        builder.set("allowNull", this.allowNull(), true);
        builder.set("pk", this.isPrimaryKey(), false);
        builder.set("automatic", this.isAutomatic(), false);
        builder.set("isindexed", this.isIndexed(), false);
        builder.set("isindexascending", this.isIndexAscending(), true);
        builder.set("allowindexduplicateds", this.allowIndexDuplicateds(), true);
        builder.set("isTime", this.isTime(), false);
        builder.set("profile", this.getDataProfileName());
        builder.set("group", this.getGroup());
        builder.set("description", this.description);
        builder.set("label", this.label);
        builder.set("shortLabel", this.shortLabel);
        builder.set("defaultvalue", this.getDefaultValue());
        builder.set("order", this.getOder());
        if (this.getFeatureAttributeEmulator() instanceof FeatureAttributeEmulatorExpression && (exp = ((FeatureAttributeEmulatorExpression)this.getFeatureAttributeEmulator()).getExpression()) != null) {
            builder.set("expression", exp.getPhrase());
        }
        builder.set("isAvoidCachingAvailableValues", this.isAvoidCachingAvailableValues(), false);
        if (this.isForeingKey()) {
            builder.set("fk", this.isForeingKey());
            builder.set("fk_table", this.getForeingKey().getTableName());
            builder.set("fk_code", this.getForeingKey().getCodeName());
            builder.set("fk_label", this.getForeingKey().getLabelFormula());
            builder.set("fk.closedlist", this.getForeingKey().isClosedList());
        }
        Tags theTags = this.getTags();
        for (String tagname : theTags) {
            String value = theTags.getString(tagname, null);
            if (value == null) continue;
            builder.tag(tagname, value);
        }
        return builder.toString();
    }

    public Object get(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Name can't be empty");
        }
        switch (name.trim().toLowerCase()) {
            case "all": {
                return this.getAll();
            }
            case "isreadonly": 
            case "readonly": {
                return this.isReadOnly();
            }
            case "hidden": {
                return this.isHidden();
            }
            case "allownull": {
                return this.allowNull();
            }
            case "pk": 
            case "ispk": 
            case "primarykey": 
            case "isprimarykey": {
                return this.isPrimaryKey();
            }
            case "isindexed": {
                return this.isIndexed();
            }
            case "isindexascending": {
                return this.isIndexAscending();
            }
            case "allowindexduplicateds": {
                return this.allowIndexDuplicateds();
            }
            case "isautomatic": 
            case "automatic": {
                return this.isAutomatic();
            }
            case "time": 
            case "istime": {
                return this.isTime();
            }
            case "profile": {
                return this.getDataProfile();
            }
            case "group": {
                return this.getGroup();
            }
            case "description": {
                return this.getDescription();
            }
            case "label": {
                return this.getLabel();
            }
            case "shortlabel": {
                return this.getShortLabel();
            }
            case "isavoidcachingavailablevalues": 
            case "avoidcachingavailablevalues": 
            case "nocachingavailablevalues": {
                return this.isAvoidCachingAvailableValues();
            }
            case "expression": {
                return this.getFeatureAttributeEmulator();
            }
            case "size": {
                return this.getSize();
            }
            case "precision": {
                return this.getPrecision();
            }
            case "scale": {
                return this.getScale();
            }
            case "roundmode": {
                return this.getRoundMode();
            }
            case "locale": {
                return this.getLocale();
            }
            case "order": {
                return this.getOder();
            }
            case "isfk": 
            case "isforeingkey": {
                return this.isForeingKey();
            }
            case "fk": 
            case "foreingkey": {
                return this.getForeingKey();
            }
            case "fk_code": 
            case "foreingkey_code": 
            case "foreingkey.code": {
                return this.getForeingKey().getCodeName();
            }
            case "fk_label": 
            case "foreingkey_label": 
            case "foreingkey.label": {
                return this.getForeingKey().getLabelFormula();
            }
            case "fk.closedlist": 
            case "foreingkey_closedlist": 
            case "foreingkey.closedlist": {
                return this.getForeingKey().isClosedList();
            }
            case "fk_table": 
            case "foreingkey_table": 
            case "foreingkey.table": {
                return this.getForeingKey().getTableName();
            }
            case "interval": {
                return this.getInterval();
            }
            case "geomtype": 
            case "geometrytype": {
                return this.getGeomType();
            }
            case "srs": {
                return this.getSRS();
            }
            case "defaultvalue": {
                return this.getDefaultValue();
            }
        }
        throw new IllegalArgumentException("Name attribute '" + name + "' not valid.");
    }

    public void setSRSForced(IProjection SRS) {
        this.SRS = SRS;
        this.setFixed(false);
    }

    public JsonObject toJson() {
        return this.toJsonBuilder().build();
    }

    public JsonObjectBuilder toJsonBuilder() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add_class((Object)this);
        builder.add("name", this.name);
        builder.add("description", this.description);
        builder.add("label", this.label);
        builder.add("shortLabel", this.shortLabel);
        builder.add("order", this.order);
        builder.add("groupName", this.groupName);
        builder.add("dataType", (Object)this.dataType);
        builder.add("size", this.size);
        builder.add("precision", this.precision);
        builder.add("scale", this.scale);
        builder.add("roundMode", this.roundMode);
        builder.add("allowNull", this.allowNull);
        builder.add("primaryKey", this.primaryKey);
        builder.add("readOnly", this.readOnly);
        builder.add("isAutomatic", this.isAutomatic);
        builder.add("isTime", this.isTime);
        builder.add("indexed", this.indexed);
        builder.add("isIndexAscending", this.isIndexAscending);
        builder.add("allowIndexDuplicateds", this.allowIndexDuplicateds);
        builder.add("hidden", this.hidden);
        builder.add("avoidCachingAvailableValues", this.avoidCachingAvailableValues);
        builder.add("geometryType", (Object)this.getGeomType());
        builder.add("srs", (Object)this.getSRS());
        builder.add("relationType", this.relationType);
        builder.add("displaySize", this.displaySize);
        if (this.locale == null) {
            builder.addNull("locale");
        } else {
            builder.add("locale", (Object)this.getLocale());
        }
        builder.add("expression", (SupportToJson)this.getFeatureAttributeEmulator());
        if (this.isForeingKey()) {
            builder.add("fk", this.isForeingKey());
            builder.add("fk_table", this.getForeingKey().getTableName());
            builder.add("fk_code", this.getForeingKey().getCodeName());
            builder.add("fk_label", this.getForeingKey().getLabelFormula());
            builder.add("fk_closedlist", this.getForeingKey().isClosedList());
            builder.add("fk_canBeOptimizedByProvider", this.getForeingKey().canBeOptimizedByProvider());
        }
        builder.add("availableValuesExpression", (SupportToJson)this.availableValuesExpression);
        builder.add("availableValuesFilter", (SupportToJson)this.availableValuesFilter);
        builder.add("defaultValue", Objects.toString(this.defaultValue, null));
        builder.add("dataProfile", this.getDataProfileName());
        builder.add("tags", (Iterable)this.tags);
        builder.add("availableValues", (Object[])this.availableValues);
        builder.add("additionalInfo", this.additionalInfo);
        builder.add("defaultFormat", this.defaultFormat);
        return builder;
    }

    public void fromJson(JsonObject json) {
        this.name = json.getString("name");
        this.description = json.getString("description", null);
        this.label = json.getString("label", null);
        this.shortLabel = json.getString("shortLabel", null);
        this.order = json.getInt("order", 0);
        this.groupName = json.getString("groupName", null);
        this.precision = json.getInt("precision", -1);
        this.size = json.getInt("size", 0);
        this.scale = json.getInt("scale", -1);
        this.roundMode = json.getInt("roundMode", 4);
        this.allowNull = json.getBoolean("allowNull", true);
        this.primaryKey = json.getBoolean("primaryKey", false);
        this.readOnly = json.getBoolean("readOnly", false);
        this.isAutomatic = json.getBoolean("isAutomatic", false);
        this.isTime = json.getBoolean("isTime", false);
        this.indexed = json.getBoolean("indexed", false);
        this.isIndexAscending = json.getBoolean("isIndexAscending", true);
        this.allowIndexDuplicateds = json.getBoolean("allowIndexDuplicateds", true);
        this.hidden = json.getBoolean("hidden", false);
        this.avoidCachingAvailableValues = json.getBoolean("avoidCachingAvailableValues", false);
        this.relationType = json.getInt("relationType", 0);
        this.displaySize = json.getInt("displaySize", this.size);
        this.dataType = (DataType)Json.toObject((JsonObject)json, (String)"dataType");
        this.geomType = (GeometryType)Json.toObject((JsonObject)json, (String)"geometryType");
        if (this.geomType != null) {
            this.geometryType = this.geomType.getType();
            this.geometrySubType = this.geomType.getSubType();
        }
        this.SRS = (IProjection)Json.toObject((JsonObject)json, (String)"srs");
        this.locale = (Locale)Json.toObject((JsonObject)json, (String)"locale");
        this.featureAttributeEmulator = (FeatureAttributeEmulator)Json.toObject((JsonObject)json, (String)"expression");
        this.tags = (Tags)Json.toObject((JsonObject)json, (String)"tags");
        this.additionalInfo = Json.toMap((JsonObject)json, (String)"additionalInfo");
        this.availableValues = (DynObjectValueItem[])Json.toArray((JsonObject)json, (String)"availableValues", (Object[])new DynObjectValueItem[0]);
        if (this.availableValues != null) {
            Coercion coercion = this.getCoercion();
            CoercionContext coercionContext = this.getCoercionContext();
            for (DynObjectValueItem item : this.availableValues) {
                if (item == null) {
                    LOGGER.warn("an available value of field " + this.getName() + " is null");
                    this.availableValues = null;
                    break;
                }
                Object value = item.getValue();
                try {
                    item.setValue(coercion.coerce(value, coercionContext));
                }
                catch (CoercionException ex) {
                    LOGGER.warn("Can't coerce value " + Objects.toString(value) + " of field " + this.getName(), (Throwable)ex);
                }
            }
        }
        this.dataProfile = json.getString("dataProfile", null);
        try {
            this.defaultValue = json.getString("defaultValue", null);
            if (!(this.defaultValue instanceof String) || !ExpressionUtils.isDynamicText((String)((String)this.defaultValue))) {
                this.defaultValue = this.coerce(this.defaultValue);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't retrive default value for attribute '" + this.name + "'.", (Throwable)ex);
        }
        this.availableValuesExpression = (Expression)Json.toObject((JsonObject)json, (String)"availableValuesExpression");
        this.availableValuesFilter = (Expression)Json.toObject((JsonObject)json, (String)"availableValuesFilter");
        if (json.getBoolean("fk", false)) {
            this.foreingKey = new DefaultForeingKey();
            this.foreingKey.setForeingKey(true);
            this.foreingKey.setTableName(json.getString("fk_table", null));
            this.foreingKey.setCodeName(json.getString("fk_code", null));
            this.foreingKey.setLabelFormula(json.getString("fk_label", null));
            this.foreingKey.setClosedList(json.getBoolean("fk_closedlist", false));
            this.foreingKey.setCanBeOptimizedByProvider(json.getBoolean("fk_canBeOptimizedByProvider", true));
        } else {
            this.foreingKey = null;
        }
        this.defaultFormat = json.getString("defaultFormat", null);
        this.setFixed(false);
    }

    public static void selfRegister() {
        Json.registerSerializer((JsonManager.JsonSerializer)new TheJsonSerializer());
    }

    public String getDefaultFormat() {
        return this.defaultFormat;
    }

    public String format(Object value) {
        if (value == null) {
            return "";
        }
        try {
            if (StringUtils.isBlank((CharSequence)this.defaultFormat)) {
                if (this.locale == null) {
                    return DataTypeUtils.toString((Locale)Locale.getDefault(), (Object)value, (String)Objects.toString(value, ""));
                }
                return DataTypeUtils.toString((Locale)this.locale, (Object)value, (String)Objects.toString(value, ""));
            }
            return String.format(this.defaultFormat, value);
        }
        catch (Exception ex) {
            return Objects.toString(value, "");
        }
    }

    public String toString() {
        try {
            String s = this.getAll();
            return s;
        }
        catch (Exception ex) {
            return super.toString();
        }
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
        this.observableHelper.notifyObservers((Observable)this, (Object)new BaseNotification(NOTIFICATION_FIXED_CHANGED, 0));
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void addObserver(Observer o) {
        this.observableHelper.addObserver(o);
    }

    public void deleteObserver(Observer o) {
        this.observableHelper.deleteObserver(o);
    }

    public void deleteObservers() {
        this.observableHelper.deleteObservers();
    }

    private static class TheJsonSerializer
    implements JsonManager.JsonSerializer {
        public Class getObjectClass() {
            return DefaultFeatureAttributeDescriptor.class;
        }

        public Object toObject(JsonObject json) {
            DefaultFeatureAttributeDescriptor o = new DefaultFeatureAttributeDescriptor();
            o.fromJson(json);
            return o;
        }

        public JsonObjectBuilder toJsonBuilder(Object value) {
            return ((SupportToJson)value).toJsonBuilder();
        }
    }

    private class PropertiesBuilder {
        private String name;
        private DataType type;
        private final Map<String, String> sets = new LinkedHashMap<String, String>();
        private Map<String, String> tags;
        private String sep;

        public void separator(String sep) {
            this.sep = sep;
        }

        public void name(String name) {
            this.name = name;
        }

        public void type(DataType type) {
            this.type = type;
        }

        public void set(String name, ForeingKey fk) {
            if (fk == null) {
                return;
            }
            if (!fk.isForeingKey()) {
                return;
            }
            this.set(name, fk.isForeingKey());
            this.set(name + "_code", fk.getCodeName());
            this.set(name + "_label", fk.getLabelFormula());
            this.set(name + "_closedlist", fk.isClosedList());
            this.set(name + "_table", fk.getTableName());
        }

        public void set(String name, FeatureAttributeEmulator value) {
            if (value == null) {
                return;
            }
            if (value instanceof FeatureAttributeEmulatorExpression) {
                this.set(name, ((FeatureAttributeEmulatorExpression)value).getExpression().getPhrase());
            }
        }

        public void set(String name, IProjection value) {
            if (value == null) {
                return;
            }
            this.set(name, value.getAbrev());
        }

        public void set(String name, GeometryType value) {
            if (value == null) {
                return;
            }
            this.set(name, value.getFullName().replace(":", "@"));
        }

        public void set(String name, Object value) {
            if (value == null) {
                return;
            }
            String s = Objects.toString(value, "");
            if (StringUtils.isBlank((CharSequence)s)) {
                return;
            }
            this.sets.put(name, s);
        }

        public void set(String name, Object value, Object skipValue) {
            if (value == null || value == skipValue) {
                return;
            }
            String s = Objects.toString(value, "");
            if (StringUtils.isBlank((CharSequence)s)) {
                return;
            }
            this.sets.put(name, s);
        }

        public void tag(String name, String value) {
            if (value == null) {
                return;
            }
            if (StringUtils.isBlank((CharSequence)value)) {
                return;
            }
            if (this.tags == null) {
                this.tags = new HashMap<String, String>();
            }
            this.tags.put(name, value);
        }

        public String toString() {
            String s;
            StringBuilder builder = new StringBuilder();
            builder.append(this.name);
            builder.append(this.sep);
            builder.append(this.type.getName());
            for (String key : this.sets.keySet()) {
                builder.append(this.sep);
                s = this.sets.get(key);
                if (s.contains(this.sep)) {
                    builder.append("setesc");
                    builder.append(this.sep);
                    builder.append("html");
                    builder.append(this.sep);
                    builder.append(key);
                    builder.append("=");
                    s = StringEscapeUtils.escapeHtml3((String)s);
                    s = StringUtils.replace((String)s, (String)this.sep, (String)("&#" + this.sep.charAt(0) + ";"));
                    builder.append(s);
                    continue;
                }
                builder.append("set");
                builder.append(this.sep);
                builder.append(key);
                builder.append("=");
                builder.append(s);
            }
            if (this.tags != null) {
                for (String key : this.tags.keySet()) {
                    builder.append(this.sep);
                    s = this.tags.get(key);
                    if (s.contains(this.sep)) {
                        builder.append("tagesc");
                        builder.append(this.sep);
                        builder.append("html");
                        builder.append(this.sep);
                        builder.append(key);
                        builder.append("=");
                        s = StringEscapeUtils.escapeHtml3((String)s);
                        s = StringUtils.replace((String)s, (String)this.sep, (String)("&#" + this.sep.charAt(0) + ";"));
                        builder.append(s);
                        continue;
                    }
                    builder.append("tag");
                    builder.append(this.sep);
                    builder.append(key);
                    builder.append("=");
                    builder.append(s);
                }
            }
            return builder.toString();
        }
    }

    private class ConstantValueEvaluator
    extends AbstractEvaluator {
        private ConstantValueEvaluator() {
        }

        public Object evaluate(EvaluatorData data) throws EvaluatorException {
            return DefaultFeatureAttributeDescriptor.this.defaultValue;
        }

        public String getName() {
            return "Constant attribute " + DefaultFeatureAttributeDescriptor.this.name;
        }
    }
}

