/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.json.JsonObject;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.mutable.MutableObject;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionUtils;
import org.gvsig.fmap.dal.BaseStoresRepository;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataQuery;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataSet;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DataStoreProvider;
import org.gvsig.fmap.dal.DataStoreProviderFactory;
import org.gvsig.fmap.dal.DataTransaction;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.SupportTransactions;
import org.gvsig.fmap.dal.SupportTransactionsHelper;
import org.gvsig.fmap.dal.exception.CloneException;
import org.gvsig.fmap.dal.exception.CloseException;
import org.gvsig.fmap.dal.exception.CreateException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.DataRuntimeException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.OpenException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.exception.WriteException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureAttributeEmulator;
import org.gvsig.fmap.dal.feature.FeatureCache;
import org.gvsig.fmap.dal.feature.FeatureIndex;
import org.gvsig.fmap.dal.feature.FeatureIndexes;
import org.gvsig.fmap.dal.feature.FeatureLocks;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureReferenceSelection;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreNotification;
import org.gvsig.fmap.dal.feature.FeatureStoreProviderFactory;
import org.gvsig.fmap.dal.feature.FeatureStoreTimeSupport;
import org.gvsig.fmap.dal.feature.FeatureStoreTransform;
import org.gvsig.fmap.dal.feature.FeatureStoreTransforms;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.NewFeatureStoreParameters;
import org.gvsig.fmap.dal.feature.exception.AlreadyEditingException;
import org.gvsig.fmap.dal.feature.exception.CreateFeatureException;
import org.gvsig.fmap.dal.feature.exception.DataExportException;
import org.gvsig.fmap.dal.feature.exception.FeatureIndexException;
import org.gvsig.fmap.dal.feature.exception.FinishEditingException;
import org.gvsig.fmap.dal.feature.exception.GetFeatureTypeException;
import org.gvsig.fmap.dal.feature.exception.IllegalFeatureException;
import org.gvsig.fmap.dal.feature.exception.IllegalFeatureTypeException;
import org.gvsig.fmap.dal.feature.exception.NeedEditingModeException;
import org.gvsig.fmap.dal.feature.exception.NoNewFeatureInsertException;
import org.gvsig.fmap.dal.feature.exception.NullFeatureTypeException;
import org.gvsig.fmap.dal.feature.exception.PerformEditingException;
import org.gvsig.fmap.dal.feature.exception.PersistenceCantFindFeatureTypeException;
import org.gvsig.fmap.dal.feature.exception.PersistenceStoreAlreadyLoadedException;
import org.gvsig.fmap.dal.feature.exception.SelectionNotAllowedException;
import org.gvsig.fmap.dal.feature.exception.StoreCancelEditingException;
import org.gvsig.fmap.dal.feature.exception.StoreDeleteEditableFeatureException;
import org.gvsig.fmap.dal.feature.exception.StoreDeleteFeatureException;
import org.gvsig.fmap.dal.feature.exception.StoreEditException;
import org.gvsig.fmap.dal.feature.exception.StoreInsertFeatureException;
import org.gvsig.fmap.dal.feature.exception.StoreUpdateFeatureException;
import org.gvsig.fmap.dal.feature.exception.StoreUpdateFeatureTypeException;
import org.gvsig.fmap.dal.feature.exception.ValidateFeaturesException;
import org.gvsig.fmap.dal.feature.exception.WriteNotAllowedException;
import org.gvsig.fmap.dal.feature.impl.DALFile;
import org.gvsig.fmap.dal.feature.impl.DefaultEditableFeature;
import org.gvsig.fmap.dal.feature.impl.DefaultEditableFeatureType;
import org.gvsig.fmap.dal.feature.impl.DefaultFeature;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureIndexes;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureQuery;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureRules;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureSelection;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureStoreNotification;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureStoreTransforms;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureType;
import org.gvsig.fmap.dal.feature.impl.LargeFeatureSelection;
import org.gvsig.fmap.dal.feature.impl.UnsupportedCreationOfFeatureSetWithChangesException;
import org.gvsig.fmap.dal.feature.impl.WrappedSpatialIndex;
import org.gvsig.fmap.dal.feature.impl.dynobjectutils.DynObjectFeatureFacade;
import org.gvsig.fmap.dal.feature.impl.editing.memory.FeatureManager;
import org.gvsig.fmap.dal.feature.impl.editing.memory.FeatureTypeManager;
import org.gvsig.fmap.dal.feature.impl.editing.memory.SpatialManager;
import org.gvsig.fmap.dal.feature.impl.featurereference.FeatureReferenceFactory;
import org.gvsig.fmap.dal.feature.impl.featurereference.FeatureReferenceIteratorToFeatureIterator;
import org.gvsig.fmap.dal.feature.impl.featureset.DefaultFeatureSet;
import org.gvsig.fmap.dal.feature.impl.undo.DefaultFeatureCommandsStack;
import org.gvsig.fmap.dal.feature.impl.undo.FeatureCommandsStack;
import org.gvsig.fmap.dal.feature.paging.FeaturePagingHelper;
import org.gvsig.fmap.dal.feature.spi.DefaultFeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureReferenceProviderServices;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProviderServices;
import org.gvsig.fmap.dal.feature.spi.LocalTransaction;
import org.gvsig.fmap.dal.feature.spi.cache.FeatureCacheProvider;
import org.gvsig.fmap.dal.feature.spi.index.FeatureIndexProviderServices;
import org.gvsig.fmap.dal.impl.DefaultDataManager;
import org.gvsig.fmap.dal.resource.Resource;
import org.gvsig.fmap.dal.spi.AbstractDataStore;
import org.gvsig.fmap.dal.spi.DataStoreInitializer2;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.fmap.dal.spi.DataTransactionServices;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.SpatialIndex;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.metadata.MetadataLocator;
import org.gvsig.metadata.MetadataManager;
import org.gvsig.metadata.exceptions.MetadataException;
import org.gvsig.timesupport.Interval;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DelegatedDynObject;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.gvsig.tools.dynobject.DynObject_v2;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.dynobject.exception.DynFieldNotFoundException;
import org.gvsig.tools.dynobject.exception.DynMethodException;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.exception.NotYetImplemented;
import org.gvsig.tools.identitymanagement.SimpleIdentityManager;
import org.gvsig.tools.observer.BaseNotification;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.observer.WeakReferencingObservable;
import org.gvsig.tools.observer.impl.DelegateWeakReferencingObservable;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.undo.RedoException;
import org.gvsig.tools.undo.UndoException;
import org.gvsig.tools.undo.UndoRedoInfo;
import org.gvsig.tools.undo.command.Command;
import org.gvsig.tools.util.CachedValue;
import org.gvsig.tools.util.ChainedIterator;
import org.gvsig.tools.util.GetItemWithSizeIsEmptyAndIterator64;
import org.gvsig.tools.util.HasAFile;
import org.gvsig.tools.util.PropertiesSupportHelper;
import org.gvsig.tools.util.UnmodifiableBasicMap;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitor;

public class DefaultFeatureStore
extends AbstractDataStore
implements DataStoreInitializer2,
FeatureStoreProviderServices,
FeatureStore,
SupportTransactions,
Observer {
    public static long sample_feature_cache_timeout_ms = 15000L;
    private static final String PERSISTENCE_DEFINITION_NAME = "FeatureStore";
    private DataStoreParameters parameters = null;
    private FeatureSelection selection;
    private FeatureLocks locks;
    private DelegateWeakReferencingObservable delegateObservable = new DelegateWeakReferencingObservable((WeakReferencingObservable)this);
    private FeatureCommandsStack commands;
    private FeatureTypeManager featureTypeManager;
    private FeatureManager featureManager;
    private SpatialManager spatialManager;
    private FeatureType defaultFeatureType = null;
    private List<FeatureType> featureTypes = new ArrayList<FeatureType>();
    private int mode = 0;
    private int submode = 0;
    private int lastMode = 0;
    private long versionOfUpdate = 0L;
    private boolean hasStrongChanges = true;
    private DefaultDataManager dataManager = null;
    private FeatureStoreProvider provider = null;
    private DefaultFeatureIndexes indexes;
    private DefaultFeatureStoreTransforms transforms;
    DelegatedDynObject metadata;
    private Set metadataChildren;
    private Long featureCount = null;
    private long temporalOid = 0L;
    private FeatureCacheProvider cache;
    private final StateInformation state = new StateInformation();
    private FeatureStoreTimeSupport timeSupport;
    private PropertiesSupportHelper propertiesSupportHelper;
    private final SupportTransactionsHelper transactionHelper = new SupportTransactionsHelper();
    private String editingSessionCode;
    private String lastEditingSessionCode;
    private CachedValue<Feature> sampleFeatureCache = null;
    private final Observer transactionObserver = (o, o1) -> {
        if (o1 instanceof BaseNotification && (((BaseNotification)o1).isOfType("ROLLBACK") || ((BaseNotification)o1).isOfType("COMMIT"))) {
            this.featureCount = null;
        }
    };
    private String fullNameForTraces;
    private Predicate<FeatureStoreNotification> notificacionsFilter;
    private static EditableFeature lastChangedFeature = null;
    private ResourcesStorage resourcesStorage;
    private Boolean temporary = null;

    protected DataManager getDataManager() {
        return this.dataManager;
    }

    public void intialize(DataManager dataManager, DataStoreParameters parameters) throws InitializeException {
        DynObjectManager dynManager = ToolsLocator.getDynObjectManager();
        this.metadata = (DelegatedDynObject)dynManager.createDynObject(PERSISTENCE_DEFINITION_NAME, "metadata");
        this.dataManager = (DefaultDataManager)dataManager;
        this.parameters = parameters;
        this.transforms = new DefaultFeatureStoreTransforms(this);
        try {
            this.indexes = new DefaultFeatureIndexes(this);
        }
        catch (DataException e) {
            throw new InitializeException((Throwable)e);
        }
    }

    public void setProvider(DataStoreProvider provider) {
        this.provider = (FeatureStoreProvider)provider;
        this.delegate((DynObject)provider);
        this.metadataChildren = new HashSet();
        this.metadataChildren.add(provider);
        if (!this.ignoreDALResource) {
            this.loadDALFile();
            this.provider.fixFeatureTypeFromParameters();
            try {
                FeatureAttributeDescriptor attrGeom;
                if (this.defaultFeatureType != null && (attrGeom = this.defaultFeatureType.getDefaultGeometryAttribute()) != null) {
                    DefaultFeatureAttributeDescriptor gattr = (DefaultFeatureAttributeDescriptor)attrGeom;
                    IProjection srs = (IProjection)this.getDynValue("CRS");
                    if (srs != null && srs != gattr.getSRS()) {
                        gattr.setSRSForced(srs);
                    }
                }
            }
            catch (Throwable th) {
                LOGGER.warn("Can't patch DAL file", th);
            }
        }
    }

    public DataStoreParameters getParameters() {
        if (this.parameters == null) {
            LOGGER.warn("Store parameters are null (" + this.getFullNameForTraces() + ")");
        }
        return this.parameters;
    }

    public int getMode() {
        return this.mode;
    }

    public DataManager getManager() {
        return this.dataManager;
    }

    public UnmodifiableBasicMap<String, DataStore> getChildren() {
        UnmodifiableBasicMap children = this.provider.getChildren();
        if (children == null) {
            return UnmodifiableBasicMap.EMPTY_UNMODIFIABLEBASICMAP;
        }
        return children;
    }

    public FeatureStoreProvider getProvider() {
        return this.provider;
    }

    public FeatureManager getFeatureManager() {
        return this.featureManager;
    }

    public void setFeatureTypes(List types, FeatureType defaultType) {
        this.featureTypes = types;
        this.defaultFeatureType = defaultType;
    }

    public void open() throws OpenException {
        if (this.mode != 0) {
            try {
                throw new IllegalStateException();
            }
            catch (Exception ex) {
                LOGGER.warn("Opening a store in editing/append mode (" + this.getFullName() + ").", (Throwable)ex);
            }
        }
        if (this.notifyChange("before_Open_DataStore").isCanceled()) {
            return;
        }
        this.provider.open();
        this.notifyChange("after_Open_DataStore");
    }

    public void refresh() throws OpenException, InitializeException {
        if (this.mode != 0) {
            this.notifyChange("before_refresh");
            this.notifyChange("after_refresh");
            return;
        }
        if (this.notifyChange("before_refresh").isCanceled()) {
            return;
        }
        if (this.state.isBroken()) {
            this.load(this.state);
        } else {
            this.featureCount = null;
            this.provider.refresh();
        }
        this.resourcesStorage = null;
        this.loadDALFile();
        this.provider.fixFeatureTypeFromParameters();
        this.notifyChange("after_refresh");
    }

    public void close() throws CloseException {
        if (this.mode != 0) {
            try {
                throw new IllegalStateException();
            }
            catch (Exception ex) {
                LOGGER.warn("Clossing a store in editing/append mode (" + this.getFullName() + ").", (Throwable)ex);
            }
        }
        if (this.notifyChange("before_Close_DataStore").isCanceled()) {
            return;
        }
        this.featureCount = null;
        this.provider.close();
        this.notifyChange("after_Close_DataStore");
    }

    protected void doDispose() throws BaseException {
        if (this.mode != 0) {
            try {
                throw new IllegalStateException();
            }
            catch (Exception ex) {
                LOGGER.warn("Dispossing a store in editing/append mode (" + this.getFullName() + ").", (Throwable)ex);
            }
        }
        if (this.notifyChange("before_Dispose_DataStore").isCanceled()) {
            return;
        }
        this.getFullName();
        this.disposeIndexes();
        if (this.selection != null) {
            this.selection.dispose();
            this.selection = null;
        }
        this.commands = null;
        this.featureCount = null;
        if (this.locks != null) {
            this.locks = null;
        }
        if (this.featureTypeManager != null) {
            this.featureTypeManager.dispose();
            this.featureTypeManager = null;
        }
        this.featureManager = null;
        this.spatialManager = null;
        this.parameters = null;
        this.notifyChange("after_Dispose_DataStore");
        if (this.delegateObservable != null) {
            this.delegateObservable.deleteObservers();
            this.delegateObservable = null;
        }
        DisposeUtils.disposeQuietly((Disposable)this.resourcesStorage);
        DataTransaction transaction = this.getTransaction();
        if (transaction != null) {
            transaction.remove((DataStore)this);
            this.setTransaction(null);
        }
        if (this.provider != null) {
            this.provider.dispose();
            this.provider = null;
        }
        try {
            throw new RuntimeException("The store is disposed");
        }
        catch (Exception ex) {
            this.state.setBreakingsCause(ex);
            return;
        }
    }

    public boolean allowWrite() {
        SimpleIdentityManager identityManager = ToolsLocator.getIdentityManager();
        if (!identityManager.getCurrentIdentity().isAuthorized("dal-write-store", (Object)this.getParameters(), this.getName())) {
            return false;
        }
        return this.provider.allowWrite();
    }

    public boolean canWriteGeometry(int geometryType) throws DataException {
        return this.provider.canWriteGeometry(geometryType, 0);
    }

    public DataServerExplorer getExplorer() throws ReadException, ValidateDataParametersException {
        if (this.state.isBroken()) {
            try {
                return this.provider.getExplorer();
            }
            catch (Throwable th) {
                return null;
            }
        }
        return this.provider.getExplorer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Envelope getEnvelope() throws DataException {
        if (this.mode == 1) {
            DefaultFeatureStore defaultFeatureStore = this;
            synchronized (defaultFeatureStore) {
                return this.spatialManager.getEnvelope();
            }
        }
        try {
            Geometry geom;
            String geom_s;
            Tags tags;
            FeatureType featureType = this.getDefaultFeatureTypeQuietly();
            if (featureType != null && (tags = featureType.getTags()).has("DAL.forcedEnvelope") && StringUtils.isNotBlank((CharSequence)(geom_s = tags.getString("DAL.forcedEnvelope", null))) && (geom = GeometryUtils.createFrom((String)geom_s)) != null) {
                return geom.getEnvelope();
            }
        }
        catch (Throwable th) {
            LOGGER.debug("Can't retrieve envelope from featrure type tag 'DAL.forcedEnvelope'.", th);
        }
        if (this.hasDynValue("Envelope")) {
            return (Envelope)this.getDynValue("Envelope");
        }
        FeatureAttributeDescriptor attrdesc = this.getDefaultFeatureType().getDefaultGeometryAttribute();
        if (attrdesc == null) {
            return null;
        }
        if (!attrdesc.isComputed()) {
            Envelope envelope = this.provider.getEnvelope(attrdesc.getName());
            if (envelope != null) {
                return envelope;
            }
            if (this.getTransforms().isEmpty()) {
                return null;
            }
        }
        int index = attrdesc.getIndex();
        MutableObject envelopeValue = new MutableObject();
        try {
            this.accept(obj -> {
                Feature f = (Feature)obj;
                Geometry g = (Geometry)f.get(index);
                if (g == null) {
                    return;
                }
                if (envelopeValue.getValue() == null) {
                    envelopeValue.setValue((Object)g.getEnvelope());
                } else {
                    ((Envelope)envelopeValue.getValue()).add(g);
                }
            });
        }
        catch (Throwable th) {
            LOGGER.warn("Can't calculate envelope", th);
            return null;
        }
        return (Envelope)envelopeValue.getValue();
    }

    public IProjection getSRSDefaultGeometry() throws DataException {
        return this.getDefaultFeatureType().getDefaultSRS();
    }

    public FeatureSelection createDefaultFeatureSelection() throws DataException {
        return new DefaultFeatureSelection(this);
    }

    public FeatureProvider createDefaultFeatureProvider(FeatureType type) throws DataException {
        if (type.hasOID()) {
            return new DefaultFeatureProvider(type, this.provider.createNewOID());
        }
        return new DefaultFeatureProvider(type);
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("dataStoreName", this.getName());
        state.set("parameters", (Persistent)this.parameters);
        state.set("selection", (Persistent)this.selection);
        state.set("transforms", (Persistent)this.transforms);
        HashMap evaluatedAttr = new HashMap(1);
        for (FeatureType type : this.featureTypes) {
            ArrayList<DefaultFeatureAttributeDescriptor> attrs = new ArrayList<DefaultFeatureAttributeDescriptor>();
            for (DefaultFeatureAttributeDescriptor attr : type) {
                if (attr.getEvaluator() == null || !(attr.getEvaluator() instanceof Persistent)) continue;
                attrs.add(attr);
            }
            if (attrs.isEmpty()) continue;
            evaluatedAttr.put(type.getId(), attrs);
        }
        if (evaluatedAttr.isEmpty()) {
            evaluatedAttr = null;
        }
        state.set("evaluatedAttributes", evaluatedAttr);
        state.set("defaultFeatureTypeId", this.defaultFeatureType.getId());
    }

    public void loadFromState(PersistentState persistentState) throws PersistenceException {
        if (this.provider != null) {
            throw new PersistenceStoreAlreadyLoadedException(this.getName());
        }
        if (this.getManager() == null) {
            this.dataManager = (DefaultDataManager)DALLocator.getDataManager();
        }
        this.state.clear();
        try {
            this.state.put("parameters", persistentState.get("parameters"));
        }
        catch (Throwable th) {
            this.state.setBreakingsCause(th);
        }
        try {
            this.state.put("selection", persistentState.get("selection"));
        }
        catch (Throwable th) {
            this.state.setBreakingsCause(th);
        }
        try {
            this.state.put("transforms", persistentState.get("transforms"));
        }
        catch (Throwable th) {
            this.state.setBreakingsCause(th);
        }
        try {
            this.state.put("evaluatedAttributes", persistentState.get("evaluatedAttributes"));
        }
        catch (Throwable th) {
            this.state.setBreakingsCause(th);
        }
        try {
            this.state.put("defaultFeatureTypeId", persistentState.getString("defaultFeatureTypeId"));
        }
        catch (Throwable th) {
            this.state.setBreakingsCause(th);
        }
        this.load(this.state);
        ((DefaultDataManager)this.getDataManager()).addObservers((DataStore)this);
    }

    private void load(StateInformation state) {
        this.featureTypes = new ArrayList<FeatureType>();
        this.defaultFeatureType = null;
        this.featureCount = null;
        DataStoreParameters params = (DataStoreParameters)state.get("parameters");
        try {
            this.intialize(this.dataManager, params);
        }
        catch (Throwable th) {
            state.setBreakingsCause(th);
        }
        try {
            org.gvsig.fmap.dal.spi.DataStoreProvider prov = this.dataManager.createProvider(this.getStoreProviderServices(), params);
            this.setProvider((DataStoreProvider)prov);
        }
        catch (Throwable th) {
            LOGGER.warn("Can't load store from state.", th);
            state.setBreakingsCause(th);
        }
        try {
            this.selection = (FeatureSelection)state.get("selection");
        }
        catch (Throwable th) {
            state.setBreakingsCause(th);
        }
        try {
            this.transforms = (DefaultFeatureStoreTransforms)state.get("transforms");
            this.transforms.setFeatureStore(this);
            Iterator<FeatureStoreTransform> th = this.transforms.iterator();
            while (th.hasNext()) {
                FeatureStoreTransform transform = th.next();
                try {
                    transform.setUp();
                }
                catch (Throwable th2) {
                    state.setBreakingsCause(th2);
                }
            }
        }
        catch (Throwable th) {
            state.setBreakingsCause(th);
        }
        try {
            Map evaluatedAttributes = (Map)state.get("evaluatedAttributes");
            if (evaluatedAttributes != null && !evaluatedAttributes.isEmpty()) {
                for (Map.Entry entry : evaluatedAttributes.entrySet()) {
                    List attrs = (List)entry.getValue();
                    if (attrs.isEmpty()) continue;
                    int fTypePos = -1;
                    DefaultFeatureType type = null;
                    for (int i = 0; i < this.featureTypes.size(); ++i) {
                        type = (DefaultFeatureType)this.featureTypes.get(i);
                        if (!type.getId().equals(entry.getKey())) continue;
                        fTypePos = i;
                        break;
                    }
                    if (type == null) {
                        throw new PersistenceCantFindFeatureTypeException(this.getName(), (String)entry.getKey());
                    }
                    DefaultEditableFeatureType eType = (DefaultEditableFeatureType)type.getEditable();
                    for (FeatureAttributeDescriptor attr : attrs) {
                        eType.addLike(attr);
                    }
                    this.featureTypes.set(fTypePos, eType.getNotEditableCopy());
                }
            }
        }
        catch (Throwable th) {
            state.setBreakingsCause(th);
        }
        try {
            String defaultFeatureTypeId = (String)state.get("defaultFeatureTypeId");
            if (this.defaultFeatureType == null || this.defaultFeatureType.getId() == null || !this.defaultFeatureType.getId().equals(defaultFeatureTypeId)) {
                FeatureType ftype = this.getFeatureType(defaultFeatureTypeId);
                if (ftype == null && (ftype = this.getFeatureType(this.getName())) == null) {
                    throw new RuntimeException("Can't locate feature type");
                }
                this.defaultFeatureType = ftype;
            }
        }
        catch (Throwable th) {
            state.setBreakingsCause(th);
        }
        LOGGER.debug("load() broken:{}, {}, {}.", new Object[]{state.isBroken(), this.getProviderName(), params.toString(args -> StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)args[0]), (CharSequence)"password") ? "******" : args[1])});
    }

    public DataStoreProviderServices getStoreProviderServices() {
        return this;
    }

    public static void selfRegister(List<Exception> exs) {
        DefaultFeatureStore.registerPersistenceDefinition();
        try {
            DefaultFeatureStore.registerMetadataDefinition();
        }
        catch (MetadataException e) {
            exs.add((Exception)((Object)e));
        }
        try {
            DynObjectManager dynObjectManager = ToolsLocator.getDynObjectManager();
            dynObjectManager.registerTag("DAL.useLargeSelection", "Indicates whether the store should use a memory-based or a disk-based selection.").setType(1);
            dynObjectManager.registerTag("DAL.forcedEnvelope", "If specified, this geometry will be used to calculate the store envelope.").setType(8);
        }
        catch (Exception e) {
            exs.add(e);
        }
    }

    private static void registerPersistenceDefinition() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(DefaultFeatureStore.class, PERSISTENCE_DEFINITION_NAME, "FeatureStore Persistent definition", null, null);
            definition.addDynFieldString("dataStoreName").setMandatory(true).setPersistent(true);
            definition.addDynFieldObject("parameters").setClassOfValue(DynObject.class).setMandatory(true).setPersistent(true);
            definition.addDynFieldObject("selection").setClassOfValue(FeatureSelection.class).setMandatory(false).setPersistent(true);
            definition.addDynFieldObject("transforms").setClassOfValue(DefaultFeatureStoreTransforms.class).setMandatory(true).setPersistent(true);
            definition.addDynFieldMap("evaluatedAttributes").setClassOfItems(List.class).setMandatory(false).setPersistent(true);
            definition.addDynFieldString("defaultFeatureTypeId").setMandatory(true).setPersistent(true);
        }
    }

    private static void registerMetadataDefinition() throws MetadataException {
        MetadataManager manager = MetadataLocator.getMetadataManager();
        if (manager.getDefinition(PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct metadataDefinition = manager.addDefinition(PERSISTENCE_DEFINITION_NAME, null);
            metadataDefinition.extend(manager.getDefinition("DataProvider"));
        }
    }

    public void setSelection(DataSet selection) throws DataException {
        this.setSelection((FeatureSet)selection);
    }

    public DataSet createSelection() throws DataException {
        return this.createFeatureSelection();
    }

    public DataSet getSelection() throws DataException {
        return this.getFeatureSelection();
    }

    public void setSelection(FeatureSet selection) throws DataException {
        this.setSelection(selection, true);
    }

    public void setSelection(FeatureSet selection, boolean undoable) throws DataException {
        if (selection == null) {
            if (undoable) {
                throw new SelectionNotAllowedException(this.getName());
            }
        } else {
            if (selection.equals(this.selection)) {
                return;
            }
            if (!selection.isFromStore((DataStore)this)) {
                throw new SelectionNotAllowedException(this.getName());
            }
        }
        if (this.selection != null) {
            this.selection.deleteObserver((Observer)this);
        }
        if (selection == null) {
            if (this.selection != null) {
                this.selection.dispose();
            }
            this.selection = null;
            return;
        }
        if (selection instanceof FeatureSelection) {
            if (undoable && this.isEditing()) {
                this.commands.selectionSet(this, this.selection, (FeatureSelection)selection);
            }
            if (this.selection != null) {
                this.selection.dispose();
            }
            this.selection = (FeatureSelection)selection;
        } else {
            if (undoable && this.isEditing()) {
                this.commands.startComplex("_selectionSet");
            }
            if (this.selection == null) {
                this.selection = this.createDefaultFeatureSelection();
            }
            this.selection.deselectAll();
            this.selection.select(selection);
            if (undoable && this.isEditing()) {
                this.commands.endComplex();
            }
        }
        FeatureSelection sel = this.getFeatureSelection();
        sel.addObserver((Observer)this);
        this.notifyChange("after_SelectionChange_DataStore");
    }

    public FeatureSelection createFeatureSelection() throws DataException {
        boolean useLargeSelection;
        FeatureType featureType = this.getDefaultFeatureTypeQuietly();
        if (featureType != null) {
            Tags tags = featureType.getTags();
            if (tags.has("DAL.useLargeSelection")) {
                useLargeSelection = tags.getBoolean("DAL.useLargeSelection", true);
            } else {
                long maxSize = this.dataManager.getMaxSizeForSmallFeatureSelection();
                useLargeSelection = this.provider.getFeatureCount() > maxSize;
            }
        } else {
            long maxSize = this.dataManager.getMaxSizeForSmallFeatureSelection();
            useLargeSelection = this.provider.getFeatureCount() > maxSize;
        }
        FeatureSelection sel = useLargeSelection ? this.createLargeFeatureSelection() : this.provider.createFeatureSelection();
        return sel;
    }

    public FeatureSelection createLargeFeatureSelection() throws DataException {
        return new LargeFeatureSelection(this);
    }

    public FeatureSelection createMemoryFeatureSelection() throws DataException {
        return this.provider.createFeatureSelection();
    }

    public FeatureSelection getFeatureSelection() throws DataException {
        if (this.selection == null) {
            this.selection = this.createFeatureSelection();
            this.selection.addObserver((Observer)this);
        }
        return this.selection;
    }

    public FeatureSelection getFeatureSelectionQuietly() {
        try {
            return this.getFeatureSelection();
        }
        catch (DataException ex) {
            return FeatureSelection.EMTPY_FEATURE_SELECTION;
        }
    }

    public boolean isFeatureSelectionEmpty() {
        if (this.selection == null) {
            return true;
        }
        try {
            return this.selection.isEmpty();
        }
        catch (Exception ex) {
            LOGGER.warn("Can't check if selection is empty in '" + this.getFullName() + "'.", (Throwable)ex);
            this.selection = null;
            return true;
        }
    }

    public FeatureStoreNotification notifyChange(FeatureStoreNotification storeNotification) {
        if (this.delegateObservable != null && this.doesTheNotificationHaveToBeSent(storeNotification)) {
            try {
                this.delegateObservable.notifyObservers((Object)storeNotification);
            }
            catch (Throwable ex) {
                LOGGER.warn("Problems notifying changes in the store '" + this.getName() + " (" + storeNotification.getType() + ").", ex);
            }
        }
        return storeNotification;
    }

    public FeatureStoreNotification notifyChange(String notification) {
        return this.notifyChange(new DefaultFeatureStoreNotification((DataStore)this, notification, this.editingSessionCode == null ? this.lastEditingSessionCode : this.editingSessionCode, this.mode == 0 ? this.lastMode : this.mode));
    }

    public FeatureStoreNotification notifyChange(String notification, String editingSessionCode) {
        return this.notifyChange(new DefaultFeatureStoreNotification((DataStore)this, notification, editingSessionCode));
    }

    public FeatureStoreNotification notifyChange(String notification, String editingSessionCode, int editMode) {
        return this.notifyChange(new DefaultFeatureStoreNotification((DataStore)this, notification, editingSessionCode, editMode));
    }

    public FeatureStoreNotification notifyChange(String notification, Iterator<FeatureReference> deleteds, Iterator<EditableFeature> inserteds, Iterator<EditableFeature> updateds, Iterator<FeatureType.FeatureTypeChanged> featureTypesChanged, boolean isSelectionCompromised) {
        return this.notifyChange(new DefaultFeatureStoreNotification((DataStore)this, notification, this.editingSessionCode == null ? this.lastEditingSessionCode : this.editingSessionCode, this.mode == 0 ? this.lastMode : this.mode, deleteds, inserteds, updateds, featureTypesChanged, isSelectionCompromised));
    }

    public FeatureStoreNotification notifyChange(String notification, FeatureProvider data) {
        Feature f = null;
        if (data != null) {
            try {
                f = this.createFeature(data);
            }
            catch (Throwable ex) {
                LOGGER.warn("Problems creating a feature to notifying changes in the store '" + this.getName() + " (" + notification + ").", ex);
            }
        }
        return this.notifyChange(notification, f);
    }

    public FeatureStoreNotification notifyChange(String notification, Feature feature) {
        return this.notifyChange(new DefaultFeatureStoreNotification((DataStore)this, notification, this.editingSessionCode == null ? this.lastEditingSessionCode : this.editingSessionCode, this.mode == 0 ? this.lastMode : this.mode, feature));
    }

    public FeatureStoreNotification notifyChange(String notification, Expression expression) {
        return this.notifyChange(new DefaultFeatureStoreNotification((DataStore)this, notification, this.editingSessionCode == null ? this.lastEditingSessionCode : this.editingSessionCode, this.mode == 0 ? this.lastMode : this.mode, expression));
    }

    public FeatureStoreNotification notifyChange(String notification, Command command) {
        return this.notifyChange(new DefaultFeatureStoreNotification((DataStore)this, notification, this.editingSessionCode == null ? this.lastEditingSessionCode : this.editingSessionCode, this.mode == 0 ? this.lastMode : this.mode, command));
    }

    public FeatureStoreNotification notifyChange(String notification, EditableFeatureType type) {
        return this.notifyChange(new DefaultFeatureStoreNotification((DataStore)this, notification, this.editingSessionCode == null ? this.lastEditingSessionCode : this.editingSessionCode, this.mode == 0 ? this.lastMode : this.mode, type));
    }

    public FeatureStoreNotification notifyChange(String notification, Resource resource) {
        return this.notifyChange(new DefaultFeatureStoreNotification((DataStore)this, "resourceChange_DataStore"));
    }

    public boolean isLocksSupported() {
        return this.provider.isLocksSupported();
    }

    public FeatureLocks getLocks() throws DataException {
        if (!this.provider.isLocksSupported()) {
            LOGGER.warn("Locks not supported");
            return null;
        }
        if (this.locks == null) {
            this.locks = this.provider.createFeatureLocks();
        }
        return this.locks;
    }

    public void disableNotifications() {
        this.delegateObservable.disableNotifications();
    }

    public void enableNotifications() {
        this.delegateObservable.enableNotifications();
    }

    public void beginComplexNotification() {
        this.delegateObservable.beginComplexNotification();
    }

    public void endComplexNotification() {
        this.delegateObservable.endComplexNotification();
    }

    public void addObserver(Observer observer) {
        if (this.delegateObservable != null) {
            this.delegateObservable.addObserver(observer);
        }
    }

    public void deleteObserver(Observer observer) {
        if (this.delegateObservable != null) {
            this.delegateObservable.deleteObserver(observer);
        }
    }

    public void deleteObservers() {
        this.delegateObservable.deleteObservers();
    }

    public void update(Observable observable, Object notification) {
        if (observable instanceof FeatureSet) {
            if (observable == this.selection) {
                this.notifyChange("after_SelectionChange_DataStore");
            } else if (observable == this.locks) {
                this.notifyChange("after_LockedChange_DataStore");
            }
        } else if (observable instanceof FeatureStoreProvider) {
            if (observable == this.provider) {
                // empty if block
            }
        } else if (observable instanceof FeatureReferenceSelection && notification instanceof String) {
            this.notifyChange((String)notification);
        }
    }

    private void newVersionOfUpdate() {
        ++this.versionOfUpdate;
    }

    private long currentVersionOfUpdate() {
        return this.versionOfUpdate;
    }

    private void checkInEditingMode() throws NeedEditingModeException {
        if (this.mode != 1) {
            throw new NeedEditingModeException(this.getName());
        }
    }

    private void checkNotInAppendMode() throws IllegalStateException {
        if (this.mode == 2) {
            throw new IllegalStateException("Error: store " + this.getFullName() + " is in append mode");
        }
    }

    private void checkIsOwnFeature(Feature feature) throws IllegalFeatureException {
        if (((DefaultFeature)feature).getStore() != this) {
            throw new IllegalFeatureException(this.getName());
        }
    }

    private void exitEditingMode() {
        if (this.commands != null) {
            try {
                this.commands.clear();
            }
            catch (Exception ex) {
                LOGGER.trace("Can't clear commands", (Throwable)ex);
            }
            this.commands = null;
        }
        if (this.featureTypeManager != null) {
            DisposeUtils.disposeQuietly((Object)this.featureTypeManager);
            this.featureTypeManager = null;
        }
        this.featureManager = null;
        if (this.spatialManager != null) {
            this.spatialManager.clear();
        }
        this.spatialManager = null;
        this.featureCount = null;
        this.lastMode = this.mode;
        this.mode = 0;
        this.hasStrongChanges = true;
        this.lastEditingSessionCode = this.editingSessionCode;
        this.editingSessionCode = null;
        if (StringUtils.equalsIgnoreCase((CharSequence)"GVSIGD_RESOURCES", (CharSequence)this.getName())) {
            DALLocator.getDataManager().clearAllCachedResources();
        }
    }

    public int getSubmode() {
        return this.submode;
    }

    public synchronized void edit() throws DataException {
        this.edit(1);
    }

    public synchronized void edit(int mode) throws DataException {
        this.edit(mode, 0);
    }

    public synchronized void edit(int mode, int submode) throws DataException {
        LOGGER.debug("Starting editing in mode: {}", (Object)mode);
        if (this.mode != 0) {
            throw new AlreadyEditingException(this.getName());
        }
        FeatureType ftype = this.getDefaultFeatureType();
        String newSessionCode = this.createUniqueID();
        try {
            if (!this.provider.supportsAppendMode()) {
                mode = 1;
            }
            if (!this.canBeEdited()) {
                throw new IllegalStateException(this.getName());
            }
            switch (mode) {
                case 0: {
                    throw new IllegalStateException(this.getName());
                }
                case 1: {
                    if (this.notifyChange("before_StartEditing_DataStore", newSessionCode, mode).isCanceled()) {
                        return;
                    }
                    this.editingSessionCode = newSessionCode;
                    this.invalidateIndexes();
                    this.featureManager = new FeatureManager(this);
                    this.featureTypeManager = new FeatureTypeManager(this);
                    this.spatialManager = new SpatialManager(this);
                    this.commands = new DefaultFeatureCommandsStack(this, this.featureManager, this.spatialManager, this.featureTypeManager);
                    this.mode = 1;
                    this.submode = submode;
                    this.hasStrongChanges = false;
                    this.notifyChange("after_StartEditing_DataStore", newSessionCode, this.mode);
                    break;
                }
                case 2: {
                    if (this.notifyChange("before_StartEditing_DataStore", newSessionCode, mode).isCanceled()) {
                        return;
                    }
                    this.editingSessionCode = newSessionCode;
                    this.invalidateIndexes();
                    this.provider.beginAppend(submode);
                    this.mode = 2;
                    this.submode = submode;
                    this.notifyChange("after_StartEditing_DataStore", newSessionCode, this.mode);
                    break;
                }
                case 3: {
                    if (!this.provider.supportsPassThroughMode()) {
                        throw new IllegalStateException(this.getName());
                    }
                    if (this.notifyChange("before_StartEditing_DataStore", newSessionCode, mode).isCanceled()) {
                        return;
                    }
                    this.editingSessionCode = newSessionCode;
                    this.invalidateIndexes();
                    this.mode = 3;
                    this.submode = submode;
                    this.notifyChange("after_StartEditing_DataStore", newSessionCode, this.mode);
                }
            }
        }
        catch (Exception e) {
            try {
                if (this.mode != 0) {
                    this.exitEditingMode();
                }
                this.notifyChange("failed_StartEditing_DataStore", newSessionCode, mode);
            }
            catch (Throwable th) {
                LOGGER.warn("Can't cleanup after error in start editing.", th);
            }
            throw new StoreEditException((Throwable)e, this.getName());
        }
    }

    private void invalidateIndexes() {
        this.setIndexesValidStatus(false);
    }

    private void setIndexesValidStatus(boolean valid) {
        FeatureIndexes theIndexes = this.getIndexes();
        LOGGER.debug("Setting the store indexes to valid status {}: {}", (Object)(valid ? Boolean.TRUE : Boolean.FALSE), (Object)theIndexes);
        for (FeatureIndex index : theIndexes) {
            if (!(index instanceof FeatureIndexProviderServices)) continue;
            FeatureIndexProviderServices indexServices = (FeatureIndexProviderServices)index;
            indexServices.setValid(valid);
        }
    }

    private void updateIndexes() throws FeatureIndexException {
        FeatureIndexes theIndexes = this.getIndexes();
        LOGGER.debug("Refilling indexes: {}", (Object)theIndexes);
        for (FeatureIndex index : theIndexes) {
            if (!(index instanceof FeatureIndexProviderServices)) continue;
            FeatureIndexProviderServices indexServices = (FeatureIndexProviderServices)index;
            indexServices.fill(true, null);
        }
    }

    private void waitForIndexes() {
        FeatureIndexes theIndexes = this.getIndexes();
        LOGGER.debug("Waiting for indexes to finish filling: {}", (Object)theIndexes);
        for (FeatureIndex index : theIndexes) {
            if (!(index instanceof FeatureIndexProviderServices)) continue;
            FeatureIndexProviderServices indexServices = (FeatureIndexProviderServices)index;
            indexServices.waitForIndex();
        }
    }

    private void disposeIndexes() {
        FeatureIndexes theIndexes = this.getIndexes();
        LOGGER.debug("Disposing indexes: {}", (Object)theIndexes);
        if (theIndexes == null) {
            return;
        }
        for (FeatureIndex index : theIndexes) {
            if (!(index instanceof FeatureIndexProviderServices)) continue;
            FeatureIndexProviderServices indexServices = (FeatureIndexProviderServices)index;
            indexServices.dispose();
        }
    }

    public boolean isEditing() {
        return this.mode == 1;
    }

    public boolean isAppending() {
        return this.mode == 2;
    }

    public synchronized void update(EditableFeatureType type) throws DataException {
        try {
            if (type == null) {
                throw new NullFeatureTypeException(this.getName());
            }
            switch (this.mode) {
                case 0: {
                    if (!type.hasOnlyMetadataChanges(this.defaultFeatureType)) break;
                    if (this.notifyChange("before_Update_Type", type).isCanceled()) {
                        return;
                    }
                    FeatureType theType = type.getNotEditableCopy();
                    if (this.defaultFeatureType.getId().equals(theType.getId())) {
                        this.defaultFeatureType = theType;
                    }
                    ArrayList<FeatureType> newtypes = new ArrayList<FeatureType>();
                    for (FeatureType featureType : this.featureTypes) {
                        if (featureType.getId().equals(theType.getId())) {
                            newtypes.add(theType);
                            continue;
                        }
                        newtypes.add(featureType);
                    }
                    this.featureTypes = newtypes;
                    this.saveDALFile();
                    this.notifyChange("after_Update_Type", type);
                    break;
                }
                case 1: {
                    if (this.notifyChange("before_Update_Type", type).isCanceled()) {
                        return;
                    }
                    this.newVersionOfUpdate();
                    FeatureType oldt = type.getSource().getCopy();
                    FeatureType newt = type.getCopy();
                    this.commands.update(newt, oldt);
                    this.hasStrongChanges = ((DefaultEditableFeatureType)type).hasStrongChanges();
                    this.notifyChange("after_Update_Type", type);
                    break;
                }
                case 2: 
                case 3: {
                    throw new NeedEditingModeException(this.getName());
                }
            }
        }
        catch (Exception e) {
            throw new StoreUpdateFeatureTypeException((Throwable)e, this.getName());
        }
    }

    public void delete(Feature feature) throws DataException {
        switch (this.mode) {
            case 3: {
                this.checkIsOwnFeature(feature);
                if (this.notifyChange("before_Delete_Feature", feature).isCanceled()) {
                    return;
                }
                this.provider.passThroughDelete((FeatureReferenceProviderServices)feature.getReference());
                this.notifyChange("after_Delete_Feature", feature);
                break;
            }
            default: {
                this.commands.delete(feature);
            }
        }
    }

    public void delete(String filter) {
        if (StringUtils.isBlank((CharSequence)filter)) {
            return;
        }
        this.delete(ExpressionUtils.createExpression((String)filter));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(Expression filter) {
        block20: {
            block19: {
                if (filter == null) {
                    return;
                }
                pendingFinishEditing = false;
                features = null;
                try {
                    switch (this.mode) {
                        case 0: {
                            pendingFinishEditing = true;
                            this.edit();
                            ** break;
                        }
                        case 2: {
                            throw new IllegalStateException("Delete not allowed in append mode.");
                        }
                        case 1: {
                            ** break;
                        }
                        case 3: {
                            if (this.notifyChange("before_Delete_Feature", filter).isCanceled()) {
                                if (pendingFinishEditing) {
                                    this.finishEditingQuietly();
                                }
                                break;
                            }
                            ** GOTO lbl-1000
                        }
                        default: {
                            throw new IllegalStateException("Mode " + this.mode + " not supported.");
                        }
                    }
                }
                catch (DataException ex) {
                    try {
                        throw new DataRuntimeException(ex.getFormatString(), ex.getMessageKey(), ex.getCode()){};
                        catch (Exception ex) {
                            throw new RuntimeException("Can't delete features (" + filter.getPhrase() + ").", ex);
                        }
                    }
                    catch (Throwable var7_9) {
                        if (pendingFinishEditing) {
                            this.finishEditingQuietly();
                        }
                        DisposeUtils.disposeQuietly(features);
                        throw var7_9;
                    }
                }
                DisposeUtils.disposeQuietly((Disposable)features);
                return;
lbl-1000:
                // 1 sources

                {
                    this.provider.passThroughDelete(filter);
                    this.notifyChange("after_Delete_Feature", filter);
                    if (!pendingFinishEditing) break block19;
                    this.finishEditingQuietly();
                }
            }
            DisposeUtils.disposeQuietly((Disposable)features);
            return;
lbl-1000:
            // 2 sources

            {
                fset = this.getFeatureSet(filter);
                features = fset.iterable();
                for (Feature f : features) {
                    fset.delete(f);
                }
                if (!pendingFinishEditing) break block20;
                this.finishEditingQuietly();
            }
        }
        DisposeUtils.disposeQuietly((Disposable)features);
    }

    public synchronized void doDelete(Feature feature) throws DataException {
        if (feature == null) {
            throw new IllegalArgumentException("feature argument can't be null.");
        }
        try {
            this.checkInEditingMode();
            this.checkIsOwnFeature(feature);
            if (feature instanceof EditableFeature && !((EditableFeature)feature).isUpdatable()) {
                throw new StoreDeleteEditableFeatureException(this.getName());
            }
            if (this.notifyChange("before_Delete_Feature", feature).isCanceled()) {
                return;
            }
            this.featureManager.delete(feature);
            this.spatialManager.deleteFeature(feature);
            this.newVersionOfUpdate();
            this.hasStrongChanges = true;
            this.notifyChange("after_Delete_Feature", feature);
        }
        catch (Exception e) {
            throw new StoreDeleteFeatureException((Throwable)e, this.getName());
        }
    }

    public synchronized void insert(FeatureSet set) throws DataException {
        switch (this.mode) {
            case 0: {
                throw new NeedEditingModeException(this.getName());
            }
            case 1: 
            case 2: 
            case 3: {
                try {
                    set.accept(obj -> {
                        EditableFeature ef = this.createNewFeature((Feature)obj);
                        this.insert(ef);
                    });
                    break;
                }
                catch (BaseException ex) {
                    throw new StoreInsertFeatureException((Throwable)ex, this.getName());
                }
            }
        }
    }

    public synchronized void insert(EditableFeature feature) throws DataException {
        LOGGER.debug("In editing mode {}, insert feature: {}", (Object)this.mode, (Object)feature);
        try {
            switch (this.mode) {
                case 0: {
                    throw new NeedEditingModeException(this.getName());
                }
                case 2: {
                    this.checkIsOwnFeature((Feature)feature);
                    if (feature.isUpdatable()) {
                        throw new NoNewFeatureInsertException(this.getName());
                    }
                    if (this.notifyChange("before_Insert_Feature", (Feature)feature).isCanceled()) {
                        return;
                    }
                    this.featureCount = null;
                    feature.validate(1);
                    this.provider.append(((DefaultEditableFeature)feature).getData());
                    this.hasStrongChanges = true;
                    this.notifyChange("after_Insert_Feature", (Feature)feature);
                    break;
                }
                case 1: {
                    if (this.submode == 2) {
                        Expression filter = feature.createFilter();
                        Feature f = this.findFirst(filter);
                        if (f == null) {
                            this.insert(feature);
                            break;
                        }
                        this.update(feature);
                        break;
                    }
                    if (feature.isUpdatable()) {
                        throw new NoNewFeatureInsertException(this.getName());
                    }
                    feature.validate(1);
                    this.commands.insert(feature);
                    break;
                }
                case 3: {
                    this.checkIsOwnFeature((Feature)feature);
                    if (feature.isUpdatable()) {
                        throw new NoNewFeatureInsertException(this.getName());
                    }
                    if (this.notifyChange("before_Insert_Feature", (Feature)feature).isCanceled()) {
                        return;
                    }
                    feature.validate(1);
                    if (this.submode == 2) {
                        this.provider.passThroughInsertOrUpdate(((DefaultEditableFeature)feature).getData());
                    } else {
                        this.provider.passThroughInsert(((DefaultEditableFeature)feature).getData());
                    }
                    this.notifyChange("after_Insert_Feature", (Feature)feature);
                }
            }
        }
        catch (Exception e) {
            throw new StoreInsertFeatureException((Throwable)e, this.getName());
        }
    }

    public synchronized void doInsert(EditableFeature feature) throws DataException {
        this.checkIsOwnFeature((Feature)feature);
        this.waitForIndexes();
        if (this.notifyChange("before_Insert_Feature", (Feature)feature).isCanceled()) {
            return;
        }
        this.newVersionOfUpdate();
        if (lastChangedFeature == null || lastChangedFeature.getSource() != feature.getSource()) {
            lastChangedFeature = feature;
            feature.validate(1);
            lastChangedFeature = null;
        }
        ((DefaultFeature)feature).setInserted(true);
        DefaultFeature newFeature = (DefaultFeature)feature.getNotEditableCopy();
        this.featureManager.add(feature);
        this.spatialManager.insertFeature(newFeature);
        this.hasStrongChanges = true;
        this.notifyChange("after_Insert_Feature", (Feature)feature);
    }

    public void update(EditableFeature feature) throws DataException {
        switch (this.mode) {
            case 3: {
                this.checkIsOwnFeature((Feature)feature);
                if (!feature.isUpdatable()) {
                    throw new NoNewFeatureInsertException(this.getName());
                }
                if (this.notifyChange("before_Update_Feature", (Feature)feature).isCanceled()) {
                    return;
                }
                feature.validate(1);
                this.provider.passThroughUpdate(((DefaultEditableFeature)feature).getData());
                this.notifyChange("after_Update_Feature", (Feature)feature);
                break;
            }
            case 1: {
                if (!feature.getType().supportReferences()) {
                    throw new UnsupportedOperationException("Can't update store in full edit mode without references support.");
                }
                if (feature.isUpdatable()) {
                    this.commands.update(feature, feature.getSource());
                    return;
                }
                this.insert(feature);
                break;
            }
            default: {
                throw new NeedEditingModeException(this.getName());
            }
        }
    }

    public void update(Object ... parameters) throws DataException {
        if (parameters.length == 1) {
            Object param0 = parameters[0];
            if (param0 instanceof EditableFeature) {
                this.update((EditableFeature)param0);
            } else if (param0 instanceof EditableFeatureType) {
                this.update((EditableFeatureType)param0);
            } else {
                throw new IllegalArgumentException("Type of first parameter isn't supported");
            }
            return;
        }
        Expression filter = null;
        long end = parameters.length;
        if (parameters.length % 2 == 1) {
            Object param = parameters[parameters.length - 1];
            if (param != null) {
                filter = param instanceof Expression ? (Expression)param : ExpressionUtils.createExpression((String)param.toString());
            }
        } else {
            end = parameters.length - 1;
        }
        switch (this.mode) {
            case 3: {
                this.provider.passThroughUpdate(parameters, filter);
                break;
            }
            case 1: {
                FeatureSet set = this.getFeatureSet(filter);
                DisposableIterator it = set.fastIterator();
                while (it.hasNext()) {
                    Feature feature = (Feature)it.next();
                    EditableFeature ef = feature.getEditable();
                    int i = 0;
                    while ((long)i < end) {
                        String name = (String)parameters[i];
                        Object value = parameters[i + 1];
                        ef.set(name, value);
                        i += 2;
                    }
                    set.update(ef);
                }
                DisposeUtils.disposeQuietly((Disposable)it);
                DisposeUtils.disposeQuietly((Disposable)set);
                break;
            }
            default: {
                throw new NeedEditingModeException(this.getName());
            }
        }
    }

    public synchronized void doUpdate(EditableFeature feature, Feature oldFeature) throws DataException {
        try {
            this.checkInEditingMode();
            this.checkIsOwnFeature((Feature)feature);
            if (this.notifyChange("before_Update_Feature", (Feature)feature).isCanceled()) {
                return;
            }
            this.newVersionOfUpdate();
            if (lastChangedFeature == null || lastChangedFeature.getSource() != feature.getSource()) {
                lastChangedFeature = feature;
                feature.validate(1);
                lastChangedFeature = null;
            }
            Feature newf = feature.getNotEditableCopy();
            this.featureManager.update(feature, oldFeature);
            this.spatialManager.updateFeature(newf, oldFeature);
            this.hasStrongChanges = true;
            this.notifyChange("after_Update_Feature", (Feature)feature);
        }
        catch (Exception e) {
            throw new StoreUpdateFeatureException((Throwable)e, this.getName());
        }
    }

    public synchronized void redo() throws RedoException {
        Command redo = this.commands.getNextRedoCommand();
        try {
            this.checkInEditingMode();
        }
        catch (NeedEditingModeException ex) {
            throw new RedoException((UndoRedoInfo)redo, (Throwable)ex);
        }
        if (this.notifyChange("before_Redo_DataStore", redo).isCanceled()) {
            return;
        }
        this.newVersionOfUpdate();
        this.commands.redo();
        this.hasStrongChanges = true;
        this.notifyChange("after_Redo_DataStore", redo);
    }

    public synchronized void undo() throws UndoException {
        Command undo = this.commands.getNextUndoCommand();
        try {
            this.checkInEditingMode();
        }
        catch (NeedEditingModeException ex) {
            throw new UndoException((UndoRedoInfo)undo, (Throwable)ex);
        }
        if (this.notifyChange("before_Undo_DataStore", undo).isCanceled()) {
            return;
        }
        this.newVersionOfUpdate();
        this.commands.undo();
        this.hasStrongChanges = true;
        this.notifyChange("after_Undo_DataStore", undo);
    }

    public List getRedoInfos() {
        if (this.isEditing() && this.commands != null) {
            return this.commands.getRedoInfos();
        }
        return null;
    }

    public List getUndoInfos() {
        if (this.isEditing() && this.commands != null) {
            return this.commands.getUndoInfos();
        }
        return null;
    }

    public synchronized FeatureCommandsStack getCommandsStack() throws DataException {
        this.checkInEditingMode();
        return this.commands;
    }

    public boolean cancelEditingQuietly() {
        try {
            this.cancelEditing();
            return true;
        }
        catch (Exception ex) {
            LOGGER.debug("Can't cancel editing", (Throwable)ex);
            return false;
        }
    }

    public synchronized void cancelEditing() throws DataException {
        try {
            switch (this.mode) {
                case 0: {
                    throw new NeedEditingModeException(this.getName());
                }
                case 2: {
                    if (this.notifyChange("before_CancelEditing_DataStore").isCanceled()) {
                        return;
                    }
                    this.provider.abortAppend();
                    this.exitEditingMode();
                    ((FeatureSelection)this.getSelection()).deselectAll();
                    this.updateIndexes();
                    this.notifyChange("after_CancelEditing_DataStore");
                    break;
                }
                case 1: {
                    boolean clearSelection = this.hasStrongChanges;
                    if (this.selection instanceof FeatureReferenceSelection) {
                        boolean bl = clearSelection = this.hasStrongChanges || this.featureManager.hasNews();
                    }
                    if (this.notifyChange("before_CancelEditing_DataStore").isCanceled()) {
                        return;
                    }
                    this.exitEditingMode();
                    if (clearSelection) {
                        ((FeatureSelection)this.getSelection()).deselectAll();
                    }
                    this.updateIndexes();
                    this.notifyChange("after_CancelEditing_DataStore");
                    break;
                }
                case 3: {
                    if (this.notifyChange("before_CancelEditing_DataStore").isCanceled()) {
                        return;
                    }
                    this.exitEditingMode();
                    ((FeatureSelection)this.getSelection()).deselectAll();
                    this.updateIndexes();
                    this.notifyChange("after_CancelEditing_DataStore");
                }
            }
        }
        catch (Exception e) {
            throw new StoreCancelEditingException((Throwable)e, this.getName());
        }
    }

    public boolean finishEditingQuietly() {
        try {
            this.finishEditing();
            return true;
        }
        catch (Exception ex) {
            LOGGER.debug("Can't finish editing", (Throwable)ex);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void finishEditing() throws DataException {
        LOGGER.debug("finish editing of mode: {}", (Object)this.mode);
        LocalTransaction trans = new LocalTransaction((DataManager)this.dataManager, new DataTransaction[]{this.getTransaction()});
        try {
            switch (this.mode) {
                case 0: {
                    throw new NeedEditingModeException(this.getName());
                }
                case 2: {
                    if (this.selection != null) {
                        this.selection = null;
                    }
                    if (this.notifyChange("before_FinishEditing_DataStore").isCanceled()) {
                        return;
                    }
                    trans.begin();
                    trans.add((DataStore)this);
                    this.saveDALFile();
                    this.provider.endAppend();
                    this.exitEditingMode();
                    this.loadDALFile();
                    this.updateIndexes();
                    trans.commit();
                    trans.close();
                    this.notifyChange("after_FinishEditing_DataStore");
                    return;
                }
                case 1: {
                    if (this.featureManager.hasChanges() || this.featureTypeManager.hasChanges()) {
                        FeatureStoreNotification notification;
                        if (this.hasStrongChanges && !this.allowWrite()) {
                            throw new WriteNotAllowedException(this.getName());
                        }
                        if (this.notifyChange("preparing_FinishEditing_DataStore").isCanceled()) {
                            return;
                        }
                        if (this.hasStrongChanges) {
                            this.validateFeaturesAtFinishEditing();
                        }
                        if ((notification = this.notifyChange("before_FinishEditing_DataStore", this.featureManager.getDeleted(), this.featureManager.getInsertedFeatures(), this.featureManager.getUpdatedFeatures(), this.featureTypeManager.getFeatureTypesChanged().iterator(), this.featureManager.isSelectionCompromised())).isCanceled()) {
                            return;
                        }
                        if (notification.isAborted()) {
                            if (notification.getAbortCause() != null) throw notification.getAbortCause();
                            throw new RuntimeException();
                        }
                        trans.begin();
                        trans.add((DataStore)this);
                        this.saveDALFile();
                        if (this.featureManager.isSelectionCompromised() && this.selection != null) {
                            this.selection = null;
                        }
                        if (this.hasStrongChanges) {
                            this.provider.performChanges(this.featureManager.getDeleted(), this.featureManager.getInserted(), this.featureManager.getUpdated(), this.featureTypeManager.getFeatureTypesChanged().iterator());
                        }
                        this.exitEditingMode();
                        this.loadDALFile();
                        this.updateIndexes();
                        trans.commit();
                        trans.close();
                    } else {
                        this.exitEditingMode();
                    }
                    this.notifyChange("after_FinishEditing_DataStore");
                    return;
                }
                case 3: {
                    if (this.selection != null) {
                        this.selection = null;
                    }
                    if (this.notifyChange("before_FinishEditing_DataStore").isCanceled()) {
                        return;
                    }
                    this.exitEditingMode();
                    this.updateIndexes();
                    this.notifyChange("after_FinishEditing_DataStore");
                    return;
                }
            }
            return;
        }
        catch (ValidateFeaturesException | WriteNotAllowedException ex) {
            if (trans.isLocal()) {
                trans.setKeepEditingMode((DataStore)this, true);
            }
            trans.abortQuietly();
            throw ex;
        }
        catch (PerformEditingException pee) {
            if (trans.isLocal()) {
                trans.setKeepEditingMode((DataStore)this, true);
            }
            trans.abortQuietly();
            try {
                this.notifyChange("failed_FinishEditing_DataStore");
                throw new WriteException(this.provider.getSourceId().toString(), (Throwable)pee);
            }
            catch (Throwable t) {
                LOGGER.warn("Problems reporting finish editing failure", t);
            }
            throw new WriteException(this.provider.getSourceId().toString(), (Throwable)pee);
        }
        catch (Throwable e) {
            if (trans.isLocal()) {
                trans.setKeepEditingMode((DataStore)this, true);
            }
            trans.abortQuietly();
            try {
                this.notifyChange("failed_FinishEditing_DataStore");
                throw new FinishEditingException(e);
            }
            catch (Throwable t) {
                LOGGER.warn("Problems reporting finish editing failure", t);
            }
            throw new FinishEditingException(e);
        }
        finally {
            trans.closeQuietly();
        }
    }

    public String getEditingSession() {
        return this.editingSessionCode;
    }

    private void clearResourcesCache() {
        ResourcesStorage theResourcesStorage = null;
        try {
            theResourcesStorage = this.getResourcesStorage();
            if (theResourcesStorage == null) {
                return;
            }
            theResourcesStorage.clearCache();
        }
        catch (Throwable ex) {
            LOGGER.warn("Can't clear resources for store '" + this.getFullNameForTraces() + "'.", ex);
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)theResourcesStorage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDALFile() {
        block11: {
            ResourcesStorage theResourcesStorage;
            ResourcesStorage.Resource resource;
            block10: {
                block9: {
                    block8: {
                        if (this.ignoreDALResource) {
                            return;
                        }
                        resource = null;
                        theResourcesStorage = null;
                        theResourcesStorage = this.getResourcesStorage();
                        if (theResourcesStorage != null && !theResourcesStorage.isReadOnly()) break block8;
                        IOUtils.closeQuietly(resource);
                        DisposeUtils.disposeQuietly((Disposable)theResourcesStorage);
                        return;
                    }
                    resource = theResourcesStorage.getResource("dal");
                    if (resource != null && !resource.isReadOnly()) break block9;
                    IOUtils.closeQuietly((Closeable)resource);
                    DisposeUtils.disposeQuietly((Disposable)theResourcesStorage);
                    return;
                }
                try {
                    DALFile dalFile = DALFile.getDALFile();
                    dalFile.setStore(this);
                    if (dalFile.isEmpty()) break block10;
                    dalFile.write(resource);
                }
                catch (Throwable ex) {
                    try {
                        LOGGER.warn("Can't save DAL resource", ex);
                        break block11;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        IOUtils.closeQuietly(resource);
                        DisposeUtils.disposeQuietly((Disposable)theResourcesStorage);
                    }
                }
            }
            IOUtils.closeQuietly((Closeable)resource);
            DisposeUtils.disposeQuietly((Disposable)theResourcesStorage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDALFile() {
        ResourcesStorage theResourcesStorage;
        ResourcesStorage.Resource resource;
        block12: {
            block11: {
                block10: {
                    if (this.ignoreDALResource) {
                        return;
                    }
                    resource = null;
                    theResourcesStorage = null;
                    theResourcesStorage = this.getResourcesStorage();
                    if (theResourcesStorage != null) break block10;
                    IOUtils.closeQuietly(resource);
                    DisposeUtils.disposeQuietly((Disposable)theResourcesStorage);
                    return;
                }
                resource = theResourcesStorage.getResource("dal");
                if (resource != null && resource.exists()) break block11;
                IOUtils.closeQuietly((Closeable)resource);
                DisposeUtils.disposeQuietly((Disposable)theResourcesStorage);
                return;
            }
            try {
                DALFile dalFile = DALFile.getDALFile(resource);
                if (dalFile.isEmpty()) break block12;
                dalFile.updateStore(this);
            }
            catch (Throwable ex) {
                block13: {
                    try {
                        if (resource == null || theResourcesStorage == null) {
                            if (theResourcesStorage == null) {
                                LOGGER.warn("Can't load DAL resource (resname=null, resurl=null, storage=null)", ex);
                            } else {
                                LOGGER.warn("Can't load DAL resource (resname=null, resurl=null, storage=" + theResourcesStorage.getClass().getName() + ").", ex);
                            }
                            break block13;
                        }
                        LOGGER.warn("Can't load DAL resource (resname=" + resource.getName() + ", resurl=" + Objects.toString(resource.getURL()) + ", storage=" + theResourcesStorage.getClass().getName() + ").", ex);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(resource);
                        DisposeUtils.disposeQuietly((Disposable)theResourcesStorage);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Closeable)resource);
                DisposeUtils.disposeQuietly((Disposable)theResourcesStorage);
            }
        }
        IOUtils.closeQuietly((Closeable)resource);
        DisposeUtils.disposeQuietly((Disposable)theResourcesStorage);
    }

    public synchronized void commitChanges() throws DataException {
        LOGGER.debug("commitChanges of mode: {}", (Object)this.mode);
        if (!this.canCommitChanges()) {
            throw new WriteNotAllowedException(this.getName());
        }
        try {
            switch (this.mode) {
                case 0: {
                    throw new NeedEditingModeException(this.getName());
                }
                case 2: {
                    this.provider.endAppend();
                    this.exitEditingMode();
                    this.invalidateIndexes();
                    this.provider.beginAppend();
                    break;
                }
                case 1: {
                    if (this.hasStrongChanges && !this.allowWrite()) {
                        throw new WriteNotAllowedException(this.getName());
                    }
                    if (this.hasStrongChanges) {
                        this.validateFeaturesAtFinishEditing();
                        this.provider.performChanges(this.featureManager.getDeleted(), this.featureManager.getInserted(), this.featureManager.getUpdated(), this.featureTypeManager.getFeatureTypesChanged().iterator());
                    }
                    this.invalidateIndexes();
                    this.featureManager = new FeatureManager(this);
                    this.featureTypeManager = new FeatureTypeManager(this);
                    this.spatialManager = new SpatialManager(this);
                    this.commands = new DefaultFeatureCommandsStack(this, this.featureManager, this.spatialManager, this.featureTypeManager);
                    this.featureCount = null;
                    this.hasStrongChanges = false;
                }
            }
        }
        catch (Exception e) {
            throw new FinishEditingException((Throwable)e);
        }
    }

    public synchronized boolean canCommitChanges() throws DataException {
        if (!this.allowWrite()) {
            return false;
        }
        switch (this.mode) {
            default: {
                return false;
            }
            case 2: {
                return true;
            }
            case 1: 
        }
        List types = this.getFeatureTypes();
        for (int i = 0; i < types.size(); ++i) {
            Object type = types.get(i);
            if (!(type instanceof DefaultEditableFeatureType) || !((DefaultEditableFeatureType)type).hasStrongChanges()) continue;
            return false;
        }
        return true;
    }

    public void beginEditingGroup(String description) throws NeedEditingModeException {
        this.checkInEditingMode();
        this.commands.startComplex(description);
    }

    public void endEditingGroup() throws NeedEditingModeException {
        this.checkInEditingMode();
        this.commands.endComplex();
    }

    public boolean isAppendModeSupported() {
        return this.provider.supportsAppendMode();
    }

    public void export(DataServerExplorer explorer, String provider, NewFeatureStoreParameters params, String name) throws DataException {
        if (this.getFeatureTypes().size() != 1) {
            throw new NotYetImplemented("export whith more than one type not yet implemented");
        }
        FeatureSelection featureSelection = (FeatureSelection)this.getSelection();
        FeatureStore target = null;
        FeatureSelection features = null;
        DisposableIterator iterator = null;
        try {
            FeatureType type = this.getDefaultFeatureType();
            if (params.getDefaultFeatureType() == null || params.getDefaultFeatureType().size() == 0) {
                params.setDefaultFeatureType((FeatureType)type.getEditable());
            }
            explorer.add(provider, (NewDataStoreParameters)params, true);
            DataManager manager = DALLocator.getDataManager();
            DataStoreParameters openParams = explorer.get(name);
            target = (FeatureStore)manager.openStore(provider, openParams);
            FeatureType targetType = target.getDefaultFeatureType();
            target.edit(2);
            FeatureAttributeDescriptor[] pkattrs = type.getPrimaryKey();
            if (featureSelection.getSize() > 0L) {
                features = this.getFeatureSelection();
            } else if (pkattrs != null && pkattrs.length > 0) {
                FeatureQuery query = this.createFeatureQuery();
                for (FeatureAttributeDescriptor pkattr : pkattrs) {
                    query.getOrder().add(pkattr.getName(), true);
                }
                features = this.getFeatureSet(query);
            } else {
                features = this.getFeatureSet();
            }
            iterator = features.fastIterator();
            while (iterator.hasNext()) {
                DefaultFeature feature = (DefaultFeature)iterator.next();
                target.insert(target.createNewFeature(targetType, (Feature)feature));
            }
            target.finishEditing();
            target.dispose();
        }
        catch (Exception e) {
            try {
                throw new DataExportException((Throwable)e, params.toString());
            }
            catch (Throwable throwable) {
                this.dispose((Disposable)iterator);
                this.dispose((Disposable)features);
                this.dispose((Disposable)target);
                throw throwable;
            }
        }
        this.dispose((Disposable)iterator);
        this.dispose((Disposable)features);
        this.dispose((Disposable)target);
    }

    public void copyTo(FeatureStore target) {
        LocalTransaction trans = new LocalTransaction(this.getDataManager(), new DataTransaction[]{this.getTransaction(), ((DefaultFeatureStore)target).getTransaction()});
        boolean finishEditingAtEnd = false;
        try {
            trans.begin();
            trans.add((DataStore)this);
            trans.add((DataStore)target);
            if (!target.isEditing() && !target.isAppending()) {
                finishEditingAtEnd = true;
                target.edit(2);
            }
            this.accept(obj -> {
                Feature f_src = (Feature)obj;
                EditableFeature f_dst = target.createNewFeature(f_src);
                target.insert(f_dst);
            });
            if (finishEditingAtEnd) {
                target.finishEditing();
            }
            trans.commit();
        }
        catch (Exception ex) {
            try {
                if (finishEditingAtEnd) {
                    target.cancelEditing();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            trans.abortQuietly();
            throw new RuntimeException("Can't copy store.", ex);
        }
        finally {
            trans.closeQuietly();
        }
    }

    public DataSet getDataSet() throws DataException {
        return this.getFeatureSet((FeatureQuery)null);
    }

    public DataSet getDataSet(DataQuery dataQuery) throws DataException {
        return this.getFeatureSet((FeatureQuery)dataQuery);
    }

    public void getDataSet(Observer observer) throws DataException {
        this.checkNotInAppendMode();
        this.getFeatureSet(null, observer);
    }

    public void getDataSet(DataQuery dataQuery, Observer observer) throws DataException {
        this.checkNotInAppendMode();
        this.getFeatureSet((FeatureQuery)dataQuery, observer);
    }

    public FeatureSet getFeatureSet() throws DataException {
        return this.getFeatureSet((FeatureQuery)null);
    }

    public FeatureSet getFeatureSet(FeatureQuery featureQuery) throws DataException {
        this.checkNotInAppendMode();
        if (featureQuery == null) {
            featureQuery = new DefaultFeatureQuery(this.getDefaultFeatureType());
        } else if (featureQuery.hasAggregateFunctions() || featureQuery.hasGroupByColumns()) {
            if (this.mode == 2) {
                throw new UnsupportedCreationOfFeatureSetWithChangesException("Can't create a set with aggregate functions or group by columns in append mode");
            }
            if (this.mode == 1 && (this.featureManager == null || this.featureManager.getPendingChangesCount() > 0L)) {
                throw new UnsupportedCreationOfFeatureSetWithChangesException("Can't create a set with aggregate functions or group by columns with editing changes");
            }
        }
        this.addRequiredAttributes(featureQuery);
        return new DefaultFeatureSet(this, featureQuery);
    }

    public FeatureSet getFeatureSet(String filter) throws DataException {
        return this.getFeatureSet(filter, null, true);
    }

    public FeatureSet getFeatureSet(String filter, String sortBy) throws DataException {
        return this.getFeatureSet(filter, sortBy, true);
    }

    public FeatureSet getFeatureSet(Expression filter) throws DataException {
        return this.getFeatureSet(filter, null, true);
    }

    public FeatureSet getFeatureSet(Expression filter, String sortBy) throws DataException {
        return this.getFeatureSet(filter, sortBy, true);
    }

    public FeatureSet getFeatureSet(Expression filter, String sortBy, boolean asc) throws DataException {
        FeatureQuery query = this.createFeatureQuery(filter, sortBy, asc);
        return this.getFeatureSet(query);
    }

    public FeatureSet getFeatureSet(String filter, String sortBy, boolean asc) throws DataException {
        FeatureQuery query = this.createFeatureQuery(filter, sortBy, asc);
        return this.getFeatureSet(query);
    }

    public List<Feature> getFeatures(String filter) {
        return this.getFeatures(filter, null, true);
    }

    public List<Feature> getFeatures(String filter, String sortBy) {
        return this.getFeatures(filter, sortBy, true);
    }

    public List<Feature> getFeatures(String filter, String sortBy, boolean asc) {
        FeatureQuery query = this.createFeatureQuery(filter, sortBy, asc);
        return this.getFeatures(query, 0);
    }

    public List<Feature> getFeatures(Expression filter) {
        return this.getFeatures(filter, null, true);
    }

    public List<Feature> getFeatures(Expression filter, String sortBy) {
        return this.getFeatures(filter, sortBy, true);
    }

    public List<Feature> getFeatures(Expression filter, String sortBy, boolean asc) {
        FeatureQuery query = this.createFeatureQuery(filter, sortBy, asc);
        return this.getFeatures(query, 0);
    }

    public List<Feature> getFeatures(FeatureQuery query) {
        return this.getFeatures(query, 0);
    }

    public List<Feature> getFeatures(FeatureQuery query, int pageSize) {
        try {
            if (pageSize <= 0) {
                pageSize = 100;
            }
            this.addRequiredAttributes(query);
            FeaturePagingHelper pager = this.dataManager.createFeaturePagingHelper(this, query, pageSize);
            return pager.asList();
        }
        catch (BaseException ex) {
            throw new RuntimeException("Can't create the list of features.", ex);
        }
    }

    public List<Feature> getFeatures() {
        return this.getFeatures(null, 0);
    }

    public GetItemWithSizeIsEmptyAndIterator64<Feature> getFeatures64() {
        return this.getFeatures64(null, 0);
    }

    public GetItemWithSizeIsEmptyAndIterator64<Feature> getFeatures64(String filter) {
        return this.getFeatures64(filter, null, true);
    }

    public GetItemWithSizeIsEmptyAndIterator64<Feature> getFeatures64(String filter, String sortBy, boolean asc) {
        FeatureQuery query = this.createFeatureQuery(filter, sortBy, asc);
        return this.getFeatures64(query, 0);
    }

    public GetItemWithSizeIsEmptyAndIterator64<Feature> getFeatures64(FeatureQuery query, int pageSize) {
        try {
            if (pageSize <= 0) {
                pageSize = 100;
            }
            FeaturePagingHelper pager = this.dataManager.createFeaturePagingHelper(this, query, pageSize);
            return pager;
        }
        catch (BaseException ex) {
            throw new RuntimeException("Can't create the list of features.", ex);
        }
    }

    public Feature first() throws DataException {
        return this.findFirst((FeatureQuery)null);
    }

    public Feature findFirst(String filter) throws DataException {
        return this.findFirst(filter, (String)null, true);
    }

    public Feature findFirst(String filter, String sortBy) throws DataException {
        return this.findFirst(filter, sortBy, true);
    }

    public Feature findFirst(String filter, String sortBy, boolean asc) throws DataException {
        FeatureQuery query = this.createFeatureQuery(filter, sortBy, asc);
        return this.findFirst(query);
    }

    public Feature findFirst(String filter, Expression sortBy, boolean asc) throws DataException {
        FeatureQuery query = this.createFeatureQuery(filter, sortBy, asc);
        return this.findFirst(query);
    }

    public Feature findFirst(Expression filter) throws DataException {
        return this.findFirst(filter, (String)null, true);
    }

    public Feature findFirst(Expression filter, String sortBy) throws DataException {
        return this.findFirst(filter, sortBy, true);
    }

    public Feature findFirst(Expression filter, String sortBy, boolean asc) throws DataException {
        FeatureQuery query = this.createFeatureQuery(filter, sortBy, asc);
        return this.findFirst(query);
    }

    public Feature findFirst(Expression filter, Expression sortBy, boolean asc) throws DataException {
        FeatureQuery query = this.createFeatureQuery(filter, sortBy, asc);
        return this.findFirst(query);
    }

    public Feature findFirst(FeatureQuery query) throws DataException {
        query = query == null ? this.createFeatureQuery() : query.getCopy();
        query.setLimit(1L);
        MutableObject feature = new MutableObject();
        try {
            this.accept(obj -> {
                feature.setValue((Object)((Feature)obj));
                throw new VisitCanceledException();
            }, (DataQuery)query);
        }
        catch (VisitCanceledException visitCanceledException) {
        }
        catch (DataException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException("", ex);
        }
        return (Feature)feature.getValue();
    }

    public void accept(Visitor visitor) throws BaseException {
        this.accept(visitor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(Visitor visitor, DataQuery dataQuery) throws BaseException {
        FeatureSet set = this.getFeatureSet((FeatureQuery)dataQuery);
        try {
            set.accept(visitor);
        }
        finally {
            set.dispose();
        }
    }

    public FeatureType getFeatureType(FeatureQuery featureQuery) throws DataException {
        DefaultFeatureType fType = (DefaultFeatureType)this.getFeatureType(featureQuery.getFeatureTypeId());
        if (featureQuery.hasAttributeNames() || featureQuery.hasConstantsAttributeNames() || fType.hasRequiredFields()) {
            if (featureQuery.hasGroupByColumns()) {
                return fType.getSubtype(featureQuery.getAttributeNames(), featureQuery.getConstantsAttributeNames(), false);
            }
            return fType.getSubtype(featureQuery.getAttributeNames(), featureQuery.getConstantsAttributeNames());
        }
        return fType;
    }

    public void getFeatureSet(Observer observer) throws DataException {
        this.checkNotInAppendMode();
        this.getFeatureSet(null, observer);
    }

    public void getFeatureSet(FeatureQuery query, Observer observer) throws DataException {
        this.checkNotInAppendMode();
        if (query == null) {
            query = new DefaultFeatureQuery(this.getDefaultFeatureType());
        }
        class LoadInBackGround
        implements Runnable {
            private final FeatureStore store;
            private final FeatureQuery query;
            private final Observer observer;

            public LoadInBackGround(FeatureStore store, FeatureQuery query, Observer observer) {
                this.store = store;
                this.query = query;
                this.observer = observer;
            }

            void notify(FeatureStoreNotification theNotification) {
                this.observer.update((Observable)this.store, (Object)theNotification);
            }

            @Override
            public void run() {
                FeatureSet set = null;
                try {
                    set = this.store.getFeatureSet(this.query);
                    this.notify(new DefaultFeatureStoreNotification((DataStore)this.store, "Load_Finished", (DataSet)set));
                }
                catch (Exception e) {
                    this.notify(new DefaultFeatureStoreNotification((DataStore)this.store, "Load_Finished", e));
                }
                finally {
                    DefaultFeatureStore.this.dispose((Disposable)set);
                }
            }
        }
        LoadInBackGround task = new LoadInBackGround(this, query, observer);
        Thread thread = new Thread((Runnable)task, "Load Feature Set in background");
        thread.start();
    }

    public Feature getFeatureByReference(FeatureReference reference) throws DataException {
        this.checkNotInAppendMode();
        FeatureReferenceProviderServices ref = (FeatureReferenceProviderServices)reference;
        FeatureType featureType = ref.getFeatureTypeId() == null ? this.getDefaultFeatureType() : this.getFeatureType(ref.getFeatureTypeId());
        return this.getFeatureByReference(reference, featureType);
    }

    public Feature getFeatureByReference(FeatureReference reference, FeatureType featureType) throws DataException {
        DefaultFeature f;
        this.checkNotInAppendMode();
        featureType = this.fixFeatureType((DefaultFeatureType)featureType);
        if (this.mode == 1 && (f = this.featureManager.get(reference, this, featureType)) != null) {
            return f;
        }
        FeatureType sourceFeatureType = featureType;
        if (!this.transforms.isEmpty()) {
            sourceFeatureType = this.transforms.getSourceFeatureTypeFrom(featureType);
        }
        DefaultFeature feature = new DefaultFeature(this, this.provider.getFeatureProviderByReference((FeatureReferenceProviderServices)reference, sourceFeatureType));
        if (!this.transforms.isEmpty()) {
            return this.transforms.applyTransform(feature, featureType);
        }
        return feature;
    }

    private FeatureType fixFeatureType(DefaultFeatureType type) throws DataException {
        FeatureType original = this.getDefaultFeatureType();
        if (type == null || type.equals(original)) {
            return original;
        }
        if (!type.isSubtypeOf(original)) {
            Iterator iter = this.getFeatureTypes().iterator();
            boolean found = false;
            while (iter.hasNext()) {
                FeatureType tmpType = (FeatureType)iter.next();
                if (type.equals(tmpType)) {
                    return type;
                }
                if (!type.isSubtypeOf(tmpType)) continue;
                found = true;
                original = tmpType;
                break;
            }
            if (!found) {
                throw new IllegalFeatureTypeException(this.getName());
            }
        }
        if (!original.hasOID()) {
            FeatureAttributeDescriptor orgAttr;
            DefaultEditableFeatureType edOriginal = (DefaultEditableFeatureType)original.getEditable();
            Iterator<FeatureAttributeDescriptor> edOriginalIter = edOriginal.iterator();
            while (edOriginalIter.hasNext()) {
                orgAttr = edOriginalIter.next();
                if (orgAttr.isPrimaryKey()) continue;
                edOriginalIter.remove();
            }
            edOriginalIter = edOriginal.iterator();
            block2: while (edOriginalIter.hasNext()) {
                orgAttr = edOriginalIter.next();
                for (FeatureAttributeDescriptor attr : type) {
                    if (!attr.getName().equals(orgAttr.getName())) continue;
                    edOriginalIter.remove();
                    continue block2;
                }
            }
            if (edOriginal.size() > 0) {
                boolean isEditable = type instanceof DefaultEditableFeatureType;
                DefaultEditableFeatureType edType = (DefaultEditableFeatureType)original.getEditable();
                edType.clear();
                edType.addAll(type);
                edType.addAll(edOriginal);
                if (!isEditable) {
                    type = (DefaultFeatureType)edType.getNotEditableCopy();
                }
            }
        }
        return type;
    }

    private void validateFeaturesAtFinishEditing() throws ValidateFeaturesException {
        try {
            this.checkInEditingMode();
            FeatureType type = this.getDefaultFeatureTypeQuietly();
            DefaultFeatureRules rules = (DefaultFeatureRules)this.getDefaultFeatureType().getRules();
            int checks = type.isCheckFeaturesAtFinishEditing() ? 4 : 0;
            int n = checks = rules.isEmpty() ? checks : checks | 2;
            if (checks == 0) {
                return;
            }
            ChainedIterator features = new ChainedIterator(new Iterator[]{this.featureManager.getInsertedFeatures(), this.featureManager.getUpdatedFeatures()});
            while (features.hasNext()) {
                EditableFeature feature = (EditableFeature)features.next();
                rules.validate(feature, checks);
            }
        }
        catch (Exception ex) {
            throw new ValidateFeaturesException(this.getName(), (Throwable)ex);
        }
    }

    public FeatureType getDefaultFeatureType() throws DataException {
        try {
            FeatureType auxFeatureType;
            if (this.isEditing() && (auxFeatureType = this.featureTypeManager.getType(this.defaultFeatureType.getId())) != null) {
                return this.avoidEditable(auxFeatureType);
            }
            FeatureType type = this.transforms.getDefaultFeatureType();
            if (type != null) {
                return this.avoidEditable(type);
            }
            return this.avoidEditable(this.defaultFeatureType);
        }
        catch (Exception e) {
            throw new GetFeatureTypeException((Throwable)e, this.getName());
        }
    }

    public FeatureType getDefaultFeatureTypeQuietly() {
        try {
            return this.getDefaultFeatureType();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private FeatureType avoidEditable(FeatureType ft) {
        if (ft instanceof EditableFeatureType) {
            return ((EditableFeatureType)ft).getNotEditableCopy();
        }
        return ft;
    }

    public FeatureType getFeatureType(String featureTypeId) throws DataException {
        if (featureTypeId == null) {
            return this.getDefaultFeatureType();
        }
        try {
            FeatureType auxFeatureType;
            if (this.isEditing() && (auxFeatureType = this.featureTypeManager.getType(featureTypeId)) != null) {
                return auxFeatureType;
            }
            FeatureType type2 = this.transforms.getFeatureType(featureTypeId);
            if (type2 != null) {
                return type2;
            }
            for (FeatureType type2 : this.featureTypes) {
                if (!type2.getId().equals(featureTypeId)) continue;
                return type2;
            }
            return null;
        }
        catch (Exception e) {
            throw new GetFeatureTypeException((Throwable)e, this.getName());
        }
    }

    public FeatureType getProviderDefaultFeatureType() {
        return this.defaultFeatureType;
    }

    public List getFeatureTypes() throws DataException {
        try {
            List<Object> types;
            if (this.isEditing()) {
                types = new ArrayList();
                for (FeatureType type : this.featureTypes) {
                    FeatureType typeaux = this.featureTypeManager.getType(type.getId());
                    if (typeaux != null) {
                        types.add(typeaux);
                        continue;
                    }
                    types.add(type);
                }
                Iterator it = this.featureTypeManager.newsIterator();
                while (it.hasNext()) {
                    FeatureType type;
                    type = (FeatureType)it.next();
                    types.add(type);
                }
            } else {
                types = this.transforms.getFeatureTypes();
                if (types == null) {
                    types = this.featureTypes;
                }
            }
            return Collections.unmodifiableList(types);
        }
        catch (Exception e) {
            throw new GetFeatureTypeException((Throwable)e, this.getName());
        }
    }

    public List getProviderFeatureTypes() throws DataException {
        return Collections.unmodifiableList(this.featureTypes);
    }

    public Feature createFeature(FeatureProvider data) throws DataException {
        DefaultFeature feature = new DefaultFeature(this, data);
        return feature;
    }

    public Feature createFeature(FeatureProvider data, FeatureType type) throws DataException {
        throw new NotYetImplemented();
    }

    public EditableFeature createNewFeature(FeatureType type, Feature defaultValues) throws DataException {
        try {
            FeatureProvider data = this.createNewFeatureProvider(type);
            DefaultEditableFeature feature = new DefaultEditableFeature(this, data);
            feature.initializeValues(defaultValues);
            data.setNew(true);
            return feature;
        }
        catch (Exception e) {
            throw new CreateFeatureException((Throwable)e, this.getName());
        }
    }

    private FeatureProvider createNewFeatureProvider(FeatureType type) throws DataException {
        type = this.fixFeatureType((DefaultFeatureType)type);
        FeatureProvider data = this.provider.createFeatureProvider(type);
        data.setNew(true);
        if (type.hasOID() && data.getOID() == null) {
            data.setOID(this.provider.createNewOID());
        } else {
            data.setOID((Object)this.getTemporalOID());
        }
        return data;
    }

    public EditableFeature createNewFeature(FeatureType type, boolean defaultValues) throws DataException {
        try {
            FeatureProvider data = this.createNewFeatureProvider(type);
            DefaultEditableFeature feature = new DefaultEditableFeature(this, data);
            if (defaultValues) {
                feature.initializeValues();
            }
            return feature;
        }
        catch (Exception e) {
            throw new CreateFeatureException((Throwable)e, this.getName());
        }
    }

    public EditableFeature createNewFeature(boolean defaultValues) throws DataException {
        return this.createNewFeature(this.getDefaultFeatureType(), defaultValues);
    }

    public EditableFeature createNewFeature() throws DataException {
        return this.createNewFeature(this.getDefaultFeatureType(), true);
    }

    public EditableFeature createNewFeature(Feature defaultValues) throws DataException {
        FeatureType ft = this.getDefaultFeatureType();
        EditableFeature f = this.createNewFeature(ft, false);
        f.copyFrom(defaultValues);
        return f;
    }

    public EditableFeature createNewFeature(JsonObject defaultValues) throws DataException {
        FeatureType ft = this.getDefaultFeatureType();
        EditableFeature f = this.createNewFeature(ft, false);
        f.copyFrom(defaultValues);
        return f;
    }

    public EditableFeatureType createFeatureType() {
        DefaultEditableFeatureType ftype = new DefaultEditableFeatureType(this);
        return ftype;
    }

    public EditableFeatureType createFeatureType(String id) {
        DefaultEditableFeatureType ftype = new DefaultEditableFeatureType(this, id);
        return ftype;
    }

    public FeatureIndexes getIndexes() {
        return this.indexes;
    }

    public FeatureIndex createIndex(FeatureType featureType, String attributeName, String indexName) throws DataException {
        return this.createIndex(null, featureType, attributeName, indexName);
    }

    public FeatureIndex createIndex(String indexTypeName, FeatureType featureType, String attributeName, String indexName) throws DataException {
        return this.createIndex(indexTypeName, featureType, attributeName, indexName, false, null);
    }

    public FeatureIndex createIndex(FeatureType featureType, String attributeName, String indexName, Observer observer) throws DataException {
        return this.createIndex(null, featureType, attributeName, indexName, observer);
    }

    public FeatureIndex createIndex(String indexTypeName, FeatureType featureType, String attributeName, String indexName, Observer observer) throws DataException {
        return this.createIndex(indexTypeName, featureType, attributeName, indexName, true, observer);
    }

    private FeatureIndex createIndex(String indexTypeName, FeatureType featureType, String attributeName, String indexName, boolean background, Observer observer) throws DataException {
        this.checkNotInAppendMode();
        FeatureIndexProviderServices index = this.dataManager.createFeatureIndexProvider(indexTypeName, this, featureType, indexName, featureType.getAttributeDescriptor(attributeName));
        try {
            index.fill(background, observer);
        }
        catch (FeatureIndexException e) {
            throw new InitializeException(index.getName(), (Throwable)e);
        }
        ((DefaultFeatureIndexes)this.getIndexes()).addIndex(index);
        return index;
    }

    public FeatureStoreTransforms getTransforms() {
        return this.transforms;
    }

    public FeatureQuery createFeatureQuery() {
        return new DefaultFeatureQuery(this.getName());
    }

    public FeatureQuery createFeatureQuery(Expression filter, String sortBy, boolean asc) {
        FeatureQuery query = null;
        if (!ExpressionUtils.isPhraseEmpty((Expression)filter)) {
            query = this.createFeatureQuery();
            query.setFilter(filter);
        }
        if (!StringUtils.isBlank((CharSequence)sortBy)) {
            if (query == null) {
                query = this.createFeatureQuery();
            }
            if (StringUtils.containsAny((CharSequence)sortBy, (CharSequence[])new CharSequence[]{"(", ")"})) {
                throw new IllegalArgumentException("Incorrect sortBy expression");
            }
            String[] attrnames = sortBy.contains(",") ? StringUtils.split((String)sortBy, (String)",") : new String[]{sortBy};
            for (String attrname : attrnames) {
                if ((attrname = attrname.trim()).startsWith("-")) {
                    query.getOrder().add(StringUtils.unwrap((String)attrname.substring(1).trim(), (char)'\"'), false);
                    continue;
                }
                if (attrname.endsWith("-")) {
                    query.getOrder().add(StringUtils.unwrap((String)attrname.substring(0, sortBy.length() - 1).trim(), (char)'\"'), false);
                    continue;
                }
                if (attrname.startsWith("+")) {
                    query.getOrder().add(StringUtils.unwrap((String)attrname.substring(1).trim(), (char)'\"'), true);
                    continue;
                }
                if (attrname.endsWith("-")) {
                    query.getOrder().add(StringUtils.unwrap((String)attrname.substring(0, sortBy.length() - 1).trim(), (char)'\"'), true);
                    continue;
                }
                query.getOrder().add(StringUtils.unwrap((String)attrname, (char)'\"'), asc);
            }
        }
        if (query != null) {
            query.retrievesAllAttributes();
        }
        return query;
    }

    public FeatureQuery createFeatureQuery(String filter) {
        return this.createFeatureQuery(ExpressionUtils.createExpression((String)filter), (String)null, true);
    }

    public FeatureQuery createFeatureQuery(Expression filter) {
        return this.createFeatureQuery(filter, (String)null, true);
    }

    public FeatureQuery createFeatureQuery(String filter, String sortBy, boolean asc) {
        if (StringUtils.isBlank((CharSequence)filter)) {
            return this.createFeatureQuery((Expression)null, sortBy, asc);
        }
        return this.createFeatureQuery(ExpressionUtils.createExpression((String)filter), sortBy, asc);
    }

    public FeatureQuery createFeatureQuery(Expression filter, Expression sortBy, boolean asc) {
        FeatureQuery query = null;
        if (filter != null) {
            query = this.createFeatureQuery();
            query.setFilter(filter);
        }
        if (sortBy != null) {
            if (query == null) {
                query = this.createFeatureQuery();
            }
            query.getOrder().add(sortBy, asc);
        }
        if (query != null) {
            query.retrievesAllAttributes();
        }
        return query;
    }

    public FeatureQuery createFeatureQuery(String filter, Expression sortBy, boolean asc) {
        if (StringUtils.isBlank((CharSequence)filter)) {
            return this.createFeatureQuery((Expression)null, sortBy, asc);
        }
        return this.createFeatureQuery(ExpressionUtils.createExpression((String)filter), sortBy, asc);
    }

    public DataQuery createQuery() {
        return this.createFeatureQuery();
    }

    public boolean canRedo() {
        return this.commands.canRedo();
    }

    public boolean canUndo() {
        return this.commands.canUndo();
    }

    public void redo(int num) throws RedoException {
        for (int i = 0; i < num; ++i) {
            this.redo();
        }
    }

    public void undo(int num) throws UndoException {
        for (int i = 0; i < num; ++i) {
            this.undo();
        }
    }

    public Object getMetadataID() {
        return this.provider.getSourceId();
    }

    public void delegate(DynObject dynObject) {
        this.metadata.delegate(dynObject);
    }

    public DynClass getDynClass() {
        return this.metadata.getDynClass();
    }

    public Object getDynValue(String name) throws DynFieldNotFoundException {
        try {
            if (this.transforms.hasDynValue(name)) {
                return this.transforms.getDynValue(name);
            }
            if (this.metadata.hasDynValue(name)) {
                return this.metadata.getDynValue(name);
            }
            if ("ProviderName".equalsIgnoreCase(name)) {
                return this.provider.getProviderName();
            }
            if ("ContainerName".equalsIgnoreCase(name)) {
                return this.provider.getSourceId();
            }
            if ("FeatureType".equalsIgnoreCase(name)) {
                try {
                    return this.getDefaultFeatureType();
                }
                catch (DataException e) {
                    return null;
                }
            }
            return this.metadata.getDynValue(name);
        }
        catch (Exception ex) {
            LOGGER.debug("Can't retrieve the value of '" + name + "' in store '" + this.getName() + "'.", (Throwable)ex);
            return null;
        }
    }

    public boolean hasDynValue(String name) {
        if (this.transforms.hasDynValue(name)) {
            return true;
        }
        if (this.provider.hasDynValue(name)) {
            return true;
        }
        if ("ProviderName".equalsIgnoreCase(name)) {
            return true;
        }
        if ("ContainerName".equalsIgnoreCase(name)) {
            return true;
        }
        if ("FeatureType".equalsIgnoreCase(name)) {
            return true;
        }
        return this.metadata.hasDynValue(name);
    }

    public boolean hasDynMethod(String name) {
        return ((DynObject_v2)this.metadata).hasDynMethod(name);
    }

    public void implement(DynClass dynClass) {
        this.metadata.implement(dynClass);
    }

    public Object invokeDynMethod(String name, Object[] args) throws DynMethodException {
        return this.metadata.invokeDynMethod((Object)this, name, args);
    }

    public Object invokeDynMethod(int code, Object[] args) throws DynMethodException {
        return this.metadata.invokeDynMethod((Object)this, code, args);
    }

    public void setDynValue(String name, Object value) throws DynFieldNotFoundException {
        if (this.transforms.hasDynValue(name)) {
            this.transforms.setDynValue(name, value);
            return;
        }
        this.metadata.setDynValue(name, value);
    }

    public Set getMetadataChildren() {
        return this.metadataChildren;
    }

    public String getMetadataName() {
        return this.provider.getProviderName();
    }

    public FeatureTypeManager getFeatureTypeManager() {
        return this.featureTypeManager;
    }

    public long getFeatureCount() throws DataException {
        if (this.featureCount == null) {
            this.featureCount = this.provider.getFeatureCount();
        }
        if (this.isEditing()) {
            if (this.isAppending()) {
                try {
                    throw new IllegalStateException();
                }
                catch (IllegalStateException e) {
                    LOGGER.info("Call DefaultFeatureStore.getFeatureCount editing in mode APPEND", (Throwable)e);
                    return -1L;
                }
            }
            return this.featureCount + this.featureManager.getDeltaSize();
        }
        return this.featureCount;
    }

    private Long getTemporalOID() {
        return this.temporalOid++;
    }

    public FeatureType getProviderFeatureType(String featureTypeId) {
        if (featureTypeId == null) {
            return this.defaultFeatureType;
        }
        for (FeatureType type : this.featureTypes) {
            if (!type.getId().equals(featureTypeId)) continue;
            return type;
        }
        return null;
    }

    public FeatureProvider getFeatureProviderFromFeature(Feature feature) {
        return ((DefaultFeature)feature).getData();
    }

    public DataStore getStore() {
        return this;
    }

    public FeatureStore getFeatureStore() {
        return this;
    }

    public void createCache(String name, DynObject parameters) throws DataException {
        this.cache = this.dataManager.createFeatureCacheProvider(name, parameters);
        if (this.cache == null) {
            throw new CreateException("FeaureCacheProvider", null);
        }
        this.cache.apply((FeatureStoreProviderServices)this, this.provider);
        this.provider = this.cache;
        this.featureCount = null;
    }

    public FeatureCache getCache() {
        return this.cache;
    }

    public void clear() {
        if (this.metadata != null) {
            this.metadata.clear();
        }
    }

    public String getName() {
        if (this.provider != null) {
            return this.provider.getName();
        }
        if (this.parameters instanceof HasAFile) {
            return FilenameUtils.getName((String)((HasAFile)this.parameters).getFile().getName());
        }
        return "unknow";
    }

    public String getFullName() {
        try {
            String fullname = null;
            if (this.provider != null) {
                fullname = this.provider.getFullName();
            }
            if (StringUtils.isBlank(fullname) && this.parameters instanceof HasAFile) {
                fullname = ((HasAFile)this.parameters).getFile().getAbsolutePath();
            }
            if (StringUtils.isBlank((CharSequence)this.fullNameForTraces)) {
                this.fullNameForTraces = fullname;
            }
            return fullname;
        }
        catch (Throwable th) {
            return null;
        }
    }

    protected String getFullNameForTraces() {
        if (StringUtils.isBlank((CharSequence)this.fullNameForTraces)) {
            return this.getFullName();
        }
        return this.fullNameForTraces;
    }

    public String getProviderName() {
        if (this.provider != null) {
            return this.provider.getProviderName();
        }
        if (this.parameters != null) {
            return this.parameters.getDataStoreName();
        }
        return null;
    }

    public boolean isKnownEnvelope() {
        return this.provider.isKnownEnvelope();
    }

    public boolean hasRetrievedFeaturesLimit() {
        return this.provider.hasRetrievedFeaturesLimit();
    }

    public int getRetrievedFeaturesLimit() {
        return this.provider.getRetrievedFeaturesLimit();
    }

    public Interval getInterval() {
        if (this.timeSupport != null) {
            return this.timeSupport.getInterval();
        }
        try {
            Interval interval;
            FeatureType type = this.getDefaultFeatureType();
            FeatureAttributeDescriptor attr = type.getDefaultTimeAttribute();
            if (attr != null && (interval = attr.getInterval()) != null) {
                return interval;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.provider == null) {
            return null;
        }
        return this.provider.getInterval();
    }

    public Collection getTimes() {
        if (this.timeSupport != null) {
            return this.timeSupport.getTimes();
        }
        return this.provider.getTimes();
    }

    public Collection getTimes(Interval interval) {
        if (this.timeSupport != null) {
            return this.timeSupport.getTimes(interval);
        }
        return this.provider.getTimes(interval);
    }

    public void setTimeSupport(FeatureStoreTimeSupport timeSupport) {
        if (this.isEditing()) {
            throw new RuntimeException("Can't add time support over attribute '" + timeSupport.getAttributeName() + "' while store is editing.");
        }
        if (!this.transforms.isEmpty()) {
            throw new RuntimeException("Can't add time support over attribute '" + timeSupport.getAttributeName() + "' if has transforms.");
        }
        FeatureType ft = this.defaultFeatureType;
        FeatureAttributeDescriptor attr = ft.getAttributeDescriptor(timeSupport.getRequiredFieldNames()[0]);
        if (attr == null) {
            throw new RuntimeException("Can't add time support over attribute '" + timeSupport.getAttributeName() + "', this attribute don't exists.");
        }
        EditableFeatureType eft = ft.getEditable();
        attr = eft.getAttributeDescriptor(timeSupport.getAttributeName());
        if (attr != null) {
            if (!(attr.getFeatureAttributeEmulator() instanceof FeatureStoreTimeSupport)) {
                throw new RuntimeException("Can't add time support, attribute '" + timeSupport.getAttributeName() + "'already exists.");
            }
            eft.remove(attr.getName());
        }
        EditableFeatureAttributeDescriptor attrTime = eft.add(timeSupport.getAttributeName(), timeSupport.getDataType());
        attrTime.setIsTime(true);
        attrTime.setFeatureAttributeEmulator((FeatureAttributeEmulator)timeSupport);
        eft.setDefaultTimeAttributeName(timeSupport.getAttributeName());
        this.defaultFeatureType = eft.getNotEditableCopy();
        this.timeSupport = timeSupport;
    }

    public Object clone() throws CloneNotSupportedException {
        DataStoreParameters dsp = this.getParameters();
        DefaultFeatureStore cloned_store = null;
        try {
            cloned_store = (DefaultFeatureStore)DALLocator.getDataManager().openStore(this.getProviderName(), dsp);
            if (this.transforms != null) {
                cloned_store.transforms = (DefaultFeatureStoreTransforms)this.transforms.clone();
                cloned_store.transforms.setStoreForClone(cloned_store);
            }
        }
        catch (Exception e) {
            throw new CloneException((Throwable)e);
        }
        return cloned_store;
    }

    public Feature getFeature(DynObject dynobject) {
        if (dynobject instanceof DynObjectFeatureFacade) {
            Feature f = ((DynObjectFeatureFacade)dynobject).getFeature();
            return f;
        }
        return null;
    }

    public Iterator iterator() {
        FeatureSet fset = null;
        try {
            fset = this.getFeatureSet();
            DisposableIterator disposableIterator = fset.fastIterator();
            return disposableIterator;
        }
        catch (DataException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)fset);
        }
    }

    public long size64() {
        FeatureSet fset = null;
        try {
            fset = this.getFeatureSet();
            long l = fset.getSize();
            return l;
        }
        catch (DataException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)fset);
        }
    }

    public ExpressionBuilder createExpressionBuilder() {
        GeometryExpressionBuilder builder = GeometryExpressionUtils.createExpressionBuilder();
        return builder;
    }

    public ExpressionBuilder createExpression() {
        return this.createExpressionBuilder();
    }

    public FeatureSet features() throws DataException {
        return this.getFeatureSet();
    }

    public DataStoreProviderFactory getProviderFactory() {
        DataStoreProviderFactory factory = this.dataManager.getStoreProviderFactory(this.parameters.getDataStoreName());
        return factory;
    }

    public void useCache(String providerName, DynObject parameters) throws DataException {
        throw new UnsupportedOperationException();
    }

    public boolean isBroken() {
        return this.state.isBroken();
    }

    public Throwable getBreakingsCause() {
        return this.state.getBreakingsCause();
    }

    public SpatialIndex wrapSpatialIndex(SpatialIndex index) {
        FeatureStoreProviderFactory factory = (FeatureStoreProviderFactory)this.getProviderFactory();
        if (!factory.supportNumericOID()) {
            return null;
        }
        WrappedSpatialIndex wrappedIndex = new WrappedSpatialIndex(index, this);
        return wrappedIndex;
    }

    public FeatureReference getFeatureReference(String code) {
        FeatureReference featureReference = FeatureReferenceFactory.createFromCode(this, code);
        return featureReference;
    }

    public long getPendingChangesCount() {
        if (this.featureManager == null) {
            return 0L;
        }
        return this.featureManager.getPendingChangesCount();
    }

    public ResourcesStorage getResourcesStorage() {
        ResourcesStorage theResourcesStorage;
        if (this.resourcesStorage != null) {
            if (this.resourcesStorage instanceof SupportTransactions && this.getTransaction() != null) {
                try {
                    this.getTransaction().add((SupportTransactions)this.resourcesStorage, false);
                }
                catch (DataException ex) {
                    LOGGER.warn("Can't get resources storage, don't add to transaction", (Throwable)ex);
                    return null;
                }
            }
            DisposeUtils.bind((Disposable)this.resourcesStorage);
            return this.resourcesStorage;
        }
        try {
            theResourcesStorage = this.provider.getResourcesStorage();
            if (theResourcesStorage != null) {
                this.resourcesStorage = theResourcesStorage;
                DisposeUtils.bind((Disposable)this.resourcesStorage);
                return theResourcesStorage;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            DataServerExplorer explorer = this.getExplorer();
            if (explorer == null) {
                return null;
            }
            theResourcesStorage = explorer.getResourcesStorage((DataStore)this);
            explorer.dispose();
            this.resourcesStorage = theResourcesStorage;
            DisposeUtils.bind((Disposable)this.resourcesStorage);
            return theResourcesStorage;
        }
        catch (Exception ex) {
            LOGGER.trace("Can't create resources storage", (Throwable)ex);
            return null;
        }
    }

    public StoresRepository getStoresRepository() {
        StoresRepository mainRepository = this.dataManager.getStoresRepository();
        StoresRepository localRepository = this.provider.getStoresRepository();
        if (localRepository == null) {
            return mainRepository;
        }
        BaseStoresRepository repository = new BaseStoresRepository(this.getName());
        repository.addRepository(localRepository);
        repository.addRepository(mainRepository);
        return repository;
    }

    public Feature getSampleFeature() {
        if (this.sampleFeatureCache == null) {
            this.sampleFeatureCache = new CachedValue<Feature>(sample_feature_cache_timeout_ms){

                protected void reload() {
                    Feature sampleFeature;
                    long t1 = System.currentTimeMillis();
                    try {
                        FeatureSelection theSelection = DefaultFeatureStore.this.getFeatureSelection();
                        sampleFeature = theSelection != null && !theSelection.isEmpty() ? theSelection.first() : DefaultFeatureStore.this.first();
                        if (sampleFeature == null) {
                            sampleFeature = DefaultFeatureStore.this.createNewFeature();
                        }
                    }
                    catch (Exception ex) {
                        sampleFeature = null;
                    }
                    long t2 = System.currentTimeMillis();
                    if (t2 - t1 > 5000L) {
                        this.setExpireTime(0x6DDD00L);
                    }
                    this.setValue(sampleFeature);
                }
            };
        }
        return (Feature)this.sampleFeatureCache.get();
    }

    public boolean supportReferences() {
        try {
            return this.getDefaultFeatureType().supportReferences();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean isTemporary() {
        if (this.temporary != null) {
            return this.temporary;
        }
        if (this.provider == null) {
            return true;
        }
        return this.provider.isTemporary();
    }

    public void setTemporary(Boolean temporary) {
        this.temporary = temporary;
    }

    public FeatureType getOriginalFeatureType(FeatureType featureType) {
        FeatureTypeManager manager = this.featureTypeManager;
        if (manager == null) {
            return null;
        }
        FeatureType originalFeatureType = manager.getOriginalFeatureType();
        if (originalFeatureType == null) {
            return null;
        }
        return originalFeatureType.getCopy();
    }

    public Object getProperty(String name) {
        if (this.propertiesSupportHelper == null) {
            return null;
        }
        return this.propertiesSupportHelper.getProperty(name);
    }

    public void setProperty(String name, Object value) {
        if (this.propertiesSupportHelper == null) {
            this.propertiesSupportHelper = new PropertiesSupportHelper();
        }
        this.propertiesSupportHelper.setProperty(name, value);
    }

    public Map<String, Object> getProperties() {
        if (this.propertiesSupportHelper == null) {
            return Collections.EMPTY_MAP;
        }
        return this.propertiesSupportHelper.getProperties();
    }

    public Feature getOriginalFeature(FeatureReference id) {
        if (this.featureManager == null) {
            return null;
        }
        return this.featureManager.getOriginal(id);
    }

    public Feature getOriginalFeature(Feature feature) {
        if (feature == null) {
            return null;
        }
        return this.getOriginalFeature(feature.getReference());
    }

    public boolean isFeatureModified(FeatureReference id) {
        if (this.featureManager == null) {
            return false;
        }
        return this.featureManager.isFeatureModified(id);
    }

    public boolean isFeatureModified(Feature feature) {
        if (feature == null) {
            return false;
        }
        return this.isFeatureModified(feature.getReference());
    }

    public void setTransaction(DataTransaction transaction) {
        DataTransaction prevTransaction = this.transactionHelper.getTransaction();
        if (prevTransaction != null) {
            prevTransaction.deleteObserver(this.transactionObserver);
        }
        this.transactionHelper.setTransaction(transaction);
        if (this.provider != null && (transaction == null || transaction instanceof DataTransactionServices)) {
            this.provider.setTransaction((DataTransactionServices)transaction);
        }
        if (transaction != null) {
            transaction.addObserver(this.transactionObserver);
        }
    }

    public DataTransaction getTransaction() {
        DataTransaction xtransaction = this.transactionHelper.getTransaction();
        return xtransaction;
    }

    public String toString() {
        try {
            ToStringBuilder builder = new ToStringBuilder((Object)this);
            builder.append("provider", this.provider == null ? null : this.provider.getProviderName());
            builder.append("fullname", (Object)this.getFullName());
            return builder.toString();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public String createUniqueID() {
        UUID x = UUID.randomUUID();
        String s = x.toString();
        return s;
    }

    public List<FeatureReference> getEditedFeatures() {
        if (this.featureManager == null) {
            return Collections.EMPTY_LIST;
        }
        List<FeatureReference> references = this.featureManager.getAddedAndUpdatedFeatures();
        if (references == null) {
            return Collections.EMPTY_LIST;
        }
        return references;
    }

    public List<FeatureReference> getEditedFeaturesNotValidated() {
        try {
            if (this.featureManager == null) {
                return Collections.EMPTY_LIST;
            }
            FeatureType type = this.getDefaultFeatureTypeQuietly();
            DefaultFeatureRules rules = (DefaultFeatureRules)this.getDefaultFeatureType().getRules();
            int checks = 12;
            if (type.isCheckFeaturesAtFinishEditing()) {
                int n = checks = rules.isEmpty() ? checks : checks | 2;
            }
            if (checks == 0) {
                return Collections.EMPTY_LIST;
            }
            List<FeatureReference> references = this.featureManager.getAddedAndUpdatedFeaturesNotValidated(rules, checks);
            if (references == null) {
                return Collections.EMPTY_LIST;
            }
            return references;
        }
        catch (DataException ex) {
            return null;
        }
    }

    public Iterator<Feature> getFeaturesIterator(Iterator<FeatureReference> references) {
        return new FeatureReferenceIteratorToFeatureIterator(this, references);
    }

    public Iterable<Feature> getFeaturesIterable(Iterator<FeatureReference> references) {
        return () -> new FeatureReferenceIteratorToFeatureIterator(this, references);
    }

    public boolean isFeatureSelectionAvailable() {
        try {
            FeatureType type = this.getDefaultFeatureType();
            return type.supportReferences();
        }
        catch (DataException ex) {
            return false;
        }
    }

    public boolean canBeEdited() {
        return this.transforms.isEmpty();
    }

    public String getLabel() {
        FeatureType ft = this.getDefaultFeatureTypeQuietly();
        if (ft == null) {
            return this.getName();
        }
        String label = ft.getLabel();
        if (StringUtils.isBlank((CharSequence)label)) {
            return this.getName();
        }
        return label;
    }

    public void addRequiredAttributes(FeatureQuery fq) {
        if (this.transforms != null && !this.transforms.isEmpty()) {
            fq.retrievesAllAttributes();
        }
    }

    public Predicate<FeatureStoreNotification> setNotificationsFilter(Predicate<FeatureStoreNotification> filter) {
        Predicate<FeatureStoreNotification> x = this.notificacionsFilter;
        this.notificacionsFilter = filter;
        return x;
    }

    private boolean doesTheNotificationHaveToBeSent(FeatureStoreNotification notfication) {
        if (this.notificacionsFilter == null) {
            return true;
        }
        return !this.notificacionsFilter.test(notfication);
    }

    public boolean allowGeometry(String name, Geometry geometry) {
        FeatureStoreProvider prov = this.getProvider();
        int allow = prov.allowGeometry(name, geometry);
        switch (allow) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        FeatureAttributeDescriptor geomAttr = this.getDefaultFeatureTypeQuietly().getDefaultGeometryAttribute();
        GeometryType storeGeometryType = geomAttr.getGeomType();
        int[] storeGeometrySuperTypes = storeGeometryType.getSuperTypes();
        int storeGeomType = storeGeometryType.getType();
        int geomType = geometry.getGeometryType().getType();
        if (GeometryUtils.isSubtype((int)storeGeomType, (int)geomType) || GeometryUtils.canAggregate((int)storeGeomType, (int)geomType)) {
            return true;
        }
        for (int storeGeometrySuperType : storeGeometrySuperTypes) {
            if (!GeometryUtils.isSubtype((int)storeGeometrySuperType, (int)geomType) && !GeometryUtils.canAggregate((int)storeGeometrySuperType, (int)geomType)) continue;
            return true;
        }
        return false;
    }

    private class StateInformation
    extends HashMap<Object, Object> {
        private static final long serialVersionUID = 4109026189635185666L;
        private boolean broken;
        private Throwable breakingsCause;

        public StateInformation() {
            this.clear();
        }

        @Override
        public void clear() {
            this.broken = false;
            this.breakingsCause = null;
            super.clear();
        }

        public boolean isBroken() {
            return this.broken;
        }

        public void broken() {
            this.broken = true;
        }

        public Throwable getBreakingsCause() {
            return this.breakingsCause;
        }

        public void setBreakingsCause(Throwable cause) {
            if (this.breakingsCause == null) {
                this.breakingsCause = cause;
            }
            this.broken = true;
        }
    }
}

