/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureExtraColumns;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreTransform;
import org.gvsig.fmap.dal.feature.FeatureStoreTransforms;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.impl.DefaultEditableFeature;
import org.gvsig.fmap.dal.feature.impl.DefaultFeature;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureStore;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureType;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.dynobject.exception.DynFieldNotFoundException;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFeatureStoreTransforms
implements FeatureStoreTransforms,
Persistent {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFeatureStoreTransforms.class);
    private DefaultFeatureStore store;
    private List<FeatureStoreTransform> transforms;
    private Boolean isTramsformValues;
    private TransformTemporalList lastTransformStack;

    public DefaultFeatureStoreTransforms() {
        this.store = null;
        this.transforms = new ArrayList<FeatureStoreTransform>();
        this.isTramsformValues = false;
    }

    public DefaultFeatureStoreTransforms(DefaultFeatureStore store) {
        this.store = store;
        this.transforms = new ArrayList<FeatureStoreTransform>();
    }

    protected void checkEditingMode() {
        if (this.store == null || this.store.getMode() != 0) {
            throw new IllegalStateException();
        }
    }

    protected void notifyChangeToStore() {
        this.store.notifyChange("Transform_Change");
    }

    public FeatureStoreTransform add(FeatureStoreTransform transform) throws DataException {
        this.checkEditingMode();
        try {
            transform.setUp();
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't set up transformation.", ex);
        }
        if (transform.getDefaultFeatureType() != null) {
            if (!transform.getFeatureTypes().contains(transform.getDefaultFeatureType())) {
                throw new IllegalArgumentException();
            }
            this.transforms.add(transform);
            transform.setFeatureStore((FeatureStore)this.store);
            transform.setSourceMetadata((DynObject)this.store.metadata);
            transform.apply((FeatureStore)this.store);
            this.notifyChangeToStore();
            if ((this.isTramsformValues == null || !this.isTramsformValues.booleanValue()) && transform.isTransformsOriginalValues()) {
                this.isTramsformValues = true;
            }
        }
        return transform;
    }

    public void clear() {
        this.checkEditingMode();
        this.transforms.clear();
        this.notifyChangeToStore();
        this.isTramsformValues = Boolean.FALSE;
    }

    public FeatureStoreTransform getTransform(int index) {
        return this.transforms.get(index);
    }

    public Iterator<FeatureStoreTransform> iterator() {
        return Collections.unmodifiableList(this.transforms).iterator();
    }

    public Object remove(int index) {
        this.checkEditingMode();
        FeatureStoreTransform trans = this.transforms.remove(index);
        trans.revoke((FeatureStore)this.store);
        this.notifyChangeToStore();
        this.isTramsformValues = null;
        return trans;
    }

    public boolean remove(FeatureStoreTransform transform) {
        this.checkEditingMode();
        boolean removed = this.transforms.remove(transform);
        if (removed) {
            this.notifyChangeToStore();
        }
        this.isTramsformValues = null;
        return removed;
    }

    public int size() {
        return this.transforms.size();
    }

    public boolean isEmpty() {
        return this.transforms.isEmpty();
    }

    private TransformTemporalList getTransformTemporalList(FeatureType targetFeatureType) {
        if (this.lastTransformStack == null || this.lastTransformStack.size() != this.transforms.size() || !this.lastTransformStack.targetFType.equals(targetFeatureType)) {
            TransformTemporalList result = new TransformTemporalList();
            FeatureType nextFType = targetFeatureType;
            for (int i = this.transforms.size() - 1; i > -1; --i) {
                TransformTemporalListElement item = new TransformTemporalListElement();
                item.transform = this.transforms.get(i);
                item.targetFeatureType = nextFType;
                nextFType = item.transform.getSourceFeatureTypeFrom(item.targetFeatureType);
                result.add(item);
            }
            this.lastTransformStack = result;
        }
        return this.lastTransformStack;
    }

    public Feature applyTransform(DefaultFeature source, FeatureType targetFeatureType) throws DataException {
        if (this.transforms.isEmpty()) {
            return source;
        }
        TransformTemporalList stack = this.getTransformTemporalList(targetFeatureType);
        ListIterator iterator = stack.listIterator(stack.size());
        FeatureType tft = null;
        while (iterator.hasPrevious()) {
            TransformTemporalListElement item = (TransformTemporalListElement)iterator.previous();
            tft = item.targetFeatureType;
            if (tft instanceof EditableFeatureType) {
                tft = ((EditableFeatureType)tft).getNotEditableCopy();
            }
            FeatureProvider targetData = this.store.createDefaultFeatureProvider(tft);
            targetData.setNew(true);
            targetData.setOID(source.getData().getOID());
            DefaultEditableFeature target = new DefaultEditableFeature(this.store, targetData);
            item.transform.applyTransform((Feature)source, (EditableFeature)target);
            targetData.setNew(source.getData().isNew());
            target.setInserted(source.isInserted());
            source = (DefaultFeature)target.getNotEditableCopy();
        }
        return source;
    }

    public FeatureType getSourceFeatureTypeFrom(FeatureType targetFeatureType) {
        FeatureType tmpFType = targetFeatureType;
        for (int i = this.transforms.size() - 1; i > -1; --i) {
            FeatureStoreTransform transform = this.transforms.get(i);
            tmpFType = transform.getSourceFeatureTypeFrom(tmpFType);
        }
        List extraCols = targetFeatureType.getExtraColumns().getColumns();
        if (extraCols != null & !extraCols.isEmpty()) {
            FeatureExtraColumns tmpExtraCols = tmpFType.getExtraColumns();
            tmpExtraCols.merge(targetFeatureType.getExtraColumns());
            ((DefaultFeatureType)tmpFType).setExtraColumn(tmpExtraCols);
        }
        return tmpFType;
    }

    public FeatureType getDefaultFeatureType() throws DataException {
        if (this.transforms.isEmpty()) {
            return null;
        }
        FeatureStoreTransform transform = this.transforms.get(this.transforms.size() - 1);
        return transform.getDefaultFeatureType();
    }

    public List<FeatureType> getFeatureTypes() throws DataException {
        if (this.transforms.isEmpty()) {
            return null;
        }
        FeatureStoreTransform transform = this.transforms.get(this.transforms.size() - 1);
        return transform.getFeatureTypes();
    }

    public FeatureStore getFeatureStore() {
        return this.store;
    }

    public void setFeatureStore(FeatureStore featureStore) {
        if (this.store != null) {
            throw new IllegalStateException();
        }
        this.store = (DefaultFeatureStore)featureStore;
        Iterator<FeatureStoreTransform> iterator = this.iterator();
        while (iterator.hasNext()) {
            FeatureStoreTransform transform = iterator.next();
            transform.setFeatureStore(featureStore);
        }
    }

    public void setStoreForClone(FeatureStore featureStore) {
        this.store = (DefaultFeatureStore)featureStore;
    }

    public boolean isTransformsOriginalValues() {
        if (this.isTramsformValues == null) {
            this.isTramsformValues = false;
            Iterator<FeatureStoreTransform> iterator = this.iterator();
            while (iterator.hasNext()) {
                FeatureStoreTransform transform = iterator.next();
                if (!transform.isTransformsOriginalValues()) continue;
                this.isTramsformValues = true;
                break;
            }
        }
        return this.isTramsformValues;
    }

    public FeatureType getFeatureType(String featureTypeId) throws DataException {
        if (this.transforms.isEmpty()) {
            return null;
        }
        if (featureTypeId == null) {
            return this.getDefaultFeatureType();
        }
        for (FeatureType featureType : this.getFeatureTypes()) {
        }
        for (FeatureType fType : this.getFeatureTypes()) {
            if (!fType.getId().equals(featureTypeId)) continue;
            return fType;
        }
        return null;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("isTramsformValues", this.isTramsformValues);
        state.set("transforms", this.transforms);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.isTramsformValues = (Boolean)state.get("isTramsformValues");
        this.transforms = new ArrayList<FeatureStoreTransform>();
        List x = (List)state.get("transforms");
        this.transforms.addAll(x);
    }

    public static void registerPersistent() {
        DynStruct definition = ToolsLocator.getPersistenceManager().addDefinition(DefaultFeatureStoreTransforms.class, "DefaultFeatureStoreTransforms", "DefaultFeatureStoreTransforms Persistent definition", null, null);
        definition.addDynFieldBoolean("isTramsformValues").setMandatory(false);
        definition.addDynFieldList("transforms").setClassOfItems(FeatureStoreTransform.class).setMandatory(true);
        definition.addDynFieldObject("store").setClassOfValue(FeatureStore.class).setMandatory(false);
    }

    public Object getDynValue(String name) throws DynFieldNotFoundException {
        if (!this.transforms.isEmpty()) {
            for (int i = this.transforms.size() - 1; i >= 0; --i) {
                FeatureStoreTransform transform = this.transforms.get(i);
                if (transform == null || !transform.hasDynValue(name)) continue;
                try {
                    Object value = transform.getDynValue(name);
                    if (value != null) {
                        return value;
                    }
                    continue;
                }
                catch (Exception ex) {
                    LOGGER.warn("Cant retrieve value of '" + name + "' in transform '" + transform.getName() + "'.", (Throwable)ex);
                }
            }
        }
        return null;
    }

    public void setDynValue(String name, Object value) throws DynFieldNotFoundException {
        if (!this.transforms.isEmpty()) {
            FeatureStoreTransform transform = this.transforms.get(this.transforms.size() - 1);
            transform.setDynValue(name, value);
        }
    }

    public boolean hasDynValue(String name) {
        if (!this.transforms.isEmpty()) {
            for (int i = this.transforms.size() - 1; i >= 0; --i) {
                FeatureStoreTransform transform = this.transforms.get(i);
                if (!transform.hasDynValue(name)) continue;
                return true;
            }
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultFeatureStoreTransforms cloned = (DefaultFeatureStoreTransforms)super.clone();
        cloned.transforms = new ArrayList<FeatureStoreTransform>();
        for (FeatureStoreTransform transform : this.transforms) {
            cloned.transforms.add((FeatureStoreTransform)transform.clone());
        }
        cloned.lastTransformStack = null;
        return cloned;
    }

    private class TransformTemporalList
    extends ArrayList {
        private static final long serialVersionUID = 1677014259279944000L;
        private FeatureType targetFType;

        private TransformTemporalList() {
        }

        @Override
        public boolean add(Object arg0) {
            if (this.isEmpty()) {
                this.targetFType = ((TransformTemporalListElement)arg0).targetFeatureType;
            }
            return super.add(arg0);
        }
    }

    private class TransformTemporalListElement {
        public FeatureStoreTransform transform = null;
        public FeatureType targetFeatureType = null;

        private TransformTemporalListElement() {
        }
    }
}

