/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.fmap.dal.BaseStoresRepository;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DataTransaction;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.expressionevaluator.FeatureSymbolTable;
import org.gvsig.fmap.dal.feature.DisposableFeatureSetIterable;
import org.gvsig.fmap.dal.feature.EditableForeingKey;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.ForeingKey;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.lang.Cloneable;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultForeingKey
implements Persistent,
ForeingKey,
EditableForeingKey,
Cloneable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultForeingKey.class);
    private boolean foreingKey = false;
    private boolean closedList = false;
    private String labelFormula = null;
    private String tableName = null;
    private String codeName = null;
    private DynObjectValueItem[] availableValues;
    private boolean loadAvailableValues = true;
    private String repositoryIDOfAvailableValues = null;
    private String repositoryLabelOfAvailableValues = null;
    private boolean ensureReferentialIntegrity = false;
    private StoresRepository storesRepository = null;
    private FeatureAttributeDescriptor descriptor;
    private String fieldName = "unknown";
    private boolean canBeOptimizedByProvider = true;
    private static final String FOREINGKEY_PERSISTENCE_DEFINITION_NAME = "ForeingKey";

    public void setDescriptor(FeatureAttributeDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public String getFieldName() {
        if (this.descriptor != null) {
            return this.descriptor.getName();
        }
        return this.fieldName;
    }

    private StoresRepository getStoresRepository() {
        if (this.storesRepository == null) {
            FeatureStore store;
            this.storesRepository = this.descriptor == null ? DALLocator.getDataManager().getStoresRepository() : ((store = this.descriptor.getStore()) == null ? DALLocator.getDataManager().getStoresRepository() : store.getStoresRepository());
        }
        return this.storesRepository;
    }

    public void unbind() {
        this.getStoresRepository();
        if (this.descriptor != null) {
            this.fieldName = this.descriptor.getName();
        }
        this.descriptor = null;
    }

    public boolean isClosedList() {
        return this.closedList;
    }

    public void setClosedList(boolean selectable) {
        this.closedList = selectable;
        this.availableValues = null;
        this.loadAvailableValues = true;
    }

    public boolean isForeingKey() {
        return this.foreingKey;
    }

    public void setForeingKey(boolean foreingKey) {
        this.foreingKey = foreingKey;
        this.availableValues = null;
        this.loadAvailableValues = true;
    }

    public String getLabelFormula() {
        return this.labelFormula;
    }

    public void setLabelFormula(String labelFormula) {
        this.labelFormula = labelFormula;
        this.availableValues = null;
        this.loadAvailableValues = true;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public void setCodeName(String codeName) {
        this.codeName = codeName;
    }

    public boolean canBeOptimizedByProvider() {
        return this.canBeOptimizedByProvider;
    }

    public void setCanBeOptimizedByProvider(boolean canBeOptimizedByProvider) {
        this.canBeOptimizedByProvider = canBeOptimizedByProvider;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
        this.availableValues = null;
        this.loadAvailableValues = true;
    }

    public boolean isEmpty() {
        return !this.foreingKey && !this.closedList && StringUtils.isBlank((CharSequence)this.tableName) && StringUtils.isBlank((CharSequence)this.codeName) && StringUtils.isBlank((CharSequence)this.labelFormula);
    }

    public void clean() {
        this.foreingKey = false;
        this.closedList = false;
        this.tableName = null;
        this.codeName = null;
        this.labelFormula = null;
        this.ensureReferentialIntegrity = false;
        this.canBeOptimizedByProvider = true;
    }

    private void disposeIfLocalContext(ForeingKey.ContextForeingKey context) {
        DefaultContextForeingKey c = (DefaultContextForeingKey)context;
        c.relese();
        if (c.refs == 0) {
            context.dispose();
        }
    }

    private ForeingKey.ContextForeingKey createLocalContextIfNull(ForeingKey.ContextForeingKey context) {
        if (context == null) {
            return this.createContext();
        }
        DefaultContextForeingKey c = (DefaultContextForeingKey)context;
        c.addRef();
        return c;
    }

    public ForeingKey.ContextForeingKey createContext() {
        return new DefaultContextForeingKey(this.getStoresRepository());
    }

    public StoresRepository getStoresRepository(ForeingKey.ContextForeingKey context) {
        context = this.createLocalContextIfNull(context);
        try {
            StoresRepository storesRepository = context.getStoresRepository();
            return storesRepository;
        }
        finally {
            this.disposeIfLocalContext(context);
        }
    }

    public FeatureStore getFeatureStore(ForeingKey.ContextForeingKey context) {
        context = this.createLocalContextIfNull(context);
        try {
            FeatureStore featureStore = context.getFeatureStore();
            return featureStore;
        }
        finally {
            this.disposeIfLocalContext(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeatureType getFeatureType(ForeingKey.ContextForeingKey context) {
        FeatureStore store = (context = this.createLocalContextIfNull(context)).getFeatureStore();
        if (store == null) {
            return null;
        }
        try {
            FeatureType featureType = store.getDefaultFeatureType();
            return featureType;
        }
        catch (DataException ex) {
            FeatureType featureType = null;
            return featureType;
        }
        finally {
            this.disposeIfLocalContext(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Feature> getFeatures(ForeingKey.ContextForeingKey context) {
        FeatureStore store = (context = this.createLocalContextIfNull(context)).getFeatureStore();
        if (store == null) {
            return null;
        }
        try {
            List list = store.getFeatures();
            return list;
        }
        finally {
            this.disposeIfLocalContext(context);
        }
    }

    public Object getCode(ForeingKey.ContextForeingKey context, Feature feature) {
        return feature.get(this.codeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeatureQuery getQuery(ForeingKey.ContextForeingKey context, Object codeValue) {
        context = this.createLocalContextIfNull(context);
        try {
            ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
            FeatureStore store = context.getFeatureStore();
            FeatureQuery query = store.createFeatureQuery();
            query.setFilter(builder.eq((ExpressionBuilder.Value)builder.variable(this.codeName), (ExpressionBuilder.Value)builder.constant(codeValue)).toString());
            query.retrievesAllAttributes();
            FeatureQuery featureQuery = query;
            return featureQuery;
        }
        finally {
            this.disposeIfLocalContext(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Feature getFeature(ForeingKey.ContextForeingKey context, Object codeValue) {
        context = this.createLocalContextIfNull(context);
        try {
            Feature feature;
            FeatureStore store = context.getFeatureStore();
            if (store == null) {
                Feature feature2 = null;
                return feature2;
            }
            FeatureQuery query = this.getQuery(context, codeValue);
            Feature feature3 = feature = store.findFirst(query);
            return feature3;
        }
        catch (DataException ex) {
            Feature feature = null;
            return feature;
        }
        finally {
            this.disposeIfLocalContext(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLabel(ForeingKey.ContextForeingKey context, Object codeValue) {
        context = this.createLocalContextIfNull(context);
        try {
            Feature feature = this.getFeature(context, codeValue);
            if (feature == null) {
                String string = null;
                return string;
            }
            String string = this.getLabel(context, feature);
            return string;
        }
        finally {
            this.disposeIfLocalContext(context);
        }
    }

    public Expression getLabelExpression(ForeingKey.ContextForeingKey context) {
        context = this.createLocalContextIfNull(context);
        try {
            Expression expression = context.getLabelExpression();
            return expression;
        }
        finally {
            this.disposeIfLocalContext(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLabel(ForeingKey.ContextForeingKey context, Feature feature) {
        if (feature == null) {
            return null;
        }
        context = this.createLocalContextIfNull(context);
        try {
            Expression labelExpression = context.getLabelExpression();
            if (labelExpression == null) {
                String string = feature.toString();
                return string;
            }
            context.getFeatureSymbolTable().setFeature(feature);
            Object x = labelExpression.execute(context.getSymbolTable());
            if (x == null) {
                String string = null;
                return string;
            }
            String string = x.toString();
            return string;
        }
        finally {
            this.disposeIfLocalContext(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynObjectValueItem[] getAvailableValues(ForeingKey.ContextForeingKey context) {
        if (!this.isClosedList()) {
            return null;
        }
        StoresRepository theStoresRepository = this.getStoresRepository(this.getTableName());
        if (theStoresRepository == null) {
            LOGGER.warn("Can't get available values for field '" + this.getStoreName() + "." + this.getFieldName() + "' from table '" + this.getTableName() + "', can't locate the stores-repository.");
            return null;
        }
        if ((theStoresRepository = theStoresRepository.getRepositoryOfStore(this.getTableName())) == null) {
            LOGGER.warn("Can't get available values for field '" + this.getStoreName() + "." + this.getFieldName() + "' from table '" + this.getTableName() + "', can't locate the stores-repository from the table.");
            return null;
        }
        if (this.availableValues == null && this.loadAvailableValues || !StringUtils.equalsIgnoreCase((CharSequence)theStoresRepository.getID(), (CharSequence)this.repositoryIDOfAvailableValues) || !StringUtils.equalsIgnoreCase((CharSequence)theStoresRepository.getLabel(), (CharSequence)this.repositoryLabelOfAvailableValues)) {
            FeatureStore foreingStore = null;
            try {
                this.repositoryLabelOfAvailableValues = theStoresRepository.getLabel();
                this.repositoryIDOfAvailableValues = theStoresRepository.getID();
                foreingStore = (FeatureStore)theStoresRepository.getStore(this.getTableName());
                DataManager dataManager = DALLocator.getDataManager();
                HashMap<String, DynObjectValueItem[]> availableValuesCache = (HashMap<String, DynObjectValueItem[]>)dataManager.getProperty("FOREIGNKEY_AVAILABLE_VALUES_CACHE");
                if (availableValuesCache == null) {
                    availableValuesCache = new HashMap<String, DynObjectValueItem[]>();
                    dataManager.setProperty("FOREIGNKEY_AVAILABLE_VALUES_CACHE", availableValuesCache);
                }
                this.availableValues = (DynObjectValueItem[])availableValuesCache.get(foreingStore.getFullName());
                if (this.availableValues == null) {
                    LOGGER.info("Loading available values for field '" + this.getStoreName() + "." + this.getFieldName() + "' from table '" + this.getTableName() + "'/" + DataStore.getFullNameQuietly((DataStore)foreingStore) + ".");
                    this.availableValues = this.getAvailableValuesFromStore(foreingStore);
                    availableValuesCache.put(foreingStore.getFullName(), this.availableValues);
                }
                this.loadAvailableValues = false;
            }
            catch (Exception ex) {
                try {
                    LOGGER.warn("Can't get available values for field '" + this.getStoreName() + "." + this.getFieldName() + "' from table '" + this.getTableName() + "' (" + DataStore.getFullNameQuietly((DataStore)foreingStore) + ").", (Throwable)ex);
                    this.loadAvailableValues = false;
                }
                catch (Throwable throwable) {
                    this.loadAvailableValues = false;
                    DisposeUtils.disposeQuietly(foreingStore);
                    throw throwable;
                }
                DisposeUtils.disposeQuietly((Disposable)foreingStore);
            }
            DisposeUtils.disposeQuietly((Disposable)foreingStore);
        }
        return this.availableValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynObjectValueItem[] getAvailableValuesFromStore(FeatureStore store) {
        DisposableFeatureSetIterable set = null;
        DynObjectValueItem[] values = null;
        try {
            Expression labelExpression = this.getLabelExpression(null);
            String theCodeName = this.getCodeName();
            FeatureSymbolTable featureSymbolTable = DALLocator.getDataManager().createFeatureSymbolTable();
            MutableSymbolTable symbolTable = featureSymbolTable.createParent();
            int count = (int)store.getFeatureCount();
            if (count < 1) {
                LOGGER.warn("Can't get available values for field '" + this.getStoreName() + "." + this.getFieldName() + "' from table '" + this.getTableName() + "'(" + DataStore.getFullNameQuietly((DataStore)store) + ").");
            }
            values = new DynObjectValueItem[Math.min(count, 1000)];
            int n = 0;
            set = store.getFeatureSet().iterable();
            for (Feature feature : set) {
                Object value;
                Object code = feature.get(theCodeName);
                if (labelExpression == null) {
                    value = code;
                } else {
                    featureSymbolTable.setFeature(feature);
                    try {
                        value = labelExpression.execute((SymbolTable)symbolTable);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Can't get label from table: " + this.tableName + " with expression: " + labelExpression.getPhrase(), (Throwable)ex);
                        values = null;
                        break;
                    }
                }
                values[n++] = new DynObjectValueItem(code, Objects.toString(value, Objects.toString(code, "##ERROR##")));
                if (n < 1000) continue;
                break;
            }
        }
        catch (Exception ex) {
            try {
                LOGGER.warn("Can't get available values for field '" + this.getStoreName() + "." + this.getFieldName() + "' from table '" + this.getTableName() + "' (" + DataStore.getFullNameQuietly((DataStore)store) + ").", (Throwable)ex);
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(set);
                throw throwable;
            }
            DisposeUtils.disposeQuietly((Disposable)set);
        }
        DisposeUtils.disposeQuietly((Disposable)set);
        return values;
    }

    private String getStoreName() {
        if (this.descriptor == null) {
            return "Unknown";
        }
        if (this.descriptor.getStore() == null) {
            return "Unknown";
        }
        return this.descriptor.getStore().getName();
    }

    public String getLabelForValue(Object value) {
        DynObjectValueItem[] values = this.getAvailableValues(null);
        if (values != null) {
            for (DynObjectValueItem value1 : values) {
                if (!Objects.equals(value, value1.getValue())) continue;
                return value1.getLabel();
            }
        }
        return Objects.toString(value, "##ERROR##");
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.foreingKey = state.getBoolean("foreingKey");
        this.closedList = state.getBoolean("selectable");
        this.labelFormula = state.getString("labelFormula");
        this.codeName = state.getString("codeName");
        this.tableName = state.getString("tableName");
        this.ensureReferentialIntegrity = state.getBoolean("ensureReferentialIntegrity");
        this.canBeOptimizedByProvider = state.getBoolean("canBeOptimizedByProvider", true);
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("foreingKey", this.foreingKey);
        state.set("selectable", this.closedList);
        state.set("labelFormula", this.labelFormula);
        state.set("codeName", this.codeName);
        state.set("tableName", this.tableName);
        state.set("ensureReferentialIntegrity", this.ensureReferentialIntegrity);
        state.set("canBeOptimizedByProvider", this.canBeOptimizedByProvider);
    }

    public static void registerPersistenceDefinition() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(FOREINGKEY_PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(DefaultForeingKey.class, FOREINGKEY_PERSISTENCE_DEFINITION_NAME, "ForeingKey persistent definition", null, null);
            definition.addDynFieldBoolean("foreingKey");
            definition.addDynFieldBoolean("selectable");
            definition.addDynFieldString("LabelFormula");
            definition.addDynFieldString("codeName");
            definition.addDynFieldString("tableName");
            definition.addDynFieldBoolean("ensureReferentialIntegrity");
            definition.addDynFieldBoolean("canBeOptimizedByProvider").setMandatory(false).setDefaultFieldValue((Object)true);
        }
    }

    public ForeingKey clone() throws CloneNotSupportedException {
        DefaultForeingKey other = (DefaultForeingKey)super.clone();
        return other;
    }

    public boolean getEnsureReferentialIntegrity() {
        return this.ensureReferentialIntegrity;
    }

    public void setEnsureReferentialIntegrity(boolean ensureReferentialIntegrity) {
        this.ensureReferentialIntegrity = ensureReferentialIntegrity;
    }

    public boolean isInAvailableValues(Object valueToCheck) {
        if (this.hasAvailableValues() && this.availableValues.length > 0) {
            for (DynObjectValueItem availableValue : this.availableValues) {
                if (!Objects.equals(valueToCheck, availableValue.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasAvailableValues() {
        if (this.availableValues == null) {
            this.getAvailableValues(null);
        }
        return this.availableValues != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoresRepository getStoresRepository(String tableName) {
        DataServerExplorer explorer;
        StoresRepository repository;
        block8: {
            BaseStoresRepository baseStoresRepository;
            FeatureStore store;
            block7: {
                repository = this.getStoresRepository();
                store = null;
                if (this.descriptor != null) {
                    store = this.descriptor.getStore();
                }
                if (store == null) {
                    return repository;
                }
                explorer = null;
                DataManager dataManager = DALLocator.getDataManager();
                explorer = store.getExplorer();
                StoresRepository repo2 = dataManager.getStoresRepository().getSubrepository(explorer);
                if (repo2 == null || !repo2.contains(tableName)) break block7;
                StoresRepository storesRepository = repo2;
                DisposeUtils.disposeQuietly((Disposable)explorer);
                return storesRepository;
            }
            try {
                DataStoreParameters params = explorer.get(tableName);
                if (!explorer.exists(params)) break block8;
                String id = this.getRepositoryId(store, tableName);
                BaseStoresRepository repo3 = new BaseStoresRepository(id, null, explorer.getParameters());
                repo3.add(tableName, params);
                baseStoresRepository = repo3;
            }
            catch (Exception ex) {
                try {
                    LOGGER.info("Can't access to table '" + tableName + "' near store " + store.getFullName() + ", search in repositories.", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    DisposeUtils.disposeQuietly(explorer);
                    throw throwable;
                }
                DisposeUtils.disposeQuietly((Disposable)explorer);
            }
            DisposeUtils.disposeQuietly((Disposable)explorer);
            return baseStoresRepository;
        }
        DisposeUtils.disposeQuietly((Disposable)explorer);
        return repository;
    }

    private String getRepositoryId(FeatureStore store, String tableName) {
        String id;
        if (store == null) {
            DataManager dataManager = DALLocator.getDataManager();
            id = tableName + "-" + dataManager.createUniqueID().replace("-", "");
        } else {
            id = tableName + "-" + DigestUtils.md5Hex((String)store.getFullName());
        }
        return id;
    }

    private class DefaultContextForeingKey
    implements ForeingKey.ContextForeingKey {
        private FeatureStore featureStore = null;
        private StoresRepository storesRepository = null;
        private Expression labelExpression;
        private SymbolTable symbolTable;
        private FeatureSymbolTable featureSymbolTable;
        private DynObject contextValues;
        private int refs = 1;
        private DataTransaction transaction;

        public DefaultContextForeingKey(StoresRepository storesRepository) {
            this.storesRepository = storesRepository;
        }

        public void addRef() {
            ++this.refs;
        }

        public void relese() {
            --this.refs;
        }

        public void dispose() {
            DisposeUtils.disposeQuietly((Disposable)this.featureStore);
            DisposeUtils.disposeQuietly((Object)this.contextValues);
            DisposeUtils.disposeQuietly((Disposable)this.transaction);
            this.featureStore = null;
            this.storesRepository = null;
            this.labelExpression = null;
            this.symbolTable = null;
            this.featureSymbolTable = null;
            this.contextValues = null;
            this.transaction = null;
        }

        public StoresRepository getStoresRepository() {
            if (this.storesRepository == null) {
                this.storesRepository = DALLocator.getDataManager().getStoresRepository();
            }
            return this.storesRepository;
        }

        public FeatureStore getFeatureStore() {
            if (DisposeUtils.isNullOrDisposed((Disposable)this.featureStore)) {
                StoresRepository repository = DefaultForeingKey.this.getStoresRepository(DefaultForeingKey.this.tableName);
                this.featureStore = (FeatureStore)repository.getStore(DefaultForeingKey.this.tableName);
                if (this.transaction != null) {
                    try {
                        this.transaction.add((DataStore)this.featureStore, true);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("Can't add table '" + DefaultForeingKey.this.tableName + "' to transaction.", ex);
                    }
                }
            }
            return this.featureStore;
        }

        public Expression getLabelExpression() {
            if (this.labelExpression == null) {
                if (StringUtils.isBlank((CharSequence)DefaultForeingKey.this.labelFormula)) {
                    return null;
                }
                this.labelExpression = ExpressionUtils.createExpression((String)DefaultForeingKey.this.labelFormula);
            }
            return this.labelExpression;
        }

        public FeatureSymbolTable getFeatureSymbolTable() {
            if (this.featureSymbolTable == null) {
                DataManager dataManager = DALLocator.getDataManager();
                this.featureSymbolTable = dataManager.createFeatureSymbolTable();
                this.symbolTable = this.featureSymbolTable.createParent();
            }
            return this.featureSymbolTable;
        }

        public SymbolTable getSymbolTable() {
            if (this.symbolTable == null) {
                DataManager dataManager = DALLocator.getDataManager();
                this.featureSymbolTable = dataManager.createFeatureSymbolTable();
                this.symbolTable = this.featureSymbolTable.createParent();
            }
            return this.symbolTable;
        }

        public DynObject getContextValues() {
            return this.contextValues;
        }

        public void setContextValues(DynObject values) {
            this.contextValues = values;
        }

        public void setTransaction(DataTransaction transaction) {
            if (this.transaction != null) {
                DisposeUtils.disposeQuietly((Disposable)this.transaction);
                this.transaction = null;
            }
            this.transaction = transaction;
            DisposeUtils.bind((Disposable)this.transaction);
        }

        public DataTransaction getTransaction() {
            return this.transaction;
        }
    }
}

