/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.impl.featurereference.FeatureReferenceFactory;
import org.gvsig.fmap.dal.feature.spi.FeatureReferenceProviderServices;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.SpatialIndex;
import org.gvsig.fmap.geom.SpatialIndexFactory;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.service.Manager;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitor;

public class WrappedSpatialIndex
implements SpatialIndex {
    private final SpatialIndex index;
    private final FeatureStore store;

    public WrappedSpatialIndex(SpatialIndex index, FeatureStore store) {
        this.index = index;
        this.store = store;
    }

    public SpatialIndexFactory getFactory() {
        return this.index.getFactory();
    }

    public void open() {
        this.index.open();
    }

    public void close() {
        this.index.close();
    }

    public void query(Envelope envelope, Visitor visitor) {
        this.index.query(envelope, (Visitor)new Oid2FeatureReferenceVisitor(visitor));
    }

    public void query(Geometry geom, Visitor visitor) {
        this.index.query(geom, (Visitor)new Oid2FeatureReferenceVisitor(visitor));
    }

    public Iterator<FeatureReference> query(Envelope envelope, long limit) {
        return new Oid2FeatureReferenceIterator(this.index.query(envelope, limit));
    }

    public Iterator<FeatureReference> query(Envelope envelope) {
        return new Oid2FeatureReferenceIterator(this.index.query(envelope));
    }

    public Iterator<FeatureReference> query(Geometry geom, long limit) {
        return new Oid2FeatureReferenceIterator(this.index.query(geom, limit));
    }

    public Iterator<FeatureReference> query(Geometry geom) {
        return new Oid2FeatureReferenceIterator(this.index.query(geom));
    }

    public Iterator<FeatureReference> queryNearest(Envelope envelope, long limit) {
        return new Oid2FeatureReferenceIterator(this.index.queryNearest(envelope, limit));
    }

    public Iterator<FeatureReference> queryNearest(Envelope envelope) {
        return new Oid2FeatureReferenceIterator(this.index.queryNearest(envelope));
    }

    public Iterator<FeatureReference> queryNearest(Geometry geom, long limit) {
        return new Oid2FeatureReferenceIterator(this.index.queryNearest(geom, limit));
    }

    public Iterator<FeatureReference> queryNearest(Geometry geom) {
        return new Oid2FeatureReferenceIterator(this.index.queryNearest(geom));
    }

    public Iterator<FeatureReference> queryAll() {
        return new Oid2FeatureReferenceIterator(this.index.queryAll());
    }

    public List<FeatureReference> queryAsList(Envelope envelope) {
        return this.asList(this.query(envelope));
    }

    public List<FeatureReference> queryAsList(Geometry geom) {
        return this.asList(this.query(geom));
    }

    public List<FeatureReference> queryAllAsList() {
        return this.asList(this.queryAll());
    }

    public void insert(Envelope envelope, Object data) {
        this.index.insert(envelope, this.getOID(data));
    }

    public void insert(Geometry geom, Object data) {
        this.index.insert(geom, this.getOID(data));
    }

    public void insert(Geometry geom) {
        this.index.insert(geom);
    }

    public boolean remove(Envelope envelope, Object data) {
        return this.index.remove(envelope, this.getOID(data));
    }

    public boolean remove(Geometry geom, Object data) {
        return this.index.remove(geom, this.getOID(data));
    }

    public boolean remove(Geometry geom) {
        return this.index.remove(geom);
    }

    public void removeAll() {
        this.index.removeAll();
    }

    public long size() {
        return this.index.size();
    }

    public void flush() {
        this.index.flush();
    }

    public Manager getManager() {
        return this.index.getManager();
    }

    protected Object getOID(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof FeatureReferenceProviderServices) {
            return ((FeatureReferenceProviderServices)obj).getOID();
        }
        if (obj instanceof Feature) {
            FeatureReference f = ((Feature)obj).getReference();
            return ((FeatureReferenceProviderServices)f).getOID();
        }
        if (obj instanceof Number) {
            return obj;
        }
        throw new IllegalArgumentException("Can't get OID from object of type '" + obj.getClass().getName() + "'.");
    }

    protected List<FeatureReference> asList(Iterator it) {
        ArrayList<FeatureReference> l = new ArrayList<FeatureReference>();
        while (it.hasNext()) {
            l.add((FeatureReference)it.next());
        }
        return l;
    }

    protected class Oid2FeatureReferenceIterator
    implements Iterator<FeatureReference> {
        private final Iterator wrapedIterator;

        public Oid2FeatureReferenceIterator(Iterator wrapedIterator) {
            this.wrapedIterator = wrapedIterator;
        }

        @Override
        public boolean hasNext() {
            return this.wrapedIterator.hasNext();
        }

        @Override
        public FeatureReference next() {
            Object oid = this.wrapedIterator.next();
            FeatureReference ref = FeatureReferenceFactory.createFromOID(WrappedSpatialIndex.this.store, oid);
            return ref;
        }

        @Override
        public void remove() {
            this.wrapedIterator.remove();
        }
    }

    protected class Oid2FeatureReferenceVisitor
    implements Visitor {
        private final Visitor wrapedVisitor;

        public Oid2FeatureReferenceVisitor(Visitor wrapedVisitor) {
            this.wrapedVisitor = wrapedVisitor;
        }

        public void visit(Object oid) throws VisitCanceledException, BaseException {
            FeatureReference ref = FeatureReferenceFactory.createFromOID(WrappedSpatialIndex.this.store, oid);
            this.wrapedVisitor.visit((Object)ref);
        }
    }
}

