/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl.editing.memory;

import java.util.Iterator;
import org.gvsig.fmap.dal.exception.CloneException;
import org.gvsig.fmap.dal.exception.CreateException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureIndexes;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureStore;
import org.gvsig.fmap.dal.feature.impl.editing.memory.FeatureManager;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProvider;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.tools.logger.FilteredLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialManager {
    private static final Logger LOG = LoggerFactory.getLogger(SpatialManager.class);
    protected boolean isFullExtentDirty = true;
    private DefaultFeatureStore featureStore;
    private Envelope fullEnvelope = null;
    private boolean noSpatialData = false;

    public SpatialManager(DefaultFeatureStore featureStore) throws DataException {
        this.featureStore = featureStore;
        FeatureIndexes findexes = featureStore.getIndexes();
        FeatureType fType = this.featureStore.getDefaultFeatureType();
        if (fType.getDefaultGeometryAttributeIndex() < 0) {
            this.noSpatialData = true;
            return;
        }
        FeatureAttributeDescriptor attr = fType.getDefaultGeometryAttribute();
        this.isFullExtentDirty = true;
        if (!fType.hasOID()) {
            return;
        }
    }

    public void updateFeature(Feature feature, Feature oldFeature) {
        if (this.noSpatialData) {
            return;
        }
        try {
            if (this.fullEnvelope == null) {
                this.isFullExtentDirty = true;
            } else if (!this.isFullExtentDirty && !this.fullEnvelope.contains(feature.getDefaultEnvelope())) {
                this.isFullExtentDirty = true;
            }
        }
        catch (Throwable t) {
            this.isFullExtentDirty = true;
        }
    }

    public void insertFeature(Feature feature) {
        if (this.noSpatialData) {
            return;
        }
        try {
            if (this.fullEnvelope == null) {
                this.isFullExtentDirty = true;
            } else if (!this.isFullExtentDirty && !this.fullEnvelope.contains(feature.getDefaultEnvelope())) {
                this.isFullExtentDirty = true;
            }
        }
        catch (Throwable t) {
            this.isFullExtentDirty = true;
        }
    }

    public void deleteFeature(Feature feature) {
        if (this.noSpatialData) {
            return;
        }
    }

    public void clear() {
    }

    public Envelope getEnvelope() throws DataException {
        if (this.noSpatialData) {
            return null;
        }
        if (this.isFullExtentDirty) {
            Iterator<EditableFeature> updated;
            EditableFeature next;
            Envelope envelope = this.getProviderEnvelope();
            if (envelope == null) {
                try {
                    envelope = GeometryLocator.getGeometryManager().createEnvelope(this.featureStore.getDefaultFeatureType().getDefaultGeometryAttribute().getGeomType().getSubType());
                }
                catch (CreateEnvelopeException ex) {
                    throw new CreateException("envelope", (Throwable)ex);
                }
            }
            try {
                envelope = (Envelope)envelope.clone();
            }
            catch (Exception ex) {
                throw new CloneException((Throwable)ex);
            }
            FeatureManager featManager = this.featureStore.getFeatureManager();
            Iterator<EditableFeature> inserted = featManager.getInsertedFeatures();
            if (inserted != null) {
                FilteredLogger logger = new FilteredLogger(LOG, "SpatialManagerGetEnvelope", 10);
                while (inserted.hasNext()) {
                    next = inserted.next();
                    try {
                        envelope.add(next.getDefaultEnvelope());
                    }
                    catch (Exception e) {
                        String s = "unknown";
                        try {
                            s = next.getReference().toString();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        logger.warn("Can't add envelope from " + s + " feature", (Throwable)e);
                    }
                }
            }
            if ((updated = featManager.getUpdatedFeatures()) != null) {
                while (updated.hasNext()) {
                    next = updated.next();
                    envelope.add(next.getDefaultEnvelope());
                }
            }
            this.fullEnvelope = envelope;
            this.isFullExtentDirty = false;
        }
        return this.fullEnvelope;
    }

    private Envelope getProviderEnvelope() throws DataException {
        FeatureStoreProvider provider = this.featureStore.getProvider();
        Envelope envelope = provider.getEnvelope();
        return envelope;
    }

    private class FeatureOperation {
        static final int INSERT = 0;
        static final int DELETE = 1;
        private FeatureReference ref;
        private int operation;

        public FeatureOperation(FeatureReference fe, int op) {
            this.ref = fe;
            this.operation = op;
        }

        public FeatureReference getFeatureReference() {
            return this.ref;
        }

        public void setFeatureReference(FeatureReference ref) {
            this.ref = ref;
        }

        public int getOperation() {
            return this.operation;
        }

        public void setOperation(int operation) {
            this.operation = operation;
        }
    }
}

