/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl.featurereference;

import java.lang.ref.WeakReference;
import java.util.Base64;
import java.util.Objects;
import javax.json.JsonObject;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureStore;
import org.gvsig.fmap.dal.feature.spi.FeatureReferenceProviderServices;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class FeatureReferenceCounter
implements FeatureReferenceProviderServices,
Persistent {
    public static final String COUNTER_TYPE = "counter";
    private static long counter = -1L;
    private long oid;
    private WeakReference storeRef;
    private String featureTypeId;

    FeatureReferenceCounter(FeatureStore store) {
        this.oid = counter--;
        this.storeRef = new WeakReference<FeatureStore>(store);
        this.featureTypeId = store.getDefaultFeatureTypeQuietly().getId();
    }

    FeatureReferenceCounter(FeatureStore store, Object oid) {
        if (!(oid instanceof Number)) {
            throw new IllegalArgumentException("oid must be a number");
        }
        if (((Number)oid).longValue() >= 0L) {
            throw new IllegalArgumentException("oid must be less than zero  (" + oid + ").");
        }
        this.oid = ((Number)oid).longValue();
        this.storeRef = new WeakReference<FeatureStore>(store);
        this.featureTypeId = store.getDefaultFeatureTypeQuietly().getId();
    }

    FeatureReferenceCounter(FeatureStore store, JsonObject code) {
        this.storeRef = new WeakReference<FeatureStore>(store);
        this.featureTypeId = store.getDefaultFeatureTypeQuietly().getId();
        this.oid = (Long)Json.toObject((JsonObject)code, (String)"oid");
    }

    public FeatureReferenceCounter() {
    }

    public Object getOID() {
        return this.oid;
    }

    public String[] getKeyNames() {
        return null;
    }

    public Object getKeyValue(String name) {
        return null;
    }

    public String getFeatureTypeId() {
        return this.featureTypeId;
    }

    public Feature getFeature() throws DataException {
        return this.getStore().getFeatureByReference((FeatureReference)this);
    }

    public Feature getFeatureQuietly() {
        try {
            return this.getFeature();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Feature getFeature(FeatureType featureType) throws DataException {
        return this.getStore().getFeatureByReference((FeatureReference)this, featureType);
    }

    private DefaultFeatureStore getStore() {
        return (DefaultFeatureStore)((Object)this.storeRef.get());
    }

    public boolean isNewFeature() {
        return true;
    }

    public String getCode() {
        String s = this.toJsonBuilder().toString();
        String r = Base64.getEncoder().encodeToString(s.getBytes());
        return r;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("type", COUNTER_TYPE);
        state.set("oid", this.oid);
        state.set("store", (Persistent)this.storeRef.get());
        state.set("featureTypeId", this.featureTypeId);
        state.set("isNewFeature", this.isNewFeature());
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.oid = state.getLong("oid");
        this.storeRef = new WeakReference<Object>(state.get("store"));
        this.featureTypeId = state.getString("featureTypeId");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FeatureReferenceCounter)) {
            return false;
        }
        FeatureReferenceCounter other = (FeatureReferenceCounter)obj;
        FeatureStore otherStore = (FeatureStore)other.storeRef.get();
        FeatureStore myrStore = (FeatureStore)this.storeRef.get();
        if (otherStore == null || myrStore == null) {
            return false;
        }
        if (!myrStore.equals(otherStore)) {
            return false;
        }
        if (this.oid == other.oid) {
            return true;
        }
        return this.oid == other.oid;
    }

    public int hashCode() {
        return Long.hashCode(this.oid);
    }

    public static boolean canUse(Object oid) {
        return oid instanceof Number && ((Number)oid).longValue() < 0L;
    }

    public JsonObjectBuilder toJsonBuilder() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("type", COUNTER_TYPE);
        builder.add("oid", this.oid);
        return builder;
    }

    public String toString() {
        return Objects.toString(this.oid);
    }
}

