/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl.featurereference;

import java.lang.ref.WeakReference;
import java.util.Base64;
import java.util.Objects;
import java.util.UUID;
import javax.json.JsonObject;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureStore;
import org.gvsig.fmap.dal.feature.spi.FeatureReferenceProviderServices;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class FeatureReferenceUID
implements FeatureReferenceProviderServices,
Persistent {
    public static final String UID_TYPE = "uid";
    private String uid;
    private WeakReference storeRef;
    private String featureTypeId;

    FeatureReferenceUID(FeatureStore store) {
        this(store, (String)null);
    }

    FeatureReferenceUID(FeatureStore store, JsonObject code) {
        this(store, code.getString(UID_TYPE, null));
    }

    private FeatureReferenceUID(FeatureStore store, String uid) {
        this.storeRef = new WeakReference<FeatureStore>(store);
        this.featureTypeId = store.getDefaultFeatureTypeQuietly().getId();
        this.uid = StringUtils.isBlank((CharSequence)uid) ? this.generateUUID() : uid;
    }

    public FeatureReferenceUID() {
    }

    private String generateUUID() {
        UUID x = UUID.randomUUID();
        String s = x.toString().replace("-", "");
        return s;
    }

    public Object getOID() {
        return null;
    }

    public String[] getKeyNames() {
        return null;
    }

    public Object getKeyValue(String name) {
        return null;
    }

    public String getFeatureTypeId() {
        return this.featureTypeId;
    }

    public Feature getFeature() throws DataException {
        return this.getStore().getFeatureByReference((FeatureReference)this);
    }

    public Feature getFeatureQuietly() {
        try {
            return this.getFeature();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Feature getFeature(FeatureType featureType) throws DataException {
        return this.getStore().getFeatureByReference((FeatureReference)this, featureType);
    }

    private DefaultFeatureStore getStore() {
        return (DefaultFeatureStore)((Object)this.storeRef.get());
    }

    public boolean isNewFeature() {
        return true;
    }

    public String getCode() {
        String s = this.toJsonBuilder().toString();
        String r = Base64.getEncoder().encodeToString(s.getBytes());
        return r;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("type", UID_TYPE);
        state.set(UID_TYPE, this.uid);
        state.set("store", (Persistent)this.storeRef.get());
        state.set("featureTypeId", this.featureTypeId);
        state.set("isNewFeature", this.isNewFeature());
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.uid = state.getString("uuid");
        this.storeRef = new WeakReference<Object>(state.get("store"));
        this.featureTypeId = state.getString("featureTypeId");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FeatureReferenceUID)) {
            return false;
        }
        FeatureReferenceUID other = (FeatureReferenceUID)obj;
        FeatureStore otherStore = (FeatureStore)other.storeRef.get();
        FeatureStore myrStore = (FeatureStore)this.storeRef.get();
        if (otherStore == null || myrStore == null) {
            return false;
        }
        if (!myrStore.equals(otherStore)) {
            return false;
        }
        return StringUtils.equals((CharSequence)this.uid, (CharSequence)other.uid);
    }

    public int hashCode() {
        if (this.uid != null) {
            return this.uid.hashCode();
        }
        return -1;
    }

    public JsonObjectBuilder toJsonBuilder() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("type", UID_TYPE);
        builder.add(UID_TYPE, this.uid);
        return builder;
    }

    public String toString() {
        return Objects.toString(this.uid);
    }
}

