/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.paging.impl;

import org.gvsig.tools.paging.DefaultPagingCalculator;
import org.gvsig.tools.paging.PagingCalculator;

public class OneSubsetOneSetPagingCalculator
extends DefaultPagingCalculator {
    private final PagingCalculator.Sizeable firstSet;
    private final PagingCalculator.Sizeable secondSet;

    public OneSubsetOneSetPagingCalculator(PagingCalculator.Sizeable firstSet, PagingCalculator.Sizeable secondSet, int maxPageSize) {
        super(firstSet, maxPageSize);
        this.firstSet = firstSet;
        this.secondSet = secondSet;
    }

    public OneSubsetOneSetPagingCalculator(PagingCalculator.Sizeable firstSet, PagingCalculator.Sizeable secondSet, int maxPageSize, long currentPage) {
        super(firstSet, maxPageSize, currentPage);
        this.firstSet = firstSet;
        this.secondSet = secondSet;
    }

    public long getTotalSize() {
        return this.secondSet.getSize();
    }

    public long getFirstSetSize() {
        return this.firstSet.getSize();
    }

    public long getSecondSetSize() {
        return this.secondSet.getSize() - this.getFirstSetSize();
    }

    public long getFirstSetInitialIndex() {
        if (this.hasCurrentPageAnyValuesInFirstSet()) {
            return this.calculateFirstSetInitialIndex();
        }
        return -1L;
    }

    private long calculateFirstSetInitialIndex() {
        return this.getCurrentPage() * (long)this.getMaxPageSize();
    }

    public long getSecondSetInitialIndex() {
        if (this.hasCurrentPageAnyValuesInSecondSet()) {
            if (this.hasCurrentPageAnyValuesInFirstSet()) {
                return 0L;
            }
            return this.getInitialIndex() - this.getFirstSetSize();
        }
        return -1L;
    }

    public long getFirstSetHowMany() {
        if (this.hasCurrentPageAnyValuesInFirstSet()) {
            return this.hasCurrentPageAllValuesInFirstSet() ? (long)this.getCurrentPageSize() : this.getFirstSetSize() - this.calculateFirstSetInitialIndex();
        }
        return 0L;
    }

    public long getSecondSetHowMany() {
        if (this.hasCurrentPageAnyValuesInSecondSet()) {
            return this.getLastIndex() - this.getFirstSetSize() - this.getSecondSetInitialIndex() + 1L;
        }
        return 0L;
    }

    protected boolean hasCurrentPageAllValuesInFirstSet() {
        return this.calculateFirstSetInitialIndex() + (long)this.getCurrentPageSize() <= this.getFirstSetSize();
    }

    public boolean hasCurrentPageAnyValuesInFirstSet() {
        return this.calculateFirstSetInitialIndex() < this.getFirstSetSize();
    }

    public boolean hasCurrentPageAnyValuesInSecondSet() {
        return this.getLastIndex() >= this.getFirstSetSize();
    }
}

