/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.impl.dataprofile;

import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.feature.AbstractDataProfile;
import org.gvsig.fmap.dal.feature.DataProfile;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.swing.api.SimpleImage;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;

public class SimpleImageDataProfile
extends AbstractDataProfile {
    public SimpleImageDataProfile() {
        super("Image", SimpleImage.class);
    }

    protected Object doCreateData(Object data, Tags tags) {
        try {
            ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
            SimpleImage image = toolsSwingManager.createSimpleImage(data);
            return image;
        }
        catch (Throwable th) {
            LOGGER.debug("Can't create image", th);
            return null;
        }
    }

    protected Object doCoerce(DataType dataType, Object data, Tags tags) throws CoercionException {
        try {
            switch (dataType.getType()) {
                case 12: {
                    ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
                    SimpleImage image = toolsSwingManager.createSimpleImage(data);
                    return image.toBytearray();
                }
                case 8: {
                    ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
                    SimpleImage image = toolsSwingManager.createSimpleImage(data);
                    return image.toString();
                }
            }
        }
        catch (Throwable th) {
            LOGGER.debug("Can't coerce image", th);
        }
        return null;
    }

    public static void selfRegister() {
        DataManager dataManager = DALLocator.getDataManager();
        dataManager.registerDataProfile((DataProfile)new SimpleImageDataProfile());
    }
}

