/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.impl.expressionevaluator;

import java.util.ArrayList;
import java.util.List;
import javax.json.JsonObject;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.impl.symboltable.FeatureSymbolTableImpl;
import org.gvsig.fmap.dal.expressionevaluator.FeatureAttributeEmulatorExpression;
import org.gvsig.fmap.dal.expressionevaluator.FeatureSymbolTable;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.json.Json;
import org.gvsig.json.JsonManager;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.json.SupportToJson;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.logger.FilteredLogger;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFeatureAttributeEmulatorExpression
implements FeatureAttributeEmulatorExpression {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFeatureAttributeEmulatorExpression.class);
    private static final String EMULEFIELDEXP_PERSISTENCE_DEFINITION_NAME = "EmulatedFieldExpression";
    private String[] requiredFields = null;
    private Expression expression = null;
    private SymbolTable symbolTable = null;
    private FeatureSymbolTable featureSymbolTable = null;
    private boolean valid;
    private String errorMessage;
    private boolean enableExceptions;
    private List<String> undefinedSymbols;
    private FilteredLogger logger;

    public DefaultFeatureAttributeEmulatorExpression() {
    }

    public DefaultFeatureAttributeEmulatorExpression(FeatureType featureType, Expression expression) {
        this.expression = expression;
        this.checkVars(featureType);
        this.enableExceptions = false;
    }

    private FilteredLogger getLogger() {
        if (this.logger == null) {
            this.logger = new FilteredLogger(LOGGER, "FeatureAttributeEmulatorExpression", 10);
        }
        return this.logger;
    }

    private void checkVars(final FeatureType featureType) {
        this.valid = true;
        final ArrayList theUsedFields = new ArrayList();
        this.undefinedSymbols = new ArrayList<String>();
        try {
            Code code = this.expression.getCode();
            code.accept(new Visitor(){

                public void visit(Object obj) throws VisitCanceledException, BaseException {
                    Code code = (Code)obj;
                    if (code instanceof Code.Identifier) {
                        String name = ((Code.Identifier)code).name();
                        if (featureType.get(name) == null) {
                            DefaultFeatureAttributeEmulatorExpression.this.undefinedSymbols.add(name);
                        } else {
                            theUsedFields.add(name);
                        }
                    }
                }
            });
        }
        catch (Exception ex) {
            this.valid = false;
            this.errorMessage = ex.getMessage();
        }
        this.requiredFields = theUsedFields.toArray(new String[theUsedFields.size()]);
    }

    public List<String> getUndefinedSymbols() {
        return this.undefinedSymbols;
    }

    public boolean isEnableExceptions() {
        return this.enableExceptions;
    }

    public void setEnableExceptions(boolean enableExceptions) {
        this.enableExceptions = enableExceptions;
    }

    public SymbolTable getSymbolTable() {
        if (this.symbolTable == null || this.featureSymbolTable == null) {
            ExpressionEvaluatorManager expressionManager = ExpressionEvaluatorLocator.getManager();
            this.featureSymbolTable = new FeatureSymbolTableImpl();
            this.symbolTable = expressionManager.createSymbolTable();
            this.symbolTable.addSymbolTable((SymbolTable)this.featureSymbolTable);
        }
        return this.symbolTable;
    }

    private FeatureSymbolTable getFeatureSymbolTable() {
        if (this.featureSymbolTable == null) {
            this.getSymbolTable();
        }
        return this.featureSymbolTable;
    }

    public boolean isValid() {
        return this.valid;
    }

    public Object get(Feature feature) {
        this.getFeatureSymbolTable().setFeature(feature);
        try {
            Object result = this.expression.execute(this.getSymbolTable());
            return result;
        }
        catch (Exception ex) {
            if (this.enableExceptions) {
                throw ex;
            }
            String phrase = "unknon";
            String featureref = "unknon";
            try {
                phrase = this.expression.getPhrase();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                featureref = feature.getReference().toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.getLogger().warn("Problems evaluating expression '" + phrase + "' with feature '" + featureref + "'.", (Throwable)ex);
            return null;
        }
    }

    public void set(EditableFeature feature, Object value) {
    }

    public boolean allowSetting() {
        return false;
    }

    public String[] getRequiredFieldNames() {
        return this.requiredFields;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("fields", this.requiredFields);
        state.set("expression", (Persistent)this.expression);
        state.set("valid", this.valid);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.valid = state.getBoolean("valid");
        this.expression = (Expression)state.get("expression");
        this.requiredFields = state.getStringArray("fields");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{ (").append(StringUtils.right((String)super.toString(), (int)9)).append(")\n");
        builder.append("isValid: ").append(this.isValid()).append(",\n");
        builder.append("requiredFields: ").append(StringUtils.join((Object[])this.requiredFields)).append(",\n");
        builder.append("errorMessage: \"").append(this.errorMessage).append("\",\n");
        builder.append("expression: ").append(this.expression).append("\n");
        builder.append("}");
        return builder.toString();
    }

    private static void registerPersistenceDefinition() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(EMULEFIELDEXP_PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(DefaultFeatureAttributeEmulatorExpression.class, EMULEFIELDEXP_PERSISTENCE_DEFINITION_NAME, "EmulatedFieldExpression persistent definition", null, null);
            definition.addDynFieldObject("expression").setMandatory(true).setPersistent(true).setClassOfValue(Expression.class);
            definition.addDynFieldArray("fields").setClassOfItems(String.class).setMandatory(true).setPersistent(true);
            definition.addDynFieldBoolean("valid").setMandatory(true).setPersistent(true);
        }
    }

    public JsonObject toJson() {
        return this.toJsonBuilder().build();
    }

    public JsonObjectBuilder toJsonBuilder() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add_class((Object)this);
        builder.add("expression", (SupportToJson)this.expression);
        builder.add("fields", (Object[])this.requiredFields);
        builder.add("valid", this.valid);
        return builder;
    }

    public void fromJson(JsonObject json) {
        this.expression = (Expression)Json.toObject((JsonObject)json, (String)"expression");
        this.requiredFields = (String[])Json.toArray((JsonObject)json, (String)"fields", (Object[])new String[0]);
        this.valid = json.getBoolean("valid", true);
    }

    public static void selfRegister() {
        DefaultFeatureAttributeEmulatorExpression.registerPersistenceDefinition();
        Json.registerSerializer((JsonManager.JsonSerializer)new TheJsonSerializer());
    }

    private static class TheJsonSerializer
    implements JsonManager.JsonSerializer {
        public Class getObjectClass() {
            return DefaultFeatureAttributeEmulatorExpression.class;
        }

        public Object toObject(JsonObject json) {
            DefaultFeatureAttributeEmulatorExpression o = new DefaultFeatureAttributeEmulatorExpression();
            o.fromJson(json);
            return o;
        }

        public JsonObjectBuilder toJsonBuilder(Object value) {
            return ((SupportToJson)value).toJsonBuilder();
        }
    }
}

