/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.raster.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.BaseStoresRepository;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.DataQuery;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataSet;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DataStoreProvider;
import org.gvsig.fmap.dal.DataStoreProviderFactory;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.exception.CloneException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.feature.exception.PersistenceStoreAlreadyLoadedException;
import org.gvsig.fmap.dal.impl.DefaultDataManager;
import org.gvsig.fmap.dal.raster.BandAttributeDescriptor;
import org.gvsig.fmap.dal.raster.BandDescriptor;
import org.gvsig.fmap.dal.raster.BandQuery;
import org.gvsig.fmap.dal.raster.RasterCache;
import org.gvsig.fmap.dal.raster.RasterQuery;
import org.gvsig.fmap.dal.raster.RasterSet;
import org.gvsig.fmap.dal.raster.RasterStore;
import org.gvsig.fmap.dal.raster.RasterStoreProviderFactory;
import org.gvsig.fmap.dal.raster.exceptions.RasterQueryCloneException;
import org.gvsig.fmap.dal.raster.impl.DefaultBandAttributeDescriptor;
import org.gvsig.fmap.dal.raster.impl.DefaultBandDescriptor;
import org.gvsig.fmap.dal.raster.impl.DefaultBandQuery;
import org.gvsig.fmap.dal.raster.impl.DefaultRasterQuery;
import org.gvsig.fmap.dal.raster.impl.DefaultRasterSet;
import org.gvsig.fmap.dal.raster.impl.DefaultRasterStoreNotification;
import org.gvsig.fmap.dal.raster.impl.exceptions.AddingBandsException;
import org.gvsig.fmap.dal.raster.spi.RasterCacheStoreProvider;
import org.gvsig.fmap.dal.raster.spi.RasterStoreProvider;
import org.gvsig.fmap.dal.raster.spi.RasterStoreProviderServices;
import org.gvsig.fmap.dal.resource.Resource;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.spi.DALSPILocator;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.dal.spi.DataStoreInitializer2;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.metadata.MetadataLocator;
import org.gvsig.metadata.MetadataManager;
import org.gvsig.metadata.exceptions.MetadataException;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.Buffer;
import org.gvsig.raster.lib.buffer.api.BufferDimensions;
import org.gvsig.timesupport.Interval;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.dynobject.DelegatedDynObject;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.gvsig.tools.dynobject.DynObject_v2;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.dynobject.exception.DynFieldNotFoundException;
import org.gvsig.tools.dynobject.exception.DynMethodException;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.locator.LocatorException;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.observer.WeakReferencingObservable;
import org.gvsig.tools.observer.impl.DelegateWeakReferencingObservable;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.util.UnmodifiableBasicMap;
import org.gvsig.tools.visitor.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRasterStore
extends AbstractDisposable
implements DataStoreInitializer2,
RasterStoreProviderServices,
RasterStore,
Observer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRasterStore.class);
    private static final String PERSISTENCE_DEFINITION_NAME = "RasterStore";
    private static final String METADATA_DEFINITION_NAME = "RasterStore";
    private DataStoreParameters parameters = null;
    private RasterStoreProvider provider = null;
    private DelegatedDynObject metadata;
    private DefaultDataManager dataManager = null;
    private List<BandsFromStore> additionalBands = null;
    private DelegateWeakReferencingObservable delegateObservable = new DelegateWeakReferencingObservable((WeakReferencingObservable)this);

    public static void registerPersistenceDefinition() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition("RasterStore") == null) {
            DynStruct definition = manager.addDefinition(DefaultRasterStore.class, "RasterStore", "RasterStore Persistent definition", null, null);
            definition.addDynFieldString("dataStoreName").setMandatory(true).setPersistent(true);
            definition.addDynFieldObject("parameters").setClassOfValue(DynObject.class).setMandatory(true).setPersistent(true);
        }
    }

    public static void registerMetadataDefinition() throws MetadataException {
        MetadataManager manager = MetadataLocator.getMetadataManager();
        if (manager.getDefinition("RasterStore") == null) {
            DynStruct metadataDefinition = manager.addDefinition("RasterStore", null);
            metadataDefinition.extend(manager.getDefinition("DataProvider"));
        }
    }

    public DataManager getManager() {
        return this.dataManager;
    }

    public String getName() {
        return this.provider.getName();
    }

    public String getFullName() {
        return this.provider.getFullName();
    }

    public DataStoreParameters getParameters() {
        return this.parameters;
    }

    public String getProviderName() {
        return this.provider.getProviderName();
    }

    public void refresh() throws DataException {
        this.notifyChange("before_Refresh_DataStore");
        this.provider.refresh();
        this.notifyChange("after_Refresh_DataStore");
    }

    public DataSet getDataSet() throws DataException {
        return this.getRasterSet();
    }

    public DataSet getDataSet(DataQuery dataQuery) throws DataException {
        return this.getRasterSet((RasterQuery)dataQuery);
    }

    public void getDataSet(Observer observer) throws DataException {
        this.getRasterSet(null, observer);
    }

    public void getDataSet(DataQuery dataQuery, Observer observer) throws DataException {
        this.getRasterSet((RasterQuery)dataQuery, observer);
    }

    /*
     * WARNING - void declaration
     */
    public RasterSet getRasterSet(RasterQuery rasterQuery) throws DataException {
        try {
            List queryBands;
            if (rasterQuery != null && !(queryBands = rasterQuery.getBands()).isEmpty()) {
                RasterQuery mainRasterQuery = rasterQuery.clone();
                mainRasterQuery.clearBands();
                HashMap<RasterStore, RasterQuery> rasterQueries = new HashMap<RasterStore, RasterQuery>();
                block2: for (Object bandQuery : queryBands) {
                    int n = bandQuery.getBand();
                    if (n < this.getProvider().getBands()) {
                        mainRasterQuery.addBand((BandQuery)bandQuery);
                        continue;
                    }
                    int bandCounter = this.getProvider().getBands();
                    boolean bandFound = false;
                    if (this.additionalBands == null) continue;
                    for (BandsFromStore bandsFromStore : this.additionalBands) {
                        RasterStore store = bandsFromStore.getStore();
                        if (n < bandCounter + bandsFromStore.size()) {
                            BandQuery storeBandQuery = store.createBandQuery(bandsFromStore.get(n - bandCounter));
                            if (rasterQueries.containsKey(store)) {
                                ((RasterQuery)rasterQueries.get(store)).addBand(storeBandQuery);
                            } else {
                                RasterQuery storeRasterQuery = rasterQuery.clone();
                                storeRasterQuery.clearBands();
                                storeRasterQuery.addBand(storeBandQuery);
                                rasterQueries.put(store, storeRasterQuery);
                                bandFound = true;
                            }
                        }
                        bandCounter += bandsFromStore.size();
                        if (!bandFound) continue;
                        continue block2;
                    }
                }
                DefaultRasterSet mainRasterSet = new DefaultRasterSet(this, mainRasterQuery);
                for (Map.Entry entry : rasterQueries.entrySet()) {
                    RasterStore store = (RasterStore)entry.getKey();
                    RasterQuery query = (RasterQuery)entry.getValue();
                    RasterSet subRasterSet = store.getRasterSet(query);
                    for (Band band : subRasterSet) {
                        mainRasterSet.addBand(band);
                    }
                }
                return mainRasterSet;
            }
            DefaultRasterSet mainRasterSet = new DefaultRasterSet(this, rasterQuery);
            if (this.additionalBands != null) {
                for (BandsFromStore bandsFromStore : this.additionalBands) {
                    void var7_16;
                    RasterStore store = bandsFromStore.getStore();
                    RasterQuery subRasterQuery = store.createRasterQuery();
                    if (rasterQuery != null) {
                        subRasterQuery.setClip(rasterQuery.getClip());
                        subRasterQuery.setScale(rasterQuery.getScale());
                    }
                    subRasterQuery.setPixelSize(mainRasterSet.getDimensions().getPixelSizeX());
                    boolean bl = false;
                    while (var7_16 < bandsFromStore.size()) {
                        BandQuery bandQuery = store.createBandQuery(bandsFromStore.get((int)var7_16));
                        subRasterQuery.addBand(bandQuery);
                        ++var7_16;
                    }
                    DefaultRasterSet defaultRasterSet = new DefaultRasterSet(store, subRasterQuery);
                    if (defaultRasterSet.getColumns() != mainRasterSet.getColumns() || defaultRasterSet.getRows() != mainRasterSet.getRows()) {
                        Buffer subBuffer = defaultRasterSet.createInterpolated(mainRasterSet.getRows(), mainRasterSet.getColumns(), 1, null);
                        for (Band band : subBuffer) {
                            mainRasterSet.addBand(band);
                        }
                    } else {
                        Iterator<Band> iterator = defaultRasterSet.iterator();
                        while (iterator.hasNext()) {
                            Band band = iterator.next();
                            mainRasterSet.addBand(band);
                        }
                    }
                    DisposeUtils.disposeQuietly((Disposable)defaultRasterSet);
                }
            }
            return mainRasterSet;
        }
        catch (Exception e) {
            throw new RasterQueryCloneException((Throwable)e);
        }
    }

    public RasterSet getRasterSet() throws DataException {
        return this.getRasterSet(this.createRasterQuery());
    }

    public void getRasterSet(Observer observer) throws DataException {
        RasterSet set = this.getRasterSet();
        set.addObserver(observer);
    }

    public void getRasterSet(RasterQuery rasterQuery, Observer observer) throws DataException {
        RasterSet set = this.getRasterSet(rasterQuery);
        set.addObserver(observer);
    }

    public void accept(Visitor visitor) throws BaseException {
        RasterSet set = this.getRasterSet();
        try {
            set.accept(visitor);
        }
        finally {
            set.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(Visitor visitor, DataQuery dataQuery) throws BaseException {
        RasterSet set = this.getRasterSet((RasterQuery)dataQuery);
        try {
            set.accept(visitor);
        }
        finally {
            set.dispose();
        }
    }

    public DataSet getSelection() throws DataException {
        return null;
    }

    public void setSelection(DataSet selection) throws DataException {
    }

    public DataSet createSelection() throws DataException {
        return null;
    }

    public UnmodifiableBasicMap<String, DataStore> getChildren() {
        UnmodifiableBasicMap children = this.provider.getChildren();
        if (children == null) {
            return UnmodifiableBasicMap.EMPTY_UNMODIFIABLEBASICMAP;
        }
        return children;
    }

    public DataServerExplorer getExplorer() throws DataException, ValidateDataParametersException {
        return this.provider.getExplorer();
    }

    public DataQuery createQuery() {
        return this.createRasterQuery();
    }

    public Interval getInterval() {
        return this.provider.getInterval();
    }

    public Collection<?> getTimes() {
        return this.provider.getTimes();
    }

    public Collection<?> getTimes(Interval interval) {
        return this.provider.getTimes(interval);
    }

    public void disableNotifications() {
        this.delegateObservable.disableNotifications();
    }

    public void enableNotifications() {
        this.delegateObservable.enableNotifications();
    }

    public void beginComplexNotification() {
        this.delegateObservable.beginComplexNotification();
    }

    public void endComplexNotification() {
        this.delegateObservable.endComplexNotification();
    }

    public void addObserver(Observer observer) {
        if (this.delegateObservable != null) {
            this.delegateObservable.addObserver(observer);
        }
    }

    public void deleteObserver(Observer observer) {
        if (this.delegateObservable != null) {
            this.delegateObservable.deleteObserver(observer);
        }
    }

    public void deleteObservers() {
        this.delegateObservable.deleteObservers();
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("dataStoreName", this.getName());
        state.set("parameters", (Persistent)this.parameters);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        if (this.provider != null) {
            throw new PersistenceStoreAlreadyLoadedException(this.getName());
        }
        if (this.getManager() == null) {
            this.dataManager = (DefaultDataManager)DALLocator.getDataManager();
        }
        DataStoreParameters params = (DataStoreParameters)state.get("parameters");
        try {
            this.intialize(this.dataManager, params);
            this.setProvider((DataStoreProvider)this.provider);
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public Set<?> getMetadataChildren() throws MetadataException {
        return null;
    }

    public Object getMetadataID() throws MetadataException {
        return this.provider.getSourceId();
    }

    public String getMetadataName() throws MetadataException {
        return this.provider.getProviderName();
    }

    public DynClass getDynClass() {
        return this.metadata.getDynClass();
    }

    public void implement(DynClass dynClass) {
        this.metadata.implement(dynClass);
    }

    public void delegate(DynObject dynObject) {
        this.metadata.delegate(dynObject);
    }

    public Object getDynValue(String name) throws DynFieldNotFoundException {
        if (this.metadata.hasDynValue(name)) {
            return this.metadata.getDynValue(name);
        }
        if ("ProviderName".equalsIgnoreCase(name)) {
            return this.provider.getProviderName();
        }
        if ("ContainerName".equalsIgnoreCase(name)) {
            return this.provider.getSourceId();
        }
        return this.metadata.getDynValue(name);
    }

    public void setDynValue(String name, Object value) throws DynFieldNotFoundException {
        this.metadata.setDynValue(name, value);
    }

    public boolean hasDynValue(String name) {
        return this.metadata.hasDynValue(name);
    }

    public Object invokeDynMethod(String name, Object[] args) throws DynMethodException {
        return this.metadata.invokeDynMethod((Object)this, name, args);
    }

    public Object invokeDynMethod(int code, Object[] args) throws DynMethodException {
        return this.metadata.invokeDynMethod((Object)this, code, args);
    }

    public void clear() {
        if (this.metadata != null) {
            this.metadata.clear();
        }
    }

    public RasterQuery createRasterQuery() {
        return new DefaultRasterQuery();
    }

    public DataStore getStore() {
        return this;
    }

    public void update(Observable observable, Object notification) {
        if (observable instanceof DataSet) {
            this.notifyChange("dataset_changed");
        } else if (observable instanceof RasterStoreProvider && observable == this.provider) {
            this.notifyChange("store_provider_changed");
        }
    }

    protected void doDispose() throws BaseException {
        LOGGER.debug("Dispose DefaultRasterStore '" + this.getFullName() + "'");
        this.notifyChange("before_Dispose_DataStore");
        DisposeUtils.dispose((Disposable)this.provider);
        this.provider = null;
        this.parameters = null;
        if (this.additionalBands != null) {
            for (BandsFromStore bandsFromStore : this.additionalBands) {
                DisposeUtils.dispose((Disposable)bandsFromStore);
            }
            this.additionalBands = null;
        }
        this.notifyChange("after_Dispose_DataStore");
        if (this.delegateObservable != null) {
            this.delegateObservable.deleteObservers();
            this.delegateObservable = null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DataStoreParameters dsp = this.getParameters();
        DefaultRasterStore cloned_store = null;
        try {
            cloned_store = (DefaultRasterStore)DALLocator.getDataManager().openStore(this.getProviderName(), dsp);
            cloned_store.additionalBands = new ArrayList<BandsFromStore>(this.additionalBands);
        }
        catch (Exception e) {
            throw new CloneException((Throwable)e);
        }
        return cloned_store;
    }

    public void notifyChange(String notification) {
        if (this.delegateObservable != null) {
            this.notifyChange(new DefaultRasterStoreNotification((DataStore)this, notification));
        }
    }

    public void notifyChange(String notification, ResourceProvider data) {
        this.notifyChange(new DefaultRasterStoreNotification((DataStore)this, "resourceChange_DataStore"));
    }

    public void notifyChange(DefaultRasterStoreNotification storeNotification) {
        try {
            this.delegateObservable.notifyObservers((Object)storeNotification);
        }
        catch (Exception e) {
            LOGGER.warn("Problems notifying changes in store '" + this.getName() + "'.", (Throwable)e);
        }
    }

    public RasterStoreProvider getProvider() {
        return this.provider;
    }

    public Envelope getEnvelope() throws DataException, LocatorException, CreateEnvelopeException {
        return this.getDimensions().getEnvelope();
    }

    public List<BandDescriptor> getBandDescriptors() {
        ArrayList<BandDescriptor> bands = new ArrayList<BandDescriptor>();
        for (int i = 0; i < this.getBands(); ++i) {
            bands.add(this.getBandDescriptor(i));
        }
        return bands;
    }

    public BandDescriptor getBandDescriptor(int band) {
        int bandsCounter = this.provider.getBands();
        if (band < bandsCounter) {
            return this.provider.getBandDescriptor(band);
        }
        if (this.additionalBands != null) {
            for (BandsFromStore bandsFromStore : this.additionalBands) {
                if (band - bandsCounter < bandsFromStore.bands.size()) {
                    return bandsFromStore.getBandDescriptor(band - bandsCounter);
                }
                bandsCounter += bandsFromStore.size();
            }
        }
        return null;
    }

    public BandQuery createBandQuery(int band) {
        return new DefaultBandQuery(band, this.getBandDescriptor(band));
    }

    public int getBands() {
        int bands = this.provider.getBands();
        if (this.additionalBands != null) {
            for (BandsFromStore bandsFromStore : this.additionalBands) {
                bands += bandsFromStore.size();
            }
        }
        return bands;
    }

    public BandDescriptor createBandDescriptor(int band, List<BandAttributeDescriptor> attributes) {
        return new DefaultBandDescriptor(this, band, attributes);
    }

    public BandAttributeDescriptor createBandAttributeDescriptor(int band, String name, String description, List<Object> values, String units) {
        return new DefaultBandAttributeDescriptor(band, name, description, values, units);
    }

    public BandAttributeDescriptor createBandAttributeDescriptor(int band, String name, Object value, String description, List<Object> values, String units) {
        return new DefaultBandAttributeDescriptor(band, name, value, description, values, units);
    }

    public BandAttributeDescriptor createBandAttributeDescriptor(int band, String name, String description, List<Object> values) {
        return new DefaultBandAttributeDescriptor(band, name, description, values);
    }

    public void notifyChange(String notification, Resource resource) {
        this.notifyChange(new DefaultRasterStoreNotification((DataStore)this, "resourceChange_DataStore"));
    }

    public RasterStore getRasterStore() {
        return this;
    }

    public void useCache(String providerName, DynObject parameters) throws DataException {
        if (providerName == null) {
            throw new InitializeException("It is necessary to provide a cache name", null);
        }
        if (parameters == null) {
            throw new InitializeException("It is necessary to provide parameters to create the explorer", null);
        }
        DataManagerProviderServices manager = DALSPILocator.getDataManagerProviderServices();
        RasterStoreProviderFactory providerFactory = (RasterStoreProviderFactory)manager.getStoreProviderFactory(providerName);
        if (providerFactory == null) {
            throw new ProviderNotRegisteredException(providerName);
        }
        RasterCacheStoreProvider cache = (RasterCacheStoreProvider)providerFactory.createProvider((DataParameters)parameters, (DataStoreProviderServices)this);
        RasterQuery rasterQuery = this.createRasterQuery();
        cache.apply(this.provider, (IProjection)this.getParameters().getDynValue("CRS"), rasterQuery);
        this.provider = cache;
    }

    public RasterCache getCache() {
        if (this.provider instanceof RasterCache) {
            return (RasterCache)this.provider;
        }
        return null;
    }

    public void intialize(DataManager dataManager, DataStoreParameters parameters) throws InitializeException {
        DynObjectManager dynManager = ToolsLocator.getDynObjectManager();
        this.metadata = (DelegatedDynObject)dynManager.createDynObject("RasterStore", "metadata");
        this.dataManager = (DefaultDataManager)dataManager;
        this.parameters = parameters;
    }

    public void setProvider(DataStoreProvider provider) {
        if (this.provider != null) {
            throw new IllegalStateException("Provider already set.");
        }
        this.provider = (RasterStoreProvider)provider;
        this.delegate((DynObject)this.provider);
    }

    public void addBand(RasterStore store, int band) throws DataException {
        if (store.equals((Object)this)) {
            LOGGER.warn("Can't add bands that belong to this same store.");
            throw new IllegalArgumentException("Can't add bands that belong to this same store.");
        }
        try {
            if (!store.getEnvelope().equals(this.getEnvelope())) {
                LOGGER.warn("The envelopes are differents.");
                throw new AddingBandsException(store.getName(), this.getName(), "The envelopes are differents.", null);
            }
        }
        catch (DataException | CreateEnvelopeException | LocatorException e) {
            LOGGER.warn("Can't compare the envelopes.", e);
            throw new AddingBandsException(store.getName(), this.getName(), "Can't compare the envelopes.", e);
        }
        if (!store.getParameters().getDynValue("CRS").equals(this.getParameters().getDynValue("CRS"))) {
            throw new AddingBandsException(store.getName(), this.getName(), "The projections are differents.", null);
        }
        if (this.additionalBands == null) {
            this.additionalBands = new ArrayList<BandsFromStore>();
        }
        boolean found = false;
        for (BandsFromStore bandsFromStore : this.additionalBands) {
            if (!bandsFromStore.getStore().equals(store)) continue;
            found = true;
            if (bandsFromStore.contains(band)) {
                LOGGER.warn("The band '" + band + "' of the store '" + store.getName() + "' is already added to the additional bands.");
                break;
            }
            bandsFromStore.add(band);
            break;
        }
        if (!found) {
            BandsFromStore bandsFromStore = new BandsFromStore(store);
            bandsFromStore.add(band);
            this.additionalBands.add(bandsFromStore);
        }
    }

    public void addBands(RasterStore store, List<Integer> bands) throws DataException {
        if (store.equals((Object)this)) {
            LOGGER.warn("Can't add bands that belong to this same store.");
            throw new IllegalArgumentException("Can't add bands that belong to this same store.");
        }
        try {
            if (!store.getEnvelope().equals(this.getEnvelope())) {
                LOGGER.warn("The envelopes are differents.");
                throw new AddingBandsException(store.getName(), this.getName(), "The envelopes are differents.", null);
            }
        }
        catch (DataException | CreateEnvelopeException | LocatorException e) {
            LOGGER.warn("Can't compare the envelopes.", e);
            throw new AddingBandsException(store.getName(), this.getName(), "Can't compare the envelopes.", e);
        }
        if (!store.getParameters().getDynValue("CRS").equals(this.getParameters().getDynValue("CRS"))) {
            throw new AddingBandsException(store.getName(), this.getName(), "The projections are differents.", null);
        }
        if (this.additionalBands == null) {
            this.additionalBands = new ArrayList<BandsFromStore>();
        }
        boolean found = false;
        for (BandsFromStore bandsFromStore : this.additionalBands) {
            if (!bandsFromStore.getStore().equals(store)) continue;
            found = true;
            for (Integer band : bands) {
                bandsFromStore.add(band);
            }
        }
        if (!found) {
            BandsFromStore bandsFromStore = new BandsFromStore(store, bands);
            this.additionalBands.add(bandsFromStore);
        }
    }

    public void clearAdditionalBands() {
        if (this.additionalBands != null) {
            for (BandsFromStore bandsFromStore : this.additionalBands) {
                DisposeUtils.dispose((Disposable)bandsFromStore);
            }
        }
        this.additionalBands = null;
    }

    public void removeBand(int band) {
        BandsFromStore additionalStore;
        if (band < this.getProvider().getBands()) {
            throw new IllegalArgumentException("Can't remove bands of main store.");
        }
        int storeCounter = 0;
        for (int bandCounter = this.getProvider().getBands(); bandCounter < band; bandCounter += additionalStore.size()) {
            additionalStore = this.additionalBands.get(storeCounter);
            if (band - bandCounter >= additionalStore.size()) continue;
            additionalStore.remove(band - bandCounter);
            if (additionalStore.size() == 0) {
                DisposeUtils.disposeQuietly((Disposable)additionalStore);
                this.additionalBands.remove((Object)additionalStore);
            }
            return;
        }
    }

    public boolean isOwnBand(int band) {
        return band < this.getProvider().getBands();
    }

    public DataStoreProviderFactory getProviderFactory() {
        DataStoreProviderFactory factory = this.dataManager.getStoreProviderFactory(this.parameters.getDataStoreName());
        return factory;
    }

    public BufferDimensions getDimensions() throws InitializeException {
        return this.getProvider().getDimensions();
    }

    public boolean isTiled() {
        return this.provider.isTiled();
    }

    public boolean hasDynMethod(String name) {
        return ((DynObject_v2)this.metadata).hasDynMethod(name);
    }

    public StoresRepository getStoresRepository() {
        StoresRepository mainRepository = this.dataManager.getStoresRepository();
        StoresRepository localRepository = this.provider.getStoresRepository();
        if (localRepository == null) {
            return mainRepository;
        }
        BaseStoresRepository repository = new BaseStoresRepository(this.getName());
        repository.addRepository(localRepository);
        repository.addRepository(mainRepository);
        return repository;
    }

    public ResourcesStorage getResourcesStorage() {
        try {
            ResourcesStorage resourcesStorage = this.provider.getResourcesStorage();
            if (resourcesStorage != null) {
                return resourcesStorage;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            DataServerExplorer explorer = this.getExplorer();
            if (explorer == null) {
                return null;
            }
            return this.getExplorer().getResourcesStorage((DataStore)this);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't create resources storage", (Throwable)ex);
            return null;
        }
    }

    private static class BandsFromStore
    extends AbstractDisposable {
        RasterStore store;
        List<Integer> bands;

        public BandsFromStore(RasterStore store) {
            this.store = store;
            ToolsLocator.getDisposableManager().bind((Disposable)store);
            this.bands = new ArrayList<Integer>();
        }

        public BandsFromStore(RasterStore store, List<Integer> bands) {
            this.store = store;
            ToolsLocator.getDisposableManager().bind((Disposable)store);
            this.bands = bands;
        }

        public void add(int band) {
            if (this.bands.contains(band)) {
                throw new IllegalArgumentException("The band " + band + " is already added.");
            }
            this.bands.add(band);
        }

        public void remove(int band) {
            if (!this.bands.contains(band)) {
                throw new IllegalArgumentException("The band " + band + " isn't previously added.");
            }
            this.bands.remove(band);
        }

        public boolean contains(int band) {
            return this.bands.contains(band);
        }

        public int get(int index) {
            return this.bands.get(index);
        }

        public RasterStore getStore() {
            return this.store;
        }

        public int size() {
            return this.bands.size();
        }

        public BandDescriptor getBandDescriptor(int index) {
            return this.store.getBandDescriptor(this.bands.get(index).intValue());
        }

        protected void doDispose() throws BaseException {
            DisposeUtils.disposeQuietly((Disposable)this.store);
        }
    }
}

