/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.srs;

import javax.json.JsonObject;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.json.Json;
import org.gvsig.json.JsonManager;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.util.IsApplicable;

public class SRSJsonSerializer
implements JsonManager.JsonSerializer,
IsApplicable {
    public Class getObjectClass() {
        return IProjection.class;
    }

    public Object toObject(JsonObject json) {
        IProjection proj = CRSFactory.getCRS((String)json.getString("fullcode"));
        return proj;
    }

    public JsonObjectBuilder toJsonBuilder(Object value) {
        IProjection proj = (IProjection)value;
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add_class(IProjection.class);
        builder.add("abrev", proj.getAbrev());
        builder.add("fullcode", proj.getFullCode());
        return builder;
    }

    public boolean isApplicable(Object ... args) {
        if (args[0] instanceof IProjection) {
            return true;
        }
        if (!(args[0] instanceof JsonObject)) {
            return false;
        }
        JsonObject json = (JsonObject)args[0];
        String className = json.getString("__classname__", null);
        return StringUtils.equalsIgnoreCase((CharSequence)className, (CharSequence)IProjection.class.getName());
    }

    public static void selfRegister() {
        Json.registerSerializer((JsonManager.JsonSerializer)new SRSJsonSerializer());
    }
}

