/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.layout.FLayoutGraphics;
import org.gvsig.app.project.documents.layout.fframes.gui.dialogs.FFrameDialogNotification;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutGraphicControls
extends Extension {
    private static final Logger logger = LoggerFactory.getLogger(LayoutGraphicControls.class);
    private LayoutPanel layout = null;

    public void execute(String s) {
        this.layout = (LayoutPanel)PluginServices.getMDIManager().getActiveWindow();
        FLayoutGraphics lg = new FLayoutGraphics(this.layout);
        logger.debug("Comand : " + s);
        if (s.compareTo("layout-graphic-group") == 0) {
            this.layout.getLayoutContext().getFrameCommandsRecord().startComplex(PluginServices.getText((Object)((Object)this), (String)"group"));
            lg.grouping();
            this.layout.getLayoutContext().getFrameCommandsRecord().endComplex();
            this.layout.getDocument().setModified(true);
        } else if (s.compareTo("layout-graphic-ungroup") == 0) {
            lg.ungrouping();
            this.layout.getDocument().setModified(true);
        } else if (s.compareTo("layout-graphic-properties") == 0) {
            lg.openFrameDialog(new Observer(){

                public void update(Observable observable, Object notification) {
                    if (notification instanceof FFrameDialogNotification && ((FFrameDialogNotification)((Object)notification)).getType() == "FrameCreated") {
                        LayoutGraphicControls.this.getLayout().getDocument().setModified(true);
                    }
                }
            });
        } else if (s.compareTo("layout-graphic-align") == 0) {
            lg.aligning();
            this.layout.getDocument().setModified(true);
        } else if (s.compareTo("layout-graphic-send-back") == 0) {
            lg.behind();
            this.layout.getDocument().setModified(true);
        } else if (s.compareTo("layout-graphic-bring-to-front") == 0) {
            lg.before();
            this.layout.getDocument().setModified(true);
        } else if (s.compareTo("layout-graphic-add-border") == 0) {
            if (lg.border()) {
                this.layout.getDocument().setModified(true);
            }
        } else if (s.compareTo("layout-graphic-position") == 0) {
            lg.position();
            this.layout.getDocument().setModified(true);
        }
    }

    public boolean isVisible() {
        IWindow f = PluginServices.getMDIManager().getActiveWindow();
        if (f == null) {
            return false;
        }
        return f instanceof LayoutPanel;
    }

    public void initialize() {
        this.registerIcons();
    }

    private void registerIcons() {
        IconThemeHelper.registerIcon((String)"action", (String)"layout-graphic-group", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"layout-graphic-ungroup", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"layout-graphic-bring-to-front", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"layout-graphic-send-back", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"layout-graphic-position", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"layout-graphic-add-border", (Object)((Object)this));
    }

    public boolean isEnabled() {
        this.layout = (LayoutPanel)PluginServices.getMDIManager().getActiveWindow();
        return this.layout.getLayoutContext().isEditable();
    }

    protected LayoutPanel getLayout() {
        return this.layout;
    }
}

