/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension.reportfromlayout;

import java.awt.Dimension;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import org.apache.commons.io.IOUtils;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.extension.reportfromlayout.ExportReportToLayoutPanelView;
import org.gvsig.app.extension.reportfromlayout.ExportReportToLayoutParameters;
import org.gvsig.app.project.documents.layout.report.LayoutReportAction;
import org.gvsig.app.project.documents.layout.report.LayoutReportActionFactory;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.report.ReportAction;
import org.gvsig.fmap.dal.swing.storesrepository.StoresRepositoryController;
import org.gvsig.i18n.Messages;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.FilePickerController;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;
import org.gvsig.utils.GenericFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportReportToLayout
extends ExportReportToLayoutPanelView {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportReportToLayout.class);
    private StoresRepositoryController treeSourceController;
    private FeatureStore source;
    private Dialog dialog;
    private FilePickerController pickerFile;

    public ExportReportToLayout() {
        this.initComponents();
    }

    private void initComponents() {
        DataSwingManager dataSwingManager = DALSwingLocator.getSwingManager();
        this.translate();
        this.treeSourceController = dataSwingManager.createStoresRepositoryController(this.treeSource);
        this.treeSource.addTreeSelectionListener(e -> {
            this.doChangeSource();
            this.doUpdateComponents();
        });
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        this.pickerFile = toolsSwingManager.createFilePickerController((JTextComponent)this.txtFile, this.btnFile);
        GenericFileFilter layoutMainExtensionFilter = new GenericFileFilter(".gvslt", Messages.getText((String)"_Layout_template") + " (*" + ".gvslt" + ")");
        this.pickerFile.setFileFilter((FileFilter)layoutMainExtensionFilter);
        this.pickerFile.addChangeListener(e -> this.doUpdateComponents());
        this.cboReport.addActionListener(e -> this.doChangeReport());
        Dimension screensize = ApplicationLocator.getApplicationManager().getUIManager().getInternalSize();
        ToolsSwingUtils.ensureHeightWitdh((JComponent)this, (int)Math.max(3 * (screensize.height / 4), ToolsSwingUtils.rows2px((int)80)), (int)Math.max(2 * (screensize.width / 4), ToolsSwingUtils.cols2px((int)35)), (int)(7 * (screensize.height / 8)), (int)(3 * (screensize.width / 4)));
        SwingUtilities.invokeLater(this::doUpdateComponents);
    }

    private void translate() {
        ToolsSwingManager manager = ToolsSwingLocator.getToolsSwingManager();
        manager.translate(this.lblSource);
        manager.translate(this.lblReport);
        manager.translate(this.lblFile);
    }

    private void doChangeSource() {
        FeatureStore theSource = this.treeSourceController.getSelectedFeatureStore();
        if (theSource == null) {
            return;
        }
        if (this.source != null) {
            DisposeUtils.disposeQuietly((Disposable)this.source);
        }
        this.source = theSource;
        this.fillCboReport();
    }

    private void doUpdateComponents() {
        this.treeSourceController.setEnabled(true);
        this.cboReport.setEnabled(this.source != null);
        if (this.dialog != null) {
            boolean enabled = this.source != null && this.pickerFile.get() != null;
            this.dialog.setButtonEnabled(1, enabled);
        }
    }

    private void fillCboReport() {
        DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
        DefaultComboBoxModel<LabeledValueImpl> model = new DefaultComboBoxModel<LabeledValueImpl>();
        if (this.source == null) {
            this.cboReport.setModel(model);
            return;
        }
        List reports = dataSwingManager.getReportActions((DataStore)this.source, t -> LayoutReportActionFactory.isJsonApplicable(t));
        for (ReportAction report : reports) {
            model.addElement(new LabeledValueImpl(report.getReportLabel(), (Object)((LayoutReportAction)report)));
        }
        this.cboReport.setModel(model);
    }

    private LayoutReportAction getReportAction() {
        return (LayoutReportAction)((LabeledValue)this.cboReport.getSelectedItem()).getValue();
    }

    public void fetch(ExportReportToLayoutParameters params) {
        params.setSource(this.source);
        params.setReportAction(this.getReportAction());
        params.setFile((File)this.pickerFile.get());
    }

    public boolean doExportReportToLayout(ExportReportToLayoutParameters params) {
        FeatureStore source = params.getSource();
        LayoutReportAction report = params.getReportAction();
        File file = params.getFile();
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        if (report == null) {
            dialogs.messageDialog(i18n.getTranslation("_Report_cant_be_null"), null, "_Export_report_to_layout", 2);
            return false;
        }
        if (source == null) {
            dialogs.messageDialog(i18n.getTranslation("_Source_cant_be_null"), null, "_Export_report_to_layout", 2);
            return false;
        }
        if (file == null) {
            dialogs.messageDialog(i18n.getTranslation("_File_cant_be_null"), null, "_Export_report_to_layout", 2);
            return false;
        }
        return this.doExportReportToLayout(source, report, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doExportReportToLayout(FeatureStore store, LayoutReportAction report, File templateFile) {
        boolean bl;
        ResourcesStorage.Resource resourceLayout = null;
        FileOutputStream templateOs = null;
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        try {
            resourceLayout = report.getTemplateAsResource();
            if (!templateFile.getPath().toLowerCase().endsWith(".gvslt".toLowerCase())) {
                templateFile = new File(templateFile.getPath() + ".gvslt");
            }
            templateOs = new FileOutputStream(templateFile);
            IOUtils.copy((InputStream)resourceLayout.asInputStream(), (OutputStream)templateOs);
            bl = true;
        }
        catch (Exception ex) {
            boolean bl2;
            try {
                dialogs.messageDialog(i18n.getTranslation("_Cant_export_report_to_layout"), null, i18n.getTranslation("_Export_report_to_layout"), 2);
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(templateOs);
                IOUtils.closeQuietly((Closeable)resourceLayout);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)templateOs);
            IOUtils.closeQuietly((Closeable)resourceLayout);
            return bl2;
        }
        IOUtils.closeQuietly((OutputStream)templateOs);
        IOUtils.closeQuietly((Closeable)resourceLayout);
        return bl;
    }

    private void doChangeReport() {
        this.pickerFile.set(null);
    }

    void setDialog(Dialog dialog) {
        this.dialog = dialog;
    }
}

