/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.commands;

import java.util.ArrayList;
import java.util.BitSet;
import org.gvsig.app.project.documents.layout.fframes.FFrameGroup;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.fframes.IFFrameViewDependence;

public class FrameManager {
    private ArrayList<IFFrame> fframes = new ArrayList();
    private BitSet invalidates = new BitSet();

    public IFFrame getFFrame(int index) {
        return this.fframes.get(index);
    }

    public int getFFrameCount() {
        return this.fframes.size();
    }

    public void undoAddFFrame(int index) {
        this.doRemoveFFrame(index);
    }

    public int doAddFFrame(IFFrame frame) {
        this.fframes.add(frame);
        int index = this.fframes.size() - 1;
        this.notifyAdded(index);
        return index;
    }

    public void doAddFFrame(IFFrame frame, int index) {
        this.invalidates.set(index, false);
        this.fframes.set(index, frame);
        this.notifyAdded(index);
    }

    public void undoModifyFFrame(int index, int newIndex) {
        this.undoRemoveFFrame(index);
        this.undoAddFFrame(newIndex);
        IFFrame fant = this.fframes.get(newIndex);
        IFFrame fnew = this.fframes.get(index);
        this.refreshDependences(fant, fnew);
    }

    public int doModifyFFrame(int indexAnt, IFFrame frameNext) {
        this.doRemoveFFrame(indexAnt);
        return this.doAddFFrame(frameNext);
    }

    public void undoRemoveFFrame(int index) {
        this.invalidates.set(index, false);
        this.notifyAdded(index);
    }

    public void doRemoveFFrame(int index) {
        this.invalidates.set(index, true);
        this.notifyRemoved(index);
    }

    protected void notifyRemoved(int index) {
        IFFrame frame = this.fframes.get(index);
        frame.frameRemoved();
    }

    protected void notifyAdded(int index) {
        IFFrame frame = this.fframes.get(index);
        frame.frameAdded();
    }

    public IFFrame[] getFFrames() {
        ArrayList<IFFrame> frames = new ArrayList<IFFrame>();
        for (int i = 0; i < this.getFFrameCount(); ++i) {
            if (this.invalidates.get(i)) continue;
            frames.add(this.fframes.get(i));
        }
        IFFrame[] fframesV = frames.toArray(new IFFrame[0]);
        return fframesV;
    }

    public IFFrame[] getAllFFrames() {
        return this.fframes.toArray(new IFFrame[0]);
    }

    public IFFrame[] getAllFFrameToDepends() {
        IFFrame[] fs = this.getAllFFrames();
        return this.getFFrameToDepends(fs);
    }

    private IFFrame[] getFFrameToDepends(IFFrame[] fs) {
        ArrayList<IFFrame> result = new ArrayList<IFFrame>();
        for (int i = 0; i < fs.length; ++i) {
            result.add(fs[i]);
            if (!(fs[i] instanceof FFrameGroup)) continue;
            IFFrame[] ffs = this.getFFrameToDepends(((FFrameGroup)fs[i]).getFFrames());
            for (int j = 0; j < ffs.length; ++j) {
                result.add(ffs[j]);
            }
        }
        return result.toArray(new IFFrame[0]);
    }

    public void refreshDependences(IFFrame fant, IFFrame fnew) {
        for (int i = 0; i < this.fframes.size(); ++i) {
            if (!(this.fframes.get(i) instanceof IFFrameViewDependence)) continue;
            IFFrameViewDependence f = (IFFrameViewDependence)((Object)this.fframes.get(i));
            f.refreshDependence(fant, fnew);
        }
    }

    public void redoModifyFFrame(int index, int newIndex, IFFrame frame) {
        this.doRemoveFFrame(index);
        this.doAddFFrame(frame, newIndex);
        IFFrame fant = this.fframes.get(newIndex);
        this.refreshDependences(fant, frame);
    }

    public BitSet invalidates() {
        return this.invalidates;
    }

    public void clear() {
    }
}

