/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.fframes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.layout.Attributes;
import org.gvsig.app.project.documents.layout.FLayoutUtilities;
import org.gvsig.app.project.documents.layout.LayoutContext;
import org.gvsig.app.project.documents.layout.LayoutDocument;
import org.gvsig.app.project.documents.layout.LayoutManager;
import org.gvsig.app.project.documents.layout.fframes.AbstractFFrameViewDependence;
import org.gvsig.app.project.documents.layout.fframes.FFrameBasic;
import org.gvsig.app.project.documents.layout.fframes.FFrameGraphics;
import org.gvsig.app.project.documents.layout.fframes.FFrameGrid;
import org.gvsig.app.project.documents.layout.fframes.FFrameGridCoordinateFormat;
import org.gvsig.app.project.documents.layout.fframes.FFrameGroup;
import org.gvsig.app.project.documents.layout.fframes.FFrameLegend;
import org.gvsig.app.project.documents.layout.fframes.FFrameNorth;
import org.gvsig.app.project.documents.layout.fframes.FFrameOverView;
import org.gvsig.app.project.documents.layout.fframes.FFramePicture;
import org.gvsig.app.project.documents.layout.fframes.FFrameScaleBar;
import org.gvsig.app.project.documents.layout.fframes.FFrameSymbol;
import org.gvsig.app.project.documents.layout.fframes.FFrameTable;
import org.gvsig.app.project.documents.layout.fframes.FFrameText;
import org.gvsig.app.project.documents.layout.fframes.FFrameView;
import org.gvsig.app.project.documents.layout.fframes.FrameFactory;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.observer.ObservableHelper;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FFrame
implements IFFrame {
    public static final String PERSISTENCE_DEFINITION_NAME = "FFrame";
    private static final String BOUNDINGBOX_FIELD = "boundingBox";
    private static final String SELECTED_FIELD = "selected";
    private static final String TAG_FIELD = "tag";
    private static final String ROTATION_FIELD = "rotation";
    private static final String LEVEL_FIELD = "level";
    private static final String NUM_FIELD = "num";
    private static final String DOCUMENT_FIELD = "layoutDocument";
    private static final String LAYOUT_CONTEXT_FIELD = "layoutContext";
    protected static final Logger LOG = LoggerFactory.getLogger(FFrame.class);
    protected Rectangle2D.Double m_BoundBox = new Rectangle2D.Double();
    protected AffineTransform lastAT = new AffineTransform();
    protected int m_Selected = 0;
    protected Rectangle n = new Rectangle();
    protected Rectangle ne = new Rectangle();
    protected Rectangle e = new Rectangle();
    protected Rectangle se = new Rectangle();
    protected Rectangle s = new Rectangle();
    protected Rectangle so = new Rectangle();
    protected Rectangle o = new Rectangle();
    protected Rectangle no = new Rectangle();
    private String tag = null;
    protected int num = 0;
    private double m_rotation = 0.0;
    private int level = -1;
    private Rectangle2D lastMoveRect;
    protected FrameFactory frameFactory;
    private static Image iNEResize = null;
    public static Image iEResize = null;
    public static Image iNResize = null;
    private static Image iMove = null;
    private static Image iSEResize = null;
    protected LayoutManager layoutManager = (LayoutManager)ProjectManager.getInstance().getDocumentManager("project.document.layout");
    private LayoutContext layoutContext = null;
    private Document document = null;
    protected ObservableHelper observers = new ObservableHelper();

    @Override
    public void drawHandlers(Graphics2D g) {
        int size = 10;
        Rectangle2D.Double r = this.getBoundingBox(null);
        Point2D.Double p = new Point2D.Double();
        g.rotate(Math.toRadians(this.getRotation()), ((RectangularShape)r).getX() + ((RectangularShape)r).getWidth() / 2.0, ((RectangularShape)r).getY() + ((RectangularShape)r).getHeight() / 2.0);
        AffineTransform atRotate = new AffineTransform();
        atRotate.rotate(Math.toRadians(this.getRotation()), ((RectangularShape)r).getX() + ((RectangularShape)r).getWidth() / 2.0, ((RectangularShape)r).getY() + ((RectangularShape)r).getHeight() / 2.0);
        g.fillRect((int)((RectangularShape)r).getX() - size, (int)((RectangularShape)r).getY() - size, size, size);
        atRotate.transform(new Point2D.Double(((RectangularShape)r).getX() - (double)size, ((RectangularShape)r).getY() - (double)size), p);
        this.no.setRect((int)((Point2D)p).getX(), (int)((Point2D)p).getY(), size, size);
        g.fillRect((int)r.getMaxX(), (int)((RectangularShape)r).getY() - size, size, size);
        atRotate.transform(new Point2D.Double(r.getMaxX(), ((RectangularShape)r).getY() - (double)size), p);
        this.ne.setRect((int)((Point2D)p).getX(), (int)((Point2D)p).getY(), size, size);
        g.fillRect((int)((RectangularShape)r).getX() - size, (int)r.getMaxY(), size, size);
        atRotate.transform(new Point2D.Double(((RectangularShape)r).getX() - (double)size, r.getMaxY()), p);
        this.so.setRect((int)((Point2D)p).getX(), (int)((Point2D)p).getY(), size, size);
        g.fillRect((int)r.getMaxX(), (int)r.getMaxY(), size, size);
        atRotate.transform(new Point2D.Double(r.getMaxX(), r.getMaxY()), p);
        this.se.setRect((int)((Point2D)p).getX(), (int)((Point2D)p).getY(), size, size);
        g.fillRect((int)r.getCenterX() - size / 2, (int)((RectangularShape)r).getY() - size, size, size);
        atRotate.transform(new Point2D.Double(r.getCenterX() - (double)(size / 2), ((RectangularShape)r).getY() - (double)size), p);
        this.n.setRect((int)((Point2D)p).getX(), (int)((Point2D)p).getY(), size, size);
        g.fillRect((int)r.getCenterX() - size / 2, (int)r.getMaxY(), size, size);
        atRotate.transform(new Point2D.Double(r.getCenterX() - (double)(size / 2), r.getMaxY()), p);
        this.s.setRect((int)((Point2D)p).getX(), (int)((Point2D)p).getY(), size, size);
        g.fillRect((int)((RectangularShape)r).getX() - size, (int)r.getCenterY() - size / 2, size, size);
        atRotate.transform(new Point2D.Double(((RectangularShape)r).getX() - (double)size, r.getCenterY() - (double)(size / 2)), p);
        this.o.setRect((int)((Point2D)p).getX(), (int)((Point2D)p).getY(), size, size);
        g.fillRect((int)r.getMaxX(), (int)r.getCenterY() - size / 2, size, size);
        atRotate.transform(new Point2D.Double(r.getMaxX(), r.getCenterY() - (double)(size / 2)), p);
        this.e.setRect((int)((Point2D)p).getX(), (int)((Point2D)p).getY(), size, size);
        g.rotate(Math.toRadians(-this.getRotation()), ((RectangularShape)r).getX() + ((RectangularShape)r).getWidth() / 2.0, ((RectangularShape)r).getY() + ((RectangularShape)r).getHeight() / 2.0);
    }

    @Override
    public void setSelected(Point2D p, MouseEvent e) {
        this.doSetSelected(this.getContains(p));
    }

    @Override
    public void updateRect(Rectangle2D r, AffineTransform at) {
        Rectangle2D.Double rec = FLayoutUtilities.toSheetRect(r, at);
        rec.setRect((int)rec.getMinX(), (int)rec.getMinY(), (int)rec.getWidth(), (int)rec.getHeight());
        this.setBoundBox(rec);
    }

    @Override
    public Rectangle2D getMovieRect(int difx, int dify) {
        return this.getMovieRect(difx, dify, false);
    }

    @Override
    public Rectangle2D getMovieRect(int difx, int dify, boolean prop) {
        this.lastMoveRect = new Rectangle2D.Double(this.getBoundingBox(null).x, this.getBoundingBox(null).y, this.getBoundingBox(null).width, this.getBoundingBox(null).height);
        Rectangle2D.Double rec = this.getBoundingBox(null);
        double x = this.lastMoveRect.getX();
        double y = this.lastMoveRect.getY();
        double w = this.lastMoveRect.getWidth();
        double h = this.lastMoveRect.getHeight();
        double ratio = w / h;
        switch (this.getSelected()) {
            case 9: {
                this.lastMoveRect.setRect(x + (double)difx, y + (double)dify, w, h);
                break;
            }
            case 1: {
                y = y + (double)dify > rec.getMaxY() ? rec.getMaxY() : (y += (double)dify);
                this.lastMoveRect.setRect(x, y, w, Math.abs(h - (double)dify));
                break;
            }
            case 7: {
                x = x + (double)difx > rec.getMaxX() ? rec.getMaxX() : (x += (double)difx);
                this.lastMoveRect.setRect(x, y, Math.abs(w - (double)difx), h);
                break;
            }
            case 5: {
                if (y > rec.getMaxY() + (double)dify) {
                    y = rec.getMaxY() + (double)dify;
                }
                this.lastMoveRect.setRect(x, y, w, Math.abs(h + (double)dify));
                break;
            }
            case 3: {
                if (x > rec.getMaxX() + (double)difx) {
                    x = rec.getMaxX() + (double)difx;
                }
                this.lastMoveRect.setRect(x, y, Math.abs(w + (double)difx), h);
                break;
            }
            case 2: {
                y = y + (double)dify > rec.getMaxY() ? rec.getMaxY() : (y += (double)dify);
                if (prop) {
                    difx = -((int)((double)dify * ratio));
                }
                if (x > rec.getMaxX() + (double)difx) {
                    x = rec.getMaxX() + (double)difx;
                }
                this.lastMoveRect.setRect(x, y, Math.abs(w + (double)difx), Math.abs(h - (double)dify));
                break;
            }
            case 8: {
                y = y + (double)dify > rec.getMaxY() ? rec.getMaxY() : (y += (double)dify);
                if (prop) {
                    difx = (int)((double)dify * ratio);
                }
                x = x + (double)difx > rec.getMaxX() ? rec.getMaxX() : (x += (double)difx);
                this.lastMoveRect.setRect(x, y, Math.abs(w - (double)difx), Math.abs(h - (double)dify));
                break;
            }
            case 4: {
                if (y > rec.getMaxY() + (double)dify) {
                    y = rec.getMaxY() + (double)dify;
                }
                if (prop) {
                    difx = (int)((double)dify * ratio);
                }
                if (x > rec.getMaxX() + (double)difx) {
                    x = rec.getMaxX() + (double)difx;
                }
                this.lastMoveRect.setRect(x, y, Math.abs(w + (double)difx), Math.abs(h + (double)dify));
                break;
            }
            case 6: {
                if (y > rec.getMaxY() + (double)dify) {
                    y = rec.getMaxY() + (double)dify;
                }
                if (prop) {
                    difx = (int)(-((double)dify * ratio));
                }
                x = x + (double)difx > rec.getMaxX() ? rec.getMaxX() : (x += (double)difx);
                this.lastMoveRect.setRect(x, y, Math.abs(w - (double)difx), Math.abs(h + (double)dify));
                break;
            }
            default: {
                this.lastMoveRect.setRect(x, y, w, h);
            }
        }
        return this.lastMoveRect;
    }

    @Override
    public Rectangle2D getLastMoveRect() {
        return this.lastMoveRect;
    }

    @Override
    public int getSelected() {
        return this.m_Selected;
    }

    @Override
    public boolean isSelected() {
        return this.getSelected() != 0;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.getBoundingBox(null).contains(p.getX(), p.getY());
    }

    @Override
    public int getContains(Point2D p) {
        Point2D point = new Point2D.Double();
        AffineTransform rotationAT = this.getRotationAT();
        if (rotationAT != null) {
            try {
                rotationAT.createInverse().transform(p, point);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {}
        } else {
            point = p;
        }
        if (this.n.contains(point.getX(), point.getY())) {
            return 1;
        }
        if (this.ne.contains(point.getX(), point.getY())) {
            return 2;
        }
        if (this.e.contains(point.getX(), point.getY())) {
            return 3;
        }
        if (this.se.contains(point.getX(), point.getY())) {
            return 4;
        }
        if (this.s.contains(point.getX(), point.getY())) {
            return 5;
        }
        if (this.so.contains(point.getX(), point.getY())) {
            return 6;
        }
        if (this.o.contains(point.getX(), point.getY())) {
            return 7;
        }
        if (this.no.contains(point.getX(), point.getY())) {
            return 8;
        }
        if (this.getBoundingBox(null).contains(point.getX(), point.getY())) {
            return 9;
        }
        return 0;
    }

    @Override
    public Image getMapCursor(Point2D p) {
        int select = this.getContains(p);
        switch (select) {
            case 1: {
                return iNResize;
            }
            case 2: {
                return iNEResize;
            }
            case 3: {
                return iEResize;
            }
            case 4: {
                return iSEResize;
            }
            case 5: {
                return iNResize;
            }
            case 6: {
                return iNEResize;
            }
            case 7: {
                return iEResize;
            }
            case 8: {
                return iSEResize;
            }
            case 9: {
                return iMove;
            }
        }
        return null;
    }

    @Override
    public abstract void draw(Graphics2D var1, AffineTransform var2, Rectangle2D var3, BufferedImage var4);

    @Override
    public Rectangle2D.Double getBoundingBox(AffineTransform at) {
        if (at != null) {
            this.lastAT = (AffineTransform)at.clone();
        }
        return FLayoutUtilities.fromSheetRect(this.m_BoundBox, this.lastAT);
    }

    @Override
    public void setBoundBox(Rectangle2D r) {
        if (r == null) {
            LOG.info("Warning: BBOX set to NULL in FFrame!");
            this.m_BoundBox = null;
        } else {
            this.m_BoundBox = new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight());
        }
    }

    @Override
    public Rectangle2D.Double getBoundBox() {
        return this.m_BoundBox;
    }

    @Override
    public void setSelected(boolean selected) {
        if (selected) {
            this.doSetSelected(9);
        } else {
            this.doSetSelected(0);
        }
    }

    protected void doSetSelected(int selectedStatus) {
        this.m_Selected = selectedStatus;
    }

    @Override
    public void drawDraft(Graphics2D g) {
        Rectangle2D.Double r = this.getBoundingBox(null);
        g.setColor(Color.lightGray);
        g.fillRect((int)((RectangularShape)r).getX(), (int)((RectangularShape)r).getY(), (int)((RectangularShape)r).getWidth(), (int)((RectangularShape)r).getHeight());
        g.setColor(Color.black);
        g.drawRect((int)((RectangularShape)r).getX(), (int)((RectangularShape)r).getY(), (int)((RectangularShape)r).getWidth() - 1, (int)((RectangularShape)r).getHeight() - 1);
        int scale = (int)(((RectangularShape)r).getWidth() / 12.0);
        Font f = new Font("SansSerif", 0, scale);
        g.setFont(f);
        g.drawString(this.getName(), (int)(r.getCenterX() - (double)(this.getName().length() * scale / 4)), (int)r.getCenterY());
    }

    @Override
    public void setNum(int i) {
        this.num = i;
    }

    public void drawEmpty(Graphics2D g) {
        Rectangle2D.Double r = this.getBoundingBox(null);
        g.setColor(Color.lightGray);
        g.fillRect((int)((RectangularShape)r).getX(), (int)((RectangularShape)r).getY(), (int)((RectangularShape)r).getWidth(), (int)((RectangularShape)r).getHeight());
        g.setColor(Color.darkGray);
        g.setStroke(new BasicStroke(2.0f));
        g.drawRect((int)((RectangularShape)r).getX(), (int)((RectangularShape)r).getY(), (int)((RectangularShape)r).getWidth(), (int)((RectangularShape)r).getHeight());
        g.setColor(Color.black);
        int scale = (int)(((RectangularShape)r).getWidth() / 12.0);
        Font f = new Font("SansSerif", 0, scale);
        g.setFont(f);
        String str = this.getNameFFrame() + " " + PluginServices.getText((Object)this, (String)"vacia");
        g.drawString(str, (int)(r.getCenterX() - (double)(str.length() * scale / 4)), (int)r.getCenterY());
    }

    @Override
    public boolean intersects(Rectangle2D rv, Rectangle2D r) {
        return rv != null && rv.intersects(r) || rv == null;
    }

    @Override
    public void setTag(String s) {
        this.tag = s;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public void drawSymbolTag(Graphics2D g) {
        Rectangle2D.Double rec = this.getBoundingBox(null);
        g.rotate(Math.toRadians(this.getRotation()), ((RectangularShape)rec).getX() + ((RectangularShape)rec).getWidth() / 2.0, ((RectangularShape)rec).getY() + ((RectangularShape)rec).getHeight() / 2.0);
        try {
            Image image = PluginServices.getIconTheme().get("symboltag-icon").getImage();
            g.drawImage(image, (int)((RectangularShape)rec).getX(), (int)rec.getCenterY(), 30, 30, null);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        g.rotate(Math.toRadians(-this.getRotation()), ((RectangularShape)rec).getX() + ((RectangularShape)rec).getWidth() / 2.0, ((RectangularShape)rec).getY() + ((RectangularShape)rec).getHeight() / 2.0);
    }

    @Override
    public void setRotation(double rotation) {
        this.m_rotation = rotation;
    }

    protected AffineTransform getRotationAT() {
        double rotation = this.getRotation();
        if (this.getLayoutContext() != null && this.getLayoutContext().getAT() != null && Math.abs(rotation) > 1.0E-5) {
            AffineTransform rotationAT = new AffineTransform();
            Rectangle2D.Double frameRect = this.getBoundingBox(this.getLayoutContext().getAT());
            rotationAT.rotate(Math.toRadians(this.getRotation()), frameRect.getCenterX(), frameRect.getCenterY());
            return rotationAT;
        }
        return null;
    }

    @Override
    public double getRotation() {
        return this.m_rotation;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int l) {
        this.level = l;
    }

    public Object clone() throws CloneNotSupportedException {
        FFrame frame = (FFrame)super.clone();
        frame.m_BoundBox = (Rectangle2D.Double)this.m_BoundBox.clone();
        return frame;
    }

    @Override
    public void setFrameFactory(FrameFactory flf) {
        this.frameFactory = flf;
    }

    @Override
    public FrameFactory getFrameFactory() {
        return this.frameFactory;
    }

    public static void initializeIcons() {
        iNEResize = PluginServices.getIconTheme().get("neresize-icon").getImage();
        iEResize = PluginServices.getIconTheme().get("eresize-icon").getImage();
        iNResize = PluginServices.getIconTheme().get("nresize-icon").getImage();
        iMove = PluginServices.getIconTheme().get("graphic-move-icon").getImage();
        iSEResize = PluginServices.getIconTheme().get("sereresize-icon").getImage();
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(FFrame.class, PERSISTENCE_DEFINITION_NAME, "FFrame persistence definition", null, null);
            definition.addDynFieldObject(BOUNDINGBOX_FIELD).setClassOfValue(Rectangle2D.class).setMandatory(true);
            definition.addDynFieldInt(SELECTED_FIELD).setMandatory(true);
            definition.addDynFieldString(TAG_FIELD).setMandatory(false);
            definition.addDynFieldDouble(ROTATION_FIELD).setMandatory(true);
            definition.addDynFieldInt(LEVEL_FIELD).setMandatory(true);
            definition.addDynFieldInt(NUM_FIELD).setMandatory(true);
            definition.addDynFieldObject(DOCUMENT_FIELD).setClassOfValue(LayoutDocument.class).setMandatory(false);
            definition.addDynFieldObject(LAYOUT_CONTEXT_FIELD).setClassOfValue(LayoutContext.class).setMandatory(false);
        }
        Attributes.registerPersistent();
        AbstractFFrameViewDependence.registerPersistent();
        FFrameBasic.registerPersistent();
        FFrameGraphics.registerPersistent();
        FFrameSymbol.registerPersistent();
        FFrameGrid.registerPersistent();
        FFrameGroup.registerPersistent();
        FFrameTable.registerPersistent();
        FFrameLegend.registerPersistent();
        FFramePicture.registerPersistent();
        FFrameNorth.registerPersistent();
        FFrameScaleBar.registerPersistent();
        FFrameText.registerPersistent();
        FFrameView.registerPersistent();
        FFrameOverView.registerPersistent();
        FFrameGridCoordinateFormat.registerPersistence();
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.m_BoundBox = (Rectangle2D.Double)state.get(BOUNDINGBOX_FIELD);
        this.m_Selected = state.getInt(SELECTED_FIELD);
        this.tag = state.getString(TAG_FIELD);
        this.m_rotation = state.getDouble(ROTATION_FIELD);
        this.level = state.getInt(LEVEL_FIELD);
        this.num = state.getInt(NUM_FIELD);
        if (state.hasValue(DOCUMENT_FIELD)) {
            this.setDocument((LayoutDocument)state.get(DOCUMENT_FIELD));
        }
        if (state.hasValue(LAYOUT_CONTEXT_FIELD)) {
            this.setLayoutContext((LayoutContext)state.get(LAYOUT_CONTEXT_FIELD));
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set(BOUNDINGBOX_FIELD, (Object)this.getBoundBox());
        state.set(SELECTED_FIELD, this.m_Selected);
        state.set(TAG_FIELD, this.getTag());
        state.set(ROTATION_FIELD, this.getRotation());
        state.set(LEVEL_FIELD, this.getLevel());
        state.set(NUM_FIELD, this.num);
        state.set(DOCUMENT_FIELD, (Persistent)this.getDocument());
        state.set(LAYOUT_CONTEXT_FIELD, (Persistent)this.getLayoutContext());
    }

    public void addObserver(Observer o) {
        this.observers.addObserver(o);
    }

    public void deleteObserver(Observer o) {
        this.observers.deleteObserver(o);
    }

    public void deleteObservers() {
        this.observers.deleteObservers();
    }

    public void dispose() {
    }

    @Override
    public void frameRemoved() {
    }

    @Override
    public void frameAdded() {
    }

    @Override
    public LayoutContext getLayoutContext() {
        return this.layoutContext;
    }

    @Override
    public void setLayoutContext(LayoutContext layoutContext) {
        this.layoutContext = layoutContext;
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    @Override
    public void setDocument(Document document) {
        this.document = document;
    }

    protected Rectangle2D getVisibleRect(Rectangle2D visibleLayoutDocRect, Rectangle2D frame) {
        if (Math.abs(this.getRotation()) > 1.0E-5) {
            Area area = new Area(frame);
            AffineTransform at = new AffineTransform();
            at.rotate(Math.toRadians(this.getRotation()), frame.getCenterX(), frame.getCenterY());
            Area rotatedArea = area.createTransformedArea(at);
            Area visibleArea = new Area(visibleLayoutDocRect);
            visibleArea.intersect(rotatedArea);
            if (visibleArea.isEmpty()) {
                return null;
            }
            try {
                Area nonRotatedVisibleArea = visibleArea.createTransformedArea(at.createInverse());
                Rectangle2D nonRotatedVisibleBounds = nonRotatedVisibleArea.getBounds2D();
                return nonRotatedVisibleBounds;
            }
            catch (NoninvertibleTransformException ex) {
                LoggerFactory.getLogger(FFrame.class).error(ex.getMessage(), (Throwable)ex);
                return null;
            }
        }
        Rectangle2D.Double visibleArea = new Rectangle2D.Double();
        Rectangle2D.intersect(visibleLayoutDocRect, frame, visibleArea);
        if (visibleArea.isEmpty()) {
            return null;
        }
        return visibleArea;
    }
}

