/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.fframes;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.documents.layout.fframes.AbstractFFrameViewDependence;
import org.gvsig.app.project.documents.layout.fframes.FFrameGridCoordinateFormat;
import org.gvsig.app.project.documents.layout.fframes.FFrameView;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.fframes.IFFrameViewDependence;
import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolManager;
import org.gvsig.gui.awt.text.RotatedTextUtils;
import org.gvsig.math.intervals.IntervalUtils;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ILineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMarkerSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.locator.LocatorException;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class FFrameGrid
extends AbstractFFrameViewDependence
implements IFFrameViewDependence {
    private static final GeometryManager GEOMETRY_MANAGER = GeometryLocator.getGeometryManager();
    private static final int OFFSET_IN_PIXELS = 5;
    public static final String PERSISTENCE_DEFINITION_NAME = "FFrameGrid";
    private static final String SYMBOLLINE_FIELD = "symbolLine";
    private static final String SYMBOLPOINT_FIELD = "symbolPoint";
    private static final String FONT_FIELD = "font";
    private static final String INTERVALX_FIELD = "intervalX";
    private static final String INTERVALY_FIELD = "intervalY";
    private static final String ISLINE_FIELD = "isLine";
    private static final String FONTSYZE_FIELD = "fontsize";
    private static final String TEXTCOLOR_FIELD = "textColor";
    private static final String USE_NUM_DIVISIONS_FIELD = "useNumDivisions";
    private static final String NUM_DIV_HORIZ_FIELD = "numDivHoriz";
    private static final String NUM_DIV_VERT_FIELD = "numDivVret";
    private static final String LABEL_FORMAT_FIELD_NEW = "labelFormatNew";
    private static final String LABEL_FORMAT_FIELD = "labelFormat";
    private static final String HORIZ_LABEL_ROTATION_FIELD = "horizLabelRotation";
    private static final String VERT_LABEL_ROTATION_FIELD = "vertLabelRotation";
    private static final String LABEL_ANCHOR = "LabelAnchor";
    public static final int FIXED_DISTANCE_MODE = 0;
    public static final int NUM_DIVISIONS_HORIZ_MODE = 1;
    public static final int NUM_DIVISIONS_VERT_MODE = 2;
    private final double defaultInterval = 100000.0;
    private Double intervalX = null;
    private Double intervalY = null;
    private Color textColor = Color.black;
    private boolean isLine;
    private int sizeFont = 8;
    private int useNumDivisions = 0;
    private int numDivHoriz = 4;
    private int numDivVert = 4;
    private FFrameGridCoordinateFormat labelFormat = new FFrameGridCoordinateFormat();
    private double horizLabelRotation = 0.0;
    private double vertLabelRotation = 0.0;
    private int labelAnchor = 0;
    private final SymbolManager symbolManager = MapContextLocator.getSymbolManager();
    private ILineSymbol symbolLine = (ILineSymbol)this.symbolManager.createSymbol("line");
    private IMarkerSymbol symbolPoint = (IMarkerSymbol)this.symbolManager.createSymbol("marker");
    private Font font = new Font("Arial", 0, this.sizeFont);

    @Override
    public void draw(Graphics2D g, AffineTransform at, Rectangle2D rv, BufferedImage imgBase) {
        try {
            Rectangle2D.Double r = this.getBoundingBox(at);
            Rectangle2D.Double rView = this.fframeViewDependence.getBoundingBox(at);
            if (r == null || rView == null) {
                return;
            }
            ViewPort vp = (ViewPort)this.fframeViewDependence.getMapContext().getViewPort().clone();
            vp.setOffset((Point2D)new Point2D.Double(rView.getMinX(), rView.getMinY()));
            vp.setImageSize(new Dimension((int)Math.round(((RectangularShape)rView).getWidth()), (int)Math.round(((RectangularShape)rView).getHeight())));
            vp.refreshExtent();
            Envelope envelope = vp.getAdjustedEnvelope();
            AffineTransform mapTransform = vp.getAffineTransform();
            this.updateIntervals(envelope);
            double theIntervalX = this.getIntervalX();
            double theIntervalY = this.getIntervalY();
            g.rotate(Math.toRadians(this.getRotation()), r.x + r.width / 2.0, r.y + r.height / 2.0);
            double minX = envelope.getMinimum(0);
            double minY = envelope.getMinimum(1);
            double maxX = envelope.getMaximum(0);
            double maxY = envelope.getMaximum(1);
            double initPointGridWCX = Math.ceil(minX / theIntervalX) * theIntervalX;
            double initPointGridWCY = Math.ceil(minY / theIntervalY) * theIntervalY;
            ILineSymbol symbolForMargins = null;
            if (this.isLine) {
                symbolForMargins = this.symbolLine;
            } else {
                try {
                    symbolForMargins = (ISymbol)this.symbolLine.clone();
                    symbolForMargins.setColor(this.symbolPoint.getColor());
                }
                catch (CloneNotSupportedException ex) {
                    LOG.error("Symbol desn't support the clone method", (Throwable)ex);
                }
            }
            this.drawBox(rView, g, (ISymbol)symbolForMargins);
            double myScale = at.getScaleX() * 0.0234;
            int scaledFontSize = (int)(myScale * (double)this.sizeFont);
            Font theFont = new Font(this.font.getFamily(), this.font.getStyle(), scaledFontSize);
            this.drawLabels(rView, initPointGridWCX, initPointGridWCY, maxX, maxY, theIntervalX, theIntervalY, mapTransform, g, theFont, (ISymbol)symbolForMargins);
            if (this.isLine) {
                this.drawLines(rView, initPointGridWCX, initPointGridWCY, maxX, maxY, theIntervalX, theIntervalY, mapTransform, g);
            } else {
                this.drawPoints(initPointGridWCX, initPointGridWCY, maxX, maxY, theIntervalX, theIntervalY, mapTransform, g);
            }
            g.rotate(Math.toRadians(-this.getRotation()), r.x + r.width / 2.0, r.y + r.height / 2.0);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    private void drawPoints(double minGridX, double minGridY, double maxGridX, double maxGridY, double intervalGridX, double intervalGridY, AffineTransform mapTransform, Graphics2D g) {
        Point2D.Double currentPoint = new Point2D.Double(minGridX, minGridY);
        Point2D.Double screenPoint = new Point2D.Double();
        while (((Point2D)currentPoint).getX() < maxGridX) {
            while (((Point2D)currentPoint).getY() < maxGridY) {
                mapTransform.transform(currentPoint, screenPoint);
                this.drawPoint(g, screenPoint);
                ((Point2D)currentPoint).setLocation(((Point2D)currentPoint).getX(), ((Point2D)currentPoint).getY() + intervalGridY);
            }
            ((Point2D)currentPoint).setLocation(((Point2D)currentPoint).getX() + intervalGridX, minGridY);
        }
    }

    private void drawLines(Rectangle2D rView, double minMapX, double minMapY, double maxMapX, double maxMapY, double intervalMapX, double intervalMapY, AffineTransform mapTransform, Graphics2D g) {
        double minX = rView.getMinX();
        double maxX = rView.getMaxX();
        double minY = rView.getMinY();
        double maxY = rView.getMaxY();
        double xMap = minMapX;
        double yMap = minMapY;
        Point2D.Double currentPoint = new Point2D.Double(minMapX, minMapY);
        mapTransform.transform(currentPoint, currentPoint);
        while (xMap < maxMapX) {
            this.drawLine(((Point2D)currentPoint).getX(), minY, ((Point2D)currentPoint).getX(), maxY, g, (ISymbol)this.symbolLine);
            ((Point2D)currentPoint).setLocation(xMap += intervalMapX, minMapY);
            mapTransform.transform(currentPoint, currentPoint);
        }
        while (yMap < maxMapY) {
            this.drawLine(minX, ((Point2D)currentPoint).getY(), maxX, ((Point2D)currentPoint).getY(), g, (ISymbol)this.symbolLine);
            ((Point2D)currentPoint).setLocation(minMapX, yMap += intervalMapY);
            mapTransform.transform(currentPoint, currentPoint);
        }
    }

    private void drawLabels(Rectangle2D rView, double minGridX, double minGridY, double maxGridX, double maxGridY, double intervalGridX, double intervalGridY, AffineTransform mapTransform, Graphics2D g, Font font, ISymbol symbolForMargins) {
        AffineTransform defaultAt = g.getTransform();
        double minX = rView.getMinX();
        double maxX = rView.getMaxX();
        double minY = rView.getMinY();
        double maxY = rView.getMaxY();
        double xMap = minGridX;
        double yMap = minGridY;
        Point2D.Double initGridPx = new Point2D.Double(minGridX, minGridY);
        mapTransform.transform(initGridPx, initGridPx);
        double xPx = ((Point2D)initGridPx).getX();
        double angle = RotatedTextUtils.normalizeAngle((double)Math.toRadians(this.getVertLabelRotation()));
        int anchor = this.getLabelAnchor();
        while (xMap < maxGridX) {
            this.drawLine(xPx, maxY + 5.0, xPx, maxY, g, symbolForMargins);
            this.drawLine(xPx, minY, xPx, minY - 5.0, g, symbolForMargins);
            g.rotate(angle);
            g.setColor(this.textColor);
            Point2D.Double p1 = new Point2D.Double(xPx, maxY + 5.0);
            TextLayout textaux = new TextLayout(this.labelFormat.format("EW", xMap), font, g.getFontRenderContext());
            Point2D rotatedP1 = RotatedTextUtils.getPosition((Point2D)p1, (TextLayout)textaux, (double)angle, (int)1, (int)anchor);
            textaux.draw(g, (int)rotatedP1.getX(), (int)rotatedP1.getY());
            Point2D.Double p2 = new Point2D.Double(xPx, minY - 5.0);
            Point2D rotatedP2 = RotatedTextUtils.getPosition((Point2D)p2, (TextLayout)textaux, (double)angle, (int)0, (int)anchor);
            textaux.draw(g, (int)rotatedP2.getX(), (int)rotatedP2.getY());
            g.setTransform(defaultAt);
            ((Point2D)initGridPx).setLocation(xMap += intervalGridX, minGridY);
            mapTransform.transform(initGridPx, initGridPx);
            xPx = ((Point2D)initGridPx).getX();
        }
        double yPx = ((Point2D)initGridPx).getY();
        angle = RotatedTextUtils.normalizeAngle((double)Math.toRadians(this.getHorizLabelRotation()));
        while (yMap < maxGridY) {
            this.drawLine(minX - 5.0, yPx, minX, yPx, g, symbolForMargins);
            this.drawLine(maxX, yPx, maxX + 5.0, yPx, g, symbolForMargins);
            g.rotate(angle);
            g.setColor(this.textColor);
            TextLayout textaux = new TextLayout(this.labelFormat.format("NS", yMap), font, g.getFontRenderContext());
            Point2D.Double p1 = new Point2D.Double(minX - 5.0, yPx);
            Point2D rotatedP1 = RotatedTextUtils.getPosition((Point2D)p1, (TextLayout)textaux, (double)angle, (int)2, (int)anchor);
            textaux.draw(g, (int)rotatedP1.getX(), (int)rotatedP1.getY());
            Point2D.Double p2 = new Point2D.Double(maxX + 5.0, yPx);
            Point2D rotatedP2 = RotatedTextUtils.getPosition((Point2D)p2, (TextLayout)textaux, (double)angle, (int)3, (int)anchor);
            textaux.draw(g, (int)rotatedP2.getX(), (int)rotatedP2.getY());
            g.setTransform(defaultAt);
            ((Point2D)initGridPx).setLocation(minGridX, yMap += intervalGridY);
            mapTransform.transform(initGridPx, initGridPx);
            yPx = ((Point2D)initGridPx).getY();
        }
    }

    private void drawBox(Rectangle2D mapRectangle, Graphics2D g, ISymbol symbol) {
        try {
            Line line = (Line)GEOMETRY_MANAGER.create(18, 0);
            line.addVertex(GEOMETRY_MANAGER.createPoint(mapRectangle.getMinX() - 1.0, mapRectangle.getMinY() - 1.0, 0));
            line.addVertex(GEOMETRY_MANAGER.createPoint(mapRectangle.getMinX() - 1.0, mapRectangle.getMaxY() + 1.0, 0));
            line.addVertex(GEOMETRY_MANAGER.createPoint(mapRectangle.getMaxX() + 1.0, mapRectangle.getMaxY() + 1.0, 0));
            line.addVertex(GEOMETRY_MANAGER.createPoint(mapRectangle.getMaxX() + 1.0, mapRectangle.getMinY() - 1.0, 0));
            line.addVertex(GEOMETRY_MANAGER.createPoint(mapRectangle.getMinX() - 1.0, mapRectangle.getMinY() - 1.0, 0));
            symbol.draw(g, null, (Geometry)line, null, null);
        }
        catch (CreateGeometryException ex) {
            LOG.error("Error drawing the box", (Throwable)ex);
        }
    }

    private void drawPoint(Graphics2D g, Point2D point) {
        try {
            Geometry geom = this.createPoint((int)point.getX(), (int)point.getY());
            this.symbolPoint.draw(g, null, geom, null, null);
        }
        catch (CreateGeometryException | LocatorException ex) {
            LOG.error("Error drawing the grid", ex);
        }
    }

    private void drawLine(double startX, double startY, double endX, double endY, Graphics2D g, ISymbol symbolLine) {
        try {
            Geometry geom = this.createLine((int)startX, (int)startY, (int)endX, (int)endY);
            symbolLine.draw(g, null, geom, null, null);
        }
        catch (CreateGeometryException | LocatorException ex) {
            LOG.error("Error drawing the grid", ex);
        }
    }

    private Geometry createLine(int i, int j, int k, int l) throws LocatorException, CreateGeometryException {
        Line curve = (Line)GEOMETRY_MANAGER.create(18, 0);
        curve.addVertex(GEOMETRY_MANAGER.createPoint((double)i, (double)j, 0));
        curve.addVertex(GEOMETRY_MANAGER.createPoint((double)k, (double)l, 0));
        return curve;
    }

    private Geometry createPoint(int i, int j) throws LocatorException, CreateGeometryException {
        return GeometryLocator.getGeometryManager().createPoint((double)i, (double)j, 0);
    }

    @Override
    public String getNameFFrame() {
        return PluginServices.getText((Object)this, (String)"cuadricula") + this.num;
    }

    @Override
    public String getName() {
        return PERSISTENCE_DEFINITION_NAME;
    }

    @Override
    public void setFFrameDependence(IFFrame f) {
        super.setFFrameDependence(f);
        this.fframeViewDependence.refresh();
    }

    public void setIntervalX(double d) {
        this.intervalX = d;
    }

    public void setIntervalY(double d) {
        this.intervalY = d;
    }

    public double getIntervalX() {
        if (this.intervalX != null) {
            return this.intervalX;
        }
        this.intervalX = this.intervalY = Double.valueOf(this.getReasonableInterval());
        return this.intervalX;
    }

    private double getReasonableInterval() {
        if (this.fframeViewDependence != null && this.fframeViewDependence.getMapContext() != null && this.fframeViewDependence.getMapContext().getViewPort().getAdjustedEnvelope() != null) {
            Envelope env = this.fframeViewDependence.getMapContext().getViewPort().getAdjustedEnvelope();
            return IntervalUtils.roundIntervalDivision(env.getLength(0), 5);
        }
        return 100000.0;
    }

    public double getIntervalY() {
        if (this.intervalX != null) {
            return this.intervalX;
        }
        this.intervalX = this.intervalY = Double.valueOf(this.getReasonableInterval());
        return this.intervalY;
    }

    public void setTextColor(Color textcolor) {
        this.textColor = textcolor;
    }

    public void setIsLine(boolean b) {
        this.isLine = b;
    }

    public boolean isLine() {
        return this.isLine;
    }

    public Color getFontColor() {
        return this.textColor;
    }

    public int getSizeFont() {
        return this.sizeFont;
    }

    public void setSizeFont(int sizeFont) {
        this.sizeFont = sizeFont;
    }

    @Override
    public Rectangle2D.Double getBoundingBox(AffineTransform at) {
        if (this.fframeViewDependence == null || this.fframeViewDependence.getMapContext() == null) {
            return super.getBoundingBox(at);
        }
        Rectangle2D.Double r = this.fframeViewDependence.getBoundingBox(at);
        Envelope extent = this.fframeViewDependence.getMapContext().getViewPort().getAdjustedEnvelope();
        if (extent == null) {
            return null;
        }
        double extentX = extent.getMaximum(0);
        double extentY = extent.getMaximum(1);
        int lengthX = String.valueOf((long)extentX).length();
        double myScale = at.getScaleX() * 0.0234;
        int scaledFontSize = (int)(myScale * (double)this.sizeFont);
        int pixelsX = (int)((double)(lengthX * scaledFontSize) * 0.7);
        int lengthY = String.valueOf((long)extentY).length();
        int pixelsY = lengthY * scaledFontSize;
        return new Rectangle2D.Double(r.getMinX() - (double)pixelsX, r.getMinY() - (double)pixelsY, r.getWidth() + (double)(pixelsX * 2), r.getHeight() + (double)(pixelsY * 2));
    }

    @Override
    public Rectangle2D getMovieRect(int difx, int dify) {
        return this.getBoundingBox(null);
    }

    @Override
    public Rectangle2D getMovieRect(int difx, int dify, boolean prop) {
        return this.getBoundingBox(null);
    }

    @Override
    public void refreshDependence(IFFrame fant, IFFrame fnew) {
        if (this.fframeViewDependence.equals(fant)) {
            this.fframeViewDependence = (FFrameView)fnew;
            this.fframeViewDependence.refresh();
        }
    }

    @Override
    public void drawHandlers(Graphics2D g) {
        g.setColor(Color.gray);
        super.drawHandlers(g);
        g.setColor(Color.black);
    }

    @Override
    public Rectangle2D getLastMoveRect() {
        return this.getBoundBox();
    }

    public ISymbol getSymbolLine() {
        return this.symbolLine;
    }

    public void setSymbolLine(ISymbol symbolLine) {
        this.symbolLine = (ILineSymbol)symbolLine;
    }

    public ISymbol getSymbolPoint() {
        return this.symbolPoint;
    }

    public void setSymbolPoint(ISymbol symbolPoint) {
        this.symbolPoint = (IMarkerSymbol)symbolPoint;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font m_font) {
        this.font = m_font;
    }

    public int getFontSize() {
        return this.font.getSize();
    }

    public void setUseNumDivisions(int mode) {
        this.useNumDivisions = mode;
    }

    protected void updateIntervals() {
        if (this.fframeViewDependence.getMapContext() != null && this.fframeViewDependence.getMapContext().getViewPort() != null) {
            Envelope env = this.fframeViewDependence.getMapContext().getViewPort().getAdjustedEnvelope();
            this.updateIntervals(env);
        }
    }

    protected void updateIntervals(Envelope env) {
        if (this.useNumDivisions == 1) {
            double division = IntervalUtils.roundIntervalDivision(env.getLength(0), this.numDivHoriz);
            this.intervalX = division;
            this.intervalY = division;
        } else if (this.useNumDivisions == 2) {
            double division = IntervalUtils.roundIntervalDivision(env.getLength(1), this.numDivVert);
            this.intervalX = division;
            this.intervalY = division;
        }
    }

    public int getUseNumDivisions() {
        return this.useNumDivisions;
    }

    public void setNumDivisionsHoriz(int nx) {
        this.numDivHoriz = nx;
    }

    public void setNumDivisionsVert(int ny) {
        this.numDivVert = ny;
    }

    public int getNumDivisionsHoriz() {
        return this.numDivHoriz;
    }

    public int getNumDivisionsVert() {
        return this.numDivVert;
    }

    public void setLabelFormat(FFrameGridCoordinateFormat f) {
        this.labelFormat = f;
    }

    public FFrameGridCoordinateFormat getLabelFormat() {
        return this.labelFormat;
    }

    public void setHorizLabelRotation(double labelRotation) {
        this.horizLabelRotation = labelRotation;
    }

    public void setVertLabelRotation(double labelRotation) {
        this.vertLabelRotation = labelRotation;
    }

    public double getHorizLabelRotation() {
        return this.horizLabelRotation;
    }

    public int getLabelAnchor() {
        return this.labelAnchor;
    }

    public void setLabelAnchor(int anchor) {
        this.labelAnchor = anchor == 1 ? anchor : 0;
    }

    public double getVertLabelRotation() {
        return this.vertLabelRotation;
    }

    public void print(Graphics2D g, AffineTransform at, Geometry shape, PrintAttributes properties) {
        this.draw(g, at, null, null);
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(FFrameGrid.class, PERSISTENCE_DEFINITION_NAME, "FFrameGrid persistence definition", null, null);
            definition.extend(manager.getDefinition("AbstractFFrameViewDependence"));
            definition.addDynFieldObject(SYMBOLLINE_FIELD).setClassOfValue(ILineSymbol.class).setMandatory(true);
            definition.addDynFieldObject(SYMBOLPOINT_FIELD).setClassOfValue(IMarkerSymbol.class).setMandatory(true);
            definition.addDynFieldObject(FONT_FIELD).setClassOfValue(Font.class).setMandatory(true);
            definition.addDynFieldDouble(INTERVALX_FIELD).setMandatory(false);
            definition.addDynFieldDouble(INTERVALY_FIELD).setMandatory(false);
            definition.addDynFieldBoolean(ISLINE_FIELD).setMandatory(true);
            definition.addDynFieldInt(FONTSYZE_FIELD).setMandatory(true);
            definition.addDynFieldObject(TEXTCOLOR_FIELD).setClassOfValue(Color.class).setMandatory(true);
            definition.addDynFieldInt(USE_NUM_DIVISIONS_FIELD).setMandatory(false);
            definition.addDynFieldInt(NUM_DIV_HORIZ_FIELD).setMandatory(false);
            definition.addDynFieldInt(NUM_DIV_VERT_FIELD).setMandatory(false);
            definition.addDynFieldObject(LABEL_FORMAT_FIELD).setClassOfValue(DecimalFormat.class).setMandatory(false);
            definition.addDynFieldObject(LABEL_FORMAT_FIELD_NEW).setClassOfValue(FFrameGridCoordinateFormat.class).setMandatory(false);
            definition.addDynFieldDouble(VERT_LABEL_ROTATION_FIELD).setMandatory(false);
            definition.addDynFieldDouble(HORIZ_LABEL_ROTATION_FIELD).setMandatory(false);
            definition.addDynFieldInt(LABEL_ANCHOR).setMandatory(false);
        }
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        FFrameGridCoordinateFormat x;
        super.loadFromState(state);
        this.symbolLine = (ILineSymbol)state.get(SYMBOLLINE_FIELD);
        this.symbolPoint = (IMarkerSymbol)state.get(SYMBOLPOINT_FIELD);
        this.font = (Font)state.get(FONT_FIELD);
        this.intervalX = (Double)state.get(INTERVALX_FIELD);
        this.intervalY = (Double)state.get(INTERVALY_FIELD);
        this.isLine = state.getBoolean(ISLINE_FIELD);
        this.sizeFont = state.getInt(FONTSYZE_FIELD);
        this.textColor = (Color)state.get(TEXTCOLOR_FIELD);
        if (state.hasValue(USE_NUM_DIVISIONS_FIELD)) {
            this.useNumDivisions = state.getInt(USE_NUM_DIVISIONS_FIELD);
        }
        if (state.hasValue(NUM_DIV_HORIZ_FIELD)) {
            this.numDivHoriz = state.getInt(NUM_DIV_HORIZ_FIELD);
        }
        if (state.hasValue(NUM_DIV_VERT_FIELD)) {
            this.numDivVert = state.getInt(NUM_DIV_VERT_FIELD);
        }
        if (state.hasValue(LABEL_FORMAT_FIELD)) {
            DecimalFormat df = (DecimalFormat)state.get(LABEL_FORMAT_FIELD);
            this.labelFormat.setDecimalFormat(df);
        }
        if (state.hasValue(LABEL_FORMAT_FIELD_NEW) && (x = (FFrameGridCoordinateFormat)state.get(LABEL_FORMAT_FIELD_NEW)) != null) {
            this.labelFormat = x;
        }
        if (state.hasValue(VERT_LABEL_ROTATION_FIELD)) {
            this.vertLabelRotation = state.getDouble(VERT_LABEL_ROTATION_FIELD);
        }
        if (state.hasValue(HORIZ_LABEL_ROTATION_FIELD)) {
            this.horizLabelRotation = state.getDouble(HORIZ_LABEL_ROTATION_FIELD);
        }
        if (state.hasValue(LABEL_ANCHOR)) {
            this.labelAnchor = state.getInt(LABEL_ANCHOR);
        }
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set(SYMBOLLINE_FIELD, (Persistent)this.symbolLine);
        state.set(SYMBOLPOINT_FIELD, (Persistent)this.symbolPoint);
        state.set(FONT_FIELD, (Object)this.font);
        state.set(INTERVALX_FIELD, this.intervalX);
        state.set(INTERVALY_FIELD, this.intervalY);
        state.set(ISLINE_FIELD, this.isLine);
        state.set(FONTSYZE_FIELD, this.sizeFont);
        state.set(TEXTCOLOR_FIELD, (Object)this.textColor);
        state.set(USE_NUM_DIVISIONS_FIELD, this.useNumDivisions);
        state.set(NUM_DIV_HORIZ_FIELD, this.numDivHoriz);
        state.set(NUM_DIV_VERT_FIELD, this.numDivVert);
        state.set(LABEL_FORMAT_FIELD, (Object)this.labelFormat.getDecimalFormat());
        state.set(LABEL_FORMAT_FIELD_NEW, (Persistent)this.labelFormat);
        state.set(VERT_LABEL_ROTATION_FIELD, this.vertLabelRotation);
        state.set(HORIZ_LABEL_ROTATION_FIELD, this.horizLabelRotation);
        state.set(LABEL_ANCHOR, this.labelAnchor);
    }
}

