/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.fframes;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.documents.layout.fframes.FFrameView;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.fframes.IFFrameViewDependence;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.MapContextException;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FFrameOverView
extends FFrameView
implements IFFrameViewDependence {
    private static final Logger logger = LoggerFactory.getLogger(FFrameOverView.class);
    public static final String PERSISTENCE_DEFINITION_NAME = "FFrameOverView";
    private static final String FFRAMEVIEWDEPENDENCE_FIELD = "fframeViewDependence";
    private MapContext assoc_map;
    private Envelope extent;
    private FFrameView fframeViewDependence;

    @Override
    protected void createImage(AffineTransform affineTransform, int width, int height, Point mapOrigin) throws ReadException, MapContextException {
        this.m_image = null;
        super.createImage(affineTransform, width, height, mapOrigin);
        Graphics2D g = this.m_image.createGraphics();
        Dimension size = this.getMapContext().getViewPort().getImageSize();
        Rectangle2D.Double r = new Rectangle2D.Double(0.0, 0.0, size.getWidth(), size.getHeight());
        this.drawAreaOfInterestBox(g, affineTransform, r, null);
        g.dispose();
    }

    protected void drawAreaOfInterestBox(Graphics2D g, AffineTransform at, Rectangle2D clip, PrintAttributes printAttributes) {
        if (this.assoc_map != null && this.assoc_map.getViewPort().getEnvelope() != null && this.getMapContext().getViewPort().getEnvelope() != null) {
            ViewPort vp = this.getMapContext().getViewPort();
            ViewPort vpOrig = this.assoc_map.getViewPort();
            if (this.extent == null) {
                this.extent = vpOrig.getAdjustedEnvelope();
            }
            BufferedImage ov_img = new BufferedImage(vp.getImageWidth(), vp.getImageHeight(), 2);
            Graphics ov_img_gra = ((Image)ov_img).getGraphics();
            ov_img_gra.setColor(new Color(0, 0, 0, 0));
            ov_img_gra.fillRect(0, 0, vp.getImageWidth(), vp.getImageHeight());
            Rectangle2D.Double aux = new Rectangle2D.Double(this.extent.getMinimum(0), this.extent.getMinimum(1), this.extent.getLength(0), this.extent.getLength(1));
            Rectangle2D extentPixels = vp.fromMapRectangle((Rectangle2D)aux);
            ov_img_gra.setColor(new Color(100, 100, 100, 100));
            ov_img_gra.fillRect((int)extentPixels.getMinX(), (int)extentPixels.getMinY(), (int)extentPixels.getWidth(), (int)extentPixels.getHeight());
            ov_img_gra.setColor(Color.red);
            ov_img_gra.drawRect((int)extentPixels.getMinX(), (int)extentPixels.getMinY(), (int)extentPixels.getWidth(), (int)extentPixels.getHeight());
            int aoi_top = (int)extentPixels.getMinY();
            int aoi_bottom = (int)extentPixels.getMaxY();
            int aoi_left = (int)extentPixels.getMinX();
            int aoi_right = (int)extentPixels.getMaxX();
            ov_img_gra.setColor(Color.darkGray);
            int cx = (int)extentPixels.getCenterX();
            int cy = (int)extentPixels.getCenterY();
            int maxx = vp.getImageWidth();
            int maxy = vp.getImageHeight();
            ov_img_gra.drawLine(cx, 0, cx, aoi_top);
            ov_img_gra.drawLine(cx, aoi_bottom, cx, maxy);
            ov_img_gra.drawLine(0, cy, aoi_left, cy);
            ov_img_gra.drawLine(aoi_right, cy, maxx, cy);
            Rectangle origClip = g.getClipBounds();
            g.setClip((int)clip.getX(), (int)clip.getY(), (int)clip.getWidth(), (int)clip.getHeight());
            g.drawImage((Image)ov_img, (int)clip.getX(), (int)clip.getY(), null);
            ov_img_gra.dispose();
            if (origClip != null) {
                g.setClip((int)((RectangularShape)origClip).getX(), (int)((RectangularShape)origClip).getY(), (int)((RectangularShape)origClip).getWidth(), (int)((RectangularShape)origClip).getHeight());
            } else {
                g.setClip(null);
            }
            this.extent = null;
        }
    }

    @Override
    protected void print(Graphics2D g, AffineTransform at, PrintAttributes printAttributes) {
        super.print(g, at, printAttributes);
        Rectangle2D.Double r = this.getBoundingBox(at);
        if (this.getMapContext() != null && this.getMapContext().getViewPort() != null) {
            ViewPort vp = this.getMapContext().getViewPort();
            Dimension oldSize = vp.getImageSize();
            vp.setImageSize(new Dimension((int)((RectangularShape)r).getWidth(), (int)((RectangularShape)r).getHeight()));
            this.drawAreaOfInterestBox(g, at, r, printAttributes);
            vp.setImageSize(oldSize);
        }
    }

    @Override
    public void setView(ViewDocument v) {
        this.viewDocument = v;
        if (this.fframeViewDependence == null) {
            return;
        }
        this.assoc_map = this.fframeViewDependence.getMapContext();
        if (v != null) {
            this.setViewMapContext(v.getMapOverViewContext());
        }
    }

    protected void setListeners() {
    }

    @Override
    public String getNameFFrame() {
        return PluginServices.getText((Object)this, (String)"Localizador") + this.num;
    }

    @Override
    public String getName() {
        return PERSISTENCE_DEFINITION_NAME;
    }

    @Override
    public FFrameOverView clone() throws CloneNotSupportedException {
        FFrameOverView frame = (FFrameOverView)super.clone();
        frame.setSelected(this.isSelected());
        return frame;
    }

    @Override
    public void setFFrameDependence(IFFrame f) {
        this.fframeViewDependence = (FFrameView)f;
    }

    @Override
    public IFFrame[] getFFrameDependence() {
        return new IFFrame[]{this.fframeViewDependence};
    }

    @Override
    public void refreshDependence(IFFrame fant, IFFrame fnew) {
        if (this.fframeViewDependence != null && this.fframeViewDependence.equals(fant) && fnew instanceof FFrameView) {
            FFrameView newFFView = (FFrameView)fnew;
            this.setView(newFFView.getView());
        }
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(FFrameOverView.class, PERSISTENCE_DEFINITION_NAME, "FFrameOverView persistence definition", null, null);
            definition.extend(manager.getDefinition("FFrameView"));
            definition.addDynFieldObject(FFRAMEVIEWDEPENDENCE_FIELD).setClassOfValue(FFrameView.class);
        }
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.fframeViewDependence = (FFrameView)state.get(FFRAMEVIEWDEPENDENCE_FIELD);
        this.setView(this.viewDocument);
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set(FFRAMEVIEWDEPENDENCE_FIELD, (Persistent)this.fframeViewDependence);
    }
}

