/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.fframes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.documents.layout.Attributes;
import org.gvsig.app.project.documents.layout.FLayoutUtilities;
import org.gvsig.app.project.documents.layout.fframes.AbstractFFrameViewDependence;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.fframes.IFFrameViewDependence;
import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class FFrameScaleBar
extends AbstractFFrameViewDependence
implements IFFrameViewDependence {
    public static final String PERSISTENCE_DEFINITION_NAME = "FFrameScaleBar";
    private static final String BINTERNALSET_FIELD = "bIntervalSet";
    private static final String DIF_FIELD = "dif";
    private static final String HASLEFT_FIELD = "hasleft";
    private static final String NAMEUNIT_FIELD = "nameUnit";
    private static final String NUMUNIT_FIELD = "numUnit";
    private static final String HEIGHT_FIELD = "height";
    private static final String STYLE_FIELD = "style";
    private static final String UNITS_FIELD = "units";
    private static final String INTERVAL_FIELD = "interval";
    private static final String NUMINTERVAL_FIELD = "numinterval";
    private static final String NUMLEFT_FIELD = "numleft";
    private static final String MAPUNITS_FIELD = "mapUnits";
    private static final String FONT_FIELD = "font";
    private static final String NUMDEC_FIELD = "numDec";
    private static final String BARCOLOR_FIELD = "barcolor";
    private static final String TEXTCOLOR_FIELD = "textcolor";
    private static final String SHOWNAMEUNITS_FIELD = "showNameUnits";
    private static final String SHOWDESCRIPTION_FIELD = "showDescription";
    private static final String ABOVENAME_FIELD = "aboveName";
    private static final String ABOVEINTERVALS_FIELD = "aboveIntervals";
    private static final String ABOVEDESCRIPTION_FIELD = "aboveDescription";
    private static final int NUMERO = 0;
    private static final int BARRA1 = 1;
    private static final int BARRA2 = 2;
    private static final int BARRA3 = 3;
    private static final int BARRA4 = 4;
    private double DIFDOWN = 1.5;
    private double DIFL = 30.0;
    private double DIFR = 30.0;
    private double DIFUP = 10.0;
    private boolean m_bIntervalSet = false;
    private int m_style = 0;
    private int m_units = 1;
    private int m_mapUnits = 1;
    private double m_interval = 1.0;
    private int m_numinterval = 3;
    private int m_numleft = 2;
    private double m_height = 0.0;
    private double m_typeUnit = Attributes.getConversionFactorToCm(1);
    private String m_nameUnit = null;
    private double m_numUnit = 0.0;
    private double m_dif = 1.0;
    private int m_hasleft = 0;
    private Font m_font = new Font("SansSerif", 0, 9);
    private Color barcolor = Color.black;
    private Color textcolor = Color.black;
    private boolean showNameUnits = true;
    private boolean showDescription = false;
    private boolean aboveName = false;
    private boolean aboveIntervals = true;
    private boolean aboveDescription = false;
    private int numDec = 0;
    public static NumberFormat numberFormat = NumberFormat.getInstance();
    private static final int DUIB = 0;
    private static final int DUBI = 1;
    private static final int DBIU = 2;
    private static final int DIBU = 3;
    private static final int UIBD = 4;
    private static final int UBID = 5;
    private static final int IBUD = 6;
    private static final int BIUD = 7;

    @Override
    public void refreshDependence(IFFrame fant, IFFrame fnew) {
        super.refreshDependence(fant, fnew);
        if (this.fframeViewDependence != null) {
            this.setMapUnits(this.fframeViewDependence.getMapUnits());
            this.setHeight(fnew.getBoundBox().height);
        }
    }

    @Override
    public void setFFrameDependence(IFFrame f) {
        super.setFFrameDependence(f);
        if (this.fframeViewDependence == null) {
            return;
        }
        this.setMapUnits(this.fframeViewDependence.getMapUnits());
        this.setHeight(f.getBoundBox().height);
    }

    public MapContext getFMap() {
        return this.fframeViewDependence.getMapContext();
    }

    public void setStyle(int s) {
        this.m_style = s;
    }

    public int getStyle() {
        return this.m_style;
    }

    public void setInterval(double s) {
        this.m_interval = s;
        if (this.m_numleft != 0) {
            this.m_hasleft = 1;
        }
        Rectangle2D.Double rect = this.getBoundBox();
        double difL = rect.width / this.DIFL;
        double difR = rect.width / this.DIFR;
        double n = rect.width - difL - difR;
        this.m_numUnit = this.m_interval * this.m_typeUnit / this.getScaleView();
        this.m_numinterval = (int)(n / this.m_numUnit) - this.m_hasleft;
        this.m_dif = 1.0;
    }

    public String obtainInterval() {
        if (this.fframeViewDependence != null) {
            Rectangle2D.Double rect = this.getBoundBox();
            if (this.m_numleft != 0) {
                this.m_hasleft = 1;
            }
            double difL = rect.width / this.DIFL;
            double difR = rect.width / this.DIFR;
            double n = rect.width - difL - difR;
            this.m_numUnit = n / (double)(this.m_numinterval + this.m_hasleft);
            double scaleXunit = this.m_numUnit * this.getScaleView() / this.m_typeUnit;
            this.m_dif = this.getExact(scaleXunit);
            this.m_numUnit *= this.m_dif;
            this.m_interval = scaleXunit;
            return this.format(this.m_interval);
        }
        return "0";
    }

    public void setNumInterval(int s) {
        this.m_numinterval = s;
        if (this.m_numleft != 0) {
            this.m_hasleft = 1;
        }
        Rectangle2D.Double rect = this.getBoundBox();
        double difL = rect.width / this.DIFL;
        double difR = rect.width / this.DIFR;
        double n = rect.width - difL - difR;
        this.m_numUnit = n / (double)(this.m_numinterval + this.m_hasleft);
        double scaleXunit = this.m_numUnit * this.getScaleView() / this.m_typeUnit;
        this.m_dif = this.getExact(scaleXunit);
        this.m_numUnit *= this.m_dif;
        this.m_interval = scaleXunit * this.m_dif;
    }

    public int getNumInterval() {
        return this.m_numinterval;
    }

    public void setNumLeft(int s) {
        this.m_numleft = s;
        this.m_hasleft = this.m_numleft != 0 ? 1 : 0;
    }

    public int getNumLeft() {
        return this.m_numleft;
    }

    public void setIntervalSet(boolean b) {
        this.m_bIntervalSet = b;
    }

    public void setUnits(int s) {
        this.m_units = s;
        this.m_typeUnit = Attributes.getConversionFactorToCm(s);
        this.m_nameUnit = PluginServices.getText((Object)this, (String)MapContext.getDistanceNames()[s]);
    }

    public int getUnits() {
        return this.m_units;
    }

    public String getInterval() {
        return this.format(this.m_interval);
    }

    public void setHeight(double d) {
        this.m_height = d;
    }

    public void setMapUnits(int i) {
        this.m_mapUnits = i;
    }

    private double getScaleView() {
        if (this.fframeViewDependence == null) {
            return 1.0;
        }
        return this.fframeViewDependence.getScale();
    }

    @Override
    public void draw(Graphics2D g, AffineTransform at, Rectangle2D rv, BufferedImage imgBase) {
        Rectangle2D.Double r = this.getBoundingBox(at);
        g.rotate(Math.toRadians(this.getRotation()), r.x + r.width / 2.0, r.y + r.height / 2.0);
        if (this.intersects(rv, r)) {
            if (this.fframeViewDependence == null || this.fframeViewDependence.getMapContext() == null) {
                this.drawEmpty(g);
            } else {
                switch (this.m_style) {
                    case 0: {
                        double scalex = r.getWidth() / 8.0;
                        if (scalex > r.getHeight() / 8.0) {
                            scalex = r.getHeight() / 2.0;
                        }
                        g.setColor(this.textcolor);
                        if (this.m_font != null) {
                            this.m_font = new Font(this.m_font.getFontName(), this.m_font.getStyle(), (int)scalex);
                            g.setFont(this.m_font);
                        }
                        FontMetrics fm = g.getFontMetrics();
                        double d = r.getWidth();
                        double scl = this.getScaleView();
                        if (scl < 1.0) {
                            String unknowScale = PluginServices.getText((Object)this, (String)"escala_desconocida");
                            if ((double)fm.stringWidth(unknowScale) > d * 0.8) {
                                double dif = (double)fm.stringWidth(unknowScale) / (d * 0.8);
                                this.m_font = new Font(this.m_font.getName(), this.m_font.getStyle(), (int)((double)this.m_font.getSize() / dif));
                                g.setFont(this.m_font);
                            }
                            g.drawString(unknowScale, (int)r.x, (int)(r.y + r.height / 2.0));
                            return;
                        }
                        String scale = this.getDescription();
                        if ((double)fm.stringWidth(String.valueOf(this.m_interval)) > d * 0.8) {
                            double dif = (double)fm.stringWidth(String.valueOf(this.m_interval)) / (d * 0.8);
                            this.m_font = new Font(this.m_font.getName(), this.m_font.getStyle(), (int)((double)this.m_font.getSize() / dif));
                            g.setFont(this.m_font);
                        }
                        g.drawString(scale, (int)r.x, (int)(r.y + r.height / 2.0));
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        this.drawBar(this.m_style, g, at);
                    }
                }
            }
        }
        g.rotate(Math.toRadians(-this.getRotation()), r.x + r.width / 2.0, r.y + r.height / 2.0);
    }

    public void setBoundBox(Rectangle2D.Double r) {
        if (this.m_numUnit < 1.0 || this.fframeViewDependence == null || this.fframeViewDependence.getMapContext() == null) {
            super.setBoundBox(r);
            return;
        }
        double difL = r.width / this.DIFL;
        double difR = r.width / this.DIFR;
        if (this.m_bIntervalSet) {
            this.m_numinterval = (int)((r.width - (difL + difR)) * this.m_dif / this.m_numUnit) - this.m_hasleft;
        }
        if (this.m_numinterval < 1) {
            this.m_numinterval = 1;
            r.width = (double)(this.m_numinterval + this.m_hasleft) * this.m_numUnit + difL + difR;
        }
        this.getBoundBox().setRect(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    private void drawBar(int type, Graphics2D g, AffineTransform at) {
        Rectangle2D.Double rect = this.getBoundBox();
        Rectangle2D.Double r = this.getBoundingBox(at);
        double numleft = this.m_numleft;
        this.initDistances();
        double difDown = rect.height / this.DIFDOWN;
        double difUp = rect.height / this.DIFUP;
        double difL = rect.width / this.DIFL;
        double difR = rect.width / this.DIFR;
        double n = rect.width - difL - difR;
        g.setStroke(new BasicStroke(0.0f));
        if (!this.m_bIntervalSet) {
            this.m_numUnit = n / (double)(this.m_numinterval + this.m_hasleft);
            double scaleXunit = this.m_numUnit * this.getScaleView() / this.m_typeUnit;
            this.m_dif = this.getExact(scaleXunit);
            this.m_numUnit *= this.m_dif;
            this.m_interval = scaleXunit * this.m_dif;
        }
        if (this.m_bIntervalSet) {
            this.m_numUnit = this.m_interval * this.m_typeUnit / (this.m_dif * this.getScaleView());
            this.m_numinterval = (int)((rect.width - (difL + difR)) * this.m_dif / this.m_numUnit) - this.m_hasleft;
        }
        if (this.m_numinterval < 1) {
            this.m_numinterval = 1;
            rect.width = (double)(this.m_numinterval + this.m_hasleft) * this.m_numUnit + difL + difR;
        }
        double h = 0.0;
        if (type == 1) {
            h = rect.height - (difUp + difDown);
        } else if (type == 2 || type == 3) {
            h = (rect.height - (difUp + difDown)) / 2.0;
        }
        Rectangle2D.Double rectotal = FLayoutUtilities.fromSheetRect(new Rectangle2D.Double(rect.x + difL, rect.y + difUp, this.m_numUnit * (double)(this.m_hasleft + this.m_numinterval), h), at);
        g.setColor(this.barcolor);
        g.fillRect((int)rectotal.x, (int)rectotal.y, (int)rectotal.width, (int)rectotal.height);
        g.setColor(Color.white);
        g.fillRect((int)rectotal.x + 2, (int)rectotal.y + 2, (int)(rectotal.width - 3.0), (int)rectotal.height - 4);
        g.setColor(this.barcolor);
        this.m_font = this.m_font != null ? new Font(this.m_font.getFontName(), this.m_font.getStyle(), (int)(r.getHeight() / 4.0)) : new Font("SansSerif", 0, (int)(r.getHeight() / 4.0));
        g.setFont(this.m_font);
        Double interval = new Double(this.m_interval);
        if (interval.isNaN()) {
            String unknowScale = PluginServices.getText((Object)this, (String)"escala_desconocida");
            FontMetrics fm = g.getFontMetrics();
            double d = r.getWidth();
            if ((double)fm.stringWidth(unknowScale) > d * 0.8) {
                double dif = (double)fm.stringWidth(unknowScale) / (d * 0.8);
                this.m_font = new Font(this.m_font.getName(), this.m_font.getStyle(), (int)((double)this.m_font.getSize() / dif));
                g.setFont(this.m_font);
            }
            g.drawString(unknowScale, (int)r.x, (int)(r.y + r.height / 2.0));
            return;
        }
        FontMetrics fm = g.getFontMetrics();
        String formatInterval = this.format(this.m_interval);
        double d = rectotal.getWidth() / (double)this.m_numinterval + (double)this.m_hasleft;
        double difpos = r.getHeight() / 4.0 * (double)formatInterval.length() / 4.0;
        if ((double)fm.stringWidth(formatInterval) > d * 0.7) {
            double dif = (double)fm.stringWidth(formatInterval) / (d * 0.7);
            difpos = d * 0.7 / 2.0;
            this.m_font = new Font(this.m_font.getName(), this.m_font.getStyle(), (int)((double)this.m_font.getSize() / dif));
            g.setFont(this.m_font);
        }
        for (int i = 0; i < this.m_numinterval; ++i) {
            Rectangle2D.Double recder = FLayoutUtilities.fromSheetRect(new Rectangle2D.Double(rect.x + difL + (this.m_numUnit * (double)i + (double)this.m_hasleft * this.m_numUnit), rect.y + difUp, this.m_numUnit, (rect.height - (difUp + difDown)) / 2.0), at);
            Rectangle2D.Double recderB = FLayoutUtilities.fromSheetRect(new Rectangle2D.Double(rect.x + difL + (this.m_numUnit * (double)i + (double)this.m_hasleft * this.m_numUnit), rect.y + difUp + (rect.height - (difUp + difDown)) / 2.0, this.m_numUnit, (rect.height - (difUp + difDown)) / 2.0), at);
            rectotal.y = recder.y;
            recderB.height = rectotal.height - recder.height + 0.5;
            if (this.m_numleft % 2 == 0) {
                if (i % 2 == 0) {
                    if (type == 1 || type == 2) {
                        this.fillRect(g, recder);
                    } else if (type == 3) {
                        g.drawRect((int)recder.x, (int)recder.y, (int)recder.width, (int)recder.height);
                    }
                } else if (type == 1) {
                    this.fillRect(g, recderB);
                }
            } else if (i % 2 != 0) {
                if (type == 1 || type == 2) {
                    this.fillRect(g, recder);
                } else if (type == 3) {
                    g.drawRect((int)recderB.x, (int)recderB.y, (int)recderB.width, (int)recderB.height);
                }
            } else if (type == 1) {
                this.fillRect(g, recderB);
            }
            String interString = this.format(this.m_interval * (double)i);
            Point2D.Double p = null;
            p = this.isAboveIntervals() ? new Point2D.Double(recder.x - difpos, r.getMinY() + r.getHeight() / this.DIFUP) : new Point2D.Double(recder.x - difpos, r.getHeight() / 4.0 + r.getMaxY() - r.getHeight() / this.DIFDOWN);
            if (i == 0) {
                double dif0 = recder.x - (double)(fm.stringWidth(interString) / 2);
                p = new Point2D.Double(dif0, p.getY());
            }
            this.drawInterval(g, interString, p);
        }
        String interString = this.format(this.m_interval * (double)this.m_numinterval);
        Point2D.Double p = null;
        p = this.isAboveIntervals() ? new Point2D.Double(rectotal.getMaxX() - difpos, r.getMinY() + r.getHeight() / this.DIFUP) : new Point2D.Double(rectotal.getMaxX() - difpos, r.getHeight() / 4.0 + r.getMaxY() - r.getHeight() / this.DIFDOWN);
        this.drawInterval(g, interString, p);
        for (int i = 0; i < this.m_numleft; ++i) {
            Rectangle2D.Double reciz = FLayoutUtilities.fromSheetRect(new Rectangle2D.Double(rect.x + difL + this.m_numUnit / (double)this.m_numleft * (double)i, rect.y + difUp, this.m_numUnit / numleft, (rect.height - (difUp + difDown)) / 2.0), at);
            Rectangle2D.Double recizB = FLayoutUtilities.fromSheetRect(new Rectangle2D.Double(rect.x + difL + this.m_numUnit / (double)this.m_numleft * (double)i, rect.y + difUp + (rect.height - (difUp + difDown)) / 2.0, this.m_numUnit / numleft, (rect.height - (difUp + difDown)) / 2.0), at);
            reciz.y = rectotal.y;
            recizB.height = rectotal.height - reciz.height + 0.5;
            if (i % 2 == 0) {
                if (type == 1 || type == 2) {
                    this.fillRect(g, reciz);
                    continue;
                }
                if (type != 3) continue;
                g.drawRect((int)reciz.x, (int)reciz.y, (int)reciz.width, (int)reciz.height);
                continue;
            }
            if (type != 1) continue;
            this.fillRect(g, recizB);
        }
        if (this.m_numleft > 0) {
            interString = this.format(this.m_interval);
            p = this.isAboveIntervals() ? new Point2D.Double(rectotal.x - difpos, r.getMinY() + r.getHeight() / this.DIFUP) : new Point2D.Double(rectotal.x - difpos, r.getHeight() / 4.0 + r.getMaxY() - r.getHeight() / this.DIFDOWN);
            this.drawInterval(g, interString, p);
        }
        if (this.m_numleft == 0) {
            Rectangle2D.Double recAux = FLayoutUtilities.fromSheetRect(new Rectangle2D.Double(rect.x + difL + this.m_numUnit / 1.0 * 0.0, rect.y + difUp, this.m_numUnit / 1.0, (rect.height - (difUp + difDown)) / 2.0), at);
            rectotal.x += recAux.width;
            rectotal.width -= recAux.width;
        }
        g.drawRect((int)rectotal.x, (int)rectotal.y, (int)rectotal.width, (int)rectotal.height);
        this.drawNameUnitsAndDescriptions(g, r);
    }

    private void initDistances() {
        int numUp = 0;
        int numDown = 0;
        this.DIFDOWN = 30.0;
        this.DIFL = 40.0;
        this.DIFR = 40.0;
        this.DIFUP = 30.0;
        if (this.isAboveName()) {
            ++numUp;
        } else {
            ++numDown;
        }
        if (this.isAboveIntervals()) {
            ++numUp;
        } else {
            ++numDown;
        }
        if (this.isAboveDescription()) {
            ++numUp;
        } else {
            ++numDown;
        }
        if (numDown == 1) {
            this.DIFDOWN = 3.0;
        } else if (numDown == 2) {
            this.DIFDOWN = 2.0;
        } else if (numDown == 3) {
            this.DIFDOWN = 1.2;
        }
        if (numUp == 1) {
            this.DIFUP = 3.0;
        } else if (numUp == 2) {
            this.DIFUP = 2.0;
        } else if (numUp == 3) {
            this.DIFUP = 1.2;
        }
    }

    private void drawNameUnitsAndDescriptions(Graphics g, Rectangle2D.Double rec) {
        FontMetrics fm = g.getFontMetrics();
        Point2D.Double pD = null;
        Point2D.Double pU = null;
        g.setColor(this.textcolor);
        switch (this.getFormat()) {
            case 0: {
                pD = new Point2D.Double(rec.getCenterX() - (double)(fm.stringWidth(this.getDescription()) / 2), rec.getMinY() + rec.getHeight() / 9.0 + (double)(fm.getHeight() / 2));
                pU = new Point2D.Double(rec.getCenterX() - (double)(fm.stringWidth(this.m_nameUnit) / 2), rec.getMinY() + rec.getHeight() / 3.0 + (double)(fm.getHeight() / 2));
                break;
            }
            case 1: {
                pD = new Point2D.Double(rec.getCenterX() - (double)(fm.stringWidth(this.getDescription()) / 2), rec.getMinY() + rec.getHeight() / 9.0 + (double)(fm.getHeight() / 2));
                pU = new Point2D.Double(rec.getCenterX() - (double)(fm.stringWidth(this.m_nameUnit) / 2), rec.getMinY() + rec.getHeight() / 3.0 + (double)(fm.getHeight() / 2));
                break;
            }
            case 2: {
                pD = new Point2D.Double(rec.getCenterX() - (double)(fm.stringWidth(this.getDescription()) / 2), rec.getMinY() + rec.getHeight() / 9.0 + (double)(fm.getHeight() / 2));
                pU = new Point2D.Double(rec.getCenterX() - (double)(fm.stringWidth(this.m_nameUnit) / 2), rec.getMaxY() - rec.getHeight() / 9.0 + (double)(fm.getHeight() / 3));
                break;
            }
            case 3: {
                pD = new Point2D.Double(rec.getCenterX() - (double)(fm.stringWidth(this.getDescription()) / 2), rec.getMinY() + rec.getHeight() / 9.0 + (double)(fm.getHeight() / 2));
                pU = new Point2D.Double(rec.getCenterX() - (double)(fm.stringWidth(this.m_nameUnit) / 2), rec.getMaxY() - rec.getHeight() / 9.0 + (double)(fm.getHeight() / 3));
                break;
            }
            case 4: {
                pD = new Point2D.Double(rec.getCenterX() - (double)(fm.stringWidth(this.getDescription()) / 2), rec.getMaxY() - rec.getHeight() / 9.0 + (double)(fm.getHeight() / 3));
                pU = new Point2D.Double(rec.getCenterX() - (double)(fm.stringWidth(this.m_nameUnit) / 2), rec.getMinY() + rec.getHeight() / 9.0 + (double)(fm.getHeight() / 2));
                break;
            }
            case 5: {
                pD = new Point2D.Double(rec.getCenterX() - (double)(fm.stringWidth(this.getDescription()) / 2), rec.getMaxY() - rec.getHeight() / 9.0 + (double)(fm.getHeight() / 3));
                pU = new Point2D.Double(rec.getCenterX() - (double)(fm.stringWidth(this.m_nameUnit) / 2), rec.getMinY() + rec.getHeight() / 9.0 + (double)(fm.getHeight() / 2));
                break;
            }
            case 6: {
                pD = new Point2D.Double(rec.getCenterX() - (double)(fm.stringWidth(this.getDescription()) / 2), rec.getMaxY() - rec.getHeight() / 3.0 + (double)(fm.getHeight() / 3));
                pU = new Point2D.Double(rec.getCenterX() - (double)(fm.stringWidth(this.m_nameUnit) / 2), rec.getMaxY() - rec.getHeight() / 9.0 + (double)(fm.getHeight() / 3));
                break;
            }
            case 7: {
                pD = new Point2D.Double(rec.getCenterX() - (double)(fm.stringWidth(this.getDescription()) / 2), rec.getMaxY() - rec.getHeight() / 3.0 + (double)(fm.getHeight() / 3));
                pU = new Point2D.Double(rec.getCenterX() - (double)(fm.stringWidth(this.m_nameUnit) / 2), rec.getMaxY() - rec.getHeight() / 9.0 + (double)(fm.getHeight() / 3));
            }
        }
        if (this.isShowNameUnits()) {
            g.drawString(this.m_nameUnit, (int)pU.x, (int)pU.y);
        }
        if (this.isShowDescription()) {
            g.drawString(this.getDescription(), (int)pD.x, (int)pD.y);
        }
    }

    public void setFont(Font f) {
        this.m_font = f;
    }

    public Font getFont() {
        return new Font(this.m_font.getFontName(), this.m_font.getStyle(), 9);
    }

    public boolean isbIntervalSet() {
        return this.m_bIntervalSet;
    }

    public void setbIntervalSet(boolean b) {
        this.m_bIntervalSet = b;
    }

    private double getExact(double total) {
        int NUM = 1;
        double t = 0.0;
        double dif = 1.0;
        Double d = new Double(total);
        Long l = new Long(d.longValue());
        int num = l.toString().length();
        t = (double)((long)(total / Math.pow(10.0, num - NUM))) * Math.pow(10.0, num - NUM);
        dif = t / total;
        if (dif == 0.0) {
            return 1.0;
        }
        return dif;
    }

    private void fillRect(Graphics2D g, Rectangle2D.Double r) {
        g.fillRect((int)r.x, (int)r.y, (int)r.width, (int)r.height);
    }

    private void drawInterval(Graphics2D g, String inter, Point2D.Double p) {
        g.setColor(this.textcolor);
        g.drawString(inter, (int)p.x, (int)p.y);
        g.setColor(this.barcolor);
    }

    @Override
    public String getNameFFrame() {
        return PluginServices.getText((Object)this, (String)"escala") + this.num;
    }

    @Override
    public String getName() {
        return PERSISTENCE_DEFINITION_NAME;
    }

    public void setBarColor(Color color) {
        this.barcolor = color;
    }

    public void setTextColor(Color color) {
        this.textcolor = color;
    }

    public Color getBarColor() {
        return this.barcolor;
    }

    public Color getTextColor() {
        return this.textcolor;
    }

    public boolean isShowNameUnits() {
        return this.showNameUnits;
    }

    public void setShowNameUnits(boolean showNameUnits) {
        this.showNameUnits = showNameUnits;
    }

    public boolean isAboveDescription() {
        return this.aboveDescription;
    }

    public void setAboveDescription(boolean aboveDescription) {
        this.aboveDescription = aboveDescription;
    }

    public boolean isAboveIntervals() {
        return this.aboveIntervals;
    }

    public void setAboveIntervals(boolean aboveIntervals) {
        this.aboveIntervals = aboveIntervals;
    }

    public boolean isAboveName() {
        return this.aboveName;
    }

    public void setAboveName(boolean aboveName) {
        this.aboveName = aboveName;
    }

    public boolean isShowDescription() {
        return this.showDescription;
    }

    public void setShowDescription(boolean showDescription) {
        this.showDescription = showDescription;
    }

    public String getDescription() {
        if (this.fframeViewDependence != null) {
            if (this.fframeViewDependence.getScale() == 0.0) {
                return PluginServices.getText((Object)this, (String)"escala_desconocida");
            }
            return "1:" + Math.round(this.fframeViewDependence.getScale());
        }
        return "1:";
    }

    public void print(Graphics2D g, AffineTransform at, Geometry geom, PrintAttributes properties) {
        this.draw(g, at, null, null);
    }

    public String format(double d) {
        if (d % (double)((long)d) != 0.0) {
            numberFormat.setMaximumFractionDigits(this.getNumDec());
        } else {
            numberFormat.setMaximumFractionDigits(0);
        }
        return numberFormat.format(d);
    }

    public int getNumDec() {
        return this.numDec;
    }

    public void setNumDec(int numDec) {
        this.numDec = numDec;
    }

    public void initialize() {
    }

    private int getFormat() {
        if (this.isAboveDescription()) {
            if (this.isAboveName()) {
                if (this.isAboveIntervals()) {
                    return 0;
                }
                return 1;
            }
            if (this.isAboveIntervals()) {
                return 3;
            }
            return 2;
        }
        if (this.isAboveName()) {
            if (this.isAboveIntervals()) {
                return 4;
            }
            return 5;
        }
        if (this.isAboveIntervals()) {
            return 6;
        }
        return 7;
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(FFrameScaleBar.class, PERSISTENCE_DEFINITION_NAME, "FFrameScaleBar persistence definition", null, null);
            definition.extend(manager.getDefinition("AbstractFFrameViewDependence"));
            definition.addDynFieldBoolean(BINTERNALSET_FIELD).setMandatory(true);
            definition.addDynFieldDouble(DIF_FIELD).setMandatory(true);
            definition.addDynFieldInt(HASLEFT_FIELD).setMandatory(true);
            definition.addDynFieldString(NAMEUNIT_FIELD).setMandatory(true);
            definition.addDynFieldDouble(NUMUNIT_FIELD).setMandatory(true);
            definition.addDynFieldDouble(HEIGHT_FIELD).setMandatory(true);
            definition.addDynFieldInt(STYLE_FIELD).setMandatory(true);
            definition.addDynFieldInt(UNITS_FIELD);
            definition.addDynFieldDouble(INTERVAL_FIELD).setMandatory(true);
            definition.addDynFieldInt(NUMINTERVAL_FIELD).setMandatory(true);
            definition.addDynFieldInt(NUMLEFT_FIELD).setMandatory(true);
            definition.addDynFieldInt(MAPUNITS_FIELD).setMandatory(true);
            definition.addDynFieldObject(FONT_FIELD).setClassOfValue(Font.class).setMandatory(true);
            definition.addDynFieldInt(NUMDEC_FIELD).setMandatory(true);
            definition.addDynFieldObject(BARCOLOR_FIELD).setClassOfValue(Color.class);
            definition.addDynFieldObject(TEXTCOLOR_FIELD).setClassOfValue(Color.class);
            definition.addDynFieldBoolean(SHOWNAMEUNITS_FIELD);
            definition.addDynFieldBoolean(SHOWDESCRIPTION_FIELD);
            definition.addDynFieldBoolean(ABOVENAME_FIELD);
            definition.addDynFieldBoolean(ABOVEINTERVALS_FIELD);
            definition.addDynFieldBoolean(ABOVEDESCRIPTION_FIELD);
        }
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.m_bIntervalSet = state.getBoolean(BINTERNALSET_FIELD);
        this.m_dif = state.getDouble(DIF_FIELD);
        this.m_hasleft = state.getInt(HASLEFT_FIELD);
        this.m_nameUnit = state.getString(NAMEUNIT_FIELD);
        this.m_numUnit = state.getDouble(NUMUNIT_FIELD);
        this.m_height = state.getDouble(HEIGHT_FIELD);
        this.m_style = state.getInt(STYLE_FIELD);
        this.m_units = state.getInt(UNITS_FIELD);
        this.m_interval = state.getDouble(INTERVAL_FIELD);
        this.m_numinterval = state.getInt(NUMINTERVAL_FIELD);
        this.m_numleft = state.getInt(NUMLEFT_FIELD);
        this.m_mapUnits = state.getInt(MAPUNITS_FIELD);
        this.m_font = (Font)state.get(FONT_FIELD);
        this.numDec = state.getInt(NUMDEC_FIELD);
        this.barcolor = (Color)state.get(BARCOLOR_FIELD);
        this.textcolor = (Color)state.get(TEXTCOLOR_FIELD);
        this.showNameUnits = state.getBoolean(SHOWNAMEUNITS_FIELD);
        this.showDescription = state.getBoolean(SHOWDESCRIPTION_FIELD);
        this.aboveName = state.getBoolean(ABOVENAME_FIELD);
        this.aboveIntervals = state.getBoolean(ABOVEINTERVALS_FIELD);
        this.aboveDescription = state.getBoolean(ABOVEDESCRIPTION_FIELD);
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set(BINTERNALSET_FIELD, this.m_bIntervalSet);
        state.set(DIF_FIELD, this.m_dif);
        state.set(HASLEFT_FIELD, this.m_hasleft);
        state.set(NAMEUNIT_FIELD, this.m_nameUnit);
        state.set(NUMUNIT_FIELD, this.m_numUnit);
        state.set(HEIGHT_FIELD, this.m_height);
        state.set(STYLE_FIELD, this.m_style);
        state.set(UNITS_FIELD, this.m_units);
        state.set(INTERVAL_FIELD, this.m_interval);
        state.set(NUMINTERVAL_FIELD, this.m_numinterval);
        state.set(NUMLEFT_FIELD, this.m_numleft);
        state.set(MAPUNITS_FIELD, this.m_mapUnits);
        state.set(FONT_FIELD, (Object)this.m_font);
        state.set(NUMDEC_FIELD, this.numDec);
        state.set(BARCOLOR_FIELD, (Object)this.barcolor);
        state.set(TEXTCOLOR_FIELD, (Object)this.textcolor);
        state.set(SHOWNAMEUNITS_FIELD, this.showNameUnits);
        state.set(SHOWDESCRIPTION_FIELD, this.showDescription);
        state.set(ABOVENAME_FIELD, this.aboveName);
        state.set(ABOVEINTERVALS_FIELD, this.aboveIntervals);
        state.set(ABOVEDESCRIPTION_FIELD, this.aboveDescription);
    }
}

