/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.fframes;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.documents.layout.fframes.FFrameBasic;
import org.gvsig.app.project.documents.layout.fframes.FFrameGroup;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.fframes.IFFrameGroupSelectable;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class FFrameTable
extends FFrameGroup
implements IFFrameGroupSelectable {
    public static final String PERSISTENCE_DEFINITION_NAME = "FFrameTable";
    private static final String NUMCOLUMNS_FIELD = "numColumns";
    private static final String NUMROWS_FIELD = "numRows";
    private int numColumns = 2;
    private int numRows = 2;
    private static final AffineTransform identity = new AffineTransform();
    private boolean selectFFrameBasic = false;
    private static Image iMove = null;

    @Override
    public void draw(Graphics2D g, AffineTransform at, Rectangle2D rv, BufferedImage imgBase) {
        Rectangle2D.Double r = this.getBoundingBox(at);
        g.setColor(Color.black);
        g.rotate(Math.toRadians(this.getRotation()), r.x + r.width / 2.0, r.y + r.height / 2.0);
        this.drawRectangles(g, at, rv, imgBase);
        g.rotate(Math.toRadians(-this.getRotation()), r.x + r.width / 2.0, r.y + r.height / 2.0);
        super.draw(g, at, rv, imgBase);
    }

    private void drawRectangles(Graphics2D g, AffineTransform at, Rectangle2D rv, BufferedImage imgBase) {
        IFFrame[] fframes;
        for (IFFrame fframe : fframes = this.getFFrames()) {
            FFrameBasic basic = (FFrameBasic)fframe;
            basic.draw(g, at, rv, imgBase);
        }
    }

    public void drawBox(Rectangle2D r, Graphics2D g) {
        IFFrame[] fframes;
        this.calculateTable(r);
        for (IFFrame fframe : fframes = this.getFFrames()) {
            FFrameBasic basic = (FFrameBasic)fframe;
            basic.draw(g, identity, null, null);
        }
    }

    public void print(Graphics2D g, AffineTransform at) throws ReadException {
        this.draw(g, at, null, null);
    }

    @Override
    public String getNameFFrame() {
        return PluginServices.getText((Object)this, (String)"box") + this.num;
    }

    @Override
    public String getName() {
        return PERSISTENCE_DEFINITION_NAME;
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public void setNumColumns(int numColumns) {
        this.numColumns = numColumns;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public void setNumRows(int numRows) {
        this.numRows = numRows;
    }

    public void calculateTable(Rectangle2D r) {
        double wC = r.getWidth() / (double)this.numColumns;
        double hR = r.getHeight() / (double)this.numRows;
        int rows = this.numRows;
        this.clearFFrames();
        for (int i = 0; i < this.numColumns; ++i) {
            for (int j = 0; j < rows; ++j) {
                double x = r.getX() + wC * (double)i;
                double y = r.getY() + hR * (double)j;
                double w = wC;
                double h = hR;
                Rectangle2D.Double rBasic = new Rectangle2D.Double(x, y, w, h);
                FFrameBasic basic = (FFrameBasic)this.layoutManager.createFrame("FFrameBasic");
                basic.setRectangle(rBasic);
                this.addFFrame(basic);
            }
        }
    }

    @Override
    public void selectFFrame(boolean b) {
        this.selectFFrameBasic = b;
    }

    @Override
    public IFFrame joinFFrame() {
        IFFrame[] fframes = this.getFFrames();
        Rectangle2D r = null;
        for (int i = fframes.length - 1; i >= 0; --i) {
            if (fframes[i].getSelected() == 0) continue;
            if (r == null) {
                r = (Rectangle2D)fframes[i].getBoundBox().clone();
            } else {
                r.add(fframes[i].getBoundBox());
            }
            this.removeFFrame(i);
        }
        if (r != null) {
            FFrameBasic basic = (FFrameBasic)this.layoutManager.createFrame("FFrameBasic");
            basic.setRectangle(r);
            this.addFFrame(basic);
            return this;
        }
        return null;
    }

    @Override
    public void setSelected(Point2D p, MouseEvent e) {
        if (!this.selectFFrameBasic) {
            super.setSelected(p, e);
        } else {
            this.setSelectedGroup(p, e);
        }
    }

    @Override
    public boolean contains(Point2D p) {
        if (!this.selectFFrameBasic) {
            return super.contains(p);
        }
        return this.contains(p);
    }

    @Override
    public void drawHandlers(Graphics2D g) {
        if (!this.selectFFrameBasic) {
            super.drawHandlers(g);
        } else {
            this.drawHandlersGroup(g);
        }
    }

    @Override
    public int getContains(Point2D p) {
        if (!this.selectFFrameBasic) {
            return super.getContains(p);
        }
        return this.getContainsGroup(p);
    }

    @Override
    public Rectangle2D getMovieRect(int difx, int dify) {
        return this.getMovieRect(difx, dify, false);
    }

    @Override
    public Rectangle2D getMovieRect(int difx, int dify, boolean prop) {
        Rectangle2D r = super.getMovieRect(difx, dify, prop);
        if (!this.selectFFrameBasic) {
            return r;
        }
        r = super.getMovieRect(0, 0, prop);
        return r;
    }

    @Override
    public Rectangle2D getMovieRectGroup(int difX, int difY) {
        Rectangle2D r = null;
        IFFrame[] fframes = this.getFFrames();
        ArrayList<IFFrame> selected = new ArrayList<IFFrame>();
        for (IFFrame fframe : fframes) {
            if (fframe.getSelected() == 0) continue;
            selected.add(fframe);
        }
        for (int i = 0; i < selected.size(); ++i) {
            if (i == 0) {
                r = ((IFFrame)selected.get(i)).getMovieRect(difX, difY);
                continue;
            }
            r.add(((IFFrame)selected.get(i)).getMovieRect(difX, difY));
        }
        return r;
    }

    @Override
    public int getContainsGroup(Point2D p) {
        IFFrame[] fframes;
        ArrayList<IFFrame> selected = new ArrayList<IFFrame>();
        for (IFFrame fframe : fframes = this.getFFrames()) {
            int contains = fframe.getContains(p);
            if (contains == 0) continue;
            if (contains == 9) {
                selected.add(fframe);
                continue;
            }
            return contains;
        }
        if (!selected.isEmpty()) {
            return ((IFFrame)selected.get(0)).getContains(p);
        }
        return 0;
    }

    @Override
    public void drawHandlersGroup(Graphics2D g) {
        IFFrame[] fframes;
        int size = 8;
        g.setColor(Color.gray);
        for (IFFrame fframe : fframes = this.getFFrames()) {
            if (fframe.getSelected() == 0) continue;
            Rectangle2D.Double r = fframe.getBoundingBox(null);
            Point2D.Double p = new Point2D.Double();
            g.rotate(Math.toRadians(this.getRotation()), ((RectangularShape)r).getX() + ((RectangularShape)r).getWidth() / 2.0, ((RectangularShape)r).getY() + ((RectangularShape)r).getHeight() / 2.0);
            AffineTransform atRotate = new AffineTransform();
            atRotate.rotate(Math.toRadians(this.getRotation()), ((RectangularShape)r).getX() + ((RectangularShape)r).getWidth() / 2.0, ((RectangularShape)r).getY() + ((RectangularShape)r).getHeight() / 2.0);
            g.fillRect((int)((RectangularShape)r).getX() - size / 2, (int)((RectangularShape)r).getY() - size / 2, size, size);
            atRotate.transform(new Point2D.Double(((RectangularShape)r).getX() - (double)(size / 2), ((RectangularShape)r).getY() - (double)(size / 2)), p);
            this.no.setRect((int)((Point2D)p).getX(), (int)((Point2D)p).getY(), size, size);
            g.fillRect((int)r.getMaxX() - size / 2, (int)((RectangularShape)r).getY() - size / 2, size, size);
            atRotate.transform(new Point2D.Double(r.getMaxX() - (double)(size / 2), ((RectangularShape)r).getY() - (double)(size / 2)), p);
            this.ne.setRect((int)((Point2D)p).getX(), (int)((Point2D)p).getY(), size, size);
            g.fillRect((int)((RectangularShape)r).getX() - size / 2, (int)r.getMaxY() - size / 2, size, size);
            atRotate.transform(new Point2D.Double(((RectangularShape)r).getX() - (double)(size / 2), r.getMaxY() - (double)(size / 2)), p);
            this.so.setRect((int)((Point2D)p).getX(), (int)((Point2D)p).getY(), size, size);
            g.fillRect((int)r.getMaxX() - size / 2, (int)r.getMaxY() - size / 2, size, size);
            atRotate.transform(new Point2D.Double(r.getMaxX() - (double)(size / 2), r.getMaxY() - (double)(size / 2)), p);
            this.se.setRect((int)((Point2D)p).getX(), (int)((Point2D)p).getY(), size, size);
            g.fillRect((int)r.getCenterX() - size / 2, (int)((RectangularShape)r).getY() - size / 2, size, size);
            atRotate.transform(new Point2D.Double(r.getCenterX() - (double)(size / 2), ((RectangularShape)r).getY() - (double)(size / 2)), p);
            this.n.setRect((int)((Point2D)p).getX(), (int)((Point2D)p).getY(), size, size);
            g.fillRect((int)r.getCenterX() - size / 2, (int)r.getMaxY() - size / 2, size, size);
            atRotate.transform(new Point2D.Double(r.getCenterX() - (double)(size / 2), r.getMaxY() - (double)(size / 2)), p);
            this.s.setRect((int)((Point2D)p).getX(), (int)((Point2D)p).getY(), size, size);
            g.fillRect((int)((RectangularShape)r).getX() - size / 2, (int)r.getCenterY() - size / 2, size, size);
            atRotate.transform(new Point2D.Double(((RectangularShape)r).getX() - (double)(size / 2), r.getCenterY() - (double)(size / 2)), p);
            this.o.setRect((int)((Point2D)p).getX(), (int)((Point2D)p).getY(), size, size);
            g.fillRect((int)r.getMaxX() - size / 2, (int)r.getCenterY() - size / 2, size, size);
            atRotate.transform(new Point2D.Double(r.getMaxX() - (double)(size / 2), r.getCenterY() - (double)(size / 2)), p);
            this.e.setRect((int)((Point2D)p).getX() - size / 2, (int)((Point2D)p).getY() - size / 2, size, size);
            g.rotate(Math.toRadians(-this.getRotation()), ((RectangularShape)r).getX() + ((RectangularShape)r).getWidth() / 2.0, ((RectangularShape)r).getY() + ((RectangularShape)r).getHeight() / 2.0);
        }
    }

    @Override
    public boolean containsGroup(Point2D p) {
        IFFrame[] fframes;
        for (IFFrame fframe : fframes = this.getFFrames()) {
            if (!fframe.contains(p)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setSelectedGroup(Point2D p, MouseEvent e) {
        IFFrame[] fframes = this.getFFrames();
        if (!e.isShiftDown()) {
            for (IFFrame fframe : fframes) {
                fframe.setSelected(false);
            }
            for (IFFrame fframe : fframes) {
                fframe.setSelected(p, e);
            }
        } else {
            for (IFFrame fframe : fframes) {
                if (!fframe.contains(p)) continue;
                if (fframe.getSelected() == 0) {
                    fframe.setSelected(p, e);
                    continue;
                }
                fframe.setSelected(false);
            }
        }
    }

    @Override
    public int getSelectedGroup() {
        return 0;
    }

    @Override
    public Image getMapCursor(Point2D p) {
        if (!this.selectFFrameBasic) {
            return super.getMapCursor(p);
        }
        return this.getMapCursorGroup(p);
    }

    @Override
    public Image getMapCursorGroup(Point2D p) {
        int select = this.getContains(p);
        switch (select) {
            case 9: {
                return iMove;
            }
        }
        return null;
    }

    public static void initializeIcons() {
        iMove = PluginServices.getIconTheme().get("graphic-move-icon").getImage();
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(FFrameTable.class, PERSISTENCE_DEFINITION_NAME, "FFrameTable persistence definition", null, null);
            definition.extend(manager.getDefinition("FFrameGroup"));
            definition.addDynFieldInt(NUMCOLUMNS_FIELD).setMandatory(true);
            definition.addDynFieldInt(NUMROWS_FIELD).setMandatory(true);
        }
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.numColumns = state.getInt(NUMCOLUMNS_FIELD);
        this.numRows = state.getInt(NUMROWS_FIELD);
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set(NUMCOLUMNS_FIELD, this.numColumns);
        state.set(NUMROWS_FIELD, this.numRows);
    }
}

