/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.fframes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiFrame.NewStatusBar;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.layout.DefaultLayoutNotification;
import org.gvsig.app.project.documents.layout.FLayoutFunctions;
import org.gvsig.app.project.documents.layout.FLayoutUtilities;
import org.gvsig.app.project.documents.layout.TocModelChangedNotification;
import org.gvsig.app.project.documents.layout.fframes.FFrame;
import org.gvsig.app.project.documents.layout.fframes.FFrameGrid;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.fframes.IFFrameUseFMap;
import org.gvsig.app.project.documents.layout.fframes.IFFrameUseProject;
import org.gvsig.app.project.documents.layout.fframes.LayoutPanelListener;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.MapContextException;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.events.AtomicEvent;
import org.gvsig.fmap.mapcontext.events.ColorEvent;
import org.gvsig.fmap.mapcontext.events.ExtentEvent;
import org.gvsig.fmap.mapcontext.events.FMapEvent;
import org.gvsig.fmap.mapcontext.events.ProjectionEvent;
import org.gvsig.fmap.mapcontext.events.listeners.AtomicEventListener;
import org.gvsig.fmap.mapcontext.events.listeners.ViewPortListener;
import org.gvsig.fmap.mapcontext.layers.CancelationException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.LayerCollectionEvent;
import org.gvsig.fmap.mapcontext.layers.LayerCollectionListener;
import org.gvsig.fmap.mapcontext.layers.LayerEvent;
import org.gvsig.fmap.mapcontext.layers.LayerPositionEvent;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.legend.events.LegendChangedEvent;
import org.gvsig.fmap.mapcontext.rendering.legend.events.listeners.LegendListener;
import org.gvsig.gui.beans.Messages;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FFrameView
extends FFrame
implements IFFrameUseProject,
IFFrameUseFMap,
LayoutPanelListener {
    private static final Logger logger = LoggerFactory.getLogger(FFrameView.class);
    public static final String PERSISTENCE_DEFINITION_NAME = "FFrameView";
    private static final String QUALITY_FIELD = "quality";
    private static final String MAPUNITS_FIELD = "mapUnits";
    private static final String SCALE_FIELD = "scale";
    private static final String VIEW_FIELD = "view";
    private static final String ENVELOPE_FIELD = "envelope";
    private static final String SHOWGRID_FIELD = "showGrid";
    private static final String GRID_FIELD = "gridview";
    private static final String HAS_TOC_FIELD = "hasToc";
    private static final String LAYER_SYNC_FIELD = "layerSync";
    private static final String EXTENT_SYNC_FIELD = "extentSync";
    private static final String SCALE_TYPE_FIELD = "scaleType";
    private static final String PERSIST_INDEPENDENT_FIELD = "persistIndependent";
    private static final String EXTENSION_FIELD = "extension";
    private static final String BLINKED_FIELD = "bLinked";
    private static final String MODE_FIELD = "mode";
    private static final String TYPESCALE_FIELD = "typeScale";
    private static final String MAPCONTEXT_FIELD = "mapContext";
    private static final String VIEWING_FIELD = "viewing";
    public static final int PRESENTATION = 0;
    public static final int DRAFT = 1;
    protected boolean syncLayers = true;
    protected boolean syncExtents = true;
    protected int quality = 0;
    protected ViewDocument viewDocument = null;
    protected MapContext mapContext = null;
    protected int mapUnits = 1;
    protected BufferedImage m_image = null;
    protected AffineTransform mapAT = null;
    protected Project project = null;
    protected double scaleAnt;
    protected Point origin;
    protected Point2D p1;
    protected Point2D p2;
    protected IFFrame grid;
    protected boolean showGrid = false;
    private boolean b_updating = false;
    protected boolean b_validCache = false;
    protected boolean b_drawing = false;
    private ViewDocListener viewDocListener;
    private OwnMapContextListener ownMapContextListener;
    private boolean b_hasToc = true;
    protected static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private boolean b_frameInitialized = true;
    protected AffineTransform originalGraphicsAT = null;
    protected Rectangle originalClip = null;
    private IFFrameUseFMap.SCALE_TYPE scaleType = IFFrameUseFMap.SCALE_TYPE.NORMAL;
    private Double fixedScale = null;
    private Envelope fixedExtent = null;
    private boolean persistIndependent;

    public FFrameView() {
        ++this.num;
        this.createListeners();
    }

    public String toString() {
        if (this.getView() == null) {
            return "FFrameView " + this.num + ": " + "Vacio";
        }
        return "FFrameView " + this.num + ": " + this.getView().getName();
    }

    @Override
    public void setScale(double d) {
        if (this.getMapContext() != null) {
            this.getMapContext().setScaleView(d);
        }
    }

    @Override
    public void setNewEnvelope(Envelope r) {
        this.getMapContext().getViewPort().setEnvelope(r);
        this.updateScaleCtrl();
    }

    protected double getDrawPaperDPI() {
        AffineTransform at = null;
        if (this.getLayoutContext() != null) {
            at = this.getLayoutContext().getAT();
        }
        return 2.54 * this.getBoundingBox((AffineTransform)at).width / this.getBoundBox().width;
    }

    @Override
    public MapContext getMapContext() {
        return this.mapContext;
    }

    public void setQuality(int q) {
        this.quality = q;
    }

    public int getQuality() {
        return this.quality;
    }

    public void setViewMapContext(MapContext viewMapContext) {
        Envelope oldEnvelope = null;
        if (this.mapContext != null) {
            this.removeOwnListeners();
            if (this.mapContext.getViewPort() != null) {
                oldEnvelope = this.mapContext.getViewPort().getEnvelope();
            }
            DisposeUtils.disposeQuietly((Disposable)this.mapContext);
            this.mapContext = null;
        }
        if (viewMapContext == null) {
            this.mapContext = null;
            return;
        }
        try {
            if (this.syncLayers) {
                this.mapContext = viewMapContext.createNewFMap((ViewPort)viewMapContext.getViewPort().clone());
                for (FLayer fLayer : viewMapContext.getGraphicsLayers()) {
                    if (!(fLayer instanceof FLyrVect)) continue;
                    this.mapContext.setGraphicsLayer(fLayer.getName(), (FLyrVect)fLayer);
                }
            } else {
                this.mapContext = viewMapContext.cloneFMap();
                this.mapContext.setViewPort((ViewPort)viewMapContext.getViewPort().clone());
            }
            ViewPort newViewPort = this.getMapContext().getViewPort();
            if (!this.syncExtents && oldEnvelope != null) {
                newViewPort.setEnvelope(oldEnvelope);
            }
            AffineTransform at = this.getLayoutContext() != null ? this.getLayoutContext().getAT() : null;
            newViewPort.setImageSize(new Dimension((int)this.getBoundingBox((AffineTransform)at).width, (int)this.getBoundingBox((AffineTransform)at).height));
            newViewPort.setDPI(this.getDrawPaperDPI());
            this.addAllListeners();
            this.updateScaleCtrl();
            this.setTocModel();
        }
        catch (CloneNotSupportedException e1) {
            logger.warn("Can't set mapcontext of the fframeview", (Throwable)e1);
        }
    }

    public void setView(ViewDocument viewDocument) {
        this.removeViewListeners();
        this.viewDocument = viewDocument;
        if (this.viewDocument != null) {
            this.setViewMapContext(this.viewDocument.getMapContext());
        } else {
            this.setViewMapContext(null);
        }
    }

    public ViewDocument getView() {
        return this.viewDocument;
    }

    @Override
    public void draw(Graphics2D g, AffineTransform at, Rectangle2D visibleLayoutDocRect, BufferedImage imgBase) {
        Rectangle2D.Double fframeViewRect = this.getBoundingBox(at);
        Rectangle2D.Double visibleArea = (Rectangle2D.Double)this.getVisibleRect(visibleLayoutDocRect, fframeViewRect);
        if (visibleArea == null) {
            return;
        }
        this.preDraw(g, fframeViewRect, visibleArea);
        if (this.getMapContext() == null) {
            this.drawEmpty(g);
        } else if (FLayoutUtilities.hasEditingLayers(this.getView())) {
            this.drawMessage(g, Messages.getText((String)"_Cannot_draw_view_if_layers_in_editing_mode"));
        } else if (this.getQuality() == 0) {
            try {
                this.drawPresentation(g, at, fframeViewRect, visibleArea, imgBase);
            }
            catch (Exception exc) {
                this.drawMessage(g, FLayoutFunctions.getLastMessage(exc));
            }
        } else {
            this.drawDraft(g);
        }
        this.postDraw(g, fframeViewRect, at);
        if (this.showGrid && this.grid != null) {
            this.grid.draw(g, at, visibleLayoutDocRect, imgBase);
        }
    }

    private void drawMessage(Graphics2D g, String msg) {
        Rectangle2D.Double r = this.getBoundingBox(null);
        g.setColor(Color.lightGray);
        g.fillRect((int)((RectangularShape)r).getX(), (int)((RectangularShape)r).getY(), (int)((RectangularShape)r).getWidth(), (int)((RectangularShape)r).getHeight());
        g.setColor(Color.darkGray);
        g.setStroke(new BasicStroke(2.0f));
        g.drawRect((int)((RectangularShape)r).getX(), (int)((RectangularShape)r).getY(), (int)((RectangularShape)r).getWidth(), (int)((RectangularShape)r).getHeight());
        g.setColor(Color.black);
        int scale = (int)(((RectangularShape)r).getWidth() / 24.0);
        Font f = new Font("SansSerif", 0, scale);
        g.setFont(f);
        if (msg == null) {
            msg = Messages.getText((String)"error");
        }
        g.drawString(msg, (int)(r.getCenterX() - (double)(msg.length() * scale / 4)), (int)r.getCenterY());
    }

    protected Envelope getVisibleEnvelope(Rectangle2D.Double fframeViewRect, Rectangle2D.Double visiblefframeViewRect) {
        Envelope oldEnv = this.getMapContext().getViewPort().getAdjustedEnvelope();
        double widthFactor = (double)((int)visiblefframeViewRect.width) / fframeViewRect.width;
        double heightFactor = (double)((int)visiblefframeViewRect.height) / fframeViewRect.height;
        double newWidth = oldEnv.getLength(0) * widthFactor;
        double newHeight = oldEnv.getLength(1) * heightFactor;
        double translateX = visiblefframeViewRect.x - fframeViewRect.x;
        double translateY = visiblefframeViewRect.y - fframeViewRect.y;
        double translateFactorX = translateX / fframeViewRect.width;
        double translateFactorY = translateY / fframeViewRect.height;
        double newX = oldEnv.getMinimum(0) + translateFactorX * oldEnv.getLength(0);
        double newMaxY = oldEnv.getMaximum(1) - translateFactorY * oldEnv.getLength(1);
        double newMaxX = newX + newWidth;
        double newY = newMaxY - newHeight;
        Envelope newEnv = null;
        try {
            newEnv = geomManager.createEnvelope(newX, newY, newMaxX, newMaxY, 0);
        }
        catch (CreateEnvelopeException ex) {
            logger.warn("Can't calculate the envelope of the visible area.", (Throwable)ex);
        }
        return newEnv;
    }

    protected void drawPresentation(Graphics2D g, AffineTransform affineTransform, Rectangle2D.Double fframeViewRect, Rectangle2D.Double visibleRect, BufferedImage imgBase) throws Exception {
        this.b_drawing = true;
        int drawWidth = (int)visibleRect.width;
        int drawHeight = (int)visibleRect.height;
        Envelope oldEnvelope = null;
        if (!visibleRect.equals(fframeViewRect)) {
            oldEnvelope = this.getMapContext().getViewPort().getEnvelope();
            if (oldEnvelope == null) {
                return;
            }
            Envelope newEnvelope = this.getVisibleEnvelope(fframeViewRect, visibleRect);
            this.getMapContext().getViewPort().setImageSize(new Dimension(drawWidth, drawHeight));
            this.getMapContext().getViewPort().setEnvelope(newEnvelope);
        } else {
            this.getMapContext().getViewPort().setImageSize(new Dimension(drawWidth, drawHeight));
            this.getMapContext().getViewPort().refreshExtent();
        }
        Point mapOrigin = new Point((int)fframeViewRect.getMinX(), (int)fframeViewRect.getMaxY());
        this.createImage(affineTransform, drawWidth, drawHeight, mapOrigin);
        this.drawImage(g, this.m_image, visibleRect);
        if (oldEnvelope != null) {
            this.getMapContext().getViewPort().setImageSize(new Dimension((int)fframeViewRect.width, (int)fframeViewRect.height));
            this.getMapContext().getViewPort().setEnvelope(oldEnvelope);
        }
        this.scaleAnt = affineTransform.getScaleX();
        this.origin = mapOrigin;
        this.b_drawing = false;
    }

    protected void createImage(AffineTransform affineTransform, int width, int height, Point mapOrigin) throws ReadException, MapContextException {
        ViewPort viewPort = this.getMapContext().getViewPort();
        if (this.origin == null || !this.origin.equals(mapOrigin) || affineTransform.getScaleX() != this.scaleAnt || this.m_image == null || !this.b_validCache) {
            viewPort.setDPI(this.getDrawPaperDPI());
            viewPort.setImageSize(new Dimension(width, height));
            this.m_image = new BufferedImage(width, height, 2);
            Graphics2D gimg = this.m_image.createGraphics();
            Color saved_color = gimg.getColor();
            gimg.setBackground(viewPort.getBackColor());
            gimg.setColor(viewPort.getBackColor());
            gimg.fillRect(0, 0, width, height);
            gimg.setColor(saved_color);
            this.getMapContext().draw(this.m_image, gimg, this.getScale());
            gimg.dispose();
            this.b_validCache = true;
        }
    }

    protected void drawImage(Graphics2D g, BufferedImage image, Rectangle2D.Double visibleRectangle) {
        Color theBackColor = this.getMapContext().getViewPort().getBackColor();
        if (theBackColor != null) {
            g.setColor(theBackColor);
            g.fillRect((int)visibleRectangle.x, (int)visibleRectangle.y, (int)visibleRectangle.width, (int)visibleRectangle.height);
        }
        g.drawImage((Image)this.m_image, (int)visibleRectangle.x, (int)visibleRectangle.y, null);
    }

    protected void preDraw(Graphics2D g, Rectangle2D.Double fframeViewRect, Rectangle2D.Double visibleRect) {
        AffineTransform rotationAT;
        this.originalGraphicsAT = (AffineTransform)g.getTransform().clone();
        if (g.getClipBounds() != null) {
            this.originalClip = (Rectangle)g.getClipBounds().clone();
        }
        if ((rotationAT = this.getRotationAT()) != null) {
            g.transform(rotationAT);
        }
        g.setClip((int)visibleRect.getMinX(), (int)visibleRect.getMinY(), (int)visibleRect.getWidth(), (int)visibleRect.getHeight());
    }

    protected void postDraw(Graphics2D g, Rectangle2D.Double fframeViewRect, AffineTransform at) {
        g.setTransform(this.originalGraphicsAT);
        if (this.getMapContext() != null) {
            this.setATMap(this.getMapContext().getViewPort().getAffineTransform());
        }
        if (this.originalClip != null) {
            g.setClip(this.originalClip.x, this.originalClip.y, this.originalClip.width, this.originalClip.height);
        }
    }

    @Deprecated
    protected void postDraw(Graphics2D g, Rectangle2D.Double rectangleLayout, Rectangle2D rectangleView, BufferedImage imgBase, Rectangle originalClip, AffineTransform at) {
        this.postDraw(g, rectangleLayout, at);
    }

    @Deprecated
    protected Rectangle preDraw(Graphics2D g, Rectangle2D.Double rectangleLayout) {
        Rectangle originalClip = null;
        if (g.getClipBounds() != null) {
            originalClip = (Rectangle)g.getClipBounds().clone();
        }
        this.preDraw(g, rectangleLayout, rectangleLayout);
        return originalClip;
    }

    public void print(Graphics2D g, AffineTransform at, Geometry geom, PrintAttributes printAttributes) {
        Rectangle2D.Double rectangleLayout = this.getBoundingBox(at);
        this.preDraw(g, rectangleLayout, rectangleLayout);
        this.print(g, at, printAttributes);
        this.postDraw(g, rectangleLayout, at);
        if (this.showGrid && this.grid != null) {
            this.grid.print(g, at, geom, printAttributes);
        }
    }

    protected void print(Graphics2D g, AffineTransform at, PrintAttributes printAttributes) {
        Rectangle2D.Double layoutRectangle = this.getBoundingBox(at);
        ViewPort viewPort = this.getMapContext().getViewPort();
        Point2D old_offset = viewPort.getOffset();
        Dimension old_imgsize = viewPort.getImageSize();
        double oldDpi = viewPort.getDPI();
        viewPort.setOffset((Point2D)new Point2D.Double(layoutRectangle.x, layoutRectangle.y));
        viewPort.setImageSize(new Dimension((int)layoutRectangle.width, (int)layoutRectangle.height));
        double dpi = PrintAttributes.PRINT_QUALITY_DPI[printAttributes.getPrintQuality()];
        viewPort.setDPI(dpi);
        Color theBackColor = viewPort.getBackColor();
        if (theBackColor != null) {
            g.setColor(theBackColor);
            g.fillRect((int)layoutRectangle.x, (int)layoutRectangle.y, viewPort.getImageWidth(), viewPort.getImageHeight());
        }
        try {
            this.getMapContext().print(g, this.getScale(), printAttributes);
        }
        catch (Exception ex) {
            logger.warn("Can't print frame view.", (Throwable)ex);
        }
        viewPort.setOffset(old_offset);
        viewPort.setImageSize(old_imgsize);
        viewPort.setDPI(oldDpi);
    }

    public void setMapUnits(int i) {
        this.mapUnits = i;
    }

    public int getMapUnits() {
        return this.mapUnits;
    }

    public double getScale() {
        return this.getMapContext().getScaleView();
    }

    public void setBufferedImage(BufferedImage bi) {
        this.m_image = bi;
    }

    @Override
    public BufferedImage getBufferedImage() {
        return this.m_image;
    }

    @Override
    public AffineTransform getATMap() {
        return this.mapAT;
    }

    @Override
    public void setATMap(AffineTransform transform) {
        this.mapAT = transform;
    }

    @Override
    public void setProject(Project p) {
        this.project = p;
    }

    @Override
    public String getNameFFrame() {
        return PluginServices.getText((Object)this, (String)"Vista") + this.num;
    }

    @Override
    public String getName() {
        return PERSISTENCE_DEFINITION_NAME;
    }

    public boolean compare(Object arg0) {
        if (!(arg0 instanceof FFrameView)) {
            return false;
        }
        if (!this.getName().equals(((FFrameView)arg0).getName())) {
            return false;
        }
        if (Math.abs(this.getBoundBox().getWidth() - ((FFrameView)arg0).getBoundBox().getWidth()) > 0.05) {
            return false;
        }
        if (Math.abs(this.getBoundBox().getHeight() - ((FFrameView)arg0).getBoundBox().getHeight()) > 0.05) {
            return false;
        }
        if (!this.toString().equals(((FFrameView)arg0).toString())) {
            return false;
        }
        if (this.getMapContext() != null && !this.getMapContext().equals((Object)((FFrameView)arg0).getMapContext())) {
            return false;
        }
        return this.getRotation() == ((FFrameView)arg0).getRotation();
    }

    public void updateScaleCtrl() {
        NewStatusBar statusbar = PluginServices.getMainFrame().getStatusBar();
        MapContext mapContext = this.getMapContext();
        if (mapContext == null) {
            return;
        }
        statusbar.setMessage("units", PluginServices.getText((Object)this, (String)mapContext.getDistanceName()));
        String scale = this.fixedScale != null && this.getScaleType() == IFFrameUseFMap.SCALE_TYPE.FIXED_SCALE ? String.valueOf(this.fixedScale.longValue()) : String.valueOf(this.getMapContext().getScaleView());
        statusbar.setControlValue("layout-view-change-scale", scale);
        IProjection proj = mapContext.getViewPort().getProjection();
        if (proj != null) {
            statusbar.setMessage("projection", proj.getAbrev());
        } else {
            statusbar.setMessage("projection", "");
        }
    }

    @Override
    public void fullExtent() throws ReadException {
        this.setNewEnvelope(this.getMapContext().getFullEnvelope());
    }

    @Override
    public void setPointsToZoom(Point2D px1, Point2D px2) {
        this.p1 = px1;
        this.p2 = px2;
    }

    @Override
    public void movePoints(Point2D px1, Point2D px2) {
        double difX = -px2.getX() + px1.getX();
        double difY = -px2.getY() + px1.getY();
        if (this.p1 != null) {
            this.p1.setLocation(this.p1.getX() + difX, this.p1.getY() + difY);
            this.p2.setLocation(this.p2.getX() + difX, this.p2.getY() + difY);
        }
    }

    @Override
    public FFrameView clone() throws CloneNotSupportedException {
        FFrameView frame = (FFrameView)super.clone();
        frame.createListeners();
        frame.setView(this.getView());
        frame.removeAllListeners();
        if (this.grid != null) {
            FFrameGrid newGrid = (FFrameGrid)this.grid.clone();
            newGrid.setFFrameDependence(frame);
            frame.setGrid(newGrid);
        }
        return frame;
    }

    public void setGrid(IFFrame grid) {
        this.grid = grid;
        this.grid.setRotation(this.getRotation());
    }

    public IFFrame getGrid() {
        return this.grid;
    }

    @Override
    public void setRotation(double rotation) {
        super.setRotation(rotation);
        if (this.grid != null) {
            this.grid.setRotation(rotation);
        }
    }

    public void showGrid(boolean b) {
        this.showGrid = b;
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    @Override
    public void refreshOriginalExtent() {
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(FFrameView.class, PERSISTENCE_DEFINITION_NAME, "FFrameView persistence definition", null, null);
            definition.extend(manager.getDefinition("FFrame"));
            definition.addDynFieldInt(QUALITY_FIELD).setMandatory(true);
            definition.addDynFieldInt(MAPUNITS_FIELD).setMandatory(true);
            definition.addDynFieldDouble(SCALE_FIELD).setMandatory(false);
            definition.addDynFieldObject(VIEW_FIELD).setClassOfValue(ViewDocument.class).setMandatory(false);
            definition.addDynFieldObject(ENVELOPE_FIELD).setClassOfValue(Envelope.class).setMandatory(false);
            definition.addDynFieldBoolean(SHOWGRID_FIELD).setMandatory(true);
            definition.addDynFieldObject(GRID_FIELD).setClassOfValue(IFFrame.class).setMandatory(false);
            definition.addDynFieldBoolean(HAS_TOC_FIELD).setMandatory(false);
            definition.addDynFieldBoolean(EXTENT_SYNC_FIELD).setMandatory(false);
            definition.addDynFieldBoolean(LAYER_SYNC_FIELD).setMandatory(false);
            definition.addDynFieldInt(SCALE_TYPE_FIELD).setMandatory(false);
            definition.addDynFieldInt(MODE_FIELD).setMandatory(false);
            definition.addDynFieldInt(TYPESCALE_FIELD).setMandatory(false);
            definition.addDynFieldBoolean(BLINKED_FIELD).setMandatory(false);
            definition.addDynFieldObject(MAPCONTEXT_FIELD).setClassOfValue(MapContext.class).setMandatory(false);
            definition.addDynFieldInt(VIEWING_FIELD).setMandatory(false);
            definition.addDynFieldInt(EXTENSION_FIELD).setMandatory(false);
            definition.addDynFieldBoolean(PERSIST_INDEPENDENT_FIELD).setMandatory(false);
        }
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.persistIndependent = state.getBoolean(PERSIST_INDEPENDENT_FIELD, false);
        this.b_frameInitialized = false;
        this.syncExtents = state.hasValue(EXTENT_SYNC_FIELD) ? state.getBoolean(EXTENT_SYNC_FIELD) : true;
        this.syncLayers = state.hasValue(LAYER_SYNC_FIELD) ? state.getBoolean(LAYER_SYNC_FIELD) : true;
        Double layoutScale = null;
        if (state.hasValue(SCALE_FIELD)) {
            layoutScale = state.getDouble(SCALE_FIELD);
        }
        Envelope envelope = (Envelope)state.get(ENVELOPE_FIELD);
        if (state.hasValue(SCALE_TYPE_FIELD)) {
            int value = state.getInt(SCALE_TYPE_FIELD);
            if (value == IFFrameUseFMap.SCALE_TYPE.FIXED_EXTENT.ordinal()) {
                this.scaleType = IFFrameUseFMap.SCALE_TYPE.FIXED_EXTENT;
                this.fixedExtent = envelope;
            } else if (value == IFFrameUseFMap.SCALE_TYPE.FIXED_SCALE.ordinal()) {
                this.scaleType = IFFrameUseFMap.SCALE_TYPE.FIXED_SCALE;
                this.fixedScale = layoutScale;
            }
        }
        this.quality = state.getInt(QUALITY_FIELD);
        this.mapUnits = state.getInt(MAPUNITS_FIELD);
        if (state.hasValue(HAS_TOC_FIELD)) {
            this.b_hasToc = state.getBoolean(HAS_TOC_FIELD);
        }
        ViewDocument persistenceView = (ViewDocument)state.get(VIEW_FIELD);
        if (this.isPersistIndependent()) {
            this.syncExtents = false;
            this.syncLayers = false;
            this.setView(persistenceView);
        } else if (persistenceView != null) {
            ViewDocument view = (ViewDocument)ProjectManager.getInstance().getCurrentProject().getDocument(persistenceView.getName(), persistenceView.getTypeName());
            if (view == null) {
                view = persistenceView;
            } else {
                DisposeUtils.disposeQuietly((Disposable)persistenceView.getMapOverViewContext());
                DisposeUtils.disposeQuietly((Disposable)persistenceView.getMapContext());
                DisposeUtils.disposeQuietly((Object)persistenceView);
            }
            this.setView(view);
        }
        if (this.getMapContext() != null) {
            if (layoutScale != null) {
                this.getMapContext().setScaleView(layoutScale.doubleValue());
            }
            this.getMapContext().getViewPort().setEnvelope(envelope);
            if (this.getLayoutContext() != null) {
                this.getLayoutContext().setTocModel(this.getMapContext());
            }
        }
        this.showGrid = state.getBoolean(SHOWGRID_FIELD);
        this.grid = (IFFrame)state.get(GRID_FIELD);
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set(EXTENT_SYNC_FIELD, this.syncExtents);
        state.set(LAYER_SYNC_FIELD, this.syncLayers);
        state.set(QUALITY_FIELD, this.quality);
        state.set(MAPUNITS_FIELD, this.mapUnits);
        state.set(VIEW_FIELD, (Persistent)this.viewDocument);
        state.set(HAS_TOC_FIELD, this.b_hasToc);
        state.set(SCALE_TYPE_FIELD, this.scaleType.ordinal());
        if (this.getMapContext() != null && this.getMapContext().getViewPort().getEnvelope() != null) {
            if (this.scaleType == IFFrameUseFMap.SCALE_TYPE.FIXED_SCALE) {
                if (this.fixedScale == null) {
                    this.fixedScale = new Double(this.getMapContext().getScaleView());
                }
                state.set(SCALE_FIELD, this.fixedScale.doubleValue());
            } else {
                state.set(SCALE_FIELD, this.getMapContext().getScaleView());
            }
            if (this.scaleType == IFFrameUseFMap.SCALE_TYPE.FIXED_EXTENT) {
                if (this.fixedExtent == null) {
                    this.fixedExtent = this.getMapContext().getViewPort().getAdjustedEnvelope();
                }
                state.set(ENVELOPE_FIELD, (Persistent)this.fixedExtent);
            } else {
                state.set(ENVELOPE_FIELD, (Persistent)this.getMapContext().getViewPort().getAdjustedEnvelope());
            }
        }
        state.set(SHOWGRID_FIELD, this.showGrid);
        state.set(GRID_FIELD, (Persistent)this.grid);
        state.set(PERSIST_INDEPENDENT_FIELD, this.persistIndependent);
    }

    @Override
    public void setBoundBox(Rectangle2D r) {
        super.setBoundBox(r);
        if (this.getMapContext() != null && this.getLayoutContext() != null) {
            AffineTransform at = this.getLayoutContext().getAT();
            double scale = this.getMapContext().getScaleView();
            this.getMapContext().getViewPort().setImageSize(new Dimension((int)this.getBoundingBox(at).getWidth(), (int)this.getBoundingBox(at).getHeight()));
            this.getMapContext().getViewPort().setDPI(this.getDrawPaperDPI());
            if (this.getScaleType() == IFFrameUseFMap.SCALE_TYPE.FIXED_SCALE) {
                this.getMapContext().setScaleView(scale);
            }
            this.updateScaleCtrl();
            this.refresh();
        }
    }

    public double getMapRotation() {
        return 0.0;
    }

    protected void invalidateLayout() {
        this.b_validCache = false;
        if (this.getLayoutContext() != null) {
            this.getLayoutContext().notifAllObservers();
        }
        this.observers.notifyObservers((Observable)this, (Object)new DefaultLayoutNotification("layout_refresh"));
    }

    protected void invalidateToc() {
        if (this.getLayoutContext() != null) {
            this.getLayoutContext().notifyTocUpdated(TocModelChangedNotification.Type.ITEM_UPDATED);
        }
    }

    protected void refreshToc() {
        if (this.getLayoutContext() != null) {
            this.getLayoutContext().notifyTocUpdated(TocModelChangedNotification.Type.MODEL_CHANGED);
        }
    }

    @Override
    public void refresh() {
        this.b_validCache = false;
    }

    protected void createListeners() {
        this.removeAllListeners();
        this.viewDocListener = new ViewDocListener(this);
        this.ownMapContextListener = new OwnMapContextListener(this);
    }

    protected void addAllListeners() {
        if (this.viewDocListener == null && this.ownMapContextListener == null) {
            this.createListeners();
        }
        if (this.getView() != null) {
            if (this.syncLayers) {
                this.getView().getMapContext().addLayerListener((LegendListener)this.viewDocListener);
                this.getView().getMapContext().getLayers().addLayerCollectionListener((LayerCollectionListener)this.viewDocListener);
                this.getView().getMapContext().addAtomicEventListener((AtomicEventListener)this.viewDocListener);
            }
            if (this.getExtentSynced()) {
                this.getView().getMapContext().getViewPort().addViewPortListener((ViewPortListener)this.viewDocListener);
            }
        }
        if (this.getMapContext() != null) {
            this.getMapContext().addLayerListener((LegendListener)this.ownMapContextListener);
            this.getMapContext().getLayers().addLayerCollectionListener((LayerCollectionListener)this.ownMapContextListener);
            this.getMapContext().getViewPort().addViewPortListener((ViewPortListener)this.ownMapContextListener);
        }
    }

    protected void resetAllListeners() {
        this.removeAllListeners();
        this.addAllListeners();
    }

    protected void removeAllListeners() {
        this.removeOwnListeners();
        this.removeViewListeners();
    }

    protected void removeOwnListeners() {
        if (this.ownMapContextListener == null) {
            return;
        }
        if (this.mapContext == null) {
            return;
        }
        this.mapContext.removeLayerListener((LegendListener)this.ownMapContextListener);
        this.mapContext.getViewPort().removeViewPortListener((ViewPortListener)this.ownMapContextListener);
        this.mapContext.getLayers().removeLayerCollectionListener((LayerCollectionListener)this.ownMapContextListener);
    }

    protected void removeViewListeners() {
        if (this.viewDocListener == null) {
            return;
        }
        if (this.getView() == null) {
            return;
        }
        MapContext mapContext = this.getView().getMapContext();
        if (mapContext == null) {
            return;
        }
        mapContext.removeLayerListener((LegendListener)this.viewDocListener);
        mapContext.getViewPort().removeViewPortListener((ViewPortListener)this.viewDocListener);
        mapContext.getLayers().removeLayerCollectionListener((LayerCollectionListener)this.viewDocListener);
        mapContext.removeAtomicEventListener((AtomicEventListener)this.viewDocListener);
    }

    @Override
    public void dispose() {
        this.removeAllListeners();
        this.viewDocListener = null;
        this.ownMapContextListener = null;
        this.viewDocument = null;
        this.mapContext = null;
    }

    @Override
    public void frameRemoved() {
        this.removeAllListeners();
        if (this.b_hasToc && this.getLayoutContext() != null) {
            this.getLayoutContext().setTocModel(null);
        }
        this.m_image = null;
    }

    @Override
    public void frameAdded() {
        this.addAllListeners();
        this.setTocModel();
        this.updateScaleCtrl();
    }

    public void setHasToc(boolean hasToc) {
        this.b_hasToc = hasToc;
        this.setTocModel();
    }

    protected void setTocModel() {
        if (this.getLayoutContext() != null) {
            if (this.b_hasToc && this.getMapContext() != null) {
                this.getLayoutContext().setTocModel(this.getMapContext());
            } else {
                this.getLayoutContext().setTocModel(null);
            }
        }
    }

    @Override
    protected void doSetSelected(int selectedStatus) {
        boolean oldSelectedStatus = this.isSelected();
        super.doSetSelected(selectedStatus);
        if (!oldSelectedStatus && this.isSelected()) {
            this.setTocModel();
            this.updateScaleCtrl();
        }
    }

    @Override
    public boolean getLayerSynced() {
        return this.syncLayers;
    }

    @Override
    public void setLayerSynced(boolean synced) {
        this.syncLayers = synced;
        this.resetAllListeners();
    }

    @Override
    public boolean getExtentSynced() {
        return this.syncExtents;
    }

    @Override
    public void setExtentSynced(boolean synced) {
        this.syncExtents = synced;
        this.resetAllListeners();
    }

    public static boolean isPan(Envelope oldEnvelope, Envelope newEnvelope) {
        if (oldEnvelope != null && newEnvelope != null) {
            double toleranceX = 1.0E-8 * Math.min(oldEnvelope.getLength(0), newEnvelope.getLength(0));
            double toleranceY = 1.0E-8 * Math.min(oldEnvelope.getLength(1), newEnvelope.getLength(1));
            if (Math.abs(oldEnvelope.getLength(0) - newEnvelope.getLength(0)) < toleranceX && Math.abs(oldEnvelope.getLength(1) - newEnvelope.getLength(1)) < toleranceY) {
                return true;
            }
        }
        return false;
    }

    protected Envelope calculateNewExtent() {
        Envelope newEnvelope = this.getView().getMapContext().getViewPort().getEnvelope();
        Envelope oldViewEnvelope = null;
        try {
            if (this.getView().getMapContext().getViewPort().getEnvelopes().hasPrevious()) {
                Rectangle2D r = this.getView().getMapContext().getViewPort().getEnvelopes().getPrev();
                oldViewEnvelope = GeometryLocator.getGeometryManager().createEnvelope(r.getMinX(), r.getMinY(), r.getMaxX(), r.getMaxY(), 0);
            }
            if (FFrameView.isPan(oldViewEnvelope, newEnvelope)) {
                Envelope envelope = this.getMapContext().getViewPort().getAdjustedEnvelope();
                double shiftX = newEnvelope.getMinimum(0) - oldViewEnvelope.getMinimum(0);
                double shiftY = newEnvelope.getMinimum(1) - oldViewEnvelope.getMinimum(1);
                double minX = envelope.getMinimum(0) + shiftX;
                double minY = envelope.getMinimum(1) + shiftY;
                double maxX = envelope.getMaximum(0) + shiftX;
                double maxY = envelope.getMaximum(1) + shiftY;
                return GeometryLocator.getGeometryManager().createEnvelope(minX, minY, maxX, maxY, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return newEnvelope;
    }

    protected boolean isDrawing() {
        return this.b_drawing;
    }

    protected boolean isUpdating() {
        return this.b_updating;
    }

    protected boolean skipFirstChangeExtent() {
        if (this.b_frameInitialized) {
            return false;
        }
        this.b_frameInitialized = true;
        return true;
    }

    protected boolean isSyncLayers() {
        return this.syncLayers;
    }

    protected void beginUpdate() {
        this.b_updating = true;
    }

    protected void endUpdate() {
        this.b_updating = false;
    }

    @Override
    public IFFrameUseFMap.SCALE_TYPE getScaleType() {
        return this.scaleType;
    }

    public Double getFixedScale() {
        return this.fixedScale;
    }

    public Envelope getFixedExtent() {
        return this.fixedExtent;
    }

    public void setExtent(Envelope extent) {
        if (this.getScaleType() == IFFrameUseFMap.SCALE_TYPE.NORMAL) {
            this.getMapContext().getViewPort().setEnvelope(extent);
        }
    }

    @Override
    public void setScaleType(IFFrameUseFMap.SCALE_TYPE scaleType) {
        this.scaleType = scaleType;
    }

    public void setScaleType(IFFrameUseFMap.SCALE_TYPE scaleType, double fixedScale) {
        if (scaleType == IFFrameUseFMap.SCALE_TYPE.FIXED_SCALE) {
            this.scaleType = scaleType;
            this.fixedScale = fixedScale;
            this.setScale(fixedScale);
        }
    }

    public void setScaleType(IFFrameUseFMap.SCALE_TYPE scaleType, Envelope fixedExtent) {
        if (scaleType == IFFrameUseFMap.SCALE_TYPE.FIXED_EXTENT) {
            this.scaleType = scaleType;
            this.fixedExtent = fixedExtent;
            this.setNewEnvelope(fixedExtent);
        }
    }

    @Override
    @Deprecated
    public int getTypeScale() {
        return 0;
    }

    @Override
    @Deprecated
    public void setLinked(boolean b) {
    }

    @Override
    @Deprecated
    public boolean getLinked() {
        return false;
    }

    @Override
    public void windowActivated() {
        if (this.isSelected() && this.getLayoutContext().getSelectedFFrames(IFFrameUseFMap.class).length == 1) {
            this.updateScaleCtrl();
        }
    }

    @Override
    public void windowClosed() {
    }

    public void setPersistIndependent(boolean b) {
        this.persistIndependent = b;
    }

    public boolean isPersistIndependent() {
        return this.persistIndependent;
    }

    private class OwnMapContextListener
    implements ViewPortListener,
    LegendListener,
    LayerCollectionListener {
        public OwnMapContextListener(FFrameView fview) {
        }

        public void extentChanged(ExtentEvent e) {
            if (FFrameView.this.isDrawing()) {
                return;
            }
            if (FFrameView.this.isUpdating()) {
                return;
            }
            try {
                FFrameView.this.beginUpdate();
                if (FFrameView.this.getScaleType() == IFFrameUseFMap.SCALE_TYPE.FIXED_EXTENT) {
                    FFrameView.this.getMapContext().getViewPort().setEnvelope(FFrameView.this.getFixedExtent());
                } else {
                    Envelope newEnvelope;
                    if (FFrameView.this.getScaleType() == IFFrameUseFMap.SCALE_TYPE.FIXED_SCALE && FFrameView.this.getFixedScale() != null) {
                        FFrameView.this.getMapContext().setScaleView(FFrameView.this.getFixedScale().doubleValue());
                        newEnvelope = FFrameView.this.getMapContext().getViewPort().getAdjustedEnvelope();
                    } else {
                        newEnvelope = e.getNewExtent();
                    }
                    if (FFrameView.this.getView() != null && FFrameView.this.getExtentSynced()) {
                        FFrameView.this.getView().getMapContext().getViewPort().setEnvelope(newEnvelope);
                    }
                }
                FFrameView.this.updateScaleCtrl();
                FFrameView.this.invalidateLayout();
            }
            finally {
                FFrameView.this.endUpdate();
            }
        }

        public void backColorChanged(ColorEvent e) {
            if (!FFrameView.this.isUpdating() && FFrameView.this.getView() != null) {
                try {
                    FFrameView.this.beginUpdate();
                    if (FFrameView.this.getLayerSynced()) {
                        FFrameView.this.getView().getMapContext().getViewPort().setBackColor(e.getNewColor());
                    }
                    FFrameView.this.invalidateLayout();
                }
                finally {
                    FFrameView.this.endUpdate();
                }
            }
        }

        public void projectionChanged(ProjectionEvent e) {
            if (!FFrameView.this.isUpdating() && FFrameView.this.getExtentSynced() && FFrameView.this.getView() != null) {
                try {
                    FFrameView.this.beginUpdate();
                    if (FFrameView.this.getLayerSynced()) {
                        FFrameView.this.getView().getMapContext().getViewPort().setProjection(e.getNewProjection());
                    }
                    FFrameView.this.invalidateLayout();
                }
                finally {
                    FFrameView.this.endUpdate();
                }
            }
        }

        public void conditionalRedraw() {
            if (!FFrameView.this.isUpdating()) {
                try {
                    FFrameView.this.beginUpdate();
                    FFrameView.this.invalidateLayout();
                }
                finally {
                    FFrameView.this.endUpdate();
                }
            }
        }

        public void legendChanged(LegendChangedEvent e) {
            this.conditionalRedraw();
            FFrameView.this.refreshToc();
        }

        public void layerAdded(LayerCollectionEvent e) {
            if (!FFrameView.this.isUpdating() && FFrameView.this.getMapContext().getViewPort().getEnvelope() == null) {
                try {
                    FFrameView.this.beginUpdate();
                    FFrameView.this.fullExtent();
                }
                catch (ReadException readException) {
                }
                finally {
                    FFrameView.this.endUpdate();
                }
            }
            this.conditionalRedraw();
            FFrameView.this.refreshToc();
        }

        public void layerMoved(LayerPositionEvent e) {
            this.conditionalRedraw();
            FFrameView.this.refreshToc();
        }

        public void layerRemoved(LayerCollectionEvent e) {
            this.conditionalRedraw();
            FFrameView.this.refreshToc();
        }

        public void layerAdding(LayerCollectionEvent e) throws CancelationException {
        }

        public void layerMoving(LayerPositionEvent e) throws CancelationException {
        }

        public void layerRemoving(LayerCollectionEvent e) throws CancelationException {
        }

        public void visibilityChanged(LayerCollectionEvent e) throws CancelationException {
            this.conditionalRedraw();
        }
    }

    private class ViewDocListener
    implements ViewPortListener,
    LegendListener,
    LayerCollectionListener,
    AtomicEventListener {
        public ViewDocListener(FFrameView fview) {
        }

        public void extentChanged(ExtentEvent e) {
            if (FFrameView.this.isUpdating()) {
                return;
            }
            if (FFrameView.this.skipFirstChangeExtent()) {
                return;
            }
            if (!FFrameView.this.getExtentSynced()) {
                return;
            }
            try {
                FFrameView.this.beginUpdate();
                if (FFrameView.this.getMapContext() != null) {
                    if (null == FFrameView.this.getScaleType()) {
                        FFrameView.this.getMapContext().getViewPort().setEnvelope(FFrameView.this.calculateNewExtent());
                    } else {
                        switch (FFrameView.this.getScaleType()) {
                            case FIXED_EXTENT: {
                                FFrameView.this.getView().getMapContext().getViewPort().setEnvelope(FFrameView.this.getFixedExtent());
                                break;
                            }
                            case FIXED_SCALE: {
                                FFrameView.this.getMapContext().setScaleView(FFrameView.this.getFixedScale().doubleValue());
                                FFrameView.this.getView().getMapContext().getViewPort().setEnvelope(FFrameView.this.getMapContext().getViewPort().getAdjustedEnvelope());
                                break;
                            }
                            default: {
                                FFrameView.this.getMapContext().getViewPort().setEnvelope(FFrameView.this.calculateNewExtent());
                            }
                        }
                    }
                    FFrameView.this.updateScaleCtrl();
                    FFrameView.this.invalidateLayout();
                }
            }
            finally {
                FFrameView.this.endUpdate();
            }
        }

        public void backColorChanged(ColorEvent e) {
            if (!FFrameView.this.isUpdating() && FFrameView.this.isSyncLayers() && FFrameView.this.getMapContext() != null) {
                FFrameView.this.beginUpdate();
                FFrameView.this.getMapContext().getViewPort().setBackColor(e.getNewColor());
                FFrameView.this.invalidateLayout();
                FFrameView.this.endUpdate();
            }
        }

        public void projectionChanged(ProjectionEvent e) {
            if (!FFrameView.this.isUpdating() && FFrameView.this.getExtentSynced() && FFrameView.this.getMapContext() != null) {
                FFrameView.this.beginUpdate();
                FFrameView.this.getMapContext().getViewPort().setProjection(e.getNewProjection());
                FFrameView.this.invalidateLayout();
                FFrameView.this.endUpdate();
            }
        }

        public void conditionalRedraw() {
            if (!FFrameView.this.isUpdating() && FFrameView.this.isSyncLayers()) {
                FFrameView.this.beginUpdate();
                FFrameView.this.invalidateLayout();
                FFrameView.this.endUpdate();
            }
        }

        public void legendChanged(LegendChangedEvent e) {
            this.conditionalRedraw();
            FFrameView.this.refreshToc();
        }

        public void layerAdded(LayerCollectionEvent e) {
            this.conditionalRedraw();
        }

        public void layerMoved(LayerPositionEvent e) {
            this.conditionalRedraw();
        }

        public void layerRemoved(LayerCollectionEvent e) {
            this.conditionalRedraw();
        }

        public void layerAdding(LayerCollectionEvent e) throws CancelationException {
        }

        public void layerMoving(LayerPositionEvent e) throws CancelationException {
        }

        public void layerRemoving(LayerCollectionEvent e) throws CancelationException {
        }

        public void visibilityChanged(LayerCollectionEvent e) throws CancelationException {
            this.conditionalRedraw();
            FFrameView.this.invalidateToc();
        }

        public void atomicEvent(AtomicEvent e) {
            boolean layoutRedraw = false;
            for (int i = e.getLayerEvents().length - 1; i >= 0; --i) {
                FMapEvent at = e.getEvent(i);
                if (!(at instanceof LayerEvent) || at.getEventType() != 4) continue;
                layoutRedraw = true;
                break;
            }
            if (layoutRedraw) {
                this.conditionalRedraw();
            }
            FFrameView.this.invalidateToc();
        }
    }
}

