/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.fframes.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.documents.layout.fframes.gui.JPRotationView;

public class JPRotation
extends JPanel {
    private static final long serialVersionUID = 5537314374490402138L;
    private JPRotationView pRotationView = null;
    private JPanel pButtons = null;
    private JButton bLeft = null;
    private JTextField txtRotation = null;
    private String parsedText = null;
    private JButton bRight = null;

    public void setRotation(double rot) {
        this.getPRotationView().setRotation(rot);
        this.setTextRotation(rot);
    }

    private void setTextRotation(double d) {
        String s = String.valueOf(d);
        if (s.endsWith(".0")) {
            this.txtRotation.setText(s.substring(0, s.length() - 2));
        } else {
            this.txtRotation.setText(s);
        }
    }

    public double getRotation() {
        return this.getPRotationView().getRotation();
    }

    private JPRotationView getPRotationView() {
        if (this.pRotationView == null) {
            this.pRotationView = new JPRotationView();
            this.pRotationView.setForeground(Color.black);
            this.pRotationView.setBackground(SystemColor.controlShadow);
            this.pRotationView.setPreferredSize(new Dimension(80, 50));
        }
        return this.pRotationView;
    }

    private JPanel getPButtons() {
        if (this.pButtons == null) {
            this.pButtons = new JPanel();
            this.pButtons.add((Component)this.getBLeft(), null);
            this.pButtons.add((Component)this.getTxtRotation(), null);
            this.pButtons.add((Component)this.getBRight(), null);
        }
        return this.pButtons;
    }

    private JButton getBLeft() {
        if (this.bLeft == null) {
            this.bLeft = new JButton();
            this.bLeft.setPreferredSize(new Dimension(24, 24));
            this.bLeft.setIcon(PluginServices.getIconTheme().get("left-rotation-icon"));
            this.bLeft.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JPRotation.this.setRotation(Double.parseDouble(JPRotation.this.txtRotation.getText()) + 1.0);
                    JPRotation.this.getTxtRotation().setText(JPRotation.this.txtRotation.getText());
                    JPRotation.this.getPRotationView().repaint();
                }
            });
        }
        return this.bLeft;
    }

    private JTextField getTxtRotation() {
        if (this.txtRotation == null) {
            this.txtRotation = new JTextField();
            this.txtRotation.setPreferredSize(new Dimension(45, 24));
            this.txtRotation.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    block3: {
                        if (JPRotation.this.txtRotation.getText().endsWith(".")) {
                            return;
                        }
                        try {
                            JPRotation.this.setRotation(Double.parseDouble(JPRotation.this.txtRotation.getText()));
                        }
                        catch (NumberFormatException e1) {
                            String oldText = JPRotation.this.parsedText;
                            JPRotation.this.parsedText = JPRotation.this.txtRotation.getText();
                            if (JPRotation.this.parsedText.equals(oldText)) break block3;
                            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)this, (String)"numero_incorrecto"));
                        }
                    }
                    JPRotation.this.getPRotationView().repaint();
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            this.txtRotation.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    String text = JPRotation.this.txtRotation.getText();
                    if (text.endsWith(".")) {
                        return;
                    }
                    Double value = JPRotation.this.getDouble(text);
                    if (value != null) {
                        JPRotation.this.setRotation(value);
                        JPRotation.this.getPRotationView().repaint();
                    } else if (e.getKeyCode() == 10) {
                        String oldText = JPRotation.this.parsedText;
                        JPRotation.this.parsedText = JPRotation.this.txtRotation.getText();
                        if (!JPRotation.this.parsedText.equals(oldText)) {
                            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)this, (String)"numero_incorrecto"));
                        }
                    }
                }
            });
            this.setTextRotation(this.getRotation());
        }
        return this.txtRotation;
    }

    protected Double getDouble(String strValue) {
        String text = strValue.replaceAll(",", ".");
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private JButton getBRight() {
        if (this.bRight == null) {
            this.bRight = new JButton();
            this.bRight.setPreferredSize(new Dimension(24, 24));
            this.bRight.setIcon(PluginServices.getIconTheme().get("right-rotation-icon"));
            this.bRight.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JPRotation.this.setRotation(Double.parseDouble(JPRotation.this.txtRotation.getText()) - 1.0);
                    JPRotation.this.getTxtRotation().setText(JPRotation.this.txtRotation.getText());
                    JPRotation.this.getPRotationView().repaint();
                }
            });
        }
        return this.bRight;
    }

    public static void main(String[] args) {
    }

    public JPRotation() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)this, (String)"grados"), 0, 0, null, null));
        this.add((Component)this.getPRotationView(), "North");
        this.add((Component)this.getPButtons(), "South");
    }
}

