/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.fframes.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.gui.styling.SymbolSelector;
import org.gvsig.app.project.documents.layout.LayoutContext;
import org.gvsig.app.project.documents.layout.fframes.FFrameGraphics;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.fframes.gui.JPRotation;
import org.gvsig.app.project.documents.layout.fframes.gui.dialogs.FFrameDialogNotification;
import org.gvsig.app.project.documents.layout.fframes.gui.dialogs.IFFrameDialog;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.gui.beans.swing.GridBagLayoutPanel;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.ObservableHelper;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.swing.api.ActionListenerSupport;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FFrameGraphicsDialog
extends SymbolSelector
implements IFFrameDialog {
    private static final long serialVersionUID = 7473813303719944579L;
    private static final Logger LOG = LoggerFactory.getLogger(FFrameGraphicsDialog.class);
    private Rectangle2D rect = new Rectangle2D.Double();
    private LayoutPanel m_layout = null;
    private boolean isAcepted = false;
    private FFrameGraphics fframegraphics = null;
    private JPRotation pRotation = null;
    private FFrameGraphics newFFrameGraphics;
    private ObservableHelper observableHelper = new ObservableHelper();
    private ActionListenerSupport actionListenerSupportHelper;

    public FFrameGraphicsDialog(LayoutPanel layout, FFrameGraphics fframe) {
        super((Object)fframe.getFSymbol(), fframe.getType(), null, true);
        this.m_layout = layout;
        this.fframegraphics = fframe;
        this.initialize();
    }

    private void initialize() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        this.actionListenerSupportHelper = toolsSwingManager.createActionListenerSupport();
        this.setSize(650, 700);
        this.getPRotation().setRotation(this.fframegraphics.getRotation());
        ((GridBagLayoutPanel)this.getJPanelOptions()).addComponent((Component)this.getPRotation());
        ActionListener okAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FFrameGraphicsDialog.this.newFFrameGraphics = (FFrameGraphics)FFrameGraphicsDialog.this.fframegraphics.clone();
                    FFrameGraphicsDialog.this.newFFrameGraphics.setBoundBox(FFrameGraphicsDialog.this.fframegraphics.getBoundBox());
                    FFrameGraphicsDialog.this.newFFrameGraphics.setSymbol((ISymbol)FFrameGraphicsDialog.this.getSelectedObject());
                    FFrameGraphicsDialog.this.newFFrameGraphics.setRotation(FFrameGraphicsDialog.this.getPRotation().getRotation());
                    LayoutContext layoutContext = FFrameGraphicsDialog.this.m_layout.getLayoutContext();
                    layoutContext.delFFrame(FFrameGraphicsDialog.this.fframegraphics);
                    layoutContext.addFFrame(FFrameGraphicsDialog.this.newFFrameGraphics, false, true);
                    layoutContext.updateFFrames();
                    FFrameGraphicsDialog.this.m_layout.getLayoutControl().refresh();
                    FFrameGraphicsDialog.this.isAcepted = true;
                    FFrameGraphicsDialog.this.notifyDialogClosed();
                }
                catch (CloneNotSupportedException e1) {
                    LOG.error("It is not possible clonate the object", (Object)e);
                }
            }
        };
        ActionListener cancelAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FFrameGraphicsDialog.this.isAcepted = false;
                FFrameGraphicsDialog.this.notifyDialogClosed();
            }
        };
        this.okCancelPanel.addOkButtonActionListener(okAction);
        this.okCancelPanel.addCancelButtonActionListener(cancelAction);
    }

    public Object getViewModel() {
        return "FPanelLegendDefault";
    }

    @Override
    public WindowInfo getWindowInfo() {
        WindowInfo m_viewinfo = new WindowInfo(8);
        m_viewinfo.setTitle(PluginServices.getText((Object)this, (String)"propiedades_grafico"));
        m_viewinfo.setWidth(650);
        m_viewinfo.setHeight(625);
        return m_viewinfo;
    }

    @Override
    public void setRectangle(Rectangle2D r) {
        this.rect.setRect(r);
    }

    @Override
    public boolean getIsAcepted() {
        return this.isAcepted;
    }

    public void viewActivated() {
    }

    private JPRotation getPRotation() {
        if (this.pRotation == null) {
            this.pRotation = new JPRotation();
            this.pRotation.setPreferredSize(new Dimension(120, 120));
        }
        return this.pRotation;
    }

    @Override
    public IFFrame getFFrame() {
        return this.newFFrameGraphics;
    }

    public void addObserver(Observer observer) {
        this.observableHelper.addObserver(observer);
    }

    public void deleteObserver(Observer observer) {
        this.observableHelper.deleteObserver(observer);
    }

    public void deleteObservers() {
        this.observableHelper.deleteObservers();
    }

    protected void notifyDialogClosed() {
        this.observableHelper.notifyObservers((Observable)this, (Object)new FFrameDialogNotification("DialogClosed"));
    }

    public void addActionListener(ActionListener listener) {
        this.actionListenerSupportHelper.addActionListener(listener);
    }

    public boolean hasActionListeners() {
        return this.actionListenerSupportHelper.hasActionListeners();
    }

    public ActionListener[] getActionListeners() {
        return this.actionListenerSupportHelper.getActionListeners();
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListenerSupportHelper.removeActionListener(listener);
    }

    public void removeAllActionListener() {
        this.actionListenerSupportHelper.removeAllActionListener();
    }

    public void fireActionEvent(ActionEvent event) {
        this.actionListenerSupportHelper.fireActionEvent(event);
    }

    @Override
    public String getTitle() {
        return this.getWindowInfo().getTitle();
    }

    public JComponent asJComponent() {
        return this;
    }
}

