/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.geometryadapters;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.gvsig.app.project.documents.layout.geometryadapters.GeometryAdapter;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ILineSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolyLineAdapter
extends GeometryAdapter {
    public static final String PERSISTENCE_DEFINITION_NAME = "PolyLineAdapter";
    private static final Logger logger = LoggerFactory.getLogger(PolyLineAdapter.class);
    protected Point2D pointPosition = new Point2D.Double();
    private AffineTransform identity = new AffineTransform();
    private MapContextManager mapContextManager = MapContextLocator.getMapContextManager();

    @Override
    public void obtainShape(Point2D p) {
        Point2D[] points = this.getPoints();
        try {
            Curve curve = (Curve)geomManager.create(2, 0);
            if (points.length > 0) {
                curve.addVertex(geomManager.createPoint(points[0].getX(), points[0].getY(), 0));
            }
            for (int i = 1; i < points.length; ++i) {
                curve.addVertex(geomManager.createPoint(points[i].getX(), points[i].getY(), 0));
            }
            if (points.length > 0) {
                curve.addVertex(geomManager.createPoint(p.getX(), p.getY(), 0));
            }
            this.setGeometry((Geometry)curve);
        }
        catch (CreateGeometryException e) {
            logger.error("Error creating the circle", (Throwable)e);
        }
    }

    @Override
    public void paint(Graphics2D g, AffineTransform at, boolean andLastPoint) {
        Geometry shapeAux;
        if (andLastPoint) {
            this.obtainShape(this.pointPosition);
        }
        if (!(shapeAux = this.getGeometry(at)).getEnvelope().isEmpty()) {
            ILineSymbol symbol = (ILineSymbol)this.mapContextManager.getSymbolManager().createSymbol("line");
            symbol.setLineColor(Color.RED);
            symbol.draw(g, this.identity, shapeAux, null, null);
        }
    }

    @Override
    public void pointPosition(Point2D p) {
        this.pointPosition = p;
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(PolyLineAdapter.class, PERSISTENCE_DEFINITION_NAME, "PolyLine Adapter persistence definition", null, null);
            definition.extend(manager.getDefinition("GeometryAdapter"));
        }
    }
}

