/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.gui.dialogs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.project.documents.layout.LayoutDocument;
import org.gvsig.app.project.documents.layout.commands.FrameCommandsRecord;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventsFAlign
implements ActionListener {
    protected static final Logger LOG = LoggerFactory.getLogger(EventsFAlign.class);
    private LayoutPanel m_layout;
    private boolean inLayout = false;
    private int alignRelativeTo;

    LayoutPanel getLayout() {
        LayoutDocument layoutDocument = (LayoutDocument)ApplicationLocator.getManager().getActiveDocument(LayoutDocument.class);
        if (layoutDocument == null) {
            return null;
        }
        this.m_layout = (LayoutPanel)layoutDocument.getMainWindow();
        return this.m_layout;
    }

    private void alignLeft() throws CloneNotSupportedException {
        LayoutPanel theLayout = this.getLayout();
        if (theLayout == null) {
            return;
        }
        IFFrame[] fframes = theLayout.getLayoutContext().getSelectedFFrames();
        if (fframes.length == 0) {
            return;
        }
        double xmin = Double.POSITIVE_INFINITY;
        switch (this.alignRelativeTo) {
            case 1: {
                xmin = 0.0;
                break;
            }
            case 0: {
                IFFrame fframe;
                int i;
                for (i = 0; i < fframes.length; ++i) {
                    fframe = fframes[i];
                    if (!(xmin > fframe.getBoundBox().getMinX())) continue;
                    xmin = fframe.getBoundBox().getMinX();
                }
                break;
            }
            case 2: {
                IFFrame fframe;
                int i;
                double w = Double.NEGATIVE_INFINITY;
                for (i = 0; i < fframes.length; ++i) {
                    fframe = fframes[i];
                    if (!(w < fframe.getBoundBox().getWidth())) continue;
                    w = fframe.getBoundBox().getWidth();
                    xmin = fframe.getBoundBox().getMinX();
                }
                break;
            }
            case 3: {
                IFFrame fframe;
                int i;
                double w = Double.POSITIVE_INFINITY;
                for (i = 0; i < fframes.length; ++i) {
                    fframe = fframes[i];
                    if (!(w > fframe.getBoundBox().getWidth())) continue;
                    w = fframe.getBoundBox().getWidth();
                    xmin = fframe.getBoundBox().getMinX();
                }
                break;
            }
            default: {
                return;
            }
        }
        FrameCommandsRecord efs = theLayout.getLayoutContext().getFrameCommandsRecord();
        efs.startComplex(PluginServices.getText((Object)this, (String)"align_left"));
        for (int i = fframes.length - 1; i >= 0; --i) {
            IFFrame fframe = (IFFrame)fframes[i].clone();
            Rectangle2D.Double r = (Rectangle2D.Double)fframe.getBoundBox().clone();
            r.x = xmin;
            fframe.setBoundBox(r);
            efs.update(fframes[i], fframe);
        }
        efs.endComplex();
    }

    private void alignCenterH() throws Exception {
        LayoutPanel theLayout = this.getLayout();
        if (theLayout == null) {
            return;
        }
        IFFrame[] fframes = theLayout.getLayoutContext().getSelectedFFrames();
        if (fframes.length == 0) {
            return;
        }
        double xcenter = 0.0;
        switch (this.alignRelativeTo) {
            case 1: {
                xcenter = theLayout.getLayoutContext().getAttributes().getPaperSize().getWidth() / 2.0;
                break;
            }
            case 0: {
                IFFrame fframe;
                int i;
                GeometryManager geomManager = GeometryLocator.getGeometryManager();
                Envelope env = geomManager.createEnvelope(0);
                for (i = 0; i < fframes.length; ++i) {
                    fframe = fframes[i];
                    Rectangle2D.Double bbox = fframe.getBoundBox();
                    env.add(geomManager.createEnvelope(bbox.getMinX(), bbox.getMinY(), bbox.getMaxX(), bbox.getMaxY(), 0));
                }
                if (env.isEmpty()) {
                    return;
                }
                xcenter = env.getCenter(0);
                break;
            }
            case 2: {
                IFFrame fframe;
                int i;
                double w = Double.NEGATIVE_INFINITY;
                for (i = 0; i < fframes.length; ++i) {
                    fframe = fframes[i];
                    if (!(w < fframe.getBoundBox().getWidth())) continue;
                    w = fframe.getBoundBox().getWidth();
                    xcenter = fframe.getBoundBox().getCenterX();
                }
                break;
            }
            case 3: {
                IFFrame fframe;
                int i;
                double w = Double.POSITIVE_INFINITY;
                for (i = 0; i < fframes.length; ++i) {
                    fframe = fframes[i];
                    if (!(w > fframe.getBoundBox().getWidth())) continue;
                    w = fframe.getBoundBox().getWidth();
                    xcenter = fframe.getBoundBox().getCenterX();
                }
                break;
            }
            default: {
                return;
            }
        }
        FrameCommandsRecord efs = theLayout.getLayoutContext().getFrameCommandsRecord();
        efs.startComplex(PluginServices.getText((Object)this, (String)"align_center"));
        for (int i = 0; i < fframes.length; ++i) {
            IFFrame fframe = (IFFrame)fframes[i].clone();
            Rectangle2D.Double r = (Rectangle2D.Double)fframe.getBoundBox().clone();
            r.x = xcenter - fframe.getBoundBox().width / 2.0;
            fframe.setBoundBox(r);
            efs.update(fframes[i], fframe);
        }
        efs.endComplex();
    }

    private void alignRight() throws CloneNotSupportedException {
        LayoutPanel theLayout = this.getLayout();
        if (theLayout == null) {
            return;
        }
        IFFrame[] fframes = theLayout.getLayoutContext().getSelectedFFrames();
        if (fframes.length == 0) {
            return;
        }
        double xmax = Double.NEGATIVE_INFINITY;
        switch (this.alignRelativeTo) {
            case 1: {
                xmax = theLayout.getLayoutContext().getAttributes().getPaperSize().getWidth();
                break;
            }
            case 0: {
                IFFrame fframe;
                int i;
                for (i = 0; i < fframes.length; ++i) {
                    fframe = fframes[i];
                    if (!(xmax < fframe.getBoundBox().getMaxX())) continue;
                    xmax = fframe.getBoundBox().getMaxX();
                }
                break;
            }
            case 2: {
                IFFrame fframe;
                int i;
                double w = Double.NEGATIVE_INFINITY;
                for (i = 0; i < fframes.length; ++i) {
                    fframe = fframes[i];
                    if (!(w < fframe.getBoundBox().getWidth())) continue;
                    w = fframe.getBoundBox().getWidth();
                    xmax = fframe.getBoundBox().getMaxX();
                }
                break;
            }
            case 3: {
                IFFrame fframe;
                int i;
                double w = Double.POSITIVE_INFINITY;
                for (i = 0; i < fframes.length; ++i) {
                    fframe = fframes[i];
                    if (!(w > fframe.getBoundBox().getWidth())) continue;
                    w = fframe.getBoundBox().getWidth();
                    xmax = fframe.getBoundBox().getMaxX();
                }
                break;
            }
            default: {
                return;
            }
        }
        FrameCommandsRecord efs = theLayout.getLayoutContext().getFrameCommandsRecord();
        efs.startComplex(PluginServices.getText((Object)this, (String)"align_right"));
        for (int i = 0; i < fframes.length; ++i) {
            IFFrame fframe = (IFFrame)fframes[i].clone();
            Rectangle2D.Double r = (Rectangle2D.Double)fframe.getBoundBox().clone();
            r.x = xmax - fframes[i].getBoundBox().width;
            fframe.setBoundBox(r);
            efs.update(fframes[i], fframe);
        }
        efs.endComplex();
    }

    private void alignDown() throws CloneNotSupportedException {
        LayoutPanel theLayout = this.getLayout();
        if (theLayout == null) {
            return;
        }
        IFFrame[] fframes = theLayout.getLayoutContext().getSelectedFFrames();
        if (fframes.length == 0) {
            return;
        }
        double ymax = Double.NEGATIVE_INFINITY;
        switch (this.alignRelativeTo) {
            case 1: {
                ymax = theLayout.getLayoutContext().getAttributes().getPaperSize().getHeight();
                break;
            }
            case 0: {
                IFFrame fframe;
                int i;
                for (i = 0; i < fframes.length; ++i) {
                    fframe = fframes[i];
                    if (!(ymax < fframe.getBoundBox().getMaxY())) continue;
                    ymax = fframe.getBoundBox().getMaxY();
                }
                break;
            }
            case 2: {
                IFFrame fframe;
                int i;
                double h = Double.NEGATIVE_INFINITY;
                for (i = 0; i < fframes.length; ++i) {
                    fframe = fframes[i];
                    if (!(h < fframe.getBoundBox().getHeight())) continue;
                    h = fframe.getBoundBox().getHeight();
                    ymax = fframe.getBoundBox().getMaxY();
                }
                break;
            }
            case 3: {
                IFFrame fframe;
                int i;
                double h = Double.POSITIVE_INFINITY;
                for (i = 0; i < fframes.length; ++i) {
                    fframe = fframes[i];
                    if (!(h > fframe.getBoundBox().getHeight())) continue;
                    h = fframe.getBoundBox().getHeight();
                    ymax = fframe.getBoundBox().getMaxY();
                }
                break;
            }
            default: {
                return;
            }
        }
        FrameCommandsRecord efs = theLayout.getLayoutContext().getFrameCommandsRecord();
        efs.startComplex(PluginServices.getText((Object)this, (String)"align_down"));
        for (int i = 0; i < fframes.length; ++i) {
            IFFrame fframe = (IFFrame)fframes[i].clone();
            Rectangle2D.Double r = (Rectangle2D.Double)fframe.getBoundBox().clone();
            r.y = ymax - fframe.getBoundBox().height;
            fframe.setBoundBox(r);
            efs.update(fframes[i], fframe);
        }
        efs.endComplex();
    }

    private void alignUp() throws CloneNotSupportedException {
        LayoutPanel theLayout = this.getLayout();
        if (theLayout == null) {
            return;
        }
        IFFrame[] fframes = theLayout.getLayoutContext().getSelectedFFrames();
        if (fframes.length == 0) {
            return;
        }
        double ymin = Double.MAX_VALUE;
        switch (this.alignRelativeTo) {
            case 1: {
                ymin = 0.0;
                break;
            }
            case 0: {
                IFFrame fframe;
                int i;
                for (i = 0; i < fframes.length; ++i) {
                    fframe = fframes[i];
                    if (!(ymin > fframe.getBoundBox().getMinY())) continue;
                    ymin = fframe.getBoundBox().getMinY();
                }
                break;
            }
            case 2: {
                IFFrame fframe;
                int i;
                double h = Double.NEGATIVE_INFINITY;
                for (i = 0; i < fframes.length; ++i) {
                    fframe = fframes[i];
                    if (!(h < fframe.getBoundBox().getHeight())) continue;
                    h = fframe.getBoundBox().getHeight();
                    ymin = fframe.getBoundBox().getMinY();
                }
                break;
            }
            case 3: {
                IFFrame fframe;
                int i;
                double h = Double.POSITIVE_INFINITY;
                for (i = 0; i < fframes.length; ++i) {
                    fframe = fframes[i];
                    if (!(h > fframe.getBoundBox().getHeight())) continue;
                    h = fframe.getBoundBox().getHeight();
                    ymin = fframe.getBoundBox().getMinY();
                }
                break;
            }
            default: {
                return;
            }
        }
        FrameCommandsRecord efs = theLayout.getLayoutContext().getFrameCommandsRecord();
        efs.startComplex(PluginServices.getText((Object)this, (String)"align_up"));
        for (int i = 0; i < fframes.length; ++i) {
            IFFrame fframe = (IFFrame)fframes[i].clone();
            Rectangle2D.Double r = (Rectangle2D.Double)fframe.getBoundBox().clone();
            r.y = ymin;
            fframe.setBoundBox(r);
            efs.update(fframes[i], fframe);
        }
        efs.endComplex();
    }

    private void alignCenterV() throws Exception {
        LayoutPanel theLayout = this.getLayout();
        if (theLayout == null) {
            return;
        }
        IFFrame[] fframes = theLayout.getLayoutContext().getSelectedFFrames();
        if (fframes.length == 0) {
            return;
        }
        double ycenter = 0.0;
        double h = Double.NEGATIVE_INFINITY;
        switch (this.alignRelativeTo) {
            case 1: {
                ycenter = theLayout.getLayoutContext().getAttributes().getPaperSize().getHeight() / 2.0;
                break;
            }
            case 0: {
                IFFrame fframe;
                int i;
                GeometryManager geomManager = GeometryLocator.getGeometryManager();
                Envelope env = geomManager.createEnvelope(0);
                for (i = 0; i < fframes.length; ++i) {
                    fframe = fframes[i];
                    Rectangle2D.Double bbox = fframe.getBoundBox();
                    env.add(geomManager.createEnvelope(bbox.getMinX(), bbox.getMinY(), bbox.getMaxX(), bbox.getMaxY(), 0));
                }
                if (env.isEmpty()) {
                    return;
                }
                ycenter = env.getCenter(1);
                break;
            }
            case 2: {
                IFFrame fframe;
                int i;
                h = Double.NEGATIVE_INFINITY;
                for (i = 0; i < fframes.length; ++i) {
                    fframe = fframes[i];
                    if (!(h < fframe.getBoundBox().getHeight())) continue;
                    h = fframe.getBoundBox().getHeight();
                    ycenter = fframe.getBoundBox().getCenterY();
                }
                break;
            }
            case 3: {
                IFFrame fframe;
                int i;
                h = Double.POSITIVE_INFINITY;
                for (i = 0; i < fframes.length; ++i) {
                    fframe = fframes[i];
                    if (!(h > fframe.getBoundBox().getHeight())) continue;
                    h = fframe.getBoundBox().getHeight();
                    ycenter = fframe.getBoundBox().getCenterY();
                }
                break;
            }
            default: {
                return;
            }
        }
        FrameCommandsRecord efs = theLayout.getLayoutContext().getFrameCommandsRecord();
        efs.startComplex(PluginServices.getText((Object)this, (String)"align_vertical_center"));
        for (int i = 0; i < fframes.length; ++i) {
            IFFrame fframe = (IFFrame)fframes[i].clone();
            Rectangle2D.Double r = (Rectangle2D.Double)fframe.getBoundBox().clone();
            r.y = ycenter - fframe.getBoundBox().height / 2.0;
            fframe.setBoundBox(r);
            efs.update(fframes[i], fframe);
        }
        efs.endComplex();
    }

    private void distLeft() throws CloneNotSupportedException {
        double xmax;
        double xmin;
        LayoutPanel theLayout = this.getLayout();
        if (theLayout == null) {
            return;
        }
        int num = 0;
        IFFrame[] fframes = theLayout.getLayoutContext().getSelectedFFrames();
        num = fframes.length;
        if (num <= 1) {
            return;
        }
        List<IFFrame> fframesList = Arrays.asList(fframes);
        fframesList.sort(new Comparator<IFFrame>(){

            @Override
            public int compare(IFFrame o1, IFFrame o2) {
                double res = Double.compare(o1.getBoundBox().getMinX(), o2.getBoundBox().getMinX());
                if (res == 0.0) {
                    res = Double.compare(o1.getBoundBox().getMaxX(), o2.getBoundBox().getMaxX());
                }
                return (int)Math.round(res);
            }
        });
        switch (this.alignRelativeTo) {
            case 1: {
                xmin = 0.0;
                double layoutWidth = theLayout.getLayoutContext().getAttributes().getPaperSize().getWidth();
                double lastFrameWidth = fframesList.get(fframesList.size() - 1).getBoundBox().getWidth();
                xmax = layoutWidth - lastFrameWidth;
                break;
            }
            case 0: {
                xmin = Double.POSITIVE_INFINITY;
                xmax = Double.NEGATIVE_INFINITY;
                for (IFFrame fframe : fframesList) {
                    if (xmin > fframe.getBoundBox().getMinX()) {
                        xmin = fframe.getBoundBox().getMinX();
                    }
                    if (!(xmax < fframe.getBoundBox().getMinX())) continue;
                    xmax = fframe.getBoundBox().getMinX();
                }
                break;
            }
            default: {
                return;
            }
        }
        double dif = xmax - xmin;
        double dist = dif / (double)(num - 1);
        FrameCommandsRecord efs = theLayout.getLayoutContext().getFrameCommandsRecord();
        efs.startComplex(PluginServices.getText((Object)this, (String)"distributes_left"));
        int i = 0;
        for (IFFrame fframe : fframesList) {
            IFFrame fframeCloned = (IFFrame)fframe.clone();
            Rectangle2D.Double r = (Rectangle2D.Double)fframeCloned.getBoundBox().clone();
            r.x = xmin + dist * (double)i++;
            fframeCloned.setBoundBox(r);
            efs.update(fframe, fframeCloned);
        }
        efs.endComplex();
    }

    private void distRight() throws CloneNotSupportedException {
        double xmin;
        double xmax;
        LayoutPanel theLayout = this.getLayout();
        if (theLayout == null) {
            return;
        }
        int num = 0;
        IFFrame[] fframes = theLayout.getLayoutContext().getSelectedFFrames();
        num = fframes.length;
        if (num <= 1) {
            return;
        }
        List<IFFrame> fframesList = Arrays.asList(fframes);
        fframesList.sort(new Comparator<IFFrame>(){

            @Override
            public int compare(IFFrame o1, IFFrame o2) {
                double res = Double.compare(o2.getBoundBox().getMaxX(), o1.getBoundBox().getMaxX());
                if (res == 0.0) {
                    res = Double.compare(o2.getBoundBox().getMinX(), o1.getBoundBox().getMinX());
                }
                return (int)Math.round(res);
            }
        });
        switch (this.alignRelativeTo) {
            case 1: {
                double layoutWidth = theLayout.getLayoutContext().getAttributes().getPaperSize().getWidth();
                double leftFrameWidth = fframesList.get(fframesList.size() - 1).getBoundBox().getWidth();
                xmax = layoutWidth;
                xmin = leftFrameWidth;
                break;
            }
            case 0: {
                xmin = Double.POSITIVE_INFINITY;
                xmax = Double.NEGATIVE_INFINITY;
                for (IFFrame fframe : fframesList) {
                    if (xmin > fframe.getBoundBox().getMaxX()) {
                        xmin = fframe.getBoundBox().getMaxX();
                    }
                    if (!(xmax < fframe.getBoundBox().getMaxX())) continue;
                    xmax = fframe.getBoundBox().getMaxX();
                }
                break;
            }
            default: {
                return;
            }
        }
        double dif = xmax - xmin;
        double dist = dif / (double)(num - 1);
        FrameCommandsRecord efs = theLayout.getLayoutContext().getFrameCommandsRecord();
        efs.startComplex(PluginServices.getText((Object)this, (String)"distributes_right"));
        int i = 0;
        for (IFFrame fframe : fframesList) {
            IFFrame fframecloned = (IFFrame)fframe.clone();
            Rectangle2D.Double r = (Rectangle2D.Double)fframecloned.getBoundBox().clone();
            r.x = xmax - dist * (double)i++ - fframecloned.getBoundBox().width;
            fframecloned.setBoundBox(r);
            efs.update(fframe, fframecloned);
        }
        efs.endComplex();
    }

    private void distUp() throws CloneNotSupportedException {
        double ymax;
        double ymin;
        LayoutPanel theLayout = this.getLayout();
        if (theLayout == null) {
            return;
        }
        int num = 0;
        IFFrame[] fframes = theLayout.getLayoutContext().getSelectedFFrames();
        num = fframes.length;
        if (num <= 1) {
            return;
        }
        List<IFFrame> fframesList = Arrays.asList(fframes);
        fframesList.sort(new Comparator<IFFrame>(){

            @Override
            public int compare(IFFrame o1, IFFrame o2) {
                double res = Double.compare(o1.getBoundBox().getMinY(), o2.getBoundBox().getMinY());
                if (res == 0.0) {
                    res = Double.compare(o1.getBoundBox().getMaxY(), o2.getBoundBox().getMaxY());
                }
                return (int)Math.round(res);
            }
        });
        switch (this.alignRelativeTo) {
            case 1: {
                ymin = 0.0;
                double layoutHeight = theLayout.getLayoutContext().getAttributes().getPaperSize().getHeight();
                double lastFrameHeight = fframesList.get(fframesList.size() - 1).getBoundBox().getHeight();
                ymax = layoutHeight - lastFrameHeight;
                break;
            }
            case 0: {
                ymin = Double.POSITIVE_INFINITY;
                ymax = Double.NEGATIVE_INFINITY;
                for (IFFrame fframe : fframesList) {
                    if (ymin > fframe.getBoundBox().getMinY()) {
                        ymin = fframe.getBoundBox().getMinY();
                    }
                    if (!(ymax < fframe.getBoundBox().getMinY())) continue;
                    ymax = fframe.getBoundBox().getMinY();
                }
                break;
            }
            default: {
                return;
            }
        }
        double dif = ymax - ymin;
        double dist = dif / (double)(num - 1);
        FrameCommandsRecord efs = theLayout.getLayoutContext().getFrameCommandsRecord();
        efs.startComplex(PluginServices.getText((Object)this, (String)"distributes_up"));
        int i = 0;
        for (IFFrame fframe : fframesList) {
            IFFrame fframeCloned = (IFFrame)fframe.clone();
            Rectangle2D.Double r = (Rectangle2D.Double)fframeCloned.getBoundBox().clone();
            r.y = ymin + dist * (double)i++;
            fframeCloned.setBoundBox(r);
            efs.update(fframe, fframeCloned);
        }
        efs.endComplex();
    }

    private void distDown() throws CloneNotSupportedException {
        double ymin;
        double ymax;
        LayoutPanel theLayout = this.getLayout();
        if (theLayout == null) {
            return;
        }
        int num = 0;
        IFFrame[] fframes = theLayout.getLayoutContext().getSelectedFFrames();
        num = fframes.length;
        if (num <= 1) {
            return;
        }
        List<IFFrame> fframesList = Arrays.asList(fframes);
        fframesList.sort(new Comparator<IFFrame>(){

            @Override
            public int compare(IFFrame o1, IFFrame o2) {
                double res = Double.compare(o2.getBoundBox().getMaxY(), o1.getBoundBox().getMaxY());
                if (res == 0.0) {
                    res = Double.compare(o2.getBoundBox().getMinY(), o1.getBoundBox().getMinY());
                }
                return (int)Math.round(res);
            }
        });
        switch (this.alignRelativeTo) {
            case 1: {
                double layoutHeight = theLayout.getLayoutContext().getAttributes().getPaperSize().getHeight();
                double leftFrameHeight = fframesList.get(fframesList.size() - 1).getBoundBox().getHeight();
                ymax = layoutHeight;
                ymin = leftFrameHeight;
                break;
            }
            case 0: {
                ymin = Double.POSITIVE_INFINITY;
                ymax = Double.NEGATIVE_INFINITY;
                for (IFFrame fframe : fframesList) {
                    if (ymin > fframe.getBoundBox().getMaxY()) {
                        ymin = fframe.getBoundBox().getMaxY();
                    }
                    if (!(ymax < fframe.getBoundBox().getMaxY())) continue;
                    ymax = fframe.getBoundBox().getMaxY();
                }
                break;
            }
            default: {
                return;
            }
        }
        double dif = ymax - ymin;
        double dist = dif / (double)(num - 1);
        FrameCommandsRecord efs = theLayout.getLayoutContext().getFrameCommandsRecord();
        efs.startComplex(PluginServices.getText((Object)this, (String)"distributes_down"));
        int i = 0;
        for (IFFrame fframe : fframesList) {
            IFFrame fframecloned = (IFFrame)fframe.clone();
            Rectangle2D.Double r = (Rectangle2D.Double)fframecloned.getBoundBox().clone();
            r.y = ymax - dist * (double)i++ - fframecloned.getBoundBox().height;
            fframecloned.setBoundBox(r);
            efs.update(fframe, fframecloned);
        }
        efs.endComplex();
    }

    private void distCenterV() throws CloneNotSupportedException {
        double xmax;
        double xmin;
        LayoutPanel theLayout = this.getLayout();
        if (theLayout == null) {
            return;
        }
        int num = 0;
        IFFrame[] fframes = theLayout.getLayoutContext().getSelectedFFrames();
        num = fframes.length;
        if (num <= 1) {
            return;
        }
        List<IFFrame> fframesList = Arrays.asList(fframes);
        fframesList.sort(new Comparator<IFFrame>(){

            @Override
            public int compare(IFFrame o1, IFFrame o2) {
                double res = Double.compare(o1.getBoundBox().getCenterX(), o2.getBoundBox().getCenterX());
                if (res == 0.0) {
                    res = Double.compare(o1.getBoundBox().getMinX(), o2.getBoundBox().getMinX());
                }
                return (int)Math.round(res);
            }
        });
        switch (this.alignRelativeTo) {
            case 1: {
                xmin = fframesList.get(0).getBoundBox().getWidth() / 2.0;
                double layoutWidth = theLayout.getLayoutContext().getAttributes().getPaperSize().getWidth();
                double lastFrameWidth = fframesList.get(fframesList.size() - 1).getBoundBox().getWidth();
                xmax = layoutWidth - lastFrameWidth / 2.0;
                break;
            }
            case 0: {
                xmin = Double.POSITIVE_INFINITY;
                xmax = Double.NEGATIVE_INFINITY;
                for (IFFrame fframe : fframesList) {
                    if (xmin > fframe.getBoundBox().getCenterX()) {
                        xmin = fframe.getBoundBox().getCenterX();
                    }
                    if (!(xmax < fframe.getBoundBox().getCenterX())) continue;
                    xmax = fframe.getBoundBox().getCenterX();
                }
                break;
            }
            default: {
                return;
            }
        }
        double dif = xmax - xmin;
        double dist = dif / (double)(num - 1);
        FrameCommandsRecord efs = theLayout.getLayoutContext().getFrameCommandsRecord();
        efs.startComplex(PluginServices.getText((Object)this, (String)"distributes_vertical"));
        int i = 0;
        for (IFFrame fframe : fframesList) {
            IFFrame fframeCloned = (IFFrame)fframe.clone();
            Rectangle2D.Double r = (Rectangle2D.Double)fframeCloned.getBoundBox().clone();
            r.x = xmin + dist * (double)i++ - r.width / 2.0;
            fframeCloned.setBoundBox(r);
            efs.update(fframe, fframeCloned);
        }
        efs.endComplex();
    }

    private void distCenterH() throws CloneNotSupportedException {
        double ymax;
        double ymin;
        LayoutPanel theLayout = this.getLayout();
        if (theLayout == null) {
            return;
        }
        int num = 0;
        IFFrame[] fframes = theLayout.getLayoutContext().getSelectedFFrames();
        num = fframes.length;
        if (num <= 1) {
            return;
        }
        List<IFFrame> fframesList = Arrays.asList(fframes);
        fframesList.sort(new Comparator<IFFrame>(){

            @Override
            public int compare(IFFrame o1, IFFrame o2) {
                double res = Double.compare(o1.getBoundBox().getCenterY(), o2.getBoundBox().getCenterY());
                if (res == 0.0) {
                    res = Double.compare(o1.getBoundBox().getMinY(), o2.getBoundBox().getMinY());
                }
                return (int)Math.round(res);
            }
        });
        switch (this.alignRelativeTo) {
            case 1: {
                ymin = fframesList.get(0).getBoundBox().getHeight() / 2.0;
                double layoutHeigth = theLayout.getLayoutContext().getAttributes().getPaperSize().getHeight();
                double lastFrameHeight = fframesList.get(fframesList.size() - 1).getBoundBox().getHeight();
                ymax = layoutHeigth - lastFrameHeight / 2.0;
                break;
            }
            case 0: {
                ymin = Double.POSITIVE_INFINITY;
                ymax = Double.NEGATIVE_INFINITY;
                for (IFFrame fframe : fframesList) {
                    if (ymin > fframe.getBoundBox().getCenterY()) {
                        ymin = fframe.getBoundBox().getCenterY();
                    }
                    if (!(ymax < fframe.getBoundBox().getCenterY())) continue;
                    ymax = fframe.getBoundBox().getCenterY();
                }
                break;
            }
            default: {
                return;
            }
        }
        double dif = ymax - ymin;
        double dist = dif / (double)(num - 1);
        FrameCommandsRecord efs = theLayout.getLayoutContext().getFrameCommandsRecord();
        efs.startComplex(PluginServices.getText((Object)this, (String)"distributes_vertical"));
        int i = 0;
        for (IFFrame fframe : fframesList) {
            IFFrame fframeCloned = (IFFrame)fframe.clone();
            Rectangle2D.Double r = (Rectangle2D.Double)fframeCloned.getBoundBox().clone();
            r.y = ymin + dist * (double)i++ - r.height / 2.0;
            fframeCloned.setBoundBox(r);
            efs.update(fframe, fframeCloned);
        }
        efs.endComplex();
    }

    private void sizeWidth() throws Exception {
        double wmax;
        LayoutPanel theLayout = this.getLayout();
        if (theLayout == null) {
            return;
        }
        IFFrame[] fframes = theLayout.getLayoutContext().getSelectedFFrames();
        if (fframes.length == 0) {
            return;
        }
        switch (this.alignRelativeTo) {
            case 1: {
                wmax = theLayout.getLayoutContext().getAttributes().getPaperSize().getWidth();
                break;
            }
            case 0: {
                IFFrame fframe;
                int i;
                GeometryManager geomManager = GeometryLocator.getGeometryManager();
                Envelope env = geomManager.createEnvelope(0);
                for (i = 0; i < fframes.length; ++i) {
                    fframe = fframes[i];
                    Rectangle2D.Double bbox = fframe.getBoundBox();
                    env.add(geomManager.createEnvelope(bbox.getMinX(), bbox.getMinY(), bbox.getMaxX(), bbox.getMaxY(), 0));
                }
                if (env.isEmpty()) {
                    return;
                }
                wmax = env.getLength(0);
                break;
            }
            case 2: {
                IFFrame fframe;
                int i;
                wmax = Double.NEGATIVE_INFINITY;
                for (i = 0; i < fframes.length; ++i) {
                    fframe = fframes[i];
                    if (!(wmax < fframe.getBoundBox().getWidth())) continue;
                    wmax = fframe.getBoundBox().getWidth();
                }
                break;
            }
            case 3: {
                IFFrame fframe;
                int i;
                wmax = Double.POSITIVE_INFINITY;
                for (i = 0; i < fframes.length; ++i) {
                    fframe = fframes[i];
                    if (!(wmax > fframe.getBoundBox().getWidth())) continue;
                    wmax = fframe.getBoundBox().getWidth();
                }
                break;
            }
            default: {
                return;
            }
        }
        FrameCommandsRecord efs = theLayout.getLayoutContext().getFrameCommandsRecord();
        efs.startComplex(PluginServices.getText((Object)this, (String)"change_width"));
        for (int i = 0; i < fframes.length; ++i) {
            IFFrame fframe = (IFFrame)fframes[i].clone();
            Rectangle2D.Double r = (Rectangle2D.Double)fframe.getBoundBox().clone();
            r.width = wmax;
            fframe.setBoundBox(r);
            efs.update(fframes[i], fframe);
        }
        efs.endComplex();
    }

    private void sizeHeight() throws Exception {
        double hmax;
        LayoutPanel theLayout = this.getLayout();
        if (theLayout == null) {
            return;
        }
        IFFrame[] fframes = theLayout.getLayoutContext().getSelectedFFrames();
        if (fframes.length == 0) {
            return;
        }
        switch (this.alignRelativeTo) {
            case 1: {
                hmax = theLayout.getLayoutContext().getAttributes().getPaperSize().getHeight();
                break;
            }
            case 0: {
                IFFrame fframe;
                int i;
                GeometryManager geomManager = GeometryLocator.getGeometryManager();
                Envelope env = geomManager.createEnvelope(0);
                for (i = 0; i < fframes.length; ++i) {
                    fframe = fframes[i];
                    Rectangle2D.Double bbox = fframe.getBoundBox();
                    env.add(geomManager.createEnvelope(bbox.getMinX(), bbox.getMinY(), bbox.getMaxX(), bbox.getMaxY(), 0));
                }
                if (env.isEmpty()) {
                    return;
                }
                hmax = env.getLength(1);
                break;
            }
            case 2: {
                IFFrame fframe;
                int i;
                hmax = Double.NEGATIVE_INFINITY;
                for (i = 0; i < fframes.length; ++i) {
                    fframe = fframes[i];
                    if (!(hmax < fframe.getBoundBox().getHeight())) continue;
                    hmax = fframe.getBoundBox().getHeight();
                }
                break;
            }
            case 3: {
                IFFrame fframe;
                int i;
                hmax = Double.POSITIVE_INFINITY;
                for (i = 0; i < fframes.length; ++i) {
                    fframe = fframes[i];
                    if (!(hmax > fframe.getBoundBox().getHeight())) continue;
                    hmax = fframe.getBoundBox().getHeight();
                }
                break;
            }
            default: {
                return;
            }
        }
        FrameCommandsRecord efs = theLayout.getLayoutContext().getFrameCommandsRecord();
        efs.startComplex(PluginServices.getText((Object)this, (String)"change_height"));
        for (int i = 0; i < fframes.length; ++i) {
            IFFrame fframe = (IFFrame)fframes[i].clone();
            Rectangle2D.Double r = (Rectangle2D.Double)fframe.getBoundBox().clone();
            r.height = hmax;
            fframe.setBoundBox(r);
            efs.update(fframes[i], fframe);
        }
        efs.endComplex();
    }

    private void spaceRight() throws CloneNotSupportedException {
        LayoutPanel theLayout = this.getLayout();
        if (theLayout == null) {
            return;
        }
        double xmin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        int num = 0;
        IFFrame[] fframes = theLayout.getLayoutContext().getSelectedFFrames();
        num = fframes.length;
        if (num <= 1) {
            return;
        }
        List<IFFrame> fframesList = Arrays.asList(fframes);
        fframesList.sort(new Comparator<IFFrame>(){

            @Override
            public int compare(IFFrame o1, IFFrame o2) {
                double res = Double.compare(o1.getBoundBox().getMinX(), o2.getBoundBox().getMinX());
                if (res == 0.0) {
                    res = Double.compare(o1.getBoundBox().getMaxX(), o2.getBoundBox().getMaxX());
                }
                return (int)Math.round(res);
            }
        });
        double framesWidth = 0.0;
        switch (this.alignRelativeTo) {
            case 1: {
                xmin = 0.0;
                xmax = theLayout.getLayoutContext().getAttributes().getPaperSize().getWidth();
                for (IFFrame fframe : fframesList) {
                    framesWidth += fframe.getBoundBox().getWidth();
                }
                break;
            }
            case 0: {
                for (IFFrame fframe : fframesList) {
                    if (xmin > fframe.getBoundBox().getMinX()) {
                        xmin = fframe.getBoundBox().getMinX();
                    }
                    if (xmax < fframe.getBoundBox().getMaxX()) {
                        xmax = fframe.getBoundBox().getMaxX();
                    }
                    framesWidth += fframe.getBoundBox().getWidth();
                }
                break;
            }
            default: {
                return;
            }
        }
        double dif = xmax - xmin;
        double dist = (dif - framesWidth) / (double)(num - 1);
        FrameCommandsRecord efs = theLayout.getLayoutContext().getFrameCommandsRecord();
        efs.startComplex(PluginServices.getText((Object)this, (String)"distributes_right"));
        boolean i = false;
        double currentX = xmin;
        for (IFFrame fframe : fframesList) {
            IFFrame fframeCloned = (IFFrame)fframe.clone();
            Rectangle2D.Double r = (Rectangle2D.Double)fframeCloned.getBoundBox().clone();
            r.x = currentX;
            currentX += r.width + dist;
            fframeCloned.setBoundBox(r);
            efs.update(fframe, fframeCloned);
        }
        efs.endComplex();
    }

    private void spaceDown() throws CloneNotSupportedException {
        LayoutPanel theLayout = this.getLayout();
        if (theLayout == null) {
            return;
        }
        double ymin = Double.POSITIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        int num = 0;
        IFFrame[] fframes = theLayout.getLayoutContext().getSelectedFFrames();
        num = fframes.length;
        if (num <= 1) {
            return;
        }
        List<IFFrame> fframesList = Arrays.asList(fframes);
        fframesList.sort(new Comparator<IFFrame>(){

            @Override
            public int compare(IFFrame o1, IFFrame o2) {
                double res = Double.compare(o1.getBoundBox().getMinY(), o2.getBoundBox().getMinY());
                if (res == 0.0) {
                    res = Double.compare(o1.getBoundBox().getMaxY(), o2.getBoundBox().getMaxY());
                }
                return (int)Math.round(res);
            }
        });
        double framesHeight = 0.0;
        switch (this.alignRelativeTo) {
            case 1: {
                ymin = 0.0;
                ymax = theLayout.getLayoutContext().getAttributes().getPaperSize().getHeight();
                for (IFFrame fframe : fframesList) {
                    framesHeight += fframe.getBoundBox().getHeight();
                }
                break;
            }
            case 0: {
                for (IFFrame fframe : fframesList) {
                    if (ymin > fframe.getBoundBox().getMinY()) {
                        ymin = fframe.getBoundBox().getMinY();
                    }
                    if (ymax < fframe.getBoundBox().getMaxY()) {
                        ymax = fframe.getBoundBox().getMaxY();
                    }
                    framesHeight += fframe.getBoundBox().getHeight();
                }
                break;
            }
            default: {
                return;
            }
        }
        double dif = ymax - ymin;
        double dist = (dif - framesHeight) / (double)(num - 1);
        FrameCommandsRecord efs = theLayout.getLayoutContext().getFrameCommandsRecord();
        efs.startComplex(PluginServices.getText((Object)this, (String)"distributes_up"));
        boolean i = false;
        double currentY = ymin;
        for (IFFrame fframe : fframesList) {
            IFFrame fframeCloned = (IFFrame)fframe.clone();
            Rectangle2D.Double r = (Rectangle2D.Double)fframeCloned.getBoundBox().clone();
            r.y = currentY;
            currentY += r.height + dist;
            fframeCloned.setBoundBox(r);
            efs.update(fframe, fframeCloned);
        }
        efs.endComplex();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LayoutPanel theLayout = this.getLayout();
        if (theLayout == null) {
            return;
        }
        theLayout.getLayoutContext().updateFFrames();
        String actionCommand = e.getActionCommand().toUpperCase();
        if (null == actionCommand) {
            return;
        }
        try {
            switch (actionCommand) {
                case "LEFT": {
                    this.alignLeft();
                    break;
                }
                case "CENTERV": {
                    this.alignCenterH();
                    break;
                }
                case "RIGHT": {
                    this.alignRight();
                    break;
                }
                case "UP": {
                    this.alignUp();
                    break;
                }
                case "CENTERH": {
                    this.alignCenterV();
                    break;
                }
                case "DOWN": {
                    this.alignDown();
                    break;
                }
                case "DISTUP": {
                    this.distUp();
                    break;
                }
                case "DISTCENTERV": {
                    this.distCenterV();
                    break;
                }
                case "DISTDOWN": {
                    this.distDown();
                    break;
                }
                case "DISTLEFT": {
                    this.distLeft();
                    break;
                }
                case "DISTCENTERH": {
                    this.distCenterH();
                    break;
                }
                case "DISTRIGHT": {
                    this.distRight();
                    break;
                }
                case "SIZECENTERV": {
                    this.sizeWidth();
                    break;
                }
                case "SIZECENTERH": {
                    this.sizeHeight();
                    break;
                }
                case "SIZEOTHER": {
                    this.sizeWidth();
                    theLayout.getLayoutContext().updateFFrames();
                    this.sizeHeight();
                    break;
                }
                case "SPACERIGHT": {
                    this.spaceRight();
                    break;
                }
                case "SPACEDOWN": {
                    this.spaceDown();
                    break;
                }
                case "INLAYOUT": {
                    this.inLayout = !this.inLayout;
                    break;
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Can't perform action '" + actionCommand + "'", (Throwable)ex);
        }
        theLayout.getLayoutContext().updateFFrames();
        theLayout.getLayoutContext().notifAllObservers();
    }

    public void setAlignRelativeTo(int i) {
        this.alignRelativeTo = i;
    }
}

