/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.tools.behavior;

import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import org.gvsig.app.project.documents.layout.tools.behavior.LayoutBehavior;
import org.gvsig.app.project.documents.layout.tools.listener.LayoutPointListener;
import org.gvsig.app.project.documents.layout.tools.listener.LayoutToolListener;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.PointEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.ToolListener;

public class LayoutPointBehavior
extends LayoutBehavior {
    private LayoutPointListener listener;
    private boolean doubleClick = false;

    public LayoutPointBehavior(LayoutPointListener l) {
        this.listener = l;
    }

    @Override
    public void mousePressed(MouseEvent e) throws BehaviorException {
        super.mousePressed(e);
        if (this.listener.cancelDrawing()) {
            // empty if block
        }
        if (e.getClickCount() == 2) {
            this.doubleClick = true;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    @Override
    public void mouseClicked(MouseEvent e) throws BehaviorException {
        super.mouseClicked(e);
        PointEvent event = new PointEvent((Point2D)e.getPoint(), e);
        this.listener.point(event);
        if (this.doubleClick) {
            this.listener.pointDoubleClick(event);
            this.doubleClick = false;
        }
    }

    public void setListener(ToolListener listener) {
        this.listener = (LayoutPointListener)listener;
    }

    @Override
    public LayoutToolListener getListener() {
        return this.listener;
    }

    @Override
    public void mouseMoved(MouseEvent e) throws BehaviorException {
        super.mouseMoved(e);
        this.getLayoutControl().setGeometryAdapterPoinPosition();
    }

    @Override
    public boolean isAdjustable() {
        return true;
    }
}

