/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.tools.behavior;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.gvsig.app.project.documents.layout.FLayoutUtilities;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.tools.behavior.LayoutBehavior;
import org.gvsig.app.project.documents.layout.tools.listener.LayoutRectangleListener;
import org.gvsig.app.project.documents.layout.tools.listener.LayoutToolListener;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.EnvelopeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutRectangleByTwoPointsBehavior
extends LayoutBehavior {
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(LayoutRectangleByTwoPointsBehavior.class);
    private LayoutRectangleListener listener;
    boolean findingSecondPoint = false;
    private Point firstPoint;

    public LayoutRectangleByTwoPointsBehavior(LayoutRectangleListener lrl) {
        this.listener = lrl;
    }

    @Override
    public void paintComponent(Graphics g) {
        IFFrame[] frames;
        BufferedImage img = this.getLayoutControl().getImage();
        BufferedImage imgRuler = this.getLayoutControl().getImgRuler();
        g.drawImage(img, 0, 0, this.getLayoutControl().getComponent());
        g.drawImage(imgRuler, 0, 0, this.getLayoutControl().getComponent());
        g.setColor(Color.black);
        g.setXORMode(Color.white);
        Rectangle r = new Rectangle();
        if (this.findingSecondPoint && this.getLayoutControl().getFirstPoint() != null && this.getLayoutControl().getLastPoint() != null) {
            r.setFrameFromDiagonal(this.getLayoutControl().getFirstPoint(), this.getLayoutControl().getLastPoint());
            g.drawRect(r.x, r.y, r.width, r.height);
        }
        for (IFFrame frame : frames = this.getLayoutControl().getLayoutContext().getSelectedFFrames()) {
            g.setColor(Color.black);
            frame.drawHandlers((Graphics2D)g);
        }
        g.setPaintMode();
    }

    @Override
    public void mousePressed(MouseEvent e) throws BehaviorException {
    }

    @Override
    public void mouseReleased(MouseEvent e) throws BehaviorException {
    }

    @Override
    public void mouseClicked(MouseEvent e) throws BehaviorException {
        if (e.getButton() != 1) {
            return;
        }
        if (!this.findingSecondPoint) {
            this.getLayoutControl().setPointAnt();
            this.getLayoutControl().setFirstPoint();
            this.firstPoint = this.getLayoutControl().getFirstPoint();
            if (this.listener.cancelDrawing()) {
                // empty if block
            }
            this.getLayoutControl().repaint();
            this.findingSecondPoint = true;
            return;
        }
        this.getLayoutControl().setLastPoint();
        this.getLayoutControl().setPointAnt();
        this.getLayoutControl().setPosition(this.firstPoint);
        this.getLayoutControl().setFirstPoint();
        Point pScreen = this.getLayoutControl().getLastPoint();
        AffineTransform at = this.getLayoutControl().getAT();
        Point2D.Double p1 = FLayoutUtilities.toSheetPoint(this.getLayoutControl().getFirstPoint(), at);
        Point2D.Double p2 = FLayoutUtilities.toSheetPoint(pScreen, at);
        if (e.getButton() == 1) {
            try {
                Envelope r = geomManager.createEnvelope(((Point2D)p1).getX(), ((Point2D)p1).getY(), ((Point2D)p2).getX(), ((Point2D)p2).getY(), 0);
                Rectangle rectPixel = new Rectangle();
                rectPixel.setFrameFromDiagonal(this.getLayoutControl().getFirstPoint(), pScreen);
                EnvelopeEvent event = new EnvelopeEvent(r, e, (Rectangle2D)rectPixel);
                this.listener.rectangle(event);
            }
            catch (CreateEnvelopeException e1) {
                logger.error("Error creating the envelope", (Object)e);
            }
        }
        this.findingSecondPoint = false;
    }

    @Override
    public void mouseDragged(MouseEvent e) throws BehaviorException {
    }

    @Override
    public void mouseMoved(MouseEvent e) throws BehaviorException {
        if (e.getButton() != 0) {
            return;
        }
        if (this.findingSecondPoint) {
            this.getLayoutControl().setLastPoint();
            this.getLayoutControl().repaint();
        }
    }

    public void setListener(LayoutToolListener listener) {
        this.listener = (LayoutRectangleListener)listener;
    }

    @Override
    public LayoutToolListener getListener() {
        return this.listener;
    }

    @Override
    public boolean isAdjustable() {
        return true;
    }
}

