/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.tools.behavior;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.tools.behavior.LayoutBehavior;
import org.gvsig.app.project.documents.layout.tools.listener.LayoutMoveListener;
import org.gvsig.app.project.documents.layout.tools.listener.LayoutToolListener;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.PointEvent;

public class LayoutSelectBehavior
extends LayoutBehavior {
    private LayoutMoveListener listener;
    private boolean dragged = false;
    private int modifiers;

    public LayoutSelectBehavior(LayoutMoveListener lpl) {
        this.listener = lpl;
    }

    @Override
    public void paintComponent(Graphics g) {
        IFFrame[] frames;
        this.getLayoutControl().getLayoutDraw().drawRectangle((Graphics2D)g);
        g.drawImage(this.getLayoutControl().getImage(), 0, 0, this.getLayoutControl().getComponent());
        if (this.getLayoutControl().isReSel()) {
            Rectangle reSel = this.getLayoutControl().getReSel();
            reSel = new Rectangle();
            reSel.setFrameFromDiagonal(this.getLayoutControl().getFirstPoint(), this.getLayoutControl().getLastPoint());
            g.drawRect(reSel.x, reSel.y, reSel.width, reSel.height);
        }
        for (IFFrame frame : frames = this.getLayoutControl().getLayoutContext().getSelectedFFrames()) {
            g.setColor(Color.black);
            frame.drawHandlers((Graphics2D)g);
            int difx = this.getLayoutControl().getLastPoint().x - this.getLayoutControl().getFirstPoint().x;
            int dify = this.getLayoutControl().getLastPoint().y - this.getLayoutControl().getFirstPoint().y;
            if (Math.abs(difx) <= 3 && Math.abs(dify) <= 3) continue;
            Rectangle2D rectangle = frame.getMovieRect(difx, dify, (this.modifiers & 2) == 0);
            if (rectangle == null) {
                return;
            }
            ((Graphics2D)g).rotate(Math.toRadians(frame.getRotation()), rectangle.getX() + rectangle.getWidth() / 2.0, rectangle.getY() + rectangle.getHeight() / 2.0);
            if (this.dragged && !this.getLayoutControl().isReSel()) {
                g.drawRect((int)rectangle.getMinX(), (int)rectangle.getMinY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
            }
            ((Graphics2D)g).rotate(Math.toRadians(-frame.getRotation()), rectangle.getX() + rectangle.getWidth() / 2.0, rectangle.getY() + rectangle.getHeight() / 2.0);
        }
        g.drawImage(this.getLayoutControl().getImgRuler(), 0, 0, this.getLayoutControl().getComponent());
    }

    @Override
    public void mousePressed(MouseEvent e) throws BehaviorException {
        super.mousePressed(e);
        PointEvent event = new PointEvent((Point2D)e.getPoint(), e);
        this.listener.press(event);
    }

    @Override
    public void mouseReleased(MouseEvent e) throws BehaviorException {
        super.mouseReleased(e);
        PointEvent event = new PointEvent((Point2D)e.getPoint(), e);
        this.listener.release(event);
        this.dragged = false;
    }

    @Override
    public void mouseDragged(MouseEvent e) throws BehaviorException {
        super.mouseDragged(e);
        PointEvent event = new PointEvent((Point2D)e.getPoint(), e);
        this.listener.drag(event);
        this.dragged = true;
        this.modifiers = e.getModifiers();
    }

    public void setListener(LayoutToolListener listener) {
        this.listener = (LayoutMoveListener)listener;
    }

    @Override
    public LayoutToolListener getListener() {
        return this.listener;
    }

    @Override
    public void mouseClicked(MouseEvent e) throws BehaviorException {
        super.mouseClicked(e);
        PointEvent event = new PointEvent((Point2D)e.getPoint(), e);
        this.listener.click(event);
    }

    @Override
    public void mouseMoved(MouseEvent e) throws BehaviorException {
        super.mouseMoved(e);
        PointEvent event = new PointEvent((Point2D)e.getPoint(), e);
        this.listener.move(event);
    }
}

