/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.util.QueryModel.Internal;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Vector;
import org.jzkit.search.util.QueryModel.Internal.AttrPlusTermNode;
import org.jzkit.search.util.QueryModel.Internal.ComplexNode;
import org.jzkit.search.util.QueryModel.Internal.InternalModelNamespaceNode;
import org.jzkit.search.util.QueryModel.Internal.InternalModelRootNode;
import org.jzkit.search.util.QueryModel.Internal.QueryNode;

public class HumanReadableVisitor {
    public static String toHumanReadableString(InternalModelRootNode rn) throws IOException {
        StringWriter sw = new StringWriter();
        HumanReadableVisitor.visit(rn, sw);
        return sw.toString();
    }

    public static void toHumanReadableString(InternalModelRootNode rn, StringWriter sw) throws IOException {
        HumanReadableVisitor.visit(rn, sw);
    }

    public static void visit(QueryNode qn, StringWriter sw) throws IOException {
        if (qn instanceof InternalModelRootNode) {
            HumanReadableVisitor.visit((InternalModelRootNode)qn, sw);
        } else if (qn instanceof InternalModelNamespaceNode) {
            HumanReadableVisitor.visit((InternalModelNamespaceNode)qn, sw);
        } else if (qn instanceof ComplexNode) {
            HumanReadableVisitor.visit((ComplexNode)qn, sw);
        } else if (qn instanceof AttrPlusTermNode) {
            HumanReadableVisitor.visit((AttrPlusTermNode)qn, sw);
        }
    }

    public static void visit(InternalModelNamespaceNode rn, StringWriter sw) throws IOException {
        if (rn.getAttrset() != null) {
            // empty if block
        }
        HumanReadableVisitor.visit(rn.getChild(), sw);
    }

    public static void visit(ComplexNode cn, StringWriter sw) throws IOException {
        int inumleft = cn.getLHS().countChildrenWithTerms();
        int inumright = cn.getRHS().countChildrenWithTerms();
        if (inumleft > 0 && inumright > 0) {
            sw.write(" ( ");
        }
        if (inumleft > 0) {
            HumanReadableVisitor.visit(cn.getLHS(), sw);
        }
        if (inumleft > 0 && inumright > 0) {
            switch (cn.getOp()) {
                case 1: {
                    sw.write(" and ");
                    break;
                }
                case 2: {
                    sw.write(" or ");
                    break;
                }
                case 3: {
                    sw.write(" andnot ");
                    break;
                }
                case 4: {
                    sw.write(" Close to ");
                    break;
                }
                default: {
                    sw.write(" ERROR ");
                }
            }
        }
        if (inumright > 0) {
            HumanReadableVisitor.visit(cn.getRHS(), sw);
        }
        if (inumleft > 0 && inumright > 0) {
            sw.write(" ) ");
        }
    }

    public static void visit(AttrPlusTermNode aptn, StringWriter sw) throws IOException {
        Object term = aptn.getTerm();
        if (term instanceof String) {
            sw.write(" " + aptn.getTermAsString(true) + " ");
        } else if (term instanceof Vector || term instanceof Object) {
            boolean multi_term_action = false;
            Object multi_term_action_val = aptn.getAttr("MultiTermOp");
            if (multi_term_action_val != null && multi_term_action_val.toString().equals("OR")) {
                multi_term_action = true;
            }
            if (multi_term_action) {
                sw.write(" Matches one or more of ");
            } else {
                sw.write(" Matches all of ");
            }
            sw.write("[");
            sw.write(" " + aptn.getTermAsString(true) + " ");
            sw.write("]");
        }
    }
}

