/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.util;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TreeWriter {
    static final int NULL_TYPE = 0;
    static final int JAVA_TYPE = 1;
    static final int CLASS_TYPE = 2;
    static final int COLLECTION_TYPE = 3;
    PrintStream pout;
    Logger logger;
    Level level;
    String lineBuffer = "";

    public TreeWriter(PrintStream out) {
        this.pout = out;
    }

    public TreeWriter(Logger logger, Level level) {
        this.logger = logger;
        this.level = level;
    }

    public void write(Object o) {
        if (this.logger == null || this.logger.isLoggable(this.level)) {
            TreeNode node = new TreeNode();
            node.type = this.classify(o);
            node.value = o;
            this.writeNode(node, 0);
        }
    }

    public void write(Object o, String rootNode) {
        if (this.logger == null || this.logger.isLoggable(this.level)) {
            TreeNode node = new TreeNode();
            node.type = this.classify(o);
            node.name = rootNode;
            node.value = o;
            this.writeNode(node, 0);
        }
    }

    private void writeNode(TreeNode node, int indent) {
        switch (node.type) {
            case 0: {
                break;
            }
            case 1: {
                for (int j = 0; j < indent; ++j) {
                    this.print(" ");
                }
                this.print(node.name + ": ");
                if (node.value.getClass().getName().equals("java.util.GregorianCalendar")) {
                    Date theDate = new Date();
                    theDate.setTime(((Calendar)node.value).getTimeInMillis());
                    String msg = DateFormat.getDateTimeInstance(2, 2).format(theDate);
                    this.println(msg);
                    break;
                }
                this.println(node.value.toString());
                break;
            }
            case 2: {
                for (int j = 0; j < indent; ++j) {
                    this.print(" ");
                }
                this.println(node.name);
                this.writeClass(node.value, indent + 2);
                break;
            }
            case 3: {
                if (node.name != null) {
                    for (int j = 0; j < indent; ++j) {
                        this.print(" ");
                    }
                    this.println(node.name);
                    indent += 2;
                }
                Collection col = (Collection)node.value;
                Iterator it = col.iterator();
                while (it.hasNext()) {
                    Object item = it.next();
                    this.writeClass(item, indent);
                }
                break;
            }
            default: {
                System.out.println("UNEXPECTED TYPE");
            }
        }
    }

    private void writeClass(Object o, int indent) {
        for (int j = 0; j < indent; ++j) {
            this.print(" ");
        }
        this.println("Class: " + o.getClass().getName());
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        Method[] methods = o.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String declaringClassName = method.getDeclaringClass().getName();
            if (!declaringClassName.startsWith("org.jzkit") || !method.getName().startsWith("get")) continue;
            Object res = null;
            try {
                res = method.invoke(o, (Object[])null);
                TreeNode node = new TreeNode();
                node.type = this.classify(res);
                node.name = method.getName().substring(3);
                node.value = res;
                nodes.add(node);
                continue;
            }
            catch (IllegalAccessException iae) {
                this.println(iae.toString());
                continue;
            }
            catch (InvocationTargetException ite) {
                for (int j = 0; j < indent + 2; ++j) {
                    this.print(" ");
                }
                this.print(method.getName().substring(3) + ": ");
                this.println("Exception");
            }
        }
        Collections.sort(nodes);
        Iterator i = ((AbstractList)nodes).iterator();
        while (i.hasNext()) {
            TreeNode node = (TreeNode)i.next();
            this.writeNode(node, indent + 2);
        }
    }

    private int classify(Object o) {
        if (o == null) {
            return 0;
        }
        Collection col = null;
        try {
            col = (Collection)o;
            return 3;
        }
        catch (ClassCastException cce) {
            String className = o.getClass().getName();
            if (className.startsWith("java")) {
                return 1;
            }
            return 2;
        }
    }

    private void print(String str) {
        this.lineBuffer = this.lineBuffer + str;
    }

    private void println(String str) {
        if (this.pout != null) {
            this.pout.println(this.lineBuffer + str);
        }
        if (this.logger != null) {
            this.logger.log(this.level, this.lineBuffer + str);
        }
        this.lineBuffer = "";
    }

    public class TreeNode
    implements Comparable {
        int type;
        String name;
        Object value;

        public int compareTo(Object o) {
            return new Integer(this.type).compareTo(new Integer(((TreeNode)o).type));
        }
    }
}

