/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.dbf;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.feature.spi.AbstractFeatureStoreProviderFactory;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProvider;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.fmap.dal.store.dbf.DBFStoreParameters;
import org.gvsig.fmap.dal.store.dbf.DBFStoreProvider;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.dynobject.DynObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBFStoreProviderFactory
extends AbstractFeatureStoreProviderFactory {
    private static final Logger logger = LoggerFactory.getLogger(DBFStoreProviderFactory.class);
    public static final String AUTODETECT_ENCODING_NAME = "dbf_AutodetectEncoding";
    public static final String AUTODETECT_ENCODING_MAX_RECORDS_NAME = "dbf_AutodetectEncodingMaxRecords";
    public static final int AUTODETECT_ENCODING_MAX_RECORDS_DEFAULT_VALUE = 1000;

    protected DBFStoreProviderFactory(String name, String description) {
        super(name, description);
    }

    public FeatureStoreProvider createProvider(DataParameters parameters, DataStoreProviderServices providerServices) throws InitializeException {
        return new DBFStoreProvider((DBFStoreParameters)parameters, providerServices);
    }

    public DynObject createParameters() {
        return new DBFStoreParameters();
    }

    public int allowCreate() {
        return 1;
    }

    public int allowWrite() {
        return 1;
    }

    public int allowRead() {
        return 1;
    }

    public int hasRasterSupport() {
        return 2;
    }

    public int hasTabularSupport() {
        return 1;
    }

    public int hasVectorialSupport() {
        return 2;
    }

    public int allowMultipleGeometryTypes() {
        return 2;
    }

    public int allowEditableFeatureType() {
        return 1;
    }

    public int useLocalIndexesCanImprovePerformance() {
        return 1;
    }

    public int isOptimalRecoverFeaturesByReference() {
        return 1;
    }

    public List<DataType> getSupportedDataTypes() {
        DataTypesManager manager = ToolsLocator.getDataTypesManager();
        ArrayList<DataType> resp = new ArrayList<DataType>();
        resp.add(manager.get(8));
        resp.add(manager.get(4));
        resp.add(manager.get(6));
        resp.add(manager.get(9));
        return resp;
    }

    public boolean allowsMandatoryAttributes() {
        return false;
    }

    public boolean allowsPrimaryKeyAttributes() {
        return false;
    }

    public int getMaxAttributeNameSize() {
        return 10;
    }
}

