/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.app.symbolinstaller.creation.wizard;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.gui.beans.wizard.panel.NotContinueWizardException;
import org.gvsig.gui.beans.wizard.panel.OptionPanel;
import org.gvsig.i18n.Messages;
import org.gvsig.installer.lib.api.InstallerLocator;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.swing.api.SwingInstallerLocator;
import org.gvsig.installer.swing.api.creation.JOutputPanel;
import org.gvsig.symbology.app.symbolinstaller.creation.DefaultMakeSymbolPackageWizard;

public class OutputWizard
implements OptionPanel {
    private JOutputPanel outputPanel = SwingInstallerLocator.getSwingInstallerManager().createOutputPanel();
    private PackageInfo packageInfo;

    public OutputWizard(DefaultMakeSymbolPackageWizard wizard, PackageInfo packageInfo) {
        this.packageInfo = packageInfo;
        this.outputPanel.setPackageInfo(packageInfo);
    }

    public JPanel getJPanel() {
        return this.outputPanel;
    }

    private String getText(String msg) {
        return Messages.getText((String)msg);
    }

    public String getPanelTitle() {
        return this.getText("_output_options");
    }

    public void lastPanel() {
    }

    public void nextPanel() throws NotContinueWizardException {
        File file = this.outputPanel.getPackageFile();
        File filePath = new File(file.getParent());
        if (!filePath.exists()) {
            JOptionPane.showMessageDialog((Component)this.outputPanel, this.getText("_the_package_file_folder_does_not_exist") + ": " + filePath);
            throw new NotContinueWizardException("", null, false);
        }
        if (this.outputPanel.isCreatePackageIndex()) {
            URL url = this.outputPanel.getDownloadURL();
            if (url == null) {
                throw new NotContinueWizardException("", null, false);
            }
            File indexFile = this.outputPanel.getPackageIndexFile();
            File indexFilePath = new File(indexFile.getParent());
            if (!indexFilePath.exists()) {
                JOptionPane.showMessageDialog((Component)this.outputPanel, this.getText("_the_package_index_file_folder_does_not_exist") + ": " + indexFilePath);
                throw new NotContinueWizardException("", null, false);
            }
        }
    }

    public void updatePanel() {
        this.outputPanel.setPackageFile(this.getDefaultPackageBundleFile());
        this.outputPanel.setPackageIndexFile(this.getDefaultPackageIndexBundleFile());
    }

    private File getDefaultPackageBundleFile() {
        PluginsManager manager = PluginsLocator.getManager();
        File installsFolder = manager.getInstallFolder();
        String fileName = InstallerLocator.getInstallerManager().getPackageFileName(this.packageInfo);
        return new File(installsFolder, fileName);
    }

    private File getDefaultPackageIndexBundleFile() {
        PluginsManager manager = PluginsLocator.getManager();
        File installsFolder = manager.getInstallFolder();
        String fileName = InstallerLocator.getInstallerManager().getPackageIndexFileName(this.packageInfo);
        return new File(installsFolder, fileName);
    }
}

