/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.swing.impl.launcher;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.gvsig.i18n.Messages;

public class AlgorithmSelectionPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private int polynomialDegree;
    private JRadioButton affine = null;
    private JRadioButton polynomial = null;
    private JComboBox degreeList = null;
    private JComboBox interpolationMethod = null;

    public AlgorithmSelectionPanel(int polynomialDegree) {
        this.polynomialDegree = polynomialDegree;
        this.init();
    }

    public void init() {
        ButtonGroup group = new ButtonGroup();
        group.add(this.getAffine());
        group.add(this.getPolynomial());
        this.getPolynomial().addActionListener(this);
        this.getAffine().addActionListener(this);
        GridBagLayout gl = new GridBagLayout();
        this.setLayout(gl);
        this.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"georef_algorithm"), 0, 0, null, null));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 8, 0);
        this.add((Component)this.getAffine(), gbc);
        gbc.gridy = 1;
        gbc.insets = new Insets(0, 5, 8, 0);
        this.add((Component)this.getPolynomial(), gbc);
        gbc.gridy = 2;
        gbc.insets = new Insets(0, 35, 8, 0);
        this.add((Component)this.getDegreeList(), gbc);
        gbc.gridy = 3;
        gbc.insets = new Insets(0, 35, 8, 0);
        this.add((Component)this.getInterpolationMethod(), gbc);
    }

    public JRadioButton getAffine() {
        if (this.affine == null) {
            this.affine = new JRadioButton(Messages.getText((String)"affine_algorithm"));
            this.affine.setSelected(true);
            this.actionPerformed(null);
        }
        return this.affine;
    }

    public JRadioButton getPolynomial() {
        if (this.polynomial == null) {
            this.polynomial = new JRadioButton(Messages.getText((String)"polynomial_algorithm"));
        }
        return this.polynomial;
    }

    public JComboBox getDegreeList() {
        if (this.degreeList == null) {
            this.degreeList = new JComboBox();
            for (int i = 1; i <= this.polynomialDegree; ++i) {
                this.degreeList.addItem(Messages.getText((String)"poly_order") + ": " + i);
            }
        }
        return this.degreeList;
    }

    public JComboBox getInterpolationMethod() {
        if (this.interpolationMethod == null) {
            this.interpolationMethod = new JComboBox();
            this.interpolationMethod.addItem(Messages.getText((String)"vecino_+_proximo"));
            this.interpolationMethod.addItem(Messages.getText((String)"bilinear"));
            this.interpolationMethod.addItem(Messages.getText((String)"inverse_distance"));
        }
        return this.interpolationMethod;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.getDegreeList().setEnabled(this.getPolynomial().isSelected());
        this.getInterpolationMethod().setEnabled(this.getPolynomial().isSelected());
    }

    public int getSelectedDegree() {
        if (this.degreeList != null && this.getPolynomial().isSelected()) {
            String s = (String)this.degreeList.getSelectedItem();
            s = s.substring(s.lastIndexOf(" ") + 1, s.length());
            try {
                return Integer.valueOf(s);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }

    public int getSelectedInterpolationMethod() {
        if (this.interpolationMethod != null && this.getPolynomial().isSelected()) {
            switch (this.getInterpolationMethod().getSelectedIndex()) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 2: {
                    return 3;
                }
            }
        }
        return -1;
    }

    public void setInterpolationMethod(int interpolationMethod) {
        switch (interpolationMethod) {
            case 1: {
                this.getInterpolationMethod().setSelectedIndex(0);
                break;
            }
            case 2: {
                this.getInterpolationMethod().setSelectedIndex(1);
                break;
            }
            case 3: {
                this.getInterpolationMethod().setSelectedIndex(2);
            }
        }
    }

    public int getAlgorithm() {
        if (this.getPolynomial().isSelected()) {
            return 0;
        }
        if (this.getAffine().isSelected()) {
            return 1;
        }
        return -1;
    }

    public void setDegree(int degree) {
        for (int i = 0; i < this.degreeList.getItemCount(); ++i) {
            String item = (String)this.degreeList.getItemAt(i);
            if (!item.endsWith(": " + degree)) continue;
            this.degreeList.setSelectedIndex(i);
            return;
        }
    }

    public void setAlgorithm(int alg) {
        switch (alg) {
            case 1: {
                this.getAffine().setSelected(true);
                this.getPolynomial().setSelected(false);
                this.actionPerformed(new ActionEvent(this.getAffine(), 0, ""));
                break;
            }
            case 0: {
                this.getPolynomial().setSelected(true);
                this.getAffine().setSelected(false);
                this.actionPerformed(new ActionEvent(this.getPolynomial(), 0, ""));
            }
        }
    }
}

