/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.swing.impl.launcher;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.util.FileUtils;
import org.gvsig.gui.beans.swing.JFileChooser;
import org.gvsig.i18n.Messages;

public class OutFileSelectionPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JTextField fileName = null;
    private JButton bSelection = null;
    private FileUtils fileUtils = RasterLocator.getManager().getFileUtils();

    public OutFileSelectionPanel() {
        this.init();
    }

    public void init() {
        BorderLayout fl = new BorderLayout();
        fl.setHgap(3);
        fl.setVgap(0);
        this.setLayout(fl);
        this.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"output_file"), 0, 0, null, null));
        this.add((Component)this.getFileName(), "Center");
        this.add((Component)this.getSelectFileButton(), "East");
    }

    private JTextField getFileName() {
        if (this.fileName == null) {
            this.fileName = new JTextField(System.getProperty("user.home") + File.separator + this.fileUtils.usesOnlyLayerName() + ".tif");
            this.fileName.setEditable(true);
        }
        return this.fileName;
    }

    private JButton getSelectFileButton() {
        if (this.bSelection == null) {
            this.bSelection = new JButton(Messages.getText((String)"select"));
            this.bSelection.addActionListener(this);
        }
        return this.bSelection;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getSelectFileButton()) {
            this.selectDirectory();
        }
    }

    private void selectDirectory() {
        JFileChooser chooser = new JFileChooser("OPEN_LAYER_FILE_CHOOSER_ID", JFileChooser.getLastPath((String)"OPEN_LAYER_FILE_CHOOSER_ID", null));
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.isDirectorySelectionEnabled();
        chooser.setFileSelectionMode(1);
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == 0) {
            String outPath = chooser.getSelectedFile().getAbsolutePath();
            String fileName = this.fileUtils.getOnlyLayerName() + ".tif";
            int index = this.getFileName().getText().lastIndexOf(File.separator);
            if (index != -1) {
                fileName = this.getFileName().getText().substring(index + 1);
            }
            if (outPath.compareTo(File.separator) == 0) {
                this.getFileName().setText(outPath + fileName);
            } else {
                this.getFileName().setText(outPath + File.separator + fileName);
            }
        }
    }

    public String getOutFile() {
        return this.getFileName().getText();
    }

    public void setOutFile(String file) {
        this.getFileName().setText(file);
    }
}

