/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.swing.impl.layer;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.raster.georeferencing.swing.impl.view.CanvasZone;
import org.gvsig.raster.georeferencing.swing.view.GeoreferencingView;
import org.gvsig.raster.georeferencing.swing.view.IGraphicLayer;
import org.gvsig.raster.georeferencing.swing.view.ToolEvent;
import org.gvsig.raster.georeferencing.swing.view.ToolListener;

public class ZoomCursorGraphicLayer
implements IGraphicLayer {
    private static final int NONE = -1;
    private static final int REDIM_LEFT = 0;
    private static final int REDIM_RIGHT = 1;
    private static final int REDIM_UP = 2;
    private static final int REDIM_DOWN = 3;
    private static final int MOVE_UR = 4;
    private static final int MOVE_UL = 5;
    private static final int MOVE_LR = 6;
    private static final int MOVE_LL = 7;
    private final int MIN_CURSOR_SIZE = 10;
    private int operation = -1;
    private int wCursor = 0;
    private int hCursor = 0;
    private int posX = 0;
    private int posY = 0;
    private Image iconHoriz = null;
    private Image iconVert = null;
    private Image iconMove = null;
    private CanvasZone canvas = null;
    private int prevX;
    private int prevY;
    private ToolListener listener = null;
    private boolean active = true;
    private boolean sleepActive = true;
    private Color cursorColor = Color.RED;
    private boolean initSize = true;
    private int initWCursor = 0;
    private int initHCursor = 0;
    private GeoreferencingView view = null;

    public ZoomCursorGraphicLayer(int pX, int pY, int w, int h, ToolListener listener) {
        this.wCursor = w;
        this.hCursor = h;
        this.posX = pX;
        this.posY = pY;
        this.listener = listener;
        try {
            this.iconHoriz = IconThemeHelper.getImage((String)"arrow_horiz-icon");
            this.iconVert = IconThemeHelper.getImage((String)"arrow_vert-icon");
            this.iconMove = IconThemeHelper.getImage((String)"arrow_move-icon");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setGeoreferencingView(GeoreferencingView view) {
        this.view = view;
        this.canvas = (CanvasZone)view.getCanvas();
        this.canvas.addMouseMotionListener((MouseMotionListener)((Object)this));
        this.canvas.addMouseListener((MouseListener)((Object)this));
    }

    public void setCursorPosition(int x, int y) {
        this.posX = x;
        this.posY = y;
    }

    public void setCursorSize(int w, int h) {
        if (this.initSize) {
            this.initWCursor = w;
            this.initHCursor = h;
            this.initSize = false;
        }
        this.wCursor = w;
        this.hCursor = h;
    }

    public void resetCursorSize() {
        this.wCursor = this.initWCursor;
        this.hCursor = this.initHCursor;
    }

    public Rectangle2D getCursorViewCoordinates() {
        return new Rectangle2D.Double(this.posX - (this.wCursor >> 1), this.posY - (this.hCursor >> 1), this.wCursor, this.hCursor);
    }

    public void draw(Graphics2D g, Rectangle2D ext, int w, int h) {
        g.setColor(this.cursorColor);
        this.wCursor = Math.max(this.wCursor, 10);
        this.hCursor = Math.max(this.hCursor, 10);
        g.drawRect(this.posX - (this.wCursor >> 1), this.posY - (this.hCursor >> 1), this.wCursor, this.hCursor);
        g.drawLine(this.posX, this.posY - (this.hCursor >> 1), this.posX, 0);
        g.drawLine(this.posX, this.posY + (this.hCursor >> 1), this.posX, h);
        g.drawLine(0, this.posY, this.posX - (this.wCursor >> 1), this.posY);
        g.drawLine(this.posX + (this.wCursor >> 1), this.posY, w, this.posY);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.prevX = e.getX();
        this.prevY = e.getY();
    }

    public void mouseReleased(MouseEvent e) {
        if (!this.isActive()) {
            return;
        }
        if (this.getOperation() != -1) {
            this.setOperation(-1);
            if (this.listener != null) {
                this.listener.endAction(new ToolEvent((Object)this, this.view, null));
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.isActive()) {
            return;
        }
        if (this.getOperation() == 4) {
            this.posX += e.getX() - (this.wCursor >> 1) - this.posX;
            this.posY += e.getY() + (this.hCursor >> 1) - this.posY;
            return;
        }
        if (this.getOperation() == 5) {
            this.posX += e.getX() + (this.wCursor >> 1) - this.posX;
            this.posY += e.getY() + (this.hCursor >> 1) - this.posY;
            return;
        }
        if (this.getOperation() == 6) {
            this.posX += e.getX() - (this.wCursor >> 1) - this.posX;
            this.posY += e.getY() - (this.hCursor >> 1) - this.posY;
            return;
        }
        if (this.getOperation() == 7) {
            this.posX += e.getX() + (this.wCursor >> 1) - this.posX;
            this.posY += e.getY() - (this.hCursor >> 1) - this.posY;
            return;
        }
        if (this.getOperation() == 0) {
            this.wCursor += this.prevX - e.getX();
            this.posX = e.getX() + (this.wCursor >> 1);
            this.prevX = e.getX();
            return;
        }
        if (this.getOperation() == 1) {
            int prevULX = this.posX - (this.wCursor >> 1);
            this.wCursor += e.getX() - this.prevX;
            this.posX = prevULX + (this.wCursor >> 1);
            this.prevX = e.getX();
            return;
        }
        if (this.getOperation() == 2) {
            this.hCursor += this.prevY - e.getY();
            this.posY = e.getY() + (this.hCursor >> 1);
            this.prevY = e.getY();
            return;
        }
        if (this.getOperation() == 3) {
            int prevULY = this.posY - (this.hCursor >> 1);
            this.hCursor += e.getY() - this.prevY;
            this.posY = prevULY + (this.hCursor >> 1);
            this.prevY = e.getY();
            return;
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (!this.isActive()) {
            return;
        }
        int pxLeft = this.posX - (this.wCursor >> 1);
        int pxRight = this.posX + (this.wCursor >> 1);
        int pyUp = this.posY - (this.hCursor >> 1);
        int pyDown = this.posY + (this.hCursor >> 1);
        if (e.getX() < pxLeft - 2 || e.getX() > pxRight + 2 || e.getY() < pyUp - 2 || e.getY() > pyDown + 2) {
            this.setOperation(-1);
            if (this.canvas.getCursor().getType() != 0) {
                this.canvas.setCursor(new Cursor(0));
                this.listener.offTool(new ToolEvent((Object)this, this.view, null));
            }
            return;
        }
        if (e.getX() >= pxRight - 2 && e.getY() <= pyUp + 2) {
            if (this.iconMove != null) {
                this.canvas.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(this.iconMove, new Point(16, 16), ""));
            }
            this.setOperation(4);
            return;
        }
        if (e.getX() <= pxLeft + 2 && e.getY() <= pyUp + 2) {
            if (this.iconMove != null) {
                this.canvas.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(this.iconMove, new Point(16, 16), ""));
            }
            this.setOperation(5);
            return;
        }
        if (e.getX() <= pxLeft + 2 && e.getY() >= pyDown - 2) {
            if (this.iconMove != null) {
                this.canvas.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(this.iconMove, new Point(16, 16), ""));
            }
            this.setOperation(7);
            return;
        }
        if (e.getX() >= pxRight - 2 && e.getY() >= pyDown - 2) {
            if (this.iconMove != null) {
                this.canvas.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(this.iconMove, new Point(16, 16), ""));
            }
            this.setOperation(6);
            return;
        }
        if (e.getX() <= pxLeft + 1) {
            if (this.iconHoriz != null) {
                this.canvas.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(this.iconHoriz, new Point(16, 16), ""));
            }
            this.setOperation(0);
            return;
        }
        if (e.getX() >= pxRight - 1) {
            if (this.iconHoriz != null) {
                this.canvas.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(this.iconHoriz, new Point(16, 16), ""));
            }
            this.setOperation(1);
            return;
        }
        if (e.getY() <= pyUp + 1) {
            if (this.iconVert != null) {
                this.canvas.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(this.iconVert, new Point(16, 16), ""));
            }
            this.setOperation(2);
            return;
        }
        if (e.getY() >= pyDown - 1) {
            if (this.iconVert != null) {
                this.canvas.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(this.iconVert, new Point(16, 16), ""));
            }
            this.setOperation(3);
            return;
        }
        this.setOperation(-1);
        if (this.canvas.getCursor().getType() != 0) {
            this.canvas.setCursor(new Cursor(0));
            this.listener.offTool(new ToolEvent((Object)this, this.view, null));
        }
    }

    public int getOperation() {
        return this.operation;
    }

    private void setOperation(int op) {
        this.operation = op;
        if (op != -1) {
            this.listener.onTool(new ToolEvent((Object)this, this.view, null));
        }
    }

    public void sleep() {
        this.sleepActive = this.active;
        this.active = false;
    }

    public void awake() {
        this.active = this.sleepActive;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Color getColor() {
        return this.cursorColor;
    }

    public void setColor(Color color) {
        this.cursorColor = color;
    }

    public void recalcPixelDrawCoordinates() {
    }

    public void recalcMapDrawCoordinates() {
    }
}

