/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.swing.impl.view.synchronize;

import java.awt.geom.Point2D;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.GeoPoint;
import org.gvsig.raster.georeferencing.swing.impl.layer.GCPsGraphicLayer;
import org.gvsig.raster.georeferencing.swing.impl.layer.GPGraphic;
import org.gvsig.raster.georeferencing.swing.impl.tool.PanTool;
import org.gvsig.raster.georeferencing.swing.impl.tool.SelectCoordOnViewTool;
import org.gvsig.raster.georeferencing.swing.impl.tool.ZoomRectangleTool;
import org.gvsig.raster.georeferencing.swing.impl.view.ViewPanelImpl;
import org.gvsig.raster.georeferencing.swing.impl.view.ZoomPanelImpl;
import org.gvsig.raster.georeferencing.swing.model.GCPList;
import org.gvsig.raster.georeferencing.swing.view.GeoreferencingView;
import org.gvsig.raster.georeferencing.swing.view.IGraphicLayer;
import org.gvsig.raster.georeferencing.swing.view.ToolListener;
import org.gvsig.raster.swing.pagedtable.PagedTable;

public class GCPSynchronizationImpl {
    private ToolListener toolListener = null;
    private ViewPanelImpl viewRaster = null;
    private ViewPanelImpl viewMap = null;
    private ZoomPanelImpl zoomMap = null;
    private ZoomPanelImpl zoomRaster = null;
    private GCPsGraphicLayer viewRasterGCPs = null;
    private GCPsGraphicLayer viewMapGCPs = null;
    private GCPsGraphicLayer viewRasterGCPsZoom = null;
    private GCPsGraphicLayer viewMapGCPsZoom = null;
    private SelectCoordOnViewTool viewRasterSelectPointTool = null;
    private SelectCoordOnViewTool viewMapSelectPointTool = null;
    private SelectCoordOnViewTool zoomRasterSelectPointTool = null;
    private SelectCoordOnViewTool zoomMapSelectPointTool = null;
    private PagedTable table = null;
    private GCPList geoPointList = null;

    public GCPSynchronizationImpl(GCPList gpList, ToolListener listener) {
        this.toolListener = listener;
        this.geoPointList = gpList;
    }

    public void setViews(GeoreferencingView vMap, GeoreferencingView vRaster, GeoreferencingView zMap, GeoreferencingView zRaster, PagedTable table) {
        this.table = table;
        this.viewRaster = (ViewPanelImpl)vRaster;
        this.viewMap = (ViewPanelImpl)vMap;
        this.zoomMap = (ZoomPanelImpl)zMap;
        this.zoomRaster = (ZoomPanelImpl)zRaster;
        if (this.zoomRaster != null) {
            this.zoomRasterSelectPointTool = new SelectCoordOnViewTool(this.toolListener, this.zoomRaster);
        }
        if (this.zoomMap != null) {
            this.zoomMapSelectPointTool = new SelectCoordOnViewTool(this.toolListener, this.zoomMap);
        }
        if (this.viewRaster != null) {
            this.viewRasterSelectPointTool = new SelectCoordOnViewTool(this.toolListener, this.viewRaster);
        }
        if (this.viewMap != null) {
            this.viewMapSelectPointTool = new SelectCoordOnViewTool(this.toolListener, this.viewMap);
        }
        this.createGCPLayers();
        this.registerPointToolListener();
    }

    public void setLayerPoints(IGraphicLayer vRaster, IGraphicLayer vMap, IGraphicLayer zRaster, IGraphicLayer zMap) {
        this.viewRasterGCPs = (GCPsGraphicLayer)vRaster;
        this.viewMapGCPs = (GCPsGraphicLayer)vMap;
        this.viewRasterGCPsZoom = (GCPsGraphicLayer)zRaster;
        this.viewMapGCPsZoom = (GCPsGraphicLayer)zMap;
    }

    public void setActiveLayerZoomCursor(boolean active) {
        if (this.viewRaster != null && this.viewRaster.getZoomCursorGraphicLayer() != null) {
            this.viewRaster.getZoomCursorGraphicLayer().setActive(active);
        }
        if (this.viewMap != null && this.viewMap.getZoomCursorGraphicLayer() != null) {
            this.viewMap.getZoomCursorGraphicLayer().setActive(active);
        }
    }

    public void redrawPoints() {
        if (this.viewRaster != null) {
            this.viewRaster.getCanvas().repaint();
        }
        if (this.viewMap != null) {
            this.viewMap.getCanvas().repaint();
        }
        if (this.zoomMap != null) {
            this.zoomMap.getCanvas().repaint();
        }
        if (this.zoomRaster != null) {
            this.zoomRaster.getCanvas().repaint();
        }
    }

    public void registerPointToolListener() {
        if (this.zoomMap != null) {
            this.zoomMapSelectPointTool.setActive(false);
            this.zoomMap.getControl().addTool(this.zoomMapSelectPointTool);
            this.zoomMap.getControl().registerToolListener(ZoomRectangleTool.class, this.toolListener);
            this.zoomMap.getControl().registerToolListener(PanTool.class, this.toolListener);
        }
        if (this.zoomRaster != null) {
            this.zoomRasterSelectPointTool.setActive(false);
            this.zoomRaster.getControl().addTool(this.zoomRasterSelectPointTool);
            this.zoomRaster.getControl().registerToolListener(ZoomRectangleTool.class, this.toolListener);
            this.zoomRaster.getControl().registerToolListener(PanTool.class, this.toolListener);
        }
        if (this.viewRaster != null) {
            this.viewRasterSelectPointTool.setActive(false);
            this.viewRaster.getControl().addTool(this.viewRasterSelectPointTool);
            this.viewRaster.getControl().registerToolListener(ZoomRectangleTool.class, this.toolListener);
            this.viewRaster.getControl().registerToolListener(PanTool.class, this.toolListener);
        }
        if (this.viewMap != null) {
            this.viewMapSelectPointTool.setActive(false);
            this.viewMap.getControl().addTool(this.viewMapSelectPointTool);
            this.viewMap.getControl().registerToolListener(ZoomRectangleTool.class, this.toolListener);
            this.viewMap.getControl().registerToolListener(PanTool.class, this.toolListener);
        }
    }

    public long addPoint(Point2D map, Point2D raster) {
        GeoPoint gp = RasterLocator.getManager().getDataStructFactory().createGeoPoint(raster, map);
        long id = System.currentTimeMillis();
        GPGraphic graphicGCP = new GPGraphic(gp);
        graphicGCP.setId(id);
        this.geoPointList.add((Object)graphicGCP);
        this.redrawPoints();
        return id;
    }

    public void removeAllPoints() {
        this.geoPointList.removeAll();
        this.redrawPoints();
    }

    public void setCoordinates(int point, double xMap, double yMap, double xRaster, double yRaster) {
        this.setXMapCoordinate(point, xMap);
        this.setYMapCoordinate(point, yMap);
        this.setXRasterCoordinate(point, xRaster);
        this.setYRasterCoordinate(point, yRaster);
        this.redrawPoints();
    }

    public void setXMapCoordinate(int point, double xMap) {
        if (this.viewMapGCPs != null) {
            double oldMapY = this.viewMapGCPs.getPoint(point).getGeoPoint().getMapPoint().getY();
            this.viewMapGCPs.getPoint(point).getGeoPoint().getMapPoint().setLocation(xMap, oldMapY);
        }
    }

    public void setYMapCoordinate(int point, double yMap) {
        if (this.viewMapGCPs != null) {
            double oldMapX = this.viewMapGCPs.getPoint(point).getGeoPoint().getMapPoint().getX();
            this.viewMapGCPs.getPoint(point).getGeoPoint().getMapPoint().setLocation(oldMapX, yMap);
        }
    }

    public void setXRasterCoordinate(int point, double xRaster) {
        if (this.viewRasterGCPs != null) {
            double oldRasterY = this.viewRasterGCPs.getPoint(point).getGeoPoint().getPixelPoint().getY();
            this.viewRasterGCPs.getPoint(point).getGeoPoint().getPixelPoint().setLocation(xRaster, oldRasterY);
        }
    }

    public void setYRasterCoordinate(int point, double yRaster) {
        if (this.viewRasterGCPs != null) {
            double oldRasterX = this.viewRasterGCPs.getPoint(point).getGeoPoint().getPixelPoint().getX();
            this.viewRasterGCPs.getPoint(point).getGeoPoint().getPixelPoint().setLocation(oldRasterX, yRaster);
        }
    }

    public void removePoint(int position) {
        this.geoPointList.remove(position);
        this.redrawPoints();
    }

    public boolean isSelectPointToolSelected() {
        return this.viewRaster != null && this.viewRaster.getControl().getToolSelected() instanceof SelectCoordOnViewTool;
    }

    public GCPList getPointList() {
        return this.geoPointList;
    }

    public void setVisiblePoint(boolean visible, int position) {
        ((GPGraphic)this.geoPointList.getGraphicPoint(position)).setDraw(visible);
        this.redrawPoints();
    }

    public void synchronizeTablePointsNumerationWithGCPList() {
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            this.table.setValueAt((Object)new Integer(i), i, 1);
            long id = (Long)this.table.getValueAt(i, this.table.getColumnCount() - 1);
            this.geoPointList.setPositionFromID(id, i);
        }
        this.redrawPoints();
    }

    public void createGCPLayers() {
        if (this.viewRaster != null) {
            this.viewRasterGCPs = new GCPsGraphicLayer(0, this.toolListener, this.geoPointList);
            this.viewRasterGCPs.setGeoreferencingView(this.viewRaster);
            this.viewRaster.addGraphicLayer(this.viewRasterGCPs);
        }
        if (this.zoomRaster != null) {
            this.viewRasterGCPsZoom = new GCPsGraphicLayer(0, this.toolListener, this.geoPointList);
            this.viewRasterGCPsZoom.setGeoreferencingView(this.zoomRaster);
            this.zoomRaster.addGraphicLayer(this.viewRasterGCPsZoom);
        }
        if (this.viewMap != null) {
            this.viewMapGCPs = new GCPsGraphicLayer(1, this.toolListener, this.geoPointList);
            this.viewMapGCPs.setGeoreferencingView(this.viewMap);
            this.viewMap.addGraphicLayer(this.viewMapGCPs);
        }
        if (this.zoomMap != null) {
            this.viewMapGCPsZoom = new GCPsGraphicLayer(1, this.toolListener, this.geoPointList);
            this.viewMapGCPsZoom.setGeoreferencingView(this.zoomMap);
            this.zoomMap.addGraphicLayer(this.viewMapGCPsZoom);
        }
    }

    public void setActiveNumberPoint(boolean active) {
        for (int i = 0; i < this.geoPointList.size(); ++i) {
            ((GPGraphic)this.geoPointList.getGraphicPoint(i)).setShowNumber(active);
        }
    }

    public void setActiveLayerPoints(boolean active) {
        if (this.viewRasterGCPs != null) {
            this.viewRasterGCPs.setActive(active);
        }
        if (this.viewMapGCPs != null) {
            this.viewMapGCPs.setActive(active);
        }
        if (this.viewRasterGCPsZoom != null) {
            this.viewRasterGCPsZoom.setActive(active);
        }
        if (this.viewMapGCPsZoom != null) {
            this.viewMapGCPsZoom.setActive(active);
        }
    }

    public GeoPoint getPointByNumber(int number) {
        for (int i = 0; i < this.geoPointList.size(); ++i) {
            GeoPoint p = this.geoPointList.getGeoPoint(i);
            if (p.getNumber() != number) continue;
            return p;
        }
        return null;
    }

    public int getPointPositionByNumber(int number) {
        for (int i = 0; i < this.geoPointList.size(); ++i) {
            GeoPoint p = this.geoPointList.getGeoPoint(i);
            if (p.getNumber() != number) continue;
            return i;
        }
        return -1;
    }
}

