/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.buffer;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.geoprocess.algorithm.base.core.GeometryOperation;
import org.gvsig.geoprocess.algorithm.base.util.GeometryUtil;
import org.gvsig.geoprocess.algorithm.buffer.IDistance;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;

public abstract class BufferOperation
extends GeometryOperation {
    public static final byte CAP_SQUARE = 0;
    public static final byte CAP_ROUND = 1;
    protected byte capBuffer = 1;
    protected int numberOfRadialBuffers = 1;
    protected IDistance distance = null;
    protected int id = 0;
    protected IProjection projection = null;
    protected byte tableFieldStructure = 0;

    public BufferOperation(IDistance distance, FeatureStore inputStore, AbstractSextanteGeoProcess p, byte tableFieldStructure) {
        super(p);
        this.distance = distance;
        try {
            this.projection = inputStore.getDefaultFeatureType().getDefaultSRS();
        }
        catch (DataException dataException) {
            // empty catch block
        }
        this.tableFieldStructure = tableFieldStructure;
    }

    protected boolean verifyNilGeometry(Geometry newGeometry) {
        return newGeometry instanceof GeometryCollection && ((GeometryCollection)newGeometry).getNumGeometries() == 0;
    }

    protected void addFeature(Feature feature, Geometry newGeom) throws CreateGeometryException, DataException {
        if (!(feature instanceof EditableFeature)) {
            this.lastEditFeature = this.persister.addFeature(feature, newGeom);
        } else {
            org.gvsig.fmap.geom.Geometry g = GeometryUtil.jtsToGeom((Geometry)newGeom);
            this.persister.addGeometryToExistingFeature((EditableFeature)feature, g);
        }
    }

    public void setTypeOfCap(byte typeOfCap) {
        this.capBuffer = typeOfCap;
    }

    public void setNumberOfRadialBuffers(int number) {
        this.numberOfRadialBuffers = number;
    }

    protected int getMapUnits() {
        IProjection proj;
        IWindow w = PluginServices.getMDIManager().getActiveWindow();
        if (!(w instanceof AbstractViewPanel)) {
            IWindow[] wList = PluginServices.getMDIManager().getAllWindows();
            for (int i = 0; i < wList.length; ++i) {
                if (!(wList[i] instanceof AbstractViewPanel)) continue;
                w = wList[i];
            }
        }
        if (w != null && w instanceof AbstractViewPanel && (proj = ((AbstractViewPanel)w).getMapControl().getViewPort().getProjection()).isProjected()) {
            return ((AbstractViewPanel)w).getMapControl().getViewPort().getMapUnits();
        }
        return 1;
    }

    protected int getDistanceUnits() {
        IWindow w = PluginServices.getMDIManager().getActiveWindow();
        if (!(w instanceof AbstractViewPanel)) {
            IWindow[] wList = PluginServices.getMDIManager().getAllWindows();
            for (int i = 0; i < wList.length; ++i) {
                if (!(wList[i] instanceof AbstractViewPanel)) continue;
                w = wList[i];
            }
        }
        if (w != null && w instanceof AbstractViewPanel) {
            return ((AbstractViewPanel)w).getMapControl().getViewPort().getDistanceUnits();
        }
        return 1;
    }

    public byte getTableFieldStructure() {
        return this.tableFieldStructure;
    }

    public IDistance getDistance() {
        return this.distance;
    }
}

