/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.newlayer.prov.file;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.NewFeatureStoreParameters;
import org.gvsig.newlayer.NewLayerException;
import org.gvsig.newlayer.NewLayerProviderPanel;
import org.gvsig.newlayer.NewLayerService;
import org.gvsig.newlayer.NewLayerWizard;
import org.gvsig.newlayer.prov.file.NewLayerFileProviderParameters;
import org.gvsig.newlayer.prov.file.panels.SelectOutputFilePanel;
import org.gvsig.newlayer.spi.AbstractNewLayerProvider;
import org.gvsig.tools.util.HasAFile;

public abstract class AbstractNewLayerFileProvider
extends AbstractNewLayerProvider {
    protected NewLayerFileProviderParameters parameters;

    protected AbstractNewLayerFileProvider(NewLayerService service) {
        super(service);
        this.parameters = new NewLayerFileProviderParameters(service);
    }

    public List<NewLayerProviderPanel> createPanels(NewLayerWizard wizard) {
        ArrayList<NewLayerProviderPanel> panels = new ArrayList<NewLayerProviderPanel>();
        panels.add(new SelectOutputFilePanel(wizard, this.parameters));
        panels.add(wizard.createFeatureTypePanel());
        return panels;
    }

    public EditableFeatureType getFeatureType() {
        return this.parameters.getFeatureType();
    }

    public DataServerExplorer getExplorer() throws NewLayerException {
        DataManager dataManager = DALLocator.getDataManager();
        try {
            DataServerExplorerParameters explorerParameters = dataManager.createServerExplorerParameters("FilesystemExplorer");
            DataServerExplorer explorer = dataManager.openServerExplorer("FilesystemExplorer", explorerParameters);
            return explorer;
        }
        catch (Exception ex) {
            throw new NewLayerException(ex);
        }
    }

    protected File getFile() {
        File file = this.parameters.getFile();
        String fileName = file.getName();
        if (StringUtils.isNotBlank((CharSequence)this.parameters.getFileExtension()) && !fileName.contains(".")) {
            fileName = fileName + "." + StringUtils.removeStart((String)this.parameters.getFileExtension(), (String)".");
        }
        if (!(file = file.getParent() != null ? new File(file.getParent() + File.separator + fileName) : new File(fileName)).isAbsolute()) {
            String home = System.getProperty("user.home");
            file = new File(home + File.separator + fileName);
        }
        return file;
    }

    public NewFeatureStoreParameters getNewStoreParameters() throws NewLayerException {
        try {
            DataServerExplorer explorer = this.getExplorer();
            NewFeatureStoreParameters storeParameters = (NewFeatureStoreParameters)explorer.getAddParameters(this.getStoreName());
            ((HasAFile)storeParameters).setFile(this.getFile());
            storeParameters.setDefaultFeatureType((FeatureType)this.getFeatureType());
            return storeParameters;
        }
        catch (Exception e) {
            LOG.warn("Can't create store parameters.", (Throwable)e);
            throw new NewLayerException(e);
        }
    }

    public DataStoreParameters getOpenStoreParameters() throws NewLayerException {
        DataManager dataManager = DALLocator.getDataManager();
        try {
            DataStoreParameters storeParameters = dataManager.createStoreParameters(this.getStoreName());
            ((HasAFile)storeParameters).setFile(this.getFile());
            return storeParameters;
        }
        catch (Exception e) {
            LOG.warn("Can't create store parameters.");
            throw new NewLayerException(e);
        }
    }
}

