/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.dbf.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.h2gis.functions.io.FileDriver;
import org.h2gis.functions.io.dbf.internal.DbaseFileException;
import org.h2gis.functions.io.dbf.internal.DbaseFileHeader;
import org.h2gis.functions.io.dbf.internal.DbaseFileReader;
import org.h2gis.functions.io.dbf.internal.DbaseFileWriter;

public class DBFDriver
implements FileDriver {
    private File dbfFile;
    private DbaseFileReader dbaseFileReader;
    private DbaseFileWriter dbaseFileWriter;

    public void initDriverFromFile(File dbfFile) throws IOException {
        this.initDriverFromFile(dbfFile, null);
    }

    public void initDriverFromFile(File dbfFile, String forceEncoding) throws IOException {
        this.dbfFile = dbfFile;
        FileInputStream fis = new FileInputStream(dbfFile);
        this.dbaseFileReader = new DbaseFileReader(fis.getChannel(), forceEncoding);
    }

    public void initDriver(File dbfFile, DbaseFileHeader dbaseHeader) throws IOException {
        this.dbfFile = dbfFile;
        FileOutputStream dbfFos = new FileOutputStream(dbfFile);
        this.dbaseFileWriter = new DbaseFileWriter(dbaseHeader, dbfFos.getChannel());
    }

    @Override
    public void insertRow(Object[] values) throws IOException {
        this.checkWriter();
        if (values.length != this.getDbaseFileHeader().getNumFields()) {
            throw new IllegalArgumentException("Incorrect field count " + values.length + " expected " + this.getFieldCount());
        }
        try {
            this.dbaseFileWriter.write(values);
        }
        catch (DbaseFileException ex) {
            throw new IOException(ex.getLocalizedMessage(), ex);
        }
    }

    private void checkReader() {
        if (this.dbaseFileReader == null) {
            throw new IllegalStateException("The driver is not in read mode");
        }
    }

    private void checkWriter() {
        if (this.dbaseFileWriter == null) {
            throw new IllegalStateException("The driver is not in write mode");
        }
    }

    public File getDbfFile() {
        return this.dbfFile;
    }

    public DbaseFileHeader getDbaseFileHeader() {
        if (this.dbaseFileReader != null) {
            return this.dbaseFileReader.getHeader();
        }
        if (this.dbaseFileWriter != null) {
            return this.dbaseFileWriter.getHeader();
        }
        throw new IllegalStateException("The driver is not initialised");
    }

    @Override
    public void close() throws IOException {
        if (this.dbaseFileReader != null) {
            this.dbaseFileReader.close();
        } else if (this.dbaseFileWriter != null) {
            this.dbaseFileWriter.close();
        }
    }

    @Override
    public long getRowCount() {
        return this.dbaseFileReader.getRecordCount();
    }

    public int getFieldCount() {
        return this.getDbaseFileHeader().getNumFields();
    }

    @Override
    public Object[] getRow(long rowId) throws IOException {
        int fieldCount = this.dbaseFileReader.getFieldCount();
        Object[] values = new Object[fieldCount];
        for (int fieldId = 0; fieldId < fieldCount; ++fieldId) {
            values[fieldId] = this.dbaseFileReader.getFieldValue((int)rowId, fieldId);
        }
        return values;
    }
}

