/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.convert;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2gis.api.DeterministicScalarFunction;

public class ST_Holes
extends DeterministicScalarFunction {
    private static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();

    public ST_Holes() {
        this.addProperty("remarks", "Returns the given geometry's holes as a GeometryCollection.");
    }

    public String getJavaStaticMethod() {
        return "getHoles";
    }

    public static GeometryCollection getHoles(Geometry geom) throws SQLException {
        if (geom != null) {
            if (geom.getDimension() >= 2) {
                ArrayList<Polygon> holes = new ArrayList<Polygon>();
                for (int i = 0; i < geom.getNumGeometries(); ++i) {
                    Geometry subgeom = geom.getGeometryN(i);
                    if (!(subgeom instanceof Polygon)) continue;
                    Polygon polygon = (Polygon)subgeom;
                    for (int j = 0; j < polygon.getNumInteriorRing(); ++j) {
                        holes.add(GEOMETRY_FACTORY.createPolygon(GEOMETRY_FACTORY.createLinearRing(polygon.getInteriorRingN(j).getCoordinates()), null));
                    }
                }
                return GEOMETRY_FACTORY.createGeometryCollection(holes.toArray(new Geometry[holes.size()]));
            }
            return GEOMETRY_FACTORY.createGeometryCollection(null);
        }
        return null;
    }
}

