/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.distance;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.linearref.LengthIndexedLine;
import org.h2gis.api.DeterministicScalarFunction;

public class ST_ProjectPoint
extends DeterministicScalarFunction {
    public ST_ProjectPoint() {
        this.addProperty("remarks", "Projet a point along a linestring. If the point projected is out of line the first or last point on the line will be returned otherwise the input point.");
    }

    public String getJavaStaticMethod() {
        return "projectPoint";
    }

    public static Point projectPoint(Geometry point, Geometry geometry) {
        if (point == null || geometry == null) {
            return null;
        }
        if (point.getDimension() == 0 && geometry.getDimension() == 1) {
            LengthIndexedLine ll = new LengthIndexedLine(geometry);
            double index = ll.project(point.getCoordinate());
            Point result = geometry.getFactory().createPoint(ll.extractPoint(index));
            return result;
        }
        return null;
    }
}

