/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.JPanel;
import org.fit.cssbox.css.DOMAnalyzer;
import org.fit.cssbox.layout.BoxFactory;
import org.fit.cssbox.layout.BrowserConfig;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.Viewport;
import org.fit.cssbox.layout.VisualContext;
import org.fit.cssbox.render.GraphicsRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class BrowserCanvas
extends JPanel {
    private static final long serialVersionUID = -8715215920271505397L;
    private static Logger log = LoggerFactory.getLogger(BrowserCanvas.class);
    protected Element root;
    protected DOMAnalyzer decoder;
    protected URL baseurl;
    protected Viewport viewport;
    protected BufferedImage img;
    protected BrowserConfig config;
    protected boolean createImage;
    protected boolean autoSizeUpdate;
    protected boolean autoMediaUpdate;

    public BrowserCanvas(Element root, DOMAnalyzer decoder, URL baseurl) {
        this.root = root;
        this.decoder = decoder;
        this.baseurl = baseurl;
        this.config = new BrowserConfig();
        this.createImage = true;
        this.autoSizeUpdate = true;
        this.autoMediaUpdate = true;
    }

    public BrowserCanvas(Element root, DOMAnalyzer decoder, Dimension dim, URL baseurl) {
        this(root, decoder, baseurl);
        this.createLayout(dim);
    }

    public BrowserConfig getConfig() {
        return this.config;
    }

    public void setConfig(BrowserConfig config) {
        this.config = config;
    }

    public ElementBox getRootBox() {
        if (this.viewport == null) {
            return null;
        }
        return this.viewport.getRootBox();
    }

    public Viewport getViewport() {
        return this.viewport;
    }

    public void createLayout(Dimension dim) {
        this.createLayout(dim, new Rectangle(dim));
    }

    public void createLayout(Dimension dim, Rectangle visibleRect) {
        if (this.createImage) {
            this.img = new BufferedImage(dim.width, dim.height, 1);
        }
        Graphics2D ig = this.img.createGraphics();
        if (this.autoMediaUpdate) {
            this.decoder.getMediaSpec().setDimensions((float)visibleRect.width, (float)visibleRect.height);
            this.decoder.recomputeStyles();
        }
        log.trace("Creating boxes");
        BoxFactory factory = new BoxFactory(this.decoder, this.baseurl);
        factory.setConfig(this.config);
        factory.reset();
        VisualContext ctx = new VisualContext(null, factory);
        this.viewport = factory.createViewportTree(this.root, ig, ctx, dim.width, dim.height);
        log.trace("We have " + factory.next_order + " boxes");
        this.viewport.setVisibleRect(visibleRect);
        this.viewport.initSubtree();
        log.trace("Layout for " + dim.width + "px");
        this.viewport.doLayout(dim.width, true, true);
        log.trace("Resulting size: " + this.viewport.getWidth() + "x" + this.viewport.getHeight() + " (" + this.viewport + ")");
        if (this.autoSizeUpdate) {
            log.trace("Updating viewport size");
            this.viewport.updateBounds(dim);
            log.trace("Resulting size: " + this.viewport.getWidth() + "x" + this.viewport.getHeight() + " (" + this.viewport + ")");
        }
        if (this.createImage && (this.viewport.getWidth() > dim.width || this.viewport.getHeight() > dim.height)) {
            this.img = new BufferedImage(Math.max(this.viewport.getWidth(), dim.width), Math.max(this.viewport.getHeight(), dim.height), 1);
            ig = this.img.createGraphics();
        }
        log.trace("Positioning for " + this.viewport.getWidth() + "x" + this.viewport.getHeight() + "px");
        this.viewport.absolutePositions();
        log.trace("Drawing");
        this.clearCanvas();
        GraphicsRenderer r = new GraphicsRenderer(ig);
        this.viewport.draw(r);
        r.close();
        this.setPreferredSize(new Dimension(this.img.getWidth(), this.img.getHeight()));
        this.revalidate();
    }

    public void updateVisibleArea(Rectangle visibleRect) {
        this.viewport.setVisibleRect(visibleRect);
        this.viewport.absolutePositions();
        this.clearCanvas();
        GraphicsRenderer r = new GraphicsRenderer(this.getImageGraphics());
        this.viewport.draw(r);
        r.close();
        this.revalidate();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.img, 0, 0, null);
    }

    public void clearCanvas() {
        Graphics2D ig = this.img.createGraphics();
        this.viewport.drawBackground(ig);
    }

    public void redrawBoxes() {
        Graphics2D ig = this.img.createGraphics();
        this.clearCanvas();
        this.viewport.draw(new GraphicsRenderer(ig));
        this.revalidate();
    }

    public Graphics2D getImageGraphics() {
        return this.img.createGraphics();
    }

    public BufferedImage getImage() {
        return this.img;
    }

    public void setImage(BufferedImage image) {
        this.img = image;
        this.createImage = false;
    }

    public void setAutoSizeUpdate(boolean b) {
        this.autoSizeUpdate = b;
    }

    public boolean getAutoSizeUpdate() {
        return this.autoSizeUpdate;
    }

    public void setAutoMediaUpdate(boolean autoMediaUpdate) {
        this.autoMediaUpdate = autoMediaUpdate;
    }

    public boolean getAutoMediaUpdate() {
        return this.autoMediaUpdate;
    }
}

