/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.split.operation;

import java.util.ArrayList;
import java.util.Collections;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.complex.Complex;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Arc;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.vectorediting.lib.prov.split.operation.SplitOperation;
import org.gvsig.vectorediting.lib.prov.split.operation.SplitOperationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArcSplitOperation
implements SplitOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArcSplitOperation.class);

    @Override
    public Geometry split(Geometry geometryToBeSplitted, Geometry splitter) throws GeometryOperationNotSupportedException, GeometryOperationException, CreateGeometryException {
        int subtype = geometryToBeSplitted.getGeometryType().getSubType();
        GeometryManager geoManager = GeometryLocator.getGeometryManager();
        Arc arcToBeSplitted = (Arc)geometryToBeSplitted;
        Geometry intersections = arcToBeSplitted.intersection(splitter);
        if (intersections == null) {
            return geometryToBeSplitted;
        }
        if (intersections instanceof Complex) {
            intersections = ((Complex)intersections).createAggregate(7, t -> t.getGeometryType().getType() == 7 || t.getGeometryType().getType() == 1);
        }
        if (intersections instanceof Point) {
            if (this.isClosed(arcToBeSplitted)) {
                return arcToBeSplitted;
            }
            return arcToBeSplitted.difference(splitter);
        }
        if (intersections instanceof MultiPoint) {
            MultiPoint multiIntersection = (MultiPoint)intersections;
            Point tmpCenter = arcToBeSplitted.getCenterPoint();
            if (tmpCenter == null) {
                tmpCenter = SplitOperationUtils.createPoint(arcToBeSplitted.getEnvelope().getCenter(0), arcToBeSplitted.getEnvelope().getCenter(1), subtype);
            }
            Point center = tmpCenter;
            double radius = center.distance((Geometry)arcToBeSplitted.getEndPoint());
            ArrayList<Point> orderedIntersectionPoints = new ArrayList<Point>();
            for (int i = 0; i < multiIntersection.getPrimitivesNumber(); ++i) {
                orderedIntersectionPoints.add(multiIntersection.getPointAt(i));
            }
            Collections.sort(orderedIntersectionPoints, (p1, p2) -> {
                double angle2;
                double angle1;
                try {
                    angle1 = SplitOperationUtils.getAngle(center, p1);
                    angle2 = SplitOperationUtils.getAngle(center, p2);
                }
                catch (BaseException e) {
                    LOGGER.warn("Problems getting angle between center and one intersection point");
                    return 0;
                }
                return Double.compare(angle1, angle2);
            });
            MultiCurve splittedArcs = geoManager.createMultiCurve(subtype);
            for (int i = 0; i < orderedIntersectionPoints.size(); ++i) {
                Point intersecctionPoint = (Point)orderedIntersectionPoints.get(i);
                Point nextIntersecctionPoint = i + 1 >= orderedIntersectionPoints.size() ? (Point)orderedIntersectionPoints.get(0) : (Point)orderedIntersectionPoints.get(i + 1);
                double angle1 = SplitOperationUtils.getAngle(center, intersecctionPoint);
                double angle2 = SplitOperationUtils.getAngle(center, nextIntersecctionPoint);
                Arc arc = (Arc)geoManager.create(12, subtype);
                arc.setPointsStartEnd(center, radius, angle1, angle2);
                splittedArcs.addCurve((Curve)arc);
            }
            return splittedArcs;
        }
        return arcToBeSplitted;
    }

    private boolean isClosed(Arc arc) {
        Point initPoint = arc.getInitPoint();
        Point endPoint = arc.getEndPoint();
        Point centerPoint = arc.getCenterPoint();
        return initPoint.equals(endPoint) || centerPoint == null;
    }
}

